/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.TestStorageUtils;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationResult;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationDataRowMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationKeyMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationRepairMeta;
import org.apache.ignite.internal.processors.cache.verify.PartitionReconciliationValueMeta;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.junit.Test;

public abstract class GridCommandHandlerPartitionReconciliationAbstractTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    public static final int INVALID_KEY = 100;
    public static final String VALUE_PREFIX = "abc_";
    public static final String BROKEN_POSTFIX_1 = "_broken1";
    public static final String BROKEN_POSTFIX_2 = "_broken2";
    protected static File dfltDiagnosticDir;
    protected static File customDiagnosticDir;
    protected IgniteEx ignite;
    private static CommandHandler hnd;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.initDiagnosticDir();
        this.cleanDiagnosticDir();
        this.cleanPersistenceDir();
        this.ignite = this.startGrids(4);
        this.ignite.cluster().active(true);
        this.prepareCache();
        hnd = new CommandHandler();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    @Override
    protected void afterTest() throws Exception {
    }

    protected abstract void prepareCache();

    @Override
    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        this.cleanDiagnosticDir();
    }

    protected void initDiagnosticDir() throws IgniteCheckedException {
        dfltDiagnosticDir = new File(U.defaultWorkDirectory() + File.separatorChar + "diagnostic" + File.separatorChar);
        customDiagnosticDir = new File(U.defaultWorkDirectory() + File.separatorChar + "diagnostic_test_dir" + File.separatorChar);
    }

    protected void cleanDiagnosticDir() {
        U.delete((File)dfltDiagnosticDir);
        U.delete((File)customDiagnosticDir);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)).setWalSegmentSize(0x400000));
        return cfg;
    }

    @Test
    public void testRemovedEntryOnPrimaryWithDefaultRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "--recheck-delay", "0", "--local-output"));
        this.validateResult(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), new PartitionReconciliationRepairMeta(false, null, RepairAlgorithm.PRINT_ONLY));
    }

    @Test
    public void testRemovedEntryOnPrimaryWithMajorityRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "MAJORITY", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100", RepairAlgorithm.MAJORITY);
    }

    @Test
    public void testRemovedEntryOnPrimaryWithRemoveRepairAlg() throws IgniteCheckedException {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "REMOVE", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), null, RepairAlgorithm.REMOVE);
    }

    @Test
    public void testRemovedEntryOnPrimaryWithPrimaryRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "PRIMARY", "--recheck-delay", "0", "--local-output"));
        this.validateResult(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), new PartitionReconciliationRepairMeta(true, null, RepairAlgorithm.PRIMARY));
        for (int i = 0; i < 4; ++i) {
            Object val = this.ignite(i).cachex("default").localPeek((Object)100, null);
            GridCommandHandlerPartitionReconciliationAbstractTest.assertNull((Object)val);
        }
    }

    @Test
    public void testRemovedEntryOnPrimaryWithMaxGridCacheVersionRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "LATEST", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    @Test
    public void testRemovedEntryOnPrimaryWithPrintOnlyRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(true);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "--recheck-delay", "0", "--local-output"));
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        this.validateResult(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), new PartitionReconciliationRepairMeta(false, null, RepairAlgorithm.PRINT_ONLY));
        GridCommandHandlerPartitionReconciliationAbstractTest.assertNull((Object)((IgniteEx)this.grid((ClusterNode)nodes.get(0))).cachex("default").localPeek((Object)100, null));
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((Object)"abc_100", (Object)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").localPeek((Object)100, null));
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((Object)"abc_100", (Object)((IgniteEx)this.grid((ClusterNode)nodes.get(2))).cachex("default").localPeek((Object)100, null));
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((Object)"abc_100_broken2", (Object)((IgniteEx)this.grid((ClusterNode)nodes.get(3))).cachex("default").localPeek((Object)100, null));
    }

    @Test
    public void testMissedUpdateWithDefaultRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(false);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    @Test
    public void testMissedUpdateOnPrimaryWithMajorityRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(false);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "MAJORITY", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    @Test
    public void testMissedUpdateOnPrimaryWithPrimaryRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(false);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "PRIMARY", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    @Test
    public void testMissedUpdateOnPrimaryWithMaxGridCacheVersionRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(false);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "LATEST", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    @Test
    public void testMissedUpdateOnPrimaryWithPrintOnlyRepairAlg() throws Exception {
        PartitionReconciliationDataRowMeta invalidDataRowMeta = this.populateCacheWithInconsistentEntry(false);
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--repair", "--recheck-delay", "0", "--local-output"));
        this.validateFix(invalidDataRowMeta, (ReconciliationResult)hnd.getLastOperationResult(), "abc_100_broken2", RepairAlgorithm.LATEST);
    }

    private void validateFix(PartitionReconciliationDataRowMeta invalidDataRowMeta, ReconciliationResult res, String invalidVal, RepairAlgorithm repairAlg) throws IgniteCheckedException {
        this.validateResult(invalidDataRowMeta, res, new PartitionReconciliationRepairMeta(true, invalidVal != null ? new PartitionReconciliationValueMeta(this.grid(0).context().cacheObjects().marshal((CacheObjectValueContext)this.ignite(0).cachex("default").cache().context().cacheObjectContext(), (Object)invalidVal), invalidVal, null) : null, repairAlg));
        for (int i = 0; i < 4; ++i) {
            Object val = this.ignite(i).cachex("default").localPeek((Object)100, null);
            GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((Object)invalidVal, (Object)val);
        }
    }

    private PartitionReconciliationDataRowMeta populateCacheWithInconsistentEntry(boolean dropEntry) throws IgniteCheckedException {
        HashMap<UUID, PartitionReconciliationValueMeta> valMetas = new HashMap<UUID, PartitionReconciliationValueMeta>();
        GridCacheContext cctx = this.ignite(0).cachex("default").cache().context();
        PartitionReconciliationDataRowMeta res = new PartitionReconciliationDataRowMeta(new PartitionReconciliationKeyMeta(this.grid(0).context().cacheObjects().marshal((CacheObjectValueContext)cctx.cacheObjectContext(), (Object)100), String.valueOf(100)), valMetas);
        List nodes = cctx.affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        if (dropEntry) {
            ((IgniteEx)this.grid((ClusterNode)nodes.get(0))).cachex("default").clearLocallyAll(Collections.singleton(100), true, true, true);
        } else {
            GridCacheVersion invalidVerNode0 = new GridCacheVersion(0, 0, 1L);
            TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(0))).cachex("default").context(), (Object)100, (boolean)false, (boolean)true, (GridCacheVersion)invalidVerNode0, (String)BROKEN_POSTFIX_1);
            String brokenValNode0 = "abc_100_broken1";
            valMetas.put(((ClusterNode)nodes.get(0)).id(), new PartitionReconciliationValueMeta(this.grid(0).context().cacheObjects().marshal((CacheObjectValueContext)cctx.cacheObjectContext(), (Object)brokenValNode0), brokenValNode0, invalidVerNode0));
        }
        GridCacheVersion invalidVerNode1 = new GridCacheVersion(0, 0, 1L);
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)invalidVerNode1, null);
        String brokenValNode1 = "abc_100";
        valMetas.put(((ClusterNode)nodes.get(1)).id(), new PartitionReconciliationValueMeta(this.grid(1).context().cacheObjects().marshal((CacheObjectValueContext)cctx.cacheObjectContext(), (Object)brokenValNode1), brokenValNode1, invalidVerNode1));
        GridCacheVersion invalidVerNode2 = new GridCacheVersion(0, 0, 2L);
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(2))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)invalidVerNode2, null);
        String brokenValNode2 = "abc_100";
        valMetas.put(((ClusterNode)nodes.get(2)).id(), new PartitionReconciliationValueMeta(this.grid(2).context().cacheObjects().marshal((CacheObjectValueContext)cctx.cacheObjectContext(), (Object)brokenValNode2), brokenValNode2, invalidVerNode2));
        GridCacheVersion invalidVerNode3 = new GridCacheVersion(0, 0, 3L);
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(3))).cachex("default").context(), (Object)100, (boolean)false, (boolean)true, (GridCacheVersion)invalidVerNode3, (String)BROKEN_POSTFIX_2);
        String brokenValNode3 = "abc_100_broken2";
        valMetas.put(((ClusterNode)nodes.get(3)).id(), new PartitionReconciliationValueMeta(this.grid(3).context().cacheObjects().marshal((CacheObjectValueContext)cctx.cacheObjectContext(), (Object)brokenValNode3), brokenValNode3, invalidVerNode3));
        return res;
    }

    private void validateResult(PartitionReconciliationDataRowMeta invalidDataRowMeta, ReconciliationResult res, PartitionReconciliationRepairMeta repairMeta) {
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)res.errors().size());
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)res.partitionReconciliationResult().skippedEntriesCount());
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)0, (int)res.partitionReconciliationResult().skippedCachesCount());
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals((int)1, (int)res.partitionReconciliationResult().inconsistentKeysCount());
        GridCommandHandlerPartitionReconciliationAbstractTest.assertEquals(Collections.singletonMap("default", Collections.singletonMap(this.ignite(0).cachex("default").cache().context().affinity().partition((Object)100), Collections.singletonList(new PartitionReconciliationDataRowMeta(invalidDataRowMeta.keyMeta(), invalidDataRowMeta.valueMeta(), repairMeta)))), (Object)res.partitionReconciliationResult().inconsistentKeys());
    }
}

