/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerIndexingClusterByClassTest
extends GridCommandHandlerClusterByClassAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi", "group1");
    }

    protected FailureHandler getFailureHandler(String igniteInstanceName) {
        return new StopNodeFailureHandler();
    }

    @Test
    public void testCheckIndexInlineSizesNoError() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "check_index_inline_sizes"));
        String output = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Found 2 secondary indexes.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"All secondary indexes have the same effective inline size on all cluster nodes.");
    }

    @Test
    public void testValidateIndexesNoErrors() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found");
    }

    @Test
    public void testValidateIndexesWithCrcNoErrors() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found");
    }

    @Test
    public void testValidateIndexesNoErrorEmptyCacheNameArg() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found");
    }

    @Test
    public void testBrokenCacheDataTreeShouldFailValidation() {
        this.breakCacheDataTreeOnCrd();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi", "--check-first", "10000", "--check-through", "10"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"issues found (listed above)");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Key is present in SQL index, but is missing in corresponding data page.");
    }

    @Test
    public void testBrokenCacheDataTreeShouldFailValidationWithCacheGroupInfo() {
        this.breakCacheDataTreeOnCrd();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"[cacheGroup=group1, cacheGroupId=-1237460590, cache=persons-cache-vi, cacheId=-528791027, idx=_key_PK]");
    }

    @Test
    public void testBrokenSqlIndexShouldFailValidation() throws Exception {
        this.breakSqlIndexOnCrd();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"issues found (listed above)");
    }

    @Test
    public void testValidateSingleCacheShouldNotTriggerCacheGroupValidation() throws Exception {
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)crd, "default", "group1");
        this.forceCheckpoint();
        this.breakCacheDataTreeOnCrd();
        this.injectTestSystemOut();
        GridCommandHandlerIndexingClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "default", "--check-through", "10"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found");
    }

    private void breakCacheDataTreeOnCrd() {
        GridCommandHandlerIndexingUtils.breakCacheDataTree(log, crd.cachex("persons-cache-vi"), 1, (i, entry) -> i % 5 == 0);
    }

    private void breakSqlIndexOnCrd() throws Exception {
        GridCommandHandlerIndexingUtils.breakSqlIndex(crd.cachex("persons-cache-vi"), 0, null);
    }
}

