/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerGetCacheSizeTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    public static final int GRID_CNT = 2;
    public static final int CACHE_SIZE = 10000;

    @Test
    public void testValidateGridCommandHandlerGetCacheSizeTest() throws Exception {
        this.prepareGridForTest();
        this.injectTestSystemOut();
        GridCommandHandlerGetCacheSizeTest.assertEquals((int)0, (int)this.execute("--cache", "list", "."));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"cacheSize=10000");
        GridCommandHandlerGetCacheSizeTest.assertEquals((int)0, (int)this.execute("--cache", "list", ".", "--groups"));
        out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"cacheSize=20000");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"cacheSize=10000");
    }

    private Ignite prepareGridForTest() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteEx client = this.startGrid("client");
        String cacheGrpName1 = "group1";
        String cacheGrpName2 = "group10";
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi", cacheGrpName1);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi0", cacheGrpName1);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi1", cacheGrpName2);
        return ignite;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }
}

