/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.junit.Before;
import org.junit.Test;

public class GridCommandHandlerCheckpointingTest
extends GridCommandHandlerClusterByClassAbstractTest {
    @Before
    public void init() {
        this.injectTestSystemOut();
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        GridCommandHandlerCheckpointingTest.assertTrue((String)"Need at least 2 nodes to test checkpoint command", (boolean)true);
        super.beforeTestsStarted();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.createCacheAndPreload((Ignite)crd, 1);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.getDataStorageConfiguration().setCheckpointFrequency(Integer.MAX_VALUE);
        return cfg;
    }

    @Test
    public void testForceCheckpointing() {
        GridCacheDatabaseSharedManager gridDb = (GridCacheDatabaseSharedManager)crd.context().cache().context().database();
        CheckpointHistory checkpointHist = gridDb.checkpointHistory();
        assert (null != checkpointHist);
        int numOfCheckpointsBefore = checkpointHist.checkpoints().size();
        CheckpointEntry lastCheckpointBefore = checkpointHist.lastCheckpoint();
        GridCommandHandlerCheckpointingTest.assertEquals((int)0, (int)this.execute("--checkpoint"));
        int numOfCheckpointsAfter = checkpointHist.checkpoints().size();
        CheckpointEntry lastCheckpointAfter = checkpointHist.lastCheckpoint();
        GridCommandHandlerCheckpointingTest.assertTrue((numOfCheckpointsAfter > numOfCheckpointsBefore ? 1 : 0) != 0);
        GridCommandHandlerCheckpointingTest.assertNotSame((Object)lastCheckpointBefore, (Object)lastCheckpointAfter);
        String out = testOut.toString();
        int numOfNodes = crd.cluster().forServers().nodes().size();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Checkpointing completed successfully on " + numOfNodes + " nodes."));
    }

    @Test
    public void testForceCheckpointingForNode() {
        IgniteEx ignite0 = this.grid(0);
        IgniteEx ignite1 = this.grid(1);
        CheckpointHistory checkpointHist0 = this.getCheckpointHistory(ignite0);
        CheckpointHistory checkpointHist1 = this.getCheckpointHistory(ignite1);
        int numOfCheckpointsBefore0 = checkpointHist0.checkpoints().size();
        int numOfCheckpointsBefore1 = checkpointHist1.checkpoints().size();
        CheckpointEntry lastCheckpointBefore0 = checkpointHist0.lastCheckpoint();
        CheckpointEntry lastCheckpointBefore1 = checkpointHist1.lastCheckpoint();
        GridCommandHandlerCheckpointingTest.assertEquals((int)0, (int)this.execute("--checkpoint", "--node-id", crd.localNode().id().toString()));
        int numOfCheckpointsAfter0 = checkpointHist0.checkpoints().size();
        int numOfCheckpointsAfter1 = checkpointHist1.checkpoints().size();
        CheckpointEntry lastCheckpointAfter0 = checkpointHist0.lastCheckpoint();
        CheckpointEntry lastCheckpointAfter1 = checkpointHist1.lastCheckpoint();
        GridCommandHandlerCheckpointingTest.assertTrue((numOfCheckpointsAfter0 > numOfCheckpointsBefore0 ? 1 : 0) != 0);
        GridCommandHandlerCheckpointingTest.assertNotSame((Object)lastCheckpointBefore0, (Object)lastCheckpointAfter0);
        GridCommandHandlerCheckpointingTest.assertTrue((numOfCheckpointsAfter1 == numOfCheckpointsBefore1 ? 1 : 0) != 0);
        GridCommandHandlerCheckpointingTest.assertSame((Object)lastCheckpointBefore1, (Object)lastCheckpointAfter1);
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Checkpointing completed successfully on 1 node.");
    }

    @Test
    public void testWrongNodeId() {
        IgniteEx ignite0 = this.grid(0);
        IgniteEx ignite1 = this.grid(1);
        String testIdStr = UUID.randomUUID().toString();
        GridCommandHandlerCheckpointingTest.assertEquals((int)1, (int)this.execute("--checkpoint", "--node-id", testIdStr));
        String s = testOut.toString();
        GridCommandHandlerCheckpointingTest.assertTrue((boolean)s.contains("Node with id=" + testIdStr + " is not found in the topology"));
        GridCommandHandlerCheckpointingTest.assertTrue((boolean)s.contains(ignite0.localNode().id().toString()));
        GridCommandHandlerCheckpointingTest.assertTrue((boolean)s.contains(ignite1.localNode().id().toString()));
    }

    private CheckpointHistory getCheckpointHistory(IgniteEx ignite) {
        GridCacheDatabaseSharedManager gridDb0 = (GridCacheDatabaseSharedManager)ignite.context().cache().context().database();
        CheckpointHistory checkpointHist0 = gridDb0.checkpointHistory();
        GridCommandHandlerCheckpointingTest.assertNotNull((String)("Checkpoint history object for " + ignite.name()), (Object)checkpointHist0);
        return checkpointHist0;
    }
}

