/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverter;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverterArguments;
import org.apache.ignite.internal.commandline.walconverter.Person;
import org.apache.ignite.internal.commandline.walconverter.PersonEx;
import org.apache.ignite.internal.commandline.walconverter.PersonKey;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteWalConverterTest
extends GridCommonAbstractTest {
    public static final String PERSON_NAME_PREFIX = "Name ";
    private String beforeIgnitePdsSkipCrc;
    private boolean beforeSkipCrc;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.beforeIgnitePdsSkipCrc = System.getProperty("IGNITE_PDS_SKIP_CRC");
        this.beforeSkipCrc = RecordV1Serializer.skipCrc;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids(true);
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected void afterTestsStopped() throws Exception {
        if (this.beforeIgnitePdsSkipCrc != null) {
            System.setProperty("IGNITE_PDS_SKIP_CRC", this.beforeIgnitePdsSkipCrc);
        } else {
            System.clearProperty("IGNITE_PDS_SKIP_CRC");
        }
        RecordV1Serializer.skipCrc = this.beforeSkipCrc;
        super.afterTestsStopped();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration igniteConfiguration = super.getConfiguration(igniteInstanceName);
        igniteConfiguration.setDataStorageConfiguration(this.getDataStorageConfiguration());
        CacheConfiguration cacheConfiguration = new CacheConfiguration().setName("default").setCacheMode(CacheMode.PARTITIONED).setBackups(0).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{PersonKey.class, Person.class});
        igniteConfiguration.setCacheConfiguration(new CacheConfiguration[]{cacheConfiguration});
        return igniteConfiguration;
    }

    private DataStorageConfiguration getDataStorageConfiguration() {
        DataStorageConfiguration dataStorageConfiguration = new DataStorageConfiguration().setWalSegmentSize(0x400000).setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(1000L).setWalCompactionEnabled(true).setDefaultDataRegionConfiguration(this.getDataRegionConfiguration());
        return dataStorageConfiguration;
    }

    private DataRegionConfiguration getDataRegionConfiguration() {
        DataRegionConfiguration dataRegionConfiguration = new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x6400000L);
        return dataRegionConfiguration;
    }

    @Test
    public void testIgniteWalConverterWithDefaultSensitive() throws Exception {
        this.testIgniteWalConverter(null);
    }

    @Test
    public void testIgniteWalConverterWithShowSensitive() throws Exception {
        this.testIgniteWalConverter(ProcessSensitiveData.SHOW);
    }

    @Test
    public void testIgniteWalConverterWithHashSensitive() throws Exception {
        this.testIgniteWalConverter(ProcessSensitiveData.HASH);
    }

    @Test
    public void testIgniteWalConverterWithHideSensitive() throws Exception {
        this.testIgniteWalConverter(ProcessSensitiveData.HIDE);
    }

    private void testIgniteWalConverter(ProcessSensitiveData sensitiveData) throws Exception {
        LinkedList<Person> list = new LinkedList<Person>();
        String nodeFolder = this.createWal(list, null);
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outByte);
        IgniteWalConverterArguments arg = new IgniteWalConverterArguments(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal/archive", (boolean)false), 4096, new File(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/binary_meta", (boolean)false), nodeFolder), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/marshaller", (boolean)false), true, null, null, null, null, sensitiveData, true, true, Collections.emptyList());
        IgniteWalConverter.convert((PrintStream)out, (IgniteWalConverterArguments)arg);
        if (sensitiveData == ProcessSensitiveData.SHOW) {
            IgniteWalConverterTest.assertTrue((boolean)"plain".equals(IgniteSystemProperties.getString((String)"IGNITE_SENSITIVE_DATA_LOGGING")));
        } else if (sensitiveData == ProcessSensitiveData.HIDE) {
            IgniteWalConverterTest.assertTrue((boolean)"none".equals(IgniteSystemProperties.getString((String)"IGNITE_SENSITIVE_DATA_LOGGING")));
        } else {
            IgniteWalConverterTest.assertTrue((boolean)"hash".equals(IgniteSystemProperties.getString((String)"IGNITE_SENSITIVE_DATA_LOGGING")));
        }
        String result = outByte.toString();
        int index = 0;
        for (Person person : list) {
            boolean find = false;
            index = result.indexOf("DataRecord", index);
            if (sensitiveData == ProcessSensitiveData.SHOW) {
                if (index > 0 && (index = result.indexOf("PersonKey", index + 10)) > 0 && (index = result.indexOf("id=" + person.getId(), index + 9)) > 0 && (index = result.indexOf(person.getClass().getSimpleName(), index + 4)) > 0 && (index = result.indexOf("id=" + person.getId(), index + person.getClass().getSimpleName().length())) > 0) {
                    index = result.indexOf("name=" + person.getName(), index + 4);
                    find = index > 0;
                }
            } else if (sensitiveData == ProcessSensitiveData.HIDE) {
                if (index > 0) {
                    find = (index = result.indexOf("v = []", index)) > 0;
                }
            } else if (index > 0) {
                index = result.indexOf("v = [" + person.hashCode() + "]", index);
                find = index > 0;
            }
            IgniteWalConverterTest.assertTrue((String)("DataRecord for Person(id=" + person.getId() + ") not found"), (boolean)find);
        }
    }

    @Test
    public void testIgniteWalConverterWithOutBinaryMeta() throws Exception {
        LinkedList<Person> list = new LinkedList<Person>();
        this.createWal(list, null);
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outByte);
        IgniteWalConverterArguments arg = new IgniteWalConverterArguments(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal/archive", (boolean)false), 4096, null, null, false, null, null, null, null, ProcessSensitiveData.SHOW, true, true, Collections.emptyList());
        IgniteWalConverter.convert((PrintStream)out, (IgniteWalConverterArguments)arg);
        String result = outByte.toString();
        int index = 0;
        for (Person person : list) {
            int start;
            boolean find = false;
            if ((index = result.indexOf("DataRecord", index)) > 0 && (index = result.indexOf(" v = [", index + 10)) > 0 && (index = result.indexOf("]", start = index + 6)) > 0) {
                String value = result.substring(start, index);
                find = new String(Base64.getDecoder().decode(value)).contains(person.getName());
            }
            IgniteWalConverterTest.assertTrue((String)("DataRecord for Person(id=" + person.getId() + ") not found"), (boolean)find);
        }
    }

    @Test
    public void testIgniteWalConverterWithBrokenWal() throws Exception {
        LinkedList<Person> list = new LinkedList<Person>();
        String nodeFolder = this.createWal(list, null);
        File walDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false);
        File wal = new File(walDir, nodeFolder + File.separator + "0000000000000000.wal");
        try (RandomAccessFile raf = new RandomAccessFile(wal, "rw");){
            raf.seek(29L);
            byte[] findByte = "Name 0".getBytes();
            boolean find = false;
            while (!find) {
                int recordTypeIndex = raf.read();
                if (recordTypeIndex <= 0) continue;
                long idx = raf.readLong();
                int fileOff = Integer.reverseBytes(raf.readInt());
                int len = Integer.reverseBytes(raf.readInt());
                if (--recordTypeIndex == WALRecord.RecordType.DATA_RECORD_V2.index()) {
                    int b;
                    int i = 0;
                    while (!find && (b = raf.read()) >= 0) {
                        if (findByte[i] == b) {
                            if (++i != findByte.length) continue;
                            find = true;
                            continue;
                        }
                        i = 0;
                    }
                    if (find) {
                        raf.seek(raf.getFilePointer() - 1L);
                        raf.write(32);
                    }
                }
                raf.seek(fileOff + len);
            }
        }
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outByte);
        IgniteWalConverterArguments arg = new IgniteWalConverterArguments(walDir, U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal/archive", (boolean)false), 4096, new File(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/binary_meta", (boolean)false), nodeFolder), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/marshaller", (boolean)false), true, null, null, null, null, ProcessSensitiveData.SHOW, true, true, Collections.emptyList());
        IgniteWalConverter.convert((PrintStream)out, (IgniteWalConverterArguments)arg);
        String result = outByte.toString();
        int index = 0;
        int countErrorRead = 0;
        for (Person person : list) {
            boolean find = false;
            if ((index = result.indexOf("DataRecord", index)) > 0 && (index = result.indexOf("PersonKey", index + 10)) > 0 && (index = result.indexOf("id=" + person.getId(), index + 9)) > 0 && (index = result.indexOf(person.getClass().getSimpleName(), index + 4)) > 0 && (index = result.indexOf("id=" + person.getId(), index + person.getClass().getSimpleName().length())) > 0) {
                index = result.indexOf("name=" + person.getName(), index + 4);
                boolean bl = find = index > 0;
            }
            if (find) continue;
            ++countErrorRead;
        }
        IgniteWalConverterTest.assertEquals((int)1, (int)countErrorRead);
    }

    @Test
    public void testIgniteWalConverterWithUnreadableWal() throws Exception {
        LinkedList<Person> list = new LinkedList<Person>();
        String nodeFolder = this.createWal(list, null);
        File walDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false);
        File wal = new File(walDir, nodeFolder + File.separator + "0000000000000000.wal");
        try (RandomAccessFile raf = new RandomAccessFile(wal, "rw");){
            raf.seek(29L);
            int find = 0;
            while (find < 2) {
                int recordTypeIndex = raf.readUnsignedByte();
                if (recordTypeIndex <= 0) continue;
                if (--recordTypeIndex == WALRecord.RecordType.DATA_RECORD_V2.index() && ++find == 2) {
                    raf.seek(raf.getFilePointer() - 1L);
                    raf.write(127);
                }
                long idx = raf.readLong();
                int fileOff = Integer.reverseBytes(raf.readInt());
                int len = Integer.reverseBytes(raf.readInt());
                raf.seek(fileOff + len);
            }
        }
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outByte);
        IgniteWalConverterArguments arg = new IgniteWalConverterArguments(walDir, U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal/archive", (boolean)false), 4096, new File(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/binary_meta", (boolean)false), nodeFolder), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/marshaller", (boolean)false), true, null, null, null, null, ProcessSensitiveData.SHOW, true, true, Collections.emptyList());
        IgniteWalConverter.convert((PrintStream)out, (IgniteWalConverterArguments)arg);
        String result = outByte.toString();
        int index = 0;
        int countErrorRead = 0;
        for (Person person : list) {
            boolean find = false;
            if ((index = result.indexOf("DataRecord", index)) > 0 && (index = result.indexOf("PersonKey", index + 10)) > 0 && (index = result.indexOf("id=" + person.getId(), index + 9)) > 0 && (index = result.indexOf(person.getClass().getSimpleName(), index + 4)) > 0 && (index = result.indexOf("id=" + person.getId(), index + person.getClass().getSimpleName().length())) > 0) {
                index = result.indexOf("name=" + person.getName(), index + 4);
                boolean bl = find = index > 0;
            }
            if (find) continue;
            ++countErrorRead;
        }
        IgniteWalConverterTest.assertEquals((int)1, (int)countErrorRead);
    }

    @Test
    public void testPages() throws Exception {
        ArrayList walRecords = new ArrayList();
        String nodeDir = this.createWal(new ArrayList<Person>(), (IgniteThrowableConsumer<IgniteEx>)(IgniteThrowableConsumer & Serializable)n -> {
            try (WALIterator walIter = n.context().cache().context().wal().replay((WALPointer)new FileWALPointer(0L, 0, 0));){
                while (walIter.hasNextX()) {
                    WALRecord walRecord = (WALRecord)((IgniteBiTuple)walIter.nextX()).get2();
                    if (!(walRecord instanceof PageSnapshot)) continue;
                    walRecords.add(new T2((Object)((PageSnapshot)walRecord), (Object)walRecord.toString()));
                }
            }
        });
        IgniteWalConverterTest.assertFalse((boolean)walRecords.isEmpty());
        File walDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false);
        IgniteWalConverterTest.assertTrue((U.fileCount((Path)walDir.toPath()) > 0 ? 1 : 0) != 0);
        File walNodeDir = new File(walDir, nodeDir);
        IgniteWalConverterTest.assertTrue((U.fileCount((Path)walNodeDir.toPath()) > 0 ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        T2 expRec = (T2)walRecords.get(0);
        IgniteWalConverterArguments args = IgniteWalConverterArguments.parse((PrintStream)ps, (String[])new String[]{"--wal-dir", walDir.getAbsolutePath(), "--pages", ((PageSnapshot)expRec.get1()).fullPageId().groupId() + ":" + ((PageSnapshot)expRec.get1()).fullPageId().pageId(), "--skip-crc"});
        baos.reset();
        IgniteWalConverter.convert((PrintStream)ps, (IgniteWalConverterArguments)args);
        GridTestUtils.assertContains((IgniteLogger)log, (String)baos.toString(), (String)((String)expRec.get2()));
    }

    private String createWal(List<Person> list, @Nullable IgniteThrowableConsumer<IgniteEx> afterPopulateConsumer) throws Exception {
        String nodeFolder;
        try (IgniteEx node = this.startGrid(0);){
            node.cluster().active(true);
            nodeFolder = node.context().pdsFolderResolver().resolveFolders().folderName();
            IgniteCache cache = node.cache("default");
            for (int i = 0; i < 10; ++i) {
                PersonKey key = new PersonKey(i);
                Person value = i % 2 == 0 ? new Person(i, PERSON_NAME_PREFIX + i) : new PersonEx(i, PERSON_NAME_PREFIX + i, "Additional information " + i, "Description " + i);
                cache.put((Object)key, (Object)value);
                list.add(value);
            }
            if (afterPopulateConsumer != null) {
                afterPopulateConsumer.accept((Object)node);
            }
        }
        return nodeFolder;
    }
}

