/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.util.Base64;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveDataUtils;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.UnwrappedDataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV1Serializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

class DataEntryWrapper
extends DataEntry {
    private final DataEntry source;
    private final ProcessSensitiveData sensitiveData;

    public DataEntryWrapper(DataEntry dataEntry, ProcessSensitiveData sensitiveData) {
        super(dataEntry.cacheId(), dataEntry.key(), dataEntry.value(), dataEntry.op(), dataEntry.nearXidVersion(), dataEntry.writeVersion(), dataEntry.expireTime(), dataEntry.partitionId(), dataEntry.partitionCounter(), dataEntry.flags());
        this.source = dataEntry;
        this.sensitiveData = sensitiveData;
    }

    public String toString() {
        String valueStr;
        String keyStr;
        if (this.source instanceof UnwrappedDataEntry) {
            UnwrappedDataEntry unwrappedDataEntry = (UnwrappedDataEntry)this.source;
            keyStr = this.toString(unwrappedDataEntry.unwrappedKey(), (CacheObject)this.source.key());
            valueStr = this.toString(unwrappedDataEntry.unwrappedValue(), this.source.value());
        } else if (this.source instanceof RecordDataV1Serializer.EncryptedDataEntry) {
            keyStr = "<encrypted>";
            valueStr = "<encrypted>";
        } else {
            keyStr = this.toString(null, (CacheObject)this.source.key());
            valueStr = this.toString(null, this.source.value());
        }
        return new SB(this.source.getClass().getSimpleName()).a("[k = ").a(keyStr).a(", v = [").a(valueStr).a("]").a(", super = [").a(S.toString(DataEntry.class, (Object)this.source)).a("]]").toString();
    }

    public String toString(Object value, CacheObject co) {
        if (this.sensitiveData == ProcessSensitiveData.SHOW || this.sensitiveData == ProcessSensitiveData.MD5) {
            String str = value instanceof String ? (String)value : (value instanceof BinaryObject ? value.toString() : (value != null ? DataEntryWrapper.toStringRecursive(value.getClass(), value) : (co instanceof BinaryObject ? co.toString() : null)));
            if (str == null || str.isEmpty()) {
                try {
                    CacheObjectValueContext ctx;
                    try {
                        ctx = (CacheObjectValueContext)IgniteUtils.field((Object)this.source, (String)"cacheObjValCtx");
                    }
                    catch (Exception e) {
                        throw new IgniteException((Throwable)e);
                    }
                    str = Base64.getEncoder().encodeToString(co.valueBytes(ctx));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
            if (this.sensitiveData == ProcessSensitiveData.MD5) {
                str = ProcessSensitiveDataUtils.md5(str);
            }
            return str;
        }
        if (this.sensitiveData == ProcessSensitiveData.HIDE) {
            return "";
        }
        if (value != null) {
            return Integer.toString(value.hashCode());
        }
        return Integer.toString(co.hashCode());
    }

    public static String toStringRecursive(Class cls, Object obj) {
        String result = null;
        if (cls != Object.class) {
            result = S.toString((Class)cls, (Object)obj, (String)DataEntryWrapper.toStringRecursive(cls.getSuperclass(), obj));
        }
        return result;
    }
}

