/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.File;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexReaderUtils {
    private IndexReaderUtils() {
        throw new UnsupportedOperationException();
    }

    public static long align(long val, int base) {
        if (val % (long)base == 0L) {
            return val;
        }
        return (val / (long)base + 1L) * (long)base;
    }

    public static long linkSize() {
        return U.jvm32Bit() ? 4L : 8L;
    }

    public static long objectSize(long fieldsSize) {
        return IndexReaderUtils.align(2L * IndexReaderUtils.linkSize() + fieldsSize, 8);
    }

    public static long objectArraySize(int len) {
        return IndexReaderUtils.align(2L * IndexReaderUtils.linkSize() + IndexReaderUtils.linkSize() * (long)len, 8);
    }

    public static String partitionFileAbsolutePath(File parent, int partId) {
        String fileName = partId == 65535 ? "index.bin" : String.format("part-%d.bin", partId);
        return new File(parent, fileName).getAbsolutePath();
    }
}

