/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskArg;
import org.apache.ignite.internal.visor.encryption.VisorChangeCacheGroupKeyTask;

public class ChangeCacheGroupKeyCommand
extends AbstractCommand<VisorCacheGroupEncryptionTaskArg> {
    private VisorCacheGroupEncryptionTaskArg taskArg;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            TaskExecutor.executeTaskByNameOnNode(client, VisorChangeCacheGroupKeyTask.class.getName(), this.taskArg, null, clientCfg);
            log.info("The encryption key has been changed for the cache group \"" + this.taskArg.groupName() + "\".");
            Object var5_6 = null;
            return var5_6;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will change the encryption key of the cache group. Joining a node during the key change process is prohibited and will be rejected.";
    }

    @Override
    public VisorCacheGroupEncryptionTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String argCacheGrpName = argIter.nextArg("\u0421ache group name is expected.");
        this.taskArg = new VisorCacheGroupEncryptionTaskArg(argCacheGrpName);
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected command argument: " + argIter.peekNextArg());
        }
    }

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Change the encryption key of the cache group:", CommandList.ENCRYPTION, EncryptionSubcommands.CHANGE_CACHE_GROUP_KEY.toString(), "cacheGroupName");
    }

    @Override
    public String name() {
        return EncryptionSubcommands.CHANGE_CACHE_GROUP_KEY.text().toUpperCase();
    }
}

