/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr;

import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCacheCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCheckPartitionCountersCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCleanupPartitionLogCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrFSTCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrHelpCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrNodeCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrPauseCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrRebuildPartitionLogCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrRepairPartitionCountersCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrResumeCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrStateCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrTopologyCommand;
import org.jetbrains.annotations.NotNull;

public enum DrSubCommandsList {
    HELP("help", new DrHelpCommand()),
    STATE("state", new DrStateCommand()),
    TOPOLOGY("topology", new DrTopologyCommand()),
    NODE("node", new DrNodeCommand()),
    CACHE("cache", new DrCacheCommand()),
    PAUSE("pause", new DrPauseCommand()),
    RESUME("resume", new DrResumeCommand()),
    CHECK("check-partition-counters", new DrCheckPartitionCountersCommand()),
    REPAIR("repair-partition-counters", new DrRepairPartitionCountersCommand()),
    REBUILD_TREES("rebuild-partition-tree", new DrRebuildPartitionLogCommand()),
    FULL_STATE_TRANSFER("full-state-transfer", new DrFSTCommand()),
    CLEANUP_TREES("cleanup-partition-tree", new DrCleanupPartitionLogCommand());

    private final String name;
    private final Command<?> cmd;

    private DrSubCommandsList(String name, Command<?> cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    public String text() {
        return this.name;
    }

    @NotNull
    public Command<?> command() {
        return this.cmd;
    }

    public static DrSubCommandsList parse(String name) {
        for (DrSubCommandsList cmd : DrSubCommandsList.values()) {
            if (!cmd.name.equalsIgnoreCase(name)) continue;
            return cmd;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

