/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IdleVerifyCommandArg;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsDumpTask;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskResult;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2;
import org.apache.ignite.lang.IgniteProductVersion;

public class IdleVerify
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String CACHES = "cacheName1,...,cacheNameN";
        String description = "Verify counters and hash sums of primary and backup partitions for the specified caches/cache groups on an idle cluster and print out the differences, if any. When no parameters are specified, all user caches are verified. Cache filtering options configure the set of caches that will be processed by " + (Object)((Object)CacheSubcommands.IDLE_VERIFY) + " command. If cache names are specified, in form of regular expressions, only matching caches will be verified. Caches matched by regexes specified after " + IdleVerifyCommandArg.EXCLUDE_CACHES + " parameter will be excluded from verification. Using parameter " + IdleVerifyCommandArg.CACHE_FILTER + " you can verify: only " + CacheFilterEnum.USER + " caches, only user " + CacheFilterEnum.PERSISTENT + " caches, only user " + CacheFilterEnum.NOT_PERSISTENT + " caches, only " + CacheFilterEnum.SYSTEM + " caches, or " + CacheFilterEnum.ALL + " of the above.";
        CacheCommands.usageCache(logger, CacheSubcommands.IDLE_VERIFY, description, Collections.singletonMap(IdleVerifyCommandArg.CHECK_CRC.toString(), "check the CRC-sum of pages stored on disk before verifying data consistency in partitions between primary and backup nodes."), CommandLogger.optional(IdleVerifyCommandArg.DUMP), CommandLogger.optional(IdleVerifyCommandArg.SKIP_ZEROS), CommandLogger.optional(IdleVerifyCommandArg.CHECK_CRC), CommandLogger.optional(IdleVerifyCommandArg.EXCLUDE_CACHES, CACHES), CommandLogger.optional(IdleVerifyCommandArg.CACHE_FILTER, CommandLogger.or(CacheFilterEnum.ALL, CacheFilterEnum.USER, CacheFilterEnum.SYSTEM, CacheFilterEnum.PERSISTENT, CacheFilterEnum.NOT_PERSISTENT)), CommandLogger.optional(CACHES));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Collection nodes = client.compute().nodes(GridClientNode::connectable);
            boolean idleVerifyV2 = true;
            for (GridClientNode node : nodes) {
                String nodeVerStr = (String)node.attribute("org.apache.ignite.build.ver");
                IgniteProductVersion nodeVer = IgniteProductVersion.fromString((String)nodeVerStr);
                if (nodeVer.compareTo(VerifyBackupPartitionsTaskV2.V2_SINCE_VER) >= 0) continue;
                idleVerifyV2 = false;
                break;
            }
            if (this.args.dump()) {
                this.cacheIdleVerifyDump(client, clientCfg, logger);
            } else if (idleVerifyV2) {
                this.cacheIdleVerifyV2(client, clientCfg, logger);
            } else {
                this.legacyCacheIdleVerify(client, clientCfg, logger);
            }
        }
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set<String> cacheNames = null;
        boolean dump = false;
        boolean skipZeros = false;
        boolean idleCheckCrc = false;
        CacheFilterEnum cacheFilterEnum = CacheFilterEnum.DEFAULT;
        Set<String> excludeCaches = null;
        int idleVerifyArgsCnt = 5;
        while (argIter.hasNextSubArg() && idleVerifyArgsCnt-- > 0) {
            String nextArg = argIter.nextArg("");
            IdleVerifyCommandArg arg = CommandArgUtils.of(nextArg, IdleVerifyCommandArg.class);
            if (arg == null) {
                cacheNames = argIter.parseStringSet(nextArg);
                this.validateRegexes(cacheNames);
                continue;
            }
            switch (arg) {
                case DUMP: {
                    dump = true;
                    break;
                }
                case SKIP_ZEROS: {
                    skipZeros = true;
                    break;
                }
                case CHECK_CRC: {
                    idleCheckCrc = true;
                    break;
                }
                case CACHE_FILTER: {
                    String filter = argIter.nextArg("The cache filter should be specified. The following values can be used: " + Arrays.toString(CacheFilterEnum.values()) + '.');
                    cacheFilterEnum = CacheFilterEnum.valueOf((String)filter.toUpperCase());
                    break;
                }
                case EXCLUDE_CACHES: {
                    excludeCaches = argIter.nextStringSet("caches, which will be excluded.");
                    this.validateRegexes(excludeCaches);
                }
            }
        }
        if (idleCheckCrc) {
            if (cacheFilterEnum == CacheFilterEnum.ALL || cacheFilterEnum == CacheFilterEnum.SYSTEM) {
                throw new IllegalArgumentException((Object)((Object)CacheSubcommands.IDLE_VERIFY) + " with " + IdleVerifyCommandArg.CHECK_CRC + " and " + IdleVerifyCommandArg.CACHE_FILTER + " " + CacheFilterEnum.ALL + " or " + CacheFilterEnum.SYSTEM + " not allowed. You should remove " + IdleVerifyCommandArg.CHECK_CRC + " or change " + IdleVerifyCommandArg.CACHE_FILTER + " value.");
            }
            if (F.constainsStringIgnoreCase(cacheNames, (String)"ignite-sys-cache")) {
                throw new IllegalArgumentException((Object)((Object)CacheSubcommands.IDLE_VERIFY) + " with " + IdleVerifyCommandArg.CHECK_CRC + " not allowed for `" + "ignite-sys-cache" + "` cache.");
            }
        }
        this.args = new Arguments(cacheNames, excludeCaches, dump, skipZeros, idleCheckCrc, cacheFilterEnum);
    }

    private void validateRegexes(Set<String> string) {
        string.forEach(s -> {
            try {
                Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                throw new IgniteException(String.format("Invalid cache name regexp '%s': %s", s, e.getMessage()));
            }
        });
    }

    private void cacheIdleVerifyDump(GridClient client, GridClientConfiguration clientCfg, Logger logger) throws GridClientException {
        VisorIdleVerifyDumpTaskArg arg = new VisorIdleVerifyDumpTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc());
        String path = (String)TaskExecutor.executeTask(client, VisorIdleVerifyDumpTask.class, arg, clientCfg);
        VerifyBackupPartitionsDumpTask.logParsedArgs((VisorIdleVerifyTaskArg)arg, logger::info);
        logger.info("VisorIdleVerifyDumpTask successfully written output to '" + path + "'");
    }

    private void cacheIdleVerifyV2(GridClient client, GridClientConfiguration clientCfg, Logger log) throws GridClientException {
        VisorIdleVerifyTaskArg taskArg = new VisorIdleVerifyTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc());
        IdleVerifyResultV2 res = (IdleVerifyResultV2)TaskExecutor.executeTask(client, VisorIdleVerifyTaskV2.class, taskArg, clientCfg);
        VerifyBackupPartitionsDumpTask.logParsedArgs((VisorIdleVerifyTaskArg)taskArg, log::info);
        res.print(log::info);
    }

    private void legacyCacheIdleVerify(GridClient client, GridClientConfiguration clientCfg, Logger logger) throws GridClientException {
        VisorIdleVerifyTaskResult res = (VisorIdleVerifyTaskResult)TaskExecutor.executeTask(client, VisorIdleVerifyTask.class, new VisorIdleVerifyTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc()), clientCfg);
        Map conflicts = res.getConflicts();
        if (conflicts.isEmpty()) {
            logger.info("idle_verify check has finished, no conflicts have been found.");
            logger.info("");
        } else {
            logger.info("idle_verify check has finished, found " + conflicts.size() + " conflict partitions.");
            logger.info("");
            for (Map.Entry entry : conflicts.entrySet()) {
                logger.info("Conflict partition: " + entry.getKey());
                logger.info("Partition instances: " + entry.getValue());
            }
        }
    }

    @Override
    public String name() {
        return CacheSubcommands.IDLE_VERIFY.text().toUpperCase();
    }

    public static class Arguments {
        private Set<String> caches;
        private Set<String> excludeCaches;
        private boolean dump;
        private boolean skipZeros;
        private boolean idleCheckCrc;
        private CacheFilterEnum cacheFilterEnum;

        public Arguments(Set<String> caches, Set<String> excludeCaches, boolean dump, boolean skipZeros, boolean idleCheckCrc, CacheFilterEnum cacheFilterEnum) {
            this.caches = caches;
            this.excludeCaches = excludeCaches;
            this.dump = dump;
            this.skipZeros = skipZeros;
            this.idleCheckCrc = idleCheckCrc;
            this.cacheFilterEnum = cacheFilterEnum;
        }

        public CacheFilterEnum getCacheFilterEnum() {
            return this.cacheFilterEnum;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public Set<String> excludeCaches() {
            return this.excludeCaches;
        }

        public boolean dump() {
            return this.dump;
        }

        public boolean idleCheckCrc() {
            return this.idleCheckCrc;
        }

        public boolean isSkipZeros() {
            return this.skipZeros;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

