/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTask;
import org.apache.ignite.internal.visor.checkpoint.VisorCheckpointTaskResult;
import org.jetbrains.annotations.Nullable;

public class CheckpointCommand
extends AbstractCommand<Void> {
    private static final String NODE_ID_ARG_NAME = "--node-id";
    @Nullable
    private UUID nodeId;

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Start checkpointing on a node with specified nodeId. If nodeId is not specified checkpoint is started on all nodes:", CommandList.CHECKPOINT, CommandLogger.optional(NODE_ID_ARG_NAME, "<nodeId>"));
    }

    @Override
    public String name() {
        return CommandList.CHECKPOINT.toCommandName();
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            List<GridClientNode> nodes;
            GridClientCompute compute = client.compute();
            if (this.nodeId == null) {
                nodes = compute.nodes(n -> n.connectable() && !n.isClient());
            } else {
                GridClientNode node = compute.node(this.nodeId);
                if (node == null) {
                    throw new IllegalArgumentException(this.collectNodesInfo(compute));
                }
                nodes = Collections.singletonList(node);
            }
            if (F.isEmpty((Collection)nodes)) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            VisorCheckpointTaskResult res = (VisorCheckpointTaskResult)compute.projection(nodes).execute(VisorCheckpointTask.class.getName(), (Object)new VisorTaskArgument((Collection)nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList()), (Object)this.arg(), false));
            if (res.isSuccess()) {
                String nodesMsgPart = nodes.size() == 1 ? "1 node." : res.numberOfSuccessNodes() + " nodes.";
                log.info("Checkpointing completed successfully on " + nodesMsgPart);
            } else {
                String nodesMsgPart = nodes.size() == 1 ? "1 node." : res.numberOfFailedNodes() + " nodes.";
                log.info("Checkpointing completed with errors on " + nodesMsgPart);
            }
        }
        catch (Throwable e) {
            log.severe("Failed to execute checkpointing command='" + this.name() + "'");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeId = null;
        while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("Unexpected error on parsing checkpoint command args");
            if (!nextArg.equals(NODE_ID_ARG_NAME)) continue;
            this.nodeId = UUID.fromString(argIter.nextArg("Failed to read node ID"));
        }
    }

    private String collectNodesInfo(GridClientCompute compute) throws GridClientException {
        SB b = new SB();
        b.a("Node with id=" + this.nodeId + " is not found in the topology").nl().a("Available cluster nodes:").nl();
        compute.nodes(node -> node.connectable() && !node.isClient()).forEach(node -> b.a((Object)node.nodeId()).nl());
        return b.toString();
    }
}

