/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.metric.MetricCommandArg;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.junit.Test;

public class MetricCommandTest
extends GridCommandHandlerClusterByClassAbstractTest {
    protected static final String CMD_METRIC = CommandList.METRIC.text();
    private IgniteEx ignite0;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.injectTestSystemOut();
        this.autoConfirmation = false;
        this.ignite0 = this.ignite(0);
    }

    @Test
    public void testMetricNameMissedFailure() {
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(1, CMD_METRIC), (String)"The name of a metric(metric registry) is expected.");
    }

    @Test
    public void testNodeIdMissedFailure() {
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(1, CMD_METRIC, "sys", MetricCommandArg.NODE_ID.argName()), (String)"ID of the node from which metric values should be obtained is expected.");
    }

    @Test
    public void testInvalidNodeIdFailure() {
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(1, CMD_METRIC, "sys", MetricCommandArg.NODE_ID.argName(), "invalid_node_id"), (String)("Failed to parse " + MetricCommandArg.NODE_ID.argName() + " command argument. String representation of \"java.util.UUID\" is expected. For example: 123e4567-e89b-42d3-a456-556642440000"));
    }

    @Test
    public void testMultipleMetricNamesFailure() {
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(1, CMD_METRIC, "ignite", "sys"), (String)"Multiple metric(metric registry) names are not supported.");
    }

    @Test
    public void testNonExistentNodeIdFailure() {
        String incorrectNodeId = UUID.randomUUID().toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(1, CMD_METRIC, "--node-id", incorrectNodeId, "ignite"), (String)("Failed to perform operation.\nNode with id=" + incorrectNodeId + " not found"));
    }

    @Test
    public void testNonExistentMetric() {
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(0, CMD_METRIC, "ignite."), (String)"No metric with specified name was found [name=ignite.]");
        GridTestUtils.assertContains((IgniteLogger)log, (String)this.executeCommand(0, CMD_METRIC, "nonexistent.metric"), (String)"No metric with specified name was found [name=nonexistent.metric]");
    }

    @Test
    public void testHistogramMetrics() {
        String mregName = "histogram-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        long[] bounds = new long[]{50L, 500L};
        HistogramMetricImpl histogram = mreg.histogram("histogram", bounds, null);
        histogram.value(10L);
        histogram.value(51L);
        histogram.value(60L);
        histogram.value(600L);
        histogram.value(600L);
        histogram.value(600L);
        histogram = mreg.histogram("histogram_with_underscore", bounds, null);
        histogram.value(10L);
        histogram.value(51L);
        histogram.value(60L);
        histogram.value(600L);
        histogram.value(600L);
        histogram.value(600L);
        MetricCommandTest.assertEquals((String)"1", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_0_50"})));
        MetricCommandTest.assertEquals((String)"2", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_50_500"})));
        MetricCommandTest.assertEquals((String)"3", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_500_inf"})));
        MetricCommandTest.assertEquals((String)"[1, 2, 3]", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram"})));
        MetricCommandTest.assertEquals((String)"1", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_with_underscore_0_50"})));
        MetricCommandTest.assertEquals((String)"2", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_with_underscore_50_500"})));
        MetricCommandTest.assertEquals((String)"3", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_with_underscore_500_inf"})));
        MetricCommandTest.assertEquals((String)"[1, 2, 3]", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "histogram_with_underscore"})));
    }

    @Test
    public void testNodeIdArgument() {
        String mregName = "boolean-metric-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.booleanMetric("boolean-metric", "");
        mreg = this.ignite(1).context().metric().registry(mregName);
        mreg.booleanMetric("boolean-metric", "").value(true);
        MetricCommandTest.assertEquals((String)"false", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "boolean-metric"})));
        MetricCommandTest.assertEquals((String)"true", (String)this.metric(this.ignite(1), MetricUtils.metricName((String[])new String[]{mregName, "boolean-metric"})));
    }

    @Test
    public void testRegistryMetrics() {
        String mregName = "test-metric-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.booleanMetric("boolean-metric", "");
        mreg.longMetric("long-metric", "").increment();
        mreg.intMetric("int-metric", "").increment();
        mreg.doubleMetric("double-metric", "");
        mreg.hitRateMetric("hitrate-metric", "", this.getTestTimeout(), 2);
        mreg.histogram("histogram", new long[]{50L, 100L}, null).value(10L);
        mreg.hitRateMetric("hitrate-metric", "", this.getTestTimeout(), 2);
        mreg.objectMetric("object-metric", Object.class, "").value(new Object(){

            public String toString() {
                return "test-object";
            }
        });
        Map<String, String> metrics = this.metrics(this.ignite0, mregName);
        MetricCommandTest.assertEquals((String)"0.0", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "double-metric"})));
        MetricCommandTest.assertEquals((String)"false", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "boolean-metric"})));
        MetricCommandTest.assertEquals((String)"1", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "long-metric"})));
        MetricCommandTest.assertEquals((String)"1", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "int-metric"})));
        MetricCommandTest.assertEquals((String)"test-object", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "object-metric"})));
        MetricCommandTest.assertEquals((String)"[1, 0, 0]", (String)metrics.get(MetricUtils.metricName((String[])new String[]{mregName, "histogram"})));
        MetricCommandTest.assertEquals((String)"0", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "hitrate-metric"})));
    }

    @Test
    public void testBooleanMetrics() {
        String mregName = "boolean-metric-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.booleanMetric("boolean-metric", "");
        MetricCommandTest.assertEquals((String)"false", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "boolean-metric"})));
        mreg.register("boolean-gauge", () -> true, "");
        MetricCommandTest.assertEquals((String)"true", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "boolean-gauge"})));
    }

    @Test
    public void testLongMetrics() {
        String mregName = "long-metric-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.longMetric("long-metric", "").add(Long.MAX_VALUE);
        MetricCommandTest.assertEquals((String)Long.toString(Long.MAX_VALUE), (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "long-metric"})));
        mreg.register("long-gauge", () -> 0L, "");
        MetricCommandTest.assertEquals((String)"0", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "long-gauge"})));
    }

    @Test
    public void testIntegerMetrics() {
        String mregName = "int-metric-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.intMetric("int-metric", "").add(Integer.MAX_VALUE);
        MetricCommandTest.assertEquals((String)Integer.toString(Integer.MAX_VALUE), (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "int-metric"})));
        mreg.register("int-gauge", () -> 0, "");
        MetricCommandTest.assertEquals((String)"0", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "int-gauge"})));
    }

    @Test
    public void testDoubleMetrics() {
        String mregName = "int-double-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.doubleMetric("double-metric", "").add(111.222);
        MetricCommandTest.assertEquals((String)"111.222", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "double-metric"})));
        mreg.register("double-gauge", () -> 0.0, "");
        MetricCommandTest.assertEquals((String)"0.0", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "double-gauge"})));
    }

    @Test
    public void testObjectMetrics() {
        String mregName = "object-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        Object metricVal = new Object(){

            public String toString() {
                return "test-object";
            }
        };
        mreg.objectMetric("object-metric", Object.class, "").value(metricVal);
        MetricCommandTest.assertEquals((String)"test-object", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "object-metric"})));
        mreg.register("object-gauge", () -> metricVal, Object.class, "");
        MetricCommandTest.assertEquals((String)"test-object", (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "object-gauge"})));
    }

    @Test
    public void testHitrateMetrics() {
        String mregName = "hitrate-registry";
        MetricRegistry mreg = this.ignite0.context().metric().registry(mregName);
        mreg.hitRateMetric("hitrate-metric", "", this.getTestTimeout(), 2).add(Integer.MAX_VALUE);
        MetricCommandTest.assertEquals((String)Integer.toString(Integer.MAX_VALUE), (String)this.metric(this.ignite0, MetricUtils.metricName((String[])new String[]{mregName, "hitrate-metric"})));
    }

    protected Map<String, String> metrics(IgniteEx node, String metricName) {
        String nodeId = node.context().discovery().localNode().id().toString();
        String out = this.executeCommand(0, CMD_METRIC, metricName, MetricCommandArg.NODE_ID.argName(), nodeId);
        Map<String, String> res = this.parseMetricCommandOutput(out);
        MetricCommandTest.assertEquals((String)"value", (String)res.remove("metric"));
        return res;
    }

    protected String metric(IgniteEx node, String name) {
        Map<String, String> metrics = this.metrics(node, name);
        MetricCommandTest.assertEquals((int)1, (int)metrics.size());
        return metrics.get(name);
    }

    protected Map<String, String> parseMetricCommandOutput(String out) {
        String outStart = "--------------------------------------------------------------------------------";
        String outEnd = "Command [" + CommandList.METRIC.toCommandName() + "] finished with code: " + 0;
        String[] rows = out.substring(out.indexOf(outStart) + outStart.length() + 1, out.indexOf(outEnd) - 1).split(U.nl());
        HashMap<String, String> res = new HashMap<String, String>();
        for (String row : rows) {
            Iterator iter = Arrays.stream(row.split(Pattern.quote("    "))).map(String::trim).filter(str -> !str.isEmpty()).iterator();
            res.put((String)iter.next(), (String)iter.next());
        }
        return res;
    }

    protected String executeCommand(int expExitCode, String ... args) {
        int res = this.execute(args);
        MetricCommandTest.assertEquals((int)expExitCode, (int)res);
        return testOut.toString();
    }
}

