/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.apache.ignite.util.GridCommandHandlerTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Ignore;
import org.junit.Test;

public class GridCommandHandlerSslTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    private volatile String[] cipherSuites;

    @NotNull
    private SslContextFactory createSslFactory() {
        SslContextFactory factory = (SslContextFactory)GridTestUtils.sslFactory();
        factory.setCipherSuites(this.cipherSuites);
        return factory;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration());
        cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setMaxSize(0x6400000L);
        cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(true);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        cfg.getConnectorConfiguration().setSslEnabled(true);
        cfg.setSslContextFactory((Factory)this.createSslFactory());
        return cfg;
    }

    private void activate(String nodeCipherSuite, String utilityCipherSuite, int expRes) throws Exception {
        this.cipherSuites = F.isEmpty((String)nodeCipherSuite) ? null : nodeCipherSuite.split(",");
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerSslTest.assertFalse((boolean)ignite.cluster().active());
        CommandHandler cmd = new CommandHandler();
        ArrayList<String> params = new ArrayList<String>();
        GridCommandHandlerTestUtils.addSslParams(params);
        if (!F.isEmpty((String)utilityCipherSuite)) {
            params.add("--ssl-cipher-suites");
            params.add(utilityCipherSuite);
        }
        params.add("--activate");
        GridCommandHandlerSslTest.assertEquals((int)expRes, (int)this.execute(params));
        if (expRes == 0) {
            GridCommandHandlerSslTest.assertTrue((boolean)ignite.cluster().active());
        } else {
            GridCommandHandlerSslTest.assertFalse((boolean)ignite.cluster().active());
        }
        GridCommandHandlerSslTest.assertEquals((int)2, (int)cmd.execute(Arrays.asList("--deactivate", "--yes")));
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-33457")
    public void testClientWithoutSslConnectsToSslEnabledCluster() throws Exception {
        this.startGrid(0);
        ArrayList<String> params = new ArrayList<String>();
        params.add("--activate");
        this.injectTestSystemOut();
        GridCommandHandlerSslTest.assertEquals((int)2, (int)this.execute(params));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"firewall settings");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"SSL configuration");
    }

    @Test
    public void testDefaultCipherSuite() throws Exception {
        this.cipherSuites = null;
        this.activate(null, null, 0);
    }

    @Test
    public void testSameCipherSuite() throws Exception {
        String ciphers = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        this.activate(ciphers, ciphers, 0);
    }

    @Test
    public void testOneCommonCipherSuite() throws Exception {
        String nodeCipherSuites = "TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        String utilityCipherSuites = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        this.activate(nodeCipherSuites, utilityCipherSuites, 0);
    }

    @Test
    public void testNoCommonCipherSuite() throws Exception {
        String nodeCipherSuites = "TLS_RSA_WITH_AES_128_GCM_SHA256";
        String utilityCipherSuites = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";
        this.injectTestSystemOut();
        this.activate(nodeCipherSuites, utilityCipherSuites, 2);
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"SSL handshake failed (connection closed).");
    }
}

