/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.jetbrains.annotations.Nullable;

public class GridCommandHandlerIndexingUtils {
    public static final String CACHE_NAME = "persons-cache-vi";
    static final String CACHE_NAME_SECOND = "persons-cache-vi-second";
    static final String GROUP_NAME = "group1";
    static final String GROUP_NAME_SECOND = "group1_second";
    static final String THREE_ENTRIES_CACHE_NAME_COMMON_PART = "three_entries";

    private GridCommandHandlerIndexingUtils() {
        throw new IllegalArgumentException("don't create");
    }

    public static void createAndFillCache(Ignite ignite, String cacheName, String grpName) {
        GridCommandHandlerIndexingUtils.createAndFillCache(ignite, cacheName, grpName, null, Collections.singletonMap(GridCommandHandlerIndexingUtils.personEntity(), rand -> new Person(rand.nextInt(), String.valueOf(rand.nextLong()))), 10000);
    }

    public static void createAndFillCache(Ignite ignite, String cacheName, String grpName, @Nullable String dataRegionName, Map<QueryEntity, Function<Random, Object>> qryEntities, int cnt) {
        Objects.requireNonNull(ignite);
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(grpName);
        Objects.requireNonNull(qryEntities);
        ignite.createCache(new CacheConfiguration().setName(cacheName).setGroupName(grpName).setDataRegionName(dataRegionName).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setQueryEntities(new ArrayList<QueryEntity>(qryEntities.keySet())).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cacheName);){
            int entity = 0;
            for (Function<Random, Object> fun : qryEntities.values()) {
                for (int i = 0; i < cnt; ++i) {
                    streamer.addData((Object)(i + entity * cnt), fun.apply(rand));
                }
                streamer.flush();
                ++entity;
            }
        }
    }

    static <K, V> void breakCacheDataTree(IgniteLogger log, IgniteInternalCache<K, V> internalCache, int partId, @Nullable BiPredicate<Integer, Cache.Entry<K, V>> filter) {
        Objects.requireNonNull(log);
        Objects.requireNonNull(internalCache);
        GridCacheContext cacheCtx = internalCache.context();
        IgniteCacheOffheapManager.CacheDataStore cacheDataStore = cacheCtx.dht().topology().localPartition(partId).dataStore();
        String delegate = "delegate";
        if (IgniteUtils.hasField((Object)cacheDataStore, (String)delegate)) {
            cacheDataStore = (IgniteCacheOffheapManager.CacheDataStore)IgniteUtils.field((Object)cacheDataStore, (String)delegate);
        }
        CacheDataRowStore cacheDataRowStore = (CacheDataRowStore)IgniteUtils.field((Object)cacheDataStore, (String)"rowStore");
        CacheDataTree cacheDataTree = (CacheDataTree)IgniteUtils.field((Object)cacheDataStore, (String)"dataTree");
        String cacheName = internalCache.name();
        QueryCursor qryCursor = cacheCtx.kernalContext().grid().cache(cacheName).withKeepBinary().query((Query)new ScanQuery(partId));
        Iterator cacheEntryIter = qryCursor.iterator();
        IgniteCacheDatabaseSharedManager db = cacheCtx.shared().database();
        int cacheId = CU.cacheId((String)cacheName);
        int i = 0;
        while (cacheEntryIter.hasNext()) {
            Cache.Entry entry = (Cache.Entry)cacheEntryIter.next();
            if (Objects.nonNull(filter) && !filter.test(i++, entry)) continue;
            db.checkpointReadLock();
            try {
                CacheDataRow oldRow = (CacheDataRow)cacheDataTree.remove((Object)new SearchRow(cacheId, cacheCtx.toCacheKeyObject(entry.getKey())));
                if (!Objects.nonNull(oldRow)) continue;
                cacheDataRowStore.removeRow(oldRow.link(), (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to remove key skipping indexes: " + entry, (Throwable)e);
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
    }

    static void createAndFillThreeFieldsEntryCache(Ignite ignite, String cacheName, String grpName, Collection<QueryEntity> entities) {
        assert (Objects.nonNull(ignite));
        assert (Objects.nonNull(cacheName));
        ignite.createCache(new CacheConfiguration().setName(cacheName).setGroupName(grpName).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setQueryEntities(entities).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cacheName);){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new CacheEntityThreeFields(rand.nextInt(), String.valueOf(rand.nextLong()), rand.nextDouble()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <K, V> void breakSqlIndex(IgniteInternalCache<K, V> internalCache, int partId, @Nullable Predicate<CacheDataRow> filter) throws Exception {
        Objects.requireNonNull(internalCache);
        GridCacheContext cacheCtx = internalCache.context();
        GridDhtLocalPartition locPart = (GridDhtLocalPartition)cacheCtx.topology().localPartitions().get(partId);
        GridIterator cacheDataGridIter = cacheCtx.group().offheap().partitionIterator(locPart.id());
        GridQueryProcessor qryProcessor = internalCache.context().kernalContext().query();
        while (cacheDataGridIter.hasNextX()) {
            CacheDataRow cacheDataRow = (CacheDataRow)cacheDataGridIter.nextX();
            if (Objects.nonNull(filter) && !filter.test(cacheDataRow)) continue;
            cacheCtx.shared().database().checkpointReadLock();
            try {
                qryProcessor.remove(cacheCtx, cacheDataRow);
            }
            finally {
                cacheCtx.shared().database().checkpointReadUnlock();
            }
        }
    }

    static QueryEntity personEntity() {
        String orgIdField = "orgId";
        String nameField = "name";
        return new QueryEntity().setKeyType(Integer.class.getName()).setValueType(Person.class.getName()).addQueryField(orgIdField, Integer.class.getName(), null).addQueryField(nameField, String.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex(nameField), new QueryIndex(orgIdField)));
    }

    static QueryEntity organizationEntity() {
        String idField = "id";
        String nameField = "name";
        return new QueryEntity().setKeyType(Integer.class.getName()).setValueType(Organization.class.getName()).addQueryField(idField, Integer.class.getName(), null).addQueryField(nameField, String.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex(nameField), new QueryIndex(idField)));
    }

    static QueryEntity complexIndexEntity() {
        QueryEntity entity = GridCommandHandlerIndexingUtils.prepareQueryEntity();
        entity.setIndexes(Arrays.asList(new QueryIndex("id"), new QueryIndex("strField"), new QueryIndex(Arrays.asList("strField", "boubleField"), QueryIndexType.SORTED)));
        return entity;
    }

    static QueryEntity simpleIndexEntity() {
        QueryEntity entity = GridCommandHandlerIndexingUtils.prepareQueryEntity();
        entity.setIndexes(Arrays.asList(new QueryIndex("id"), new QueryIndex("strField"), new QueryIndex("boubleField")));
        return entity;
    }

    private static QueryEntity prepareQueryEntity() {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(CacheEntityThreeFields.class.getName());
        entity.addQueryField("id", Integer.class.getName(), null);
        entity.addQueryField("strField", String.class.getName(), null);
        entity.addQueryField("boubleField", Double.class.getName(), null);
        return entity;
    }

    static void createAndFillSeveralCaches(Ignite ignite) {
        GridCommandHandlerIndexingUtils.createAndFillCache(ignite, CACHE_NAME, GROUP_NAME);
        GridCommandHandlerIndexingUtils.createAndFillThreeFieldsEntryCache(ignite, "test_three_entries_complex_index", GROUP_NAME, Arrays.asList(GridCommandHandlerIndexingUtils.complexIndexEntity()));
        GridCommandHandlerIndexingUtils.createAndFillCache(ignite, CACHE_NAME_SECOND, GROUP_NAME_SECOND);
        GridCommandHandlerIndexingUtils.createAndFillThreeFieldsEntryCache(ignite, "three_entries_simple_indexes", null, Arrays.asList(GridCommandHandlerIndexingUtils.simpleIndexEntity()));
        GridCommandHandlerIndexingUtils.createAndFillThreeFieldsEntryCache(ignite, "three_entries_no_indexes", null, Collections.emptyList());
    }

    static class CacheEntityThreeFields
    implements Serializable {
        public static final String ID_NAME = "id";
        public static final String STR_NAME = "strField";
        public static final String DOUBLE_NAME = "boubleField";
        int id;
        String strField;
        double doubleField;

        CacheEntityThreeFields(int id, String strField, double doubleField) {
            this.id = id;
            this.strField = strField;
            this.doubleField = doubleField;
        }
    }

    static class Organization
    implements Serializable {
        int id;
        String name;
        String addr;

        Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Organization addr(String addr) {
            this.addr = addr;
            return this;
        }
    }

    static class Person
    implements Serializable {
        int orgId;
        String name;
        String orgAddr;

        Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }

        public Person orgAddr(String orgAddr) {
            this.orgAddr = orgAddr;
            return this;
        }
    }
}

