/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerIndexingTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    public static final int GRID_CNT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateIndexesFailedOnNotIdleCluster() throws Exception {
        this.checkpointFreq = 100L;
        Ignite ignite = this.prepareGridForTest();
        AtomicBoolean stopFlag = new AtomicBoolean();
        IgniteCache cache = ignite.cache("persons-cache-vi");
        Thread loadThread = new Thread(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!stopFlag.get()) {
                int id = rnd.nextInt();
                cache.put((Object)id, (Object)new GridCommandHandlerIndexingUtils.Person(id, "name" + id));
                if (!Thread.interrupted()) continue;
                break;
            }
        });
        try {
            loadThread.start();
            GridCommandHandlerIndexingTest.doSleep((long)this.checkpointFreq);
            this.injectTestSystemOut();
            GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "persons-cache-vi"));
        }
        finally {
            stopFlag.set(true);
            loadThread.join();
        }
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Cluster not idle. Modifications found in caches or groups: [\"group1\"]");
    }

    @Test
    public void testRemoveMetadataAndRecreateWithDifferentCase() throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        IgniteCache cache = this.grid(0).getOrCreateCache("persons-cache-vi");
        cache.query(new SqlFieldsQuery("CREATE TABLE t1(id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=default, key_type=CUSTOM_SQL_KEY_TYPE, value_type=CUSTOM_SQL_VALUE_TYPE\"").setSchema("PUBLIC")).getAll();
        cache.query(new SqlFieldsQuery("INSERT INTO PUBLIC.t1 VALUES(1, '1')")).getAll();
        cache.query(new SqlFieldsQuery("DROP TABLE PUBLIC.t1")).getAll();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "CUSTOM_SQL_KEY_TYPE"));
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "CUSTOM_SQL_VALUE_TYPE"));
        cache.query(new SqlFieldsQuery("CREATE TABLE t1(id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=default, key_type=CUSTOM_SQL_KEY_TYPE, value_type=CUSTOM_SQL_VALUE_type\"").setSchema("PUBLIC")).getAll();
        for (int i = 0; i < 10; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO PUBLIC.t1 VALUES(" + i + ", '1')")).getAll();
        }
        List res = cache.query(new SqlFieldsQuery("SELECT * FROM PUBLIC.t1")).getAll();
        GridCommandHandlerIndexingTest.assertEquals((int)10, (int)res.size());
    }

    @Test
    public void testIdleVerifyCheckFailsOnNotIdleClusterWithOverwriteWithPers() throws Exception {
        this.runIdleVerifyCheckCrcFailsOnNotIdleCluster(true);
    }

    @Test
    public void testIdleVerifyCheckFailsOnNotIdleClusterWithOverwriteWithoutPers() throws Exception {
        this.persistenceEnable(false);
        this.runIdleVerifyCheckCrcFailsOnNotIdleCluster(true);
    }

    @Test
    public void testIdleVerifyCheckFailsOnNotIdleClusterWithoutOverwriteWithPers() throws Exception {
        this.runIdleVerifyCheckCrcFailsOnNotIdleCluster(false);
    }

    @Test
    public void testIdleVerifyCheckFailsOnNotIdleClusterWithoutOverwriteWithoutPers() throws Exception {
        this.persistenceEnable(false);
        this.runIdleVerifyCheckCrcFailsOnNotIdleCluster(false);
    }

    public void runIdleVerifyCheckCrcFailsOnNotIdleCluster(boolean allowOverwrite) throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        int cntPreload = 100;
        int maxItems = 100000;
        this.createCacheAndPreload((Ignite)ig, cntPreload, 1, new CachePredicate(F.asList((Object)ig.name())));
        GridCacheDatabaseSharedManager db = null;
        if (this.persistenceEnable()) {
            this.forceCheckpoint();
            db = (GridCacheDatabaseSharedManager)ig.context().cache().context().database();
            db.enableCheckpoints(false).get();
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        CountDownLatch startLoading = new CountDownLatch(1);
        IgniteInternalFuture f = GridTestUtils.runAsync(() -> {
            try (IgniteDataStreamer ldr = ig.dataStreamer("default");){
                ldr.allowOverwrite(allowOverwrite);
                ldr.perThreadBufferSize(1);
                boolean addFlag = true;
                int i = cntPreload;
                while (!stopFlag.get()) {
                    if (addFlag) {
                        ldr.addData((Object)i, (Object)i);
                    } else {
                        ldr.removeData((Object)i);
                    }
                    if (i == maxItems / 2) {
                        startLoading.countDown();
                    }
                    if (i % 10 == 0) {
                        ldr.flush();
                    }
                    if (++i != maxItems) continue;
                    addFlag = !addFlag;
                    i = 0;
                }
            }
        });
        this.injectTestSystemOut();
        startLoading.await();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "--check-sizes"));
        stopFlag.set(true);
        f.get();
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Cluster not idle. Modifications found in caches or groups: ");
        testOut.reset();
        if (this.persistenceEnable()) {
            db.enableCheckpoints(true).get();
        }
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "--check-sizes"));
        out = testOut.toString();
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"Cluster not idle. Modifications found in caches or groups: ");
    }

    @Test
    public void testCorruptedIndexPartitionShouldFailValidationWithCrc() throws Exception {
        Ignite ignite = this.prepareGridForTest();
        this.forceCheckpoint();
        this.enableCheckpoints(ignite, false);
        this.corruptIndexPartition(this.indexPartition(ignite, "group1"), 1024, 4096);
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"issues found (listed above)");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"CRC validation failed");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)"Runtime failure on bounds");
    }

    @Test
    public void testCorruptedIndexPartitionShouldFailValidationWithoutCrc() throws Exception {
        Ignite ignite = this.prepareGridForTest();
        this.forceCheckpoint();
        this.stopAllGrids();
        File idxPath = this.indexPartition(ignite, "group1");
        this.corruptIndexPartition(idxPath, 6, 47746);
        this.startGrids(2);
        this.awaitPartitionMapExchange();
        this.forceCheckpoint();
        this.enableCheckpoints(G.allGrids(), false);
        this.injectTestSystemOut();
        GridCommandHandlerIndexingTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Runtime failure on bounds");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)"CRC validation failed");
    }

    private Ignite prepareGridForTest() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteEx client = this.startGrid("client");
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi", "group1");
        return ignite;
    }

    private File indexPartition(Ignite ig, String groupName) {
        IgniteEx ig0 = (IgniteEx)ig;
        FilePageStoreManager pageStoreManager = (FilePageStoreManager)ig0.context().cache().context().pageStore();
        return new File(pageStoreManager.cacheWorkDir(true, groupName), "index.bin");
    }

    private void corruptIndexPartition(File path, int size, int offset) throws IOException {
        GridCommandHandlerIndexingTest.assertTrue((boolean)path.exists());
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        try (RandomAccessFile idx = new RandomAccessFile(path, "rw");){
            byte[] trash = new byte[size];
            rand.nextBytes(trash);
            idx.seek(offset);
            idx.write(trash);
        }
    }

    static class CachePredicate
    implements IgnitePredicate<ClusterNode> {
        private List<String> excludeNodes;

        public CachePredicate(List<String> excludeNodes) {
            this.excludeNodes = excludeNodes;
        }

        public boolean apply(ClusterNode clusterNode) {
            String name = clusterNode.attribute("org.apache.ignite.ignite.name").toString();
            return !this.excludeNodes.contains(name);
        }
    }
}

