/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.IndexColumn;
import org.junit.Test;

public class GridCommandHandlerBrokenIndexTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    private final String IDX_NAME = "bad_index";
    private final String EXCEPTION_MSG = "Exception from BadIndex#find()";
    private final String IDX_ISSUE_STR = "IndexValidationIssue [key=null, cacheName=persons-cache-vi, idxName=bad_index], class java.lang.RuntimeException: Exception from BadIndex#find()";
    private List<LogListener> lsnrs = new ArrayList<LogListener>();

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (cfg.isClientMode().booleanValue()) {
            return cfg;
        }
        ListeningTestLogger testLog = new ListeningTestLogger(false, log);
        String errMsg = "Find in index failed: IndexValidationIssue [key=null, cacheName=persons-cache-vi, idxName=bad_index], class java.lang.RuntimeException: Exception from BadIndex#find()";
        LogListener lsnr = LogListener.matches((String)errMsg).build();
        testLog.registerListener(lsnr);
        this.lsnrs.add(lsnr);
        cfg.setGridLogger((IgniteLogger)testLog);
        return cfg;
    }

    @Test
    public void testIndexFindFail() throws Exception {
        this.cleanPersistenceDir();
        this.prepareGridForTest();
        this.injectTestSystemOut();
        this.addBadIndex();
        GridCommandHandlerBrokenIndexTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "persons-cache-vi"));
        GridCommandHandlerBrokenIndexTest.assertTrue((!this.lsnrs.isEmpty() ? 1 : 0) != 0);
        LogListener lsnrWithError = this.lsnrs.stream().filter(LogListener::check).findAny().orElse(null);
        GridCommandHandlerBrokenIndexTest.assertNotNull((String)"\"Find in index failed:\" message not found in ignite log", (Object)lsnrWithError);
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"IndexValidationIssue [key=null, cacheName=persons-cache-vi, idxName=bad_index], class java.lang.RuntimeException: Exception from BadIndex#find()");
    }

    private void prepareGridForTest() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteEx client = this.startGrid("client");
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi", "group1");
    }

    private void addBadIndex() {
        IgniteEx ignite = this.grid(0);
        int grpId = CU.cacheGroupId((String)"persons-cache-vi", (String)"group1");
        CacheGroupContext grpCtx = ignite.context().cache().cacheGroup(grpId);
        GridCommandHandlerBrokenIndexTest.assertNotNull((Object)grpCtx);
        GridQueryProcessor qry = ignite.context().query();
        IgniteH2Indexing indexing = (IgniteH2Indexing)qry.getIndexing();
        block0: for (GridCacheContext ctx : grpCtx.caches()) {
            Collection types = qry.types(ctx.name());
            if (F.isEmpty((Collection)types)) continue;
            for (GridQueryTypeDescriptor type : types) {
                GridH2Table gridH2Tbl = indexing.schemaManager().dataTable(ctx.name(), type.tableName());
                if (gridH2Tbl == null) continue;
                ArrayList indexes = gridH2Tbl.getIndexes();
                BadIndex bi = null;
                for (Index idx : indexes) {
                    if (!(idx instanceof H2TreeIndexBase)) continue;
                    bi = new BadIndex(gridH2Tbl, "bad_index", idx.getIndexColumns(), idx.getIndexType());
                    break;
                }
                if (bi == null) continue;
                indexes.add(bi);
                break block0;
            }
        }
    }

    private class BadIndex
    extends H2TreeIndexBase {
        protected BadIndex(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
            super(tbl, name, cols, type);
        }

        public int inlineSize() {
            return 0;
        }

        public H2CacheRow put(H2CacheRow row) {
            return null;
        }

        public boolean putx(H2CacheRow row) {
            return false;
        }

        public boolean removex(SearchRow row) {
            return false;
        }

        public int segmentsCount() {
            return 0;
        }

        public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
            return 0L;
        }

        public Cursor find(Session session, SearchRow first, SearchRow last) {
            throw new RuntimeException("Exception from BadIndex#find()");
        }

        public Cursor findFirstOrLast(Session session, boolean first) {
            return null;
        }

        public long getRowCount(Session session) {
            return 0L;
        }
    }
}

