/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverter;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverterArguments;
import org.apache.ignite.internal.encryption.AbstractEncryptionTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class IgniteEncryptedWalConverterTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(AbstractEncryptionTest.KEYSTORE_PATH);
        encSpi.setKeyStorePassword("tde-password".toCharArray());
        return super.getConfiguration(igniteInstanceName).setEncryptionSpi((EncryptionSpi)encSpi).setCacheConfiguration(new CacheConfiguration[]{IgniteEncryptedWalConverterTest.defaultCacheConfiguration().setEncryptionEnabled(true)}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    @Test
    public void testIgniteWalConverter() throws Exception {
        String nodeFolder = this.createWal();
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outByte);
        IgniteWalConverterArguments arg = new IgniteWalConverterArguments(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal", (boolean)false), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/wal/archive", (boolean)false), 4096, new File(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/binary_meta", (boolean)false), nodeFolder), U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db/marshaller", (boolean)false), false, null, null, null, null, null, false, false, Collections.emptyList());
        IgniteWalConverter.convert((PrintStream)out, (IgniteWalConverterArguments)arg);
        String result = outByte.toString();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"EncryptedRecord"));
    }

    private String createWal() throws Exception {
        try (IgniteEx node = this.startGrid(0);){
            node.cluster().state(ClusterState.ACTIVE);
            IgniteCache cache = node.cache("default");
            for (int i = 0; i < 10; ++i) {
                cache.put((Object)i, (Object)i);
            }
            String string = node.context().pdsFolderResolver().resolveFolders().folderName();
            return string;
        }
    }
}

