/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.argument;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.processors.cache.verify.SensitiveMode;

public enum PartitionReconciliationCommandArg implements CommandArg
{
    REPAIR("--repair", RepairAlgorithm.defaultValue()),
    FAST_CHECK("--fast-check", Boolean.FALSE),
    INCLUDE_SENSITIVE("--include-sensitive", Boolean.FALSE),
    SENSITIVE_MODE("--sensitive-mode", SensitiveMode.DEFAULT),
    PARALLELISM("--parallelism", 0),
    BATCH_SIZE("--batch-size", 1000),
    RECHECK_ATTEMPTS("--recheck-attempts", 2),
    LOCAL_OUTPUT("--local-output", Boolean.FALSE),
    RECHECK_DELAY("--recheck-delay", 5);

    private final String name;
    private final Object dfltVal;

    private PartitionReconciliationCommandArg(String name, Object dfltVal) {
        this.name = name;
        this.dfltVal = dfltVal;
    }

    public static Set<String> args() {
        return Arrays.stream(PartitionReconciliationCommandArg.values()).map(PartitionReconciliationCommandArg::argName).collect(Collectors.toSet());
    }

    @Override
    public String argName() {
        return this.name;
    }

    public Object defaultValue() {
        return this.dfltVal;
    }

    public String toString() {
        return this.name;
    }
}

