/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.PartitionReconciliationCommandArg;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationAffectedEntries;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationResult;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.processors.cache.verify.SensitiveMode;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.checker.VisorPartitionReconciliationTask;
import org.apache.ignite.internal.visor.checker.VisorPartitionReconciliationTaskArg;
import org.apache.ignite.internal.visor.util.VisorIllegalStateException;

public class PartitionReconciliation
extends AbstractCommand<Arguments> {
    public static final String PARALLELISM_FORMAT_MESSAGE = "The positive integer should be specified, or 0 (number of cores on a server node will be used as parallelism in such case). If the given value is greater than the number of cores on a server node, the behavior will be equal to the case when 0 is specified.";
    public static final String BATCH_SIZE_FORMAT_MESSAGE = "Invalid batch size: %s. Integer value greater than zero should be used.";
    public static final String RECHECK_ATTEMPTS_FORMAT_MESSAGE = "Invalid recheck attempts: %s. Integer value between 1 (inclusive) and 5 (exclusive) should be used.";
    public static final String RECHECK_DELAY_FORMAT_MESSAGE = "Invalid recheck delay: %s. Integer value between 0 (inclusive) and 100 (exclusive) should be used.";
    private Arguments args;

    @Override
    public void printUsage(Logger log) {
        String caches = "cacheName1,...,cacheNameN";
        String desc = "Verify whether there are inconsistent entries for the specified caches and print out the differences if any. Fix inconsistency if " + PartitionReconciliationCommandArg.REPAIR + "argument is presented. When no parameters are specified, all user caches are verified. Cache filtering options configure the set of caches that will be processed by " + (Object)((Object)CacheSubcommands.PARTITION_RECONCILIATION) + " command. If cache names are specified, in form of regular expressions, only matching caches will be verified.";
        HashMap<String, String> paramsDesc = new HashMap<String, String>();
        paramsDesc.put(PartitionReconciliationCommandArg.FAST_CHECK.toString(), "This option allows checking and repairing only partitions that did not pass validation during the last partition map exchange, otherwise, all partitions will be taken into account.");
        paramsDesc.put(PartitionReconciliationCommandArg.REPAIR.toString(), "If present, fix all inconsistent data. Specifies which repair algorithm to use for doubtful keys. The following values can be used: " + Arrays.toString(RepairAlgorithm.values()) + ". Default value is " + PartitionReconciliationCommandArg.REPAIR.defaultValue() + '.');
        paramsDesc.put(PartitionReconciliationCommandArg.PARALLELISM.toString(), "Maximum number of threads that can be involved in partition reconciliation activities on one node. Default value equals number of cores.");
        paramsDesc.put(PartitionReconciliationCommandArg.BATCH_SIZE.toString(), "Amount of keys to retrieve within one job. Default value is " + PartitionReconciliationCommandArg.BATCH_SIZE.defaultValue() + '.');
        paramsDesc.put(PartitionReconciliationCommandArg.RECHECK_ATTEMPTS.toString(), "Amount of potentially inconsistent keys recheck attempts. Value between 1 (inclusive) and 5 (exclusive) should be used. Default value is " + PartitionReconciliationCommandArg.RECHECK_ATTEMPTS.defaultValue() + '.');
        paramsDesc.put(PartitionReconciliationCommandArg.INCLUDE_SENSITIVE.toString(), "Print data to result with sensitive information: keys and values. Default value is " + PartitionReconciliationCommandArg.INCLUDE_SENSITIVE.defaultValue() + '.');
        paramsDesc.put(PartitionReconciliationCommandArg.SENSITIVE_MODE.toString(), "This parameter determines the output mode of sensitive information. Default value is " + PartitionReconciliationCommandArg.SENSITIVE_MODE.defaultValue().toString().toLowerCase() + '.');
        CacheCommands.usageCache(log, CacheSubcommands.PARTITION_RECONCILIATION, desc, paramsDesc, CommandLogger.optional(PartitionReconciliationCommandArg.REPAIR), CommandLogger.optional(PartitionReconciliationCommandArg.FAST_CHECK), CommandLogger.optional(PartitionReconciliationCommandArg.PARALLELISM), CommandLogger.optional(PartitionReconciliationCommandArg.BATCH_SIZE), CommandLogger.optional(PartitionReconciliationCommandArg.RECHECK_ATTEMPTS), CommandLogger.optional(PartitionReconciliationCommandArg.INCLUDE_SENSITIVE), CommandLogger.optional(PartitionReconciliationCommandArg.SENSITIVE_MODE), CommandLogger.optional(caches));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CacheSubcommands.PARTITION_RECONCILIATION.text().toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            ReconciliationResult reconciliationResult = this.partitionReconciliationCheck(client, clientCfg, log);
            return reconciliationResult;
        }
        catch (Throwable e) {
            log.severe("Failed to execute partition reconciliation command " + CommandLogger.errorMessage(e));
            throw e;
        }
    }

    private ReconciliationResult partitionReconciliationCheck(GridClient client, GridClientConfiguration clientCfg, Logger log) throws GridClientException {
        VisorPartitionReconciliationTaskArg taskArg = new VisorPartitionReconciliationTaskArg(this.args.caches, this.args.fastCheck, this.args.repair, this.args.includeSensitive, this.args.locOutput, this.args.parallelism, this.args.batchSize, this.args.recheckAttempts, this.args.repairAlg, this.args.recheckDelay, this.args.sensitiveMode);
        List srvNodes = client.compute().nodes().stream().filter(node -> !node.isClient()).collect(Collectors.toList());
        List<GridClientNode> unsupportedSrvNodes = srvNodes.stream().filter(node -> !node.supports(IgniteFeatures.PARTITION_RECONCILIATION)).collect(Collectors.toList());
        List<Object> unsupportedLatestAlgNodes = this.args.repairAlg == RepairAlgorithm.LATEST_SKIP_MISSING_PRIMARY || this.args.repairAlg == RepairAlgorithm.LATEST_TRUST_MISSING_PRIMARY ? srvNodes.stream().filter(node -> !node.supports(IgniteFeatures.PARTITION_RECONCILIATION_LATEST_ALG_UPDATE)).collect(Collectors.toList()) : Collections.emptyList();
        if (!unsupportedSrvNodes.isEmpty()) {
            String strErrReason = "Partition reconciliation was rejected. The node [id=%s, consistentId=%s] doesn't support this feature.";
            this.reportUnsupportedNode("Partition reconciliation was rejected. The node [id=%s, consistentId=%s] doesn't support this feature.", unsupportedSrvNodes, log);
            throw new VisorIllegalStateException("There are server nodes that do not support the partition reconciliation.");
        }
        if (!unsupportedLatestAlgNodes.isEmpty()) {
            String strErrReason = "Partition reconciliation was rejected. The node [id=%s, consistentId=%s] doesn't support repair algorithm '" + this.args.repairAlg + "'.";
            this.reportUnsupportedNode(strErrReason, unsupportedLatestAlgNodes, log);
            throw new VisorIllegalStateException("There are server nodes that do not support the specified algorithm [" + this.args.repairAlg + "].");
        }
        ReconciliationResult res = (ReconciliationResult)TaskExecutor.executeTask(client, VisorPartitionReconciliationTask.class, taskArg, clientCfg);
        this.print(res, log::info);
        return res;
    }

    private void reportUnsupportedNode(String msg, List<GridClientNode> nodes, Logger log) {
        List errs = nodes.stream().map(n -> String.format(msg, n.nodeId(), n.consistentId())).collect(Collectors.toList());
        this.print(new ReconciliationResult(new ReconciliationAffectedEntries(), new HashMap(), errs), log::info);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set<String> cacheNames = null;
        boolean repair = false;
        boolean fastCheck = (Boolean)PartitionReconciliationCommandArg.FAST_CHECK.defaultValue();
        boolean includeSensitive = (Boolean)PartitionReconciliationCommandArg.INCLUDE_SENSITIVE.defaultValue();
        SensitiveMode sensitiveMode = (SensitiveMode)PartitionReconciliationCommandArg.SENSITIVE_MODE.defaultValue();
        boolean locOutput = (Boolean)PartitionReconciliationCommandArg.LOCAL_OUTPUT.defaultValue();
        int parallelism = (Integer)PartitionReconciliationCommandArg.PARALLELISM.defaultValue();
        int batchSize = (Integer)PartitionReconciliationCommandArg.BATCH_SIZE.defaultValue();
        int recheckAttempts = (Integer)PartitionReconciliationCommandArg.RECHECK_ATTEMPTS.defaultValue();
        RepairAlgorithm repairAlg = (RepairAlgorithm)PartitionReconciliationCommandArg.REPAIR.defaultValue();
        int recheckDelay = (Integer)PartitionReconciliationCommandArg.RECHECK_DELAY.defaultValue();
        int partReconciliationArgsCnt = 8;
        while (argIter.hasNextSubArg() && partReconciliationArgsCnt-- > 0) {
            String nextArg = argIter.nextArg("");
            PartitionReconciliationCommandArg arg = CommandArgUtils.of(nextArg, PartitionReconciliationCommandArg.class);
            if (arg == null) {
                cacheNames = argIter.parseStringSet(nextArg);
                this.validateRegexps(cacheNames);
                continue;
            }
            switch (arg) {
                case REPAIR: {
                    repair = true;
                    String peekedNextArg = argIter.peekNextArg();
                    if (PartitionReconciliationCommandArg.args().contains(peekedNextArg)) break;
                    String strVal = argIter.nextArg("The repair algorithm should be specified. The following values can be used: " + Arrays.toString(RepairAlgorithm.values()) + '.');
                    try {
                        repairAlg = RepairAlgorithm.fromString((String)strVal);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid repair algorithm: " + strVal + ". The following values can be used: " + Arrays.toString(RepairAlgorithm.values()) + '.');
                    }
                }
                case FAST_CHECK: {
                    fastCheck = true;
                    break;
                }
                case INCLUDE_SENSITIVE: {
                    includeSensitive = true;
                    break;
                }
                case SENSITIVE_MODE: {
                    String peekedArg = argIter.peekNextArg();
                    if (PartitionReconciliationCommandArg.args().contains(peekedArg)) break;
                    String strVal = argIter.nextArg("The sensitive mode should be specified. The following values can be used: " + Arrays.toString(SensitiveMode.values()) + '.');
                    try {
                        sensitiveMode = SensitiveMode.fromString((String)strVal);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid sensitive mode: " + strVal + ". The following values can be used: " + Arrays.toString(SensitiveMode.values()) + '.');
                    }
                }
                case LOCAL_OUTPUT: {
                    locOutput = true;
                    break;
                }
                case PARALLELISM: {
                    String strVal = argIter.nextArg("The parallelism level should be specified.");
                    try {
                        parallelism = Integer.parseInt(strVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format(PARALLELISM_FORMAT_MESSAGE, strVal));
                    }
                    if (parallelism >= 0) break;
                    throw new IllegalArgumentException(String.format(PARALLELISM_FORMAT_MESSAGE, strVal));
                }
                case BATCH_SIZE: {
                    String strVal = argIter.nextArg("The batch size should be specified.");
                    try {
                        batchSize = Integer.parseInt(strVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format(BATCH_SIZE_FORMAT_MESSAGE, strVal));
                    }
                    if (batchSize > 0) break;
                    throw new IllegalArgumentException(String.format(BATCH_SIZE_FORMAT_MESSAGE, strVal));
                }
                case RECHECK_ATTEMPTS: {
                    String strVal = argIter.nextArg("The recheck attempts should be specified.");
                    try {
                        recheckAttempts = Integer.parseInt(strVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format(RECHECK_ATTEMPTS_FORMAT_MESSAGE, strVal));
                    }
                    if (recheckAttempts >= 1 && recheckAttempts <= 5) break;
                    throw new IllegalArgumentException(String.format(RECHECK_ATTEMPTS_FORMAT_MESSAGE, strVal));
                }
                case RECHECK_DELAY: {
                    String strVal = argIter.nextArg("The recheck delay should be specified.");
                    try {
                        recheckDelay = Integer.parseInt(strVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format(RECHECK_DELAY_FORMAT_MESSAGE, strVal));
                    }
                    if (recheckDelay >= 0 && recheckDelay <= 100) break;
                    throw new IllegalArgumentException(String.format(RECHECK_DELAY_FORMAT_MESSAGE, strVal));
                }
            }
        }
        this.args = new Arguments(cacheNames, repair, fastCheck, includeSensitive, sensitiveMode, locOutput, parallelism, batchSize, recheckAttempts, repairAlg, recheckDelay);
    }

    private void validateRegexps(Set<String> str) {
        str.forEach(s -> {
            try {
                Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                throw new IgniteException(String.format("Invalid cache name regexp '%s': %s", s, e.getMessage()));
            }
        });
    }

    private String prepareHeaderMeta() {
        SB options = new SB("partition_reconciliation task was executed with the following args: ");
        options.a("caches=[").a(this.args.caches() == null ? "" : String.join((CharSequence)", ", this.args.caches())).a("], repair=[" + this.args.repair).a("], fast-check=[" + this.args.fastCheck).a("], includeSensitive=[" + this.args.includeSensitive).a("], sensitiveMode=[" + this.args.sensitiveMode).a("], parallelism=[" + this.args.parallelism).a("], batch-size=[" + this.args.batchSize).a("], recheck-attempts=[" + this.args.recheckAttempts).a("], fix-alg=[" + this.args.repairAlg).a("], recheck-delay=[" + this.args.recheckDelay + ']').a(System.lineSeparator());
        if (this.args.includeSensitive) {
            options.a("WARNING: Please be aware that sensitive data will be printed to the console and output file(s).").a(System.lineSeparator());
        }
        return options.toString();
    }

    private String prepareResultFolders(Map<UUID, String> nodeIdsToFolders, Map<UUID, String> nodesIdsToConsistenceIdsMap) {
        SB out = new SB("partition_reconciliation task prepared result where line is - <nodeConsistentId>, <nodeId> : <folder> \n");
        for (Map.Entry<UUID, String> entry : nodeIdsToFolders.entrySet()) {
            String consId = nodesIdsToConsistenceIdsMap.get(entry.getKey());
            out.a(consId + " " + entry.getKey() + " : " + (entry.getValue() == null ? "All keys on this node are consistent: report wasn't generated." : entry.getValue())).a("\n");
        }
        return out.toString();
    }

    private void print(ReconciliationResult res, Consumer<String> printer) {
        ReconciliationAffectedEntries reconciliationRes = res.partitionReconciliationResult();
        printer.accept(this.prepareHeaderMeta());
        printer.accept(this.prepareErrors(res.errors()));
        printer.accept(this.prepareResultFolders(res.nodeIdToFolder(), reconciliationRes.nodesIdsToConsistentIdsMap()));
        reconciliationRes.print(printer, this.args.includeSensitive);
    }

    private String prepareErrors(List<String> errors) {
        SB errorMsg = new SB();
        if (!errors.isEmpty()) {
            errorMsg.a("The following errors occurred during the execution of partition reconciliation:").a(System.lineSeparator());
            for (int i = 0; i < errors.size(); ++i) {
                errorMsg.a(i + 1).a(". ").a(errors.get(i)).a(System.lineSeparator());
            }
        }
        return errorMsg.toString();
    }

    protected static class Arguments {
        private final Set<String> caches;
        private final boolean repair;
        private final boolean fastCheck;
        private final boolean includeSensitive;
        private final SensitiveMode sensitiveMode;
        private final boolean locOutput;
        private final int parallelism;
        private final int batchSize;
        private final int recheckAttempts;
        private final RepairAlgorithm repairAlg;
        private int recheckDelay;

        public Arguments(Set<String> caches, boolean repair, boolean fastCheck, boolean includeSensitive, SensitiveMode sensitiveMode, boolean locOutput, int parallelism, int batchSize, int recheckAttempts, RepairAlgorithm repairAlg, int recheckDelay) {
            this.caches = caches;
            this.repair = repair;
            this.fastCheck = fastCheck;
            this.includeSensitive = includeSensitive;
            this.sensitiveMode = sensitiveMode;
            this.locOutput = locOutput;
            this.parallelism = parallelism;
            this.batchSize = batchSize;
            this.recheckAttempts = recheckAttempts;
            this.repairAlg = repairAlg;
            this.recheckDelay = recheckDelay;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public boolean repair() {
            return this.repair;
        }

        public boolean fastCheck() {
            return this.fastCheck;
        }

        public int parallelism() {
            return this.parallelism;
        }

        public int batchSize() {
            return this.batchSize;
        }

        public int recheckAttempts() {
            return this.recheckAttempts;
        }

        public boolean includeSensitive() {
            return this.includeSensitive;
        }

        public SensitiveMode sensitiveMode() {
            return this.sensitiveMode;
        }

        public boolean locOutput() {
            return this.locOutput;
        }

        public RepairAlgorithm repairAlg() {
            return this.repairAlg;
        }

        public int recheckDelay() {
            return this.recheckDelay;
        }
    }
}

