/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IndexForceRebuildCommandArg;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTask;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskArg;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskRes;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusInfoContainer;

public class CacheIndexesForceRebuild
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String desc = "Triggers rebuild of all indexes for specified caches or cache groups.";
        LinkedHashMap map = U.newLinkedHashMap((int)16);
        map.put(IndexForceRebuildCommandArg.NODE_ID.argName(), "Specify node for indexes rebuild.");
        map.put(IndexForceRebuildCommandArg.CACHE_NAMES.argName(), "Comma-separated list of cache names for which indexes should be rebuilt.");
        map.put(IndexForceRebuildCommandArg.GROUP_NAMES.argName(), "Comma-separated list of cache group names for which indexes should be rebuilt.");
        CacheCommands.usageCache(logger, CacheSubcommands.INDEX_FORCE_REBUILD, desc, map, IndexForceRebuildCommandArg.NODE_ID.argName() + " nodeId", CommandLogger.or(IndexForceRebuildCommandArg.CACHE_NAMES + " cacheName1,...cacheNameN", IndexForceRebuildCommandArg.GROUP_NAMES + " groupName1,...groupNameN"));
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        IndexForceRebuildTaskRes taskRes;
        block15: {
            IndexForceRebuildTaskArg taskArg = new IndexForceRebuildTaskArg(this.args.cacheGrps, this.args.cacheNames);
            UUID nodeId = this.args.nodeId;
            try (GridClient client = Command.startClient(clientCfg);){
                if (GridClientUtils.nodeSupports((UUID)nodeId, (GridClient)client, (IgniteFeatures)IgniteFeatures.INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT)) {
                    taskRes = (IndexForceRebuildTaskRes)TaskExecutor.executeTaskByNameOnNode(client, IndexForceRebuildTask.class.getName(), taskArg, nodeId, clientCfg);
                    break block15;
                }
                logger.info("Indexes force rebuild is not supported by node " + nodeId);
                Object var8_8 = null;
                return var8_8;
            }
        }
        this.printResult(taskRes, logger);
        return taskRes;
    }

    private void printResult(IndexForceRebuildTaskRes res, Logger logger) {
        if (!F.isEmpty((Collection)res.notFoundCacheNames())) {
            String warning = this.args.cacheGrps == null ? "WARNING: These caches were not found:" : "WARNING: These cache groups were not found:";
            logger.info(warning);
            res.notFoundCacheNames().stream().sorted().forEach(name -> logger.info("  " + name));
            logger.info("");
        }
        if (!F.isEmpty((Collection)res.cachesWithRebuildInProgress())) {
            logger.info("WARNING: These caches have indexes rebuilding in progress:");
            this.printInfos(res.cachesWithRebuildInProgress(), logger);
            logger.info("");
        }
        if (!F.isEmpty((Collection)res.cachesWithStartedRebuild())) {
            logger.info("Indexes rebuild was started for these caches:");
            this.printInfos(res.cachesWithStartedRebuild(), logger);
        } else {
            logger.info("WARNING: Indexes rebuild was not started for any cache. Check command input.");
        }
        logger.info("");
    }

    private void printInfos(Collection<IndexRebuildStatusInfoContainer> infos, Logger logger) {
        infos.stream().sorted(IndexRebuildStatusInfoContainer.comparator()).forEach(rebuildStatusInfo -> logger.info("  " + rebuildStatusInfo.toString()));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CacheSubcommands.INDEX_FORCE_REBUILD.text().toUpperCase();
    }

    @Override
    public void parseArguments(CommandArgIterator argIterator) {
        UUID nodeId = null;
        Set<String> cacheGrps = null;
        Set<String> cacheNames = null;
        block5: while (argIterator.hasNextSubArg()) {
            String nextArg = argIterator.nextArg("");
            IndexForceRebuildCommandArg arg = CommandArgUtils.of(nextArg, IndexForceRebuildCommandArg.class);
            if (arg == null) {
                throw new IllegalArgumentException("Unknown argument: " + nextArg);
            }
            switch (arg) {
                case NODE_ID: {
                    if (nodeId != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    nodeId = UUID.fromString(argIterator.nextArg("Failed to read node id."));
                    continue block5;
                }
                case GROUP_NAMES: {
                    if (cacheGrps != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    cacheGrps = argIterator.nextStringSet("comma-separated list of cache group names.");
                    if (!cacheGrps.equals(Collections.emptySet())) continue block5;
                    throw new IllegalArgumentException(arg.argName() + " not specified.");
                }
                case CACHE_NAMES: {
                    if (cacheNames != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    cacheNames = argIterator.nextStringSet("comma-separated list of cache names.");
                    if (!cacheNames.equals(Collections.emptySet())) continue block5;
                    throw new IllegalArgumentException(arg.argName() + " not specified.");
                }
            }
            throw new IllegalArgumentException("Unknown argument: " + arg.argName());
        }
        this.args = new Arguments(nodeId, cacheGrps, cacheNames);
        this.validateArguments();
    }

    private void validateArguments() {
        if (this.args.nodeId == null) {
            throw new IllegalArgumentException(IndexForceRebuildCommandArg.NODE_ID + " must be specified.");
        }
        if (this.args.cacheGrps == null == (this.args.cacheNames() == null)) {
            throw new IllegalArgumentException("Either " + IndexForceRebuildCommandArg.GROUP_NAMES + " or " + IndexForceRebuildCommandArg.CACHE_NAMES + " must be specified.");
        }
    }

    public static class Arguments {
        private UUID nodeId;
        private Set<String> cacheGrps;
        private Set<String> cacheNames;

        public Arguments(UUID nodeId, Set<String> cacheGrps, Set<String> cacheNames) {
            this.nodeId = nodeId;
            this.cacheGrps = cacheGrps;
            this.cacheNames = cacheNames;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public Set<String> cacheGrps() {
            return this.cacheGrps;
        }

        public Set<String> cacheNames() {
            return this.cacheNames;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

