/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.TestStorageUtils;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridJobExecuteResponse;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationResult;
import org.apache.ignite.internal.processors.cache.verify.checker.tasks.PartitionReconciliationProcessorTask;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerPartitionReconciliationAbstractTest;
import org.junit.Test;

public class GridCommandHandlerPartitionReconciliationCommonTest
extends GridCommandHandlerPartitionReconciliationAbstractTest {
    public static final int INVALID_KEY = 100;
    public static final String VALUE_PREFIX = "abc_";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.prepareCache();
    }

    @Test
    public void testSimpleCaseOfInconsistencyDetection() {
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(2))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 2L), null);
        this.injectTestSystemOut();
        GridCommandHandlerPartitionReconciliationCommonTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "--local-output"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"INCONSISTENT KEYS: 1");
    }

    @Test
    public void testConsoleScopedReportContainsAggregatedInfoAboutAmountAndNotDetailedInfoInCaseOfNonConsoleMode() {
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 2L), null);
        this.injectTestSystemOut();
        GridCommandHandlerPartitionReconciliationCommonTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"INCONSISTENT KEYS: 1");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)"<nodeConsistentId>, <nodeId>: <value> <version>");
    }

    @Test
    public void testConsoleScopedReportContainsAggregatedInfoAboutAmountAndNotDetailedInfoInCaseOfConsoleMode() {
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 2L), null);
        this.injectTestSystemOut();
        GridCommandHandlerPartitionReconciliationCommonTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "--local-output"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"INCONSISTENT KEYS: 1");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"<nodeConsistentId>, <nodeId>: <value> <version>");
    }

    @Test
    public void testConsoleOutputContainsWarningAboutSensitiveInformation() {
        this.injectTestSystemOut();
        GridCommandHandlerPartitionReconciliationCommonTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "--local-output", "--include-sensitive"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"WARNING: Please be aware that sensitive data will be printed to the console and output file(s).");
    }

    @Test
    public void testConsoleOutputHidesSensitiveInformation() throws Exception {
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 2L), null);
        this.injectTestSystemOut();
        CommandHandler hnd = new CommandHandler();
        GridCommandHandlerPartitionReconciliationCommonTest.assertEquals((int)0, (int)this.execute(hnd, "--cache", "partition_reconciliation", "--local-output"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"INCONSISTENT KEYS: 1");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"***** ver=[topVer=");
        ClusterNode primaryNode = this.ignite(0).affinity("default").mapKeyToNode((Object)100);
        GridCommandHandlerPartitionReconciliationCommonTest.assertNotNull((String)"Cannot find primary node for the key [key=100]", (Object)primaryNode);
        ReconciliationResult res = (ReconciliationResult)hnd.getLastOperationResult();
        String pathToReport = (String)res.nodeIdToFolder().get(primaryNode.id());
        GridCommandHandlerPartitionReconciliationCommonTest.assertNotNull((String)"Cannot find partition reconciliation report", (Object)pathToReport);
        String inconsistencyReport = new String(Files.readAllBytes(Paths.get(pathToReport, new String[0])));
        GridTestUtils.assertContains((IgniteLogger)log, (String)inconsistencyReport, (String)"***** ver=[topVer=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionReconciliationTaskDoesNotBlockGracefulStop() throws Exception {
        this.ignite(0).cache("default").put((Object)100, (Object)"abc_100");
        List nodes = this.ignite(0).cachex("default").cache().context().affinity().nodesByKey((Object)100, this.ignite(0).cachex("default").context().topology().readyTopologyVersion());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((IgniteEx)this.grid((ClusterNode)nodes.get(1))).cachex("default").context(), (Object)100, (boolean)false, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 2L), null);
        CountDownLatch evtLatch = new CountDownLatch(1);
        G.allGrids().forEach(ig -> ((IgniteEx)ig).context().io().addMessageListener(GridTopic.TOPIC_TASK, new GridMessageListener((Ignite)ig, evtLatch){
            final /* synthetic */ Ignite val$ig;
            final /* synthetic */ CountDownLatch val$evtLatch;
            {
                this.val$ig = ignite;
                this.val$evtLatch = countDownLatch;
            }

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof GridJobExecuteResponse) {
                    boolean partReconciliationTask;
                    GridJobExecuteResponse jobRes = (GridJobExecuteResponse)msg;
                    ComputeTaskInternalFuture fut = ((IgniteEx)this.val$ig).context().task().taskFuture(jobRes.getSessionId());
                    boolean bl = partReconciliationTask = fut != null && fut.getTaskSession().getTaskName().contains(PartitionReconciliationProcessorTask.class.getSimpleName());
                    if (partReconciliationTask) {
                        this.val$evtLatch.countDown();
                    }
                }
            }
        }));
        long start = System.nanoTime();
        int batchSize = 25;
        int recheckAttempts = 3;
        int recheckDelay = 10;
        CommandHandler hnd = new CommandHandler();
        GridTestUtils.runAsync(() -> this.execute(hnd, "--cache", "partition_reconciliation", "--load-factor", "0.1", "--batch-size", Integer.toString(batchSize), "--recheck-attempts", Integer.toString(recheckAttempts), "--recheck-delay", Integer.toString(recheckDelay)));
        GridCommandHandlerPartitionReconciliationCommonTest.assertTrue((String)("The partition reconciliation task is not started in " + recheckDelay * recheckAttempts + " sec."), (boolean)evtLatch.await(recheckDelay * recheckAttempts, TimeUnit.SECONDS));
        try {
            this.stopAllGrids();
            long end = System.nanoTime();
            GridCommandHandlerPartitionReconciliationCommonTest.assertTrue((String)"It seems that partition reconciliation task blocked garceful stop of the cluster.", (TimeUnit.SECONDS.toNanos(recheckDelay * recheckAttempts) > end - start ? 1 : 0) != 0);
        }
        finally {
            this.ignite = this.startGrids(4);
        }
    }

    @Override
    protected void prepareCache() {
        this.ignite(0).destroyCache("default");
        this.ignite(0).createCache(new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setCacheMode(CacheMode.PARTITIONED).setBackups(3).setReadFromBackup(true));
        try (IgniteDataStreamer streamer = this.ignite(0).dataStreamer("default");){
            for (int i = 0; i < 100; ++i) {
                streamer.addData((Object)i, (Object)(VALUE_PREFIX + i));
            }
        }
    }
}

