/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerIndexRebuildStatusTest
extends GridCommandHandlerAbstractTest {
    private static AtomicInteger idxRebuildsStartedNum = new AtomicInteger();
    private static AtomicBoolean statusRequestingFinished = new AtomicBoolean();
    private static boolean clusterRestartRequired;
    public static final int GRIDS_NUM = 3;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startupTestCluster();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.shutdownTestCluster();
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        if (clusterRestartRequired) {
            this.shutdownTestCluster();
            this.startupTestCluster();
            clusterRestartRequired = false;
        }
        idxRebuildsStartedNum.set(0);
        statusRequestingFinished.set(false);
    }

    @Override
    protected void afterTest() throws Exception {
        boolean allIndexesRebuilt = GridTestUtils.waitForCondition(() -> idxRebuildsStartedNum.get() == 0, (long)30000L);
        super.afterTest();
        if (!allIndexesRebuilt) {
            clusterRestartRequired = true;
            GridCommandHandlerIndexRebuildStatusTest.fail((String)"Failed to wait for index rebuild");
        }
    }

    private void startupTestCluster() throws Exception {
        this.cleanPersistenceDir();
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().active(true);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, "cache1", "group2");
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, "cache2", "group1");
        GridCommandHandlerIndexingUtils.createAndFillThreeFieldsEntryCache((Ignite)ignite, "cache_no_group", null, Arrays.asList(GridCommandHandlerIndexingUtils.simpleIndexEntity()));
    }

    private void shutdownTestCluster() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testCommandOutput() throws Exception {
        this.injectTestSystemOut();
        idxRebuildsStartedNum.set(0);
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        this.stopGrid(2);
        this.stopGrid(1);
        GridTestUtils.deleteIndexBin((String)this.getTestIgniteInstanceName(2));
        GridTestUtils.deleteIndexBin((String)this.getTestIgniteInstanceName(1));
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteEx ignite1 = this.startGrid(2);
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteEx ignite2 = this.startGrid(1);
        UUID id1 = ignite1.localNode().id();
        UUID id2 = ignite2.localNode().id();
        boolean allRebuildsStarted = GridTestUtils.waitForCondition(() -> idxRebuildsStartedNum.get() == 6, (long)30000L);
        GridCommandHandlerIndexRebuildStatusTest.assertTrue((String)"Failed to wait for all indexes to start being rebuilt", (boolean)allRebuildsStarted);
        GridCommandHandlerIndexRebuildStatusTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_rebuild_status"));
        statusRequestingFinished.set(true);
        this.checkResult(handler, id1, id2);
    }

    @Test
    public void testNodeIdOption() throws Exception {
        this.injectTestSystemOut();
        idxRebuildsStartedNum.set(0);
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        this.stopGrid(2);
        this.stopGrid(1);
        GridTestUtils.deleteIndexBin((String)this.getTestIgniteInstanceName(2));
        GridTestUtils.deleteIndexBin((String)this.getTestIgniteInstanceName(1));
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteEx ignite1 = this.startGrid(2);
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        this.startGrid(1);
        UUID id1 = ignite1.localNode().id();
        boolean allRebuildsStarted = GridTestUtils.waitForCondition(() -> idxRebuildsStartedNum.get() == 6, (long)30000L);
        GridCommandHandlerIndexRebuildStatusTest.assertTrue((String)"Failed to wait for all indexes to start being rebuilt", (boolean)allRebuildsStarted);
        GridCommandHandlerIndexRebuildStatusTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_rebuild_status", "--node-id", id1.toString()));
        statusRequestingFinished.set(true);
        this.checkResult(handler, id1);
    }

    @Test
    public void testEmptyResult() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexRebuildStatusTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_rebuild_status"));
        String output = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"There are no caches that have index rebuilding in progress.");
    }

    private void checkResult(CommandHandler handler, UUID ... nodeIds) {
        String output = testOut.toString();
        Map cmdResult = (Map)handler.getLastOperationResult();
        GridCommandHandlerIndexRebuildStatusTest.assertNotNull((Object)cmdResult);
        GridCommandHandlerIndexRebuildStatusTest.assertEquals((String)"Unexpected number of nodes in result", (int)nodeIds.length, (int)cmdResult.size());
        for (UUID nodeId : nodeIds) {
            Set cacheInfos = (Set)cmdResult.get(nodeId);
            GridCommandHandlerIndexRebuildStatusTest.assertNotNull((Object)cacheInfos);
            GridCommandHandlerIndexRebuildStatusTest.assertEquals((String)"Unexpected number of cacheInfos in result", (int)3, (int)cacheInfos.size());
            String nodeStr = "node_id=" + nodeId + ", groupName=group1, cacheName=cache2\nnode_id=" + nodeId + ", groupName=group2, cacheName=cache1\nnode_id=" + nodeId + ", groupName=no_group, cacheName=cache_no_group";
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)nodeStr);
        }
    }

    private static class BlockingSchemaIndexCacheVisitorClosure
    implements SchemaIndexCacheVisitorClosure {
        private SchemaIndexCacheVisitorClosure original;

        BlockingSchemaIndexCacheVisitorClosure(SchemaIndexCacheVisitorClosure original) {
            this.original = original;
        }

        public void apply(CacheDataRow row) throws IgniteCheckedException {
            try {
                GridTestUtils.waitForCondition(() -> statusRequestingFinished.get(), (long)60000L);
            }
            catch (IgniteInterruptedCheckedException e) {
                log.error("Waiting for indexes rebuild was interrupted", (Throwable)e);
                statusRequestingFinished.set(true);
            }
            this.original.apply(row);
        }
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private BlockingIndexing() {
        }

        protected void rebuildIndexesFromHash0(GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut, SchemaIndexOperationCancellationToken cancel) {
            idxRebuildsStartedNum.incrementAndGet();
            rebuildIdxFut.listen((IgniteInClosure)(CI1 & Serializable)f -> idxRebuildsStartedNum.decrementAndGet());
            super.rebuildIndexesFromHash0(cctx, (SchemaIndexCacheVisitorClosure)new BlockingSchemaIndexCacheVisitorClosure(clo), rebuildIdxFut, cancel);
        }
    }
}

