/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.EncryptionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.encryption.AbstractEncryptionTest;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.util.GridCommandHandlerTestUtils;
import org.jetbrains.annotations.Nullable;

@WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="true")
public abstract class GridCommandHandlerAbstractTest
extends GridCommonAbstractTest {
    protected static final String CLIENT_NODE_NAME_PREFIX = "client";
    protected static final String DAEMON_NODE_NAME_PREFIX = "daemon";
    protected static final String CMD_AUTO_CONFIRMATION = "--yes";
    protected static PrintStream sysOut;
    private static InputStream sysIn;
    protected static ByteArrayOutputStream testOut;
    protected AtomicConfiguration atomicConfiguration;
    protected DataRegionConfiguration dataRegionConfiguration;
    protected long checkpointFreq = 180000L;
    protected boolean autoConfirmation = true;
    protected boolean encryptionEnabled;
    protected double reencryptSpeed = 0.0;
    protected int reencryptBatchSize = 100;
    protected Object lastOperationResult;
    private boolean persistent = true;

    protected void persistenceEnable(boolean pr) {
        this.persistent = pr;
    }

    protected boolean persistenceEnable() {
        return this.persistent;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        testOut = new ByteArrayOutputStream(16384);
        sysOut = System.out;
        sysIn = System.in;
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        GridTestUtils.cleanIdleVerifyLogFiles();
        GridClientFactory.stopAll((boolean)false);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        log.info("Test output for " + this.currentTestMethod());
        log.info("----------------------------------------");
        System.setOut(sysOut);
        System.setIn(sysIn);
        log.info(testOut.toString());
        testOut.reset();
        this.encryptionEnabled = false;
        GridClientFactory.stopAll((boolean)false);
    }

    public String getTestIgniteInstanceName() {
        return "gridCommandHandlerTest";
    }

    protected Logger createTestLogger() {
        Logger log = CommandHandler.initLogger(null);
        log.addHandler(CommandHandler.setupStreamHandler());
        return log;
    }

    protected boolean sslEnabled() {
        return false;
    }

    protected boolean idleVerifyRes(Path p) {
        return p.toFile().getName().startsWith("idle-dump-");
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.atomicConfiguration != null) {
            cfg.setAtomicConfiguration(this.atomicConfiguration);
        }
        cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        cfg.setConnectorConfiguration(new ConnectorConfiguration().setSslEnabled(this.sslEnabled()));
        if (this.sslEnabled()) {
            cfg.setSslContextFactory(GridTestUtils.sslFactory());
        }
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(this.checkpointFreq).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x3200000L).setPersistenceEnabled(this.persistent));
        if (this.dataRegionConfiguration != null) {
            dsCfg.setDataRegionConfigurations(new DataRegionConfiguration[]{this.dataRegionConfiguration});
        }
        cfg.setDataStorageConfiguration(dsCfg);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        cfg.setClientMode(igniteInstanceName.startsWith(CLIENT_NODE_NAME_PREFIX));
        cfg.setDaemon(igniteInstanceName.startsWith(DAEMON_NODE_NAME_PREFIX));
        if (this.encryptionEnabled) {
            KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
            encSpi.setKeyStorePath(AbstractEncryptionTest.KEYSTORE_PATH);
            encSpi.setKeyStorePassword("tde-password".toCharArray());
            cfg.setEncryptionSpi((EncryptionSpi)encSpi);
            EncryptionConfiguration encCfg = new EncryptionConfiguration();
            encCfg.setReencryptionRateLimit(this.reencryptSpeed);
            encCfg.setReencryptionBatchSize(this.reencryptBatchSize);
            dsCfg.setEncryptionConfiguration(encCfg);
        }
        return cfg;
    }

    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(Paths.get(U.defaultWorkDirectory(), new String[0]), this::idleVerifyRes);){
            for (Path path : files) {
                Files.delete(path);
            }
        }
    }

    protected int execute(String ... args) {
        return this.execute(new ArrayList<String>(Arrays.asList(args)));
    }

    protected int execute(List<String> args) {
        return this.execute(new CommandHandler(this.createTestLogger()), args);
    }

    protected int execute(CommandHandler hnd, String ... args) {
        return this.execute(hnd, new ArrayList<String>(Arrays.asList(args)));
    }

    protected int execute(CommandHandler hnd, List<String> args) {
        if (!F.isEmpty(args) && !"--help".equalsIgnoreCase(args.get(0))) {
            this.addExtraArguments(args);
        }
        testOut.reset();
        int exitCode = hnd.execute(args);
        this.lastOperationResult = hnd.getLastOperationResult();
        Logger logger = (Logger)U.field((Object)hnd, (String)"logger");
        Arrays.stream(logger.getHandlers()).forEach(Handler::flush);
        return exitCode;
    }

    protected void addExtraArguments(List<String> args) {
        if (this.autoConfirmation) {
            args.add(CMD_AUTO_CONFIRMATION);
        }
        if (!(!this.sslEnabled() || args.size() >= 2 && args.get(0).equals("--cache") && args.get(1).equals("help"))) {
            GridCommandHandlerTestUtils.addSslParams(args);
        }
    }

    protected void injectTestSystemOut() {
        System.setOut(new PrintStream(testOut));
    }

    protected void injectTestSystemIn(String ... inputStrings) {
        assert (Objects.nonNull(inputStrings));
        String inputStr = String.join((CharSequence)System.lineSeparator(), inputStrings);
        System.setIn(new ByteArrayInputStream(inputStr.getBytes()));
    }

    protected void checkUserFutures() {
        for (Ignite ignite : G.allGrids()) {
            IgniteEx ig = (IgniteEx)ignite;
            Collection futs = ig.context().cache().context().mvcc().activeFutures();
            boolean hasFutures = false;
            for (GridCacheFuture fut : futs) {
                if (fut.isDone() || fut instanceof GridNearTxPrepareFutureAdapter && ((GridNearTxPrepareFutureAdapter)fut).tx().system() || fut instanceof GridDhtTxPrepareFuture && ((GridDhtTxPrepareFuture)fut).tx().system()) continue;
                log.error("Expecting no active future [node=" + ig.localNode().id() + ", fut=" + fut + ']');
                hasFutures = true;
            }
            if (hasFutures) {
                GridCommandHandlerAbstractTest.fail((String)"Some mvcc futures are not finished");
            }
            Collection txs = ig.context().cache().context().tm().activeTransactions().stream().filter(tx -> !tx.system()).collect(Collectors.toSet());
            for (IgniteInternalTx tx2 : txs) {
                log.error("Expecting no active transaction [node=" + ig.localNode().id() + ", tx=" + tx2 + ']');
            }
            if (txs.isEmpty()) continue;
            GridCommandHandlerAbstractTest.fail((String)"Some transaction are not finished");
        }
    }

    protected void createCacheAndPreload(Ignite ignite, int countEntries, int partitions, @Nullable IgnitePredicate<ClusterNode> filter) {
        assert (Objects.nonNull(ignite));
        CacheConfiguration ccfg = new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, partitions)).setBackups(1).setEncryptionEnabled(this.encryptionEnabled);
        if (filter != null) {
            ccfg.setNodeFilter(filter);
        }
        ignite.createCache(ccfg);
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int i = 0; i < countEntries; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
    }

    protected void createCacheAndPreload(Ignite ignite, int countEntries) {
        this.createCacheAndPreload(ignite, countEntries, 32, null);
    }
}

