/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReader;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactory;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactoryImpl;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteIndexReaderTest
extends GridCommonAbstractTest {
    protected static final int PAGE_SIZE = 4096;
    protected static final int PART_CNT = 1024;
    private static final int PAGE_STORE_VER = 2;
    protected static final String CACHE_GROUP_NAME = "defaultGroup";
    private static final String EMPTY_CACHE_NAME = "empty";
    private static final String EMPTY_CACHE_GROUP_NAME = "emptyGroup";
    private static final String QUERY_CACHE_NAME = "query";
    private static final String QUERY_CACHE_GROUP_NAME = "queryGroup";
    private static final int CREATED_TABLES_CNT = 3;
    private static final String LINE_DELIM = System.lineSeparator();
    private static final String CHECK_IDX_PTRN_COMMON = "<PREFIX>Index tree: I \\[idxName=[\\-_0-9]{1,20}_%s##H2Tree.0, pageId=[0-9a-f]{16}\\]" + LINE_DELIM + "<PREFIX>-- Page stat:" + LINE_DELIM + "<PREFIX>([0-9a-zA-Z]{1,50}: [0-9]{1,5}" + LINE_DELIM + "<PREFIX>){%s,1000}-- Count of items found in leaf pages: %s" + LINE_DELIM;
    private static final String CHECK_IDX_PTRN_CORRECT = CHECK_IDX_PTRN_COMMON + "<PREFIX>No errors occurred while traversing.";
    private static final String CHECK_IDX_PTRN_WITH_ERRORS = CHECK_IDX_PTRN_COMMON + "<PREFIX>" + "<ERROR> " + "Errors:" + LINE_DELIM + "<PREFIX>" + "<ERROR> " + "Page id=[0-9]{1,30}, exceptions:" + LINE_DELIM + "class.*?Exception.*";
    private static File workDir;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.prepareWorkDir();
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setPageSize(4096).setWalSegmentSize(0x400000).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0x1400000L).setMaxSize(0x4000000L))).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setGroupName(CACHE_GROUP_NAME).setSqlSchema("PUBLIC"), new CacheConfiguration(EMPTY_CACHE_NAME).setGroupName(EMPTY_CACHE_GROUP_NAME), new CacheConfiguration(QUERY_CACHE_NAME).setGroupName(QUERY_CACHE_GROUP_NAME).setQueryEntities(Arrays.asList(new QueryEntity(Integer.class, TestClass1.class).addQueryField("id", Integer.class.getName(), null).addQueryField("f", Integer.class.getName(), null).addQueryField("s", String.class.getName(), null).setIndexes(Collections.singleton(new QueryIndex("f"))).setTableName("QT1"), new QueryEntity(Integer.class, TestClass2.class).addQueryField("id", Integer.class.getName(), null).addQueryField("f", Integer.class.getName(), null).addQueryField("s", String.class.getName(), null).setIndexes(Collections.singleton(new QueryIndex("s"))).setTableName("QT2")))});
    }

    protected void prepareWorkDir() throws Exception {
        try (IgniteEx node = this.startGrid(0);){
            this.populateData(node, null);
            workDir = ((FilePageStoreManager)node.context().cache().context().pageStore()).workDir();
        }
    }

    protected void populateData(IgniteEx node, @Nullable Boolean insert) throws Exception {
        int i;
        Objects.requireNonNull(node);
        IgniteClusterEx cluster = node.cluster();
        if (!cluster.active()) {
            cluster.active(true);
        }
        IgniteCache qryCache = node.cache(QUERY_CACHE_NAME);
        int s = Objects.isNull(insert) || insert != false ? 0 : 70;
        int e = Objects.isNull(insert) || insert == false ? 100 : 80;
        for (i = s; i < e; ++i) {
            qryCache.put((Object)i, (Object)new TestClass1(i, String.valueOf(i)));
        }
        s = Objects.isNull(insert) || insert != false ? 0 : 50;
        e = Objects.isNull(insert) || insert == false ? 70 : 60;
        for (i = s; i < e; ++i) {
            qryCache.put((Object)i, (Object)new TestClass2(i, String.valueOf(i)));
        }
        IgniteCache cache = node.cache("default");
        for (int i2 = 0; i2 < 3; ++i2) {
            IgniteIndexReaderTest.createAndFillTable(cache, TableInfo.generate(i2), insert);
        }
        this.forceCheckpoint((Ignite)node);
    }

    protected String dataDir(String cacheGrpName) {
        return "cacheGroup-" + cacheGrpName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptFile(File workDir, int partId, int pageIdxCorrupt) throws Exception {
        block21: {
            String fileName = partId == 65535 ? "index.bin" : String.format("part-%d.bin", partId);
            File cacheWorkDir = new File(workDir, this.dataDir(CACHE_GROUP_NAME));
            File file = new File(cacheWorkDir, fileName);
            File backup = new File(cacheWorkDir, fileName + ".backup");
            if (!backup.exists()) {
                Files.copy(file.toPath(), backup.toPath(), new CopyOption[0]);
            }
            ByteBuffer buf = GridUnsafe.allocateBuffer((int)4096);
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            try (FileChannel c = new RandomAccessFile(file, "rw").getChannel();){
                int pageIdx;
                byte[] trash = new byte[4096];
                ThreadLocalRandom.current().nextBytes(trash);
                int pageCnt = 0;
                do {
                    buf.rewind();
                    if (c.read(buf) == -1) {
                        break block21;
                    }
                    ++pageCnt;
                    buf.rewind();
                    long pageId = PageIO.getPageId((long)addr);
                    pageIdx = PageIdUtils.pageIndex((long)pageId);
                } while (pageIdx != pageIdxCorrupt);
                buf.put(trash);
                buf.rewind();
                c.write(buf, (pageCnt - 1) * 4096);
                return;
            }
            finally {
                GridUnsafe.freeBuffer((ByteBuffer)buf);
            }
        }
    }

    private void restoreFile(File workDir, int partId) throws IOException {
        String fileName = partId == 65535 ? "index.bin" : String.format("part-%d.bin", partId);
        File cacheWorkDir = new File(workDir, this.dataDir(CACHE_GROUP_NAME));
        File backupFiles = new File(cacheWorkDir, fileName + ".backup");
        if (!backupFiles.exists()) {
            return;
        }
        Path backupFilesPath = backupFiles.toPath();
        Files.copy(backupFilesPath, new File(cacheWorkDir, fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.delete(backupFilesPath);
    }

    private static List<IgnitePair<String>> fields(int cnt) {
        LinkedList<IgnitePair<String>> res = new LinkedList<IgnitePair<String>>();
        for (int i = 0; i < cnt; ++i) {
            res.add((IgnitePair<String>)new IgnitePair((Object)("f" + i), (Object)(i % 2 == 0 ? "integer" : "varchar(100)")));
        }
        return res;
    }

    private static List<IgnitePair<String>> idxs(String tblName, List<IgnitePair<String>> fields) {
        LinkedList<IgnitePair<String>> res = new LinkedList<IgnitePair<String>>();
        res.addAll(fields.stream().map(f -> new IgnitePair((Object)(tblName + "_" + (String)f.get1() + "_idx"), f.get1())).collect(Collectors.toList()));
        if (fields.size() > 1) {
            res.add((IgnitePair<String>)new IgnitePair((Object)(tblName + "_" + (String)fields.get(0).get1() + "_" + (String)fields.get(1).get1() + "_idx"), (Object)((String)fields.get(0).get1() + "," + (String)fields.get(1).get1())));
        }
        return res;
    }

    private static void createAndFillTable(IgniteCache cache, TableInfo info, @Nullable Boolean insert) {
        int i;
        String idxToDelName = info.tblName + "_idx_to_delete";
        List<IgnitePair<String>> fields = IgniteIndexReaderTest.fields(info.fieldsCnt);
        List<IgnitePair<String>> idxs = IgniteIndexReaderTest.idxs(info.tblName, fields);
        String strFields = fields.stream().map(f -> (String)f.get1() + " " + (String)f.get2()).collect(Collectors.joining(", "));
        if (Objects.isNull(insert) || insert.booleanValue()) {
            IgniteIndexReaderTest.query(cache, "create table " + info.tblName + " (id integer primary key, " + strFields + ") with \"CACHE_NAME=" + info.tblName + ", CACHE_GROUP=" + CACHE_GROUP_NAME + "\"");
            for (IgnitePair<String> idx : idxs) {
                IgniteIndexReaderTest.query(cache, String.format("create index %s on %s (%s)", idx.get1(), info.tblName, idx.get2()));
            }
            IgniteIndexReaderTest.query(cache, String.format("create index %s on %s (%s)", idxToDelName, info.tblName, fields.get(0).get1()));
        }
        int s = Objects.isNull(insert) || insert != false ? 0 : info.rec - 10;
        int e = Objects.isNull(insert) || insert == false ? info.rec : info.rec - 10;
        for (i = s; i < e; ++i) {
            IgniteIndexReaderTest.insertQuery(cache, info.tblName, fields, i);
        }
        if (Objects.nonNull(insert) && !insert.booleanValue()) {
            for (i = s - 10; i < s; ++i) {
                IgniteIndexReaderTest.updateQuery(cache, info.tblName, fields, i);
            }
        }
        if (Objects.isNull(insert) || !insert.booleanValue()) {
            for (i = info.rec - info.del; i < info.rec; ++i) {
                IgniteIndexReaderTest.query(cache, "delete from " + info.tblName + " where id = " + i);
            }
        }
        if (Objects.isNull(insert) || !insert.booleanValue()) {
            IgniteIndexReaderTest.query(cache, "drop index " + idxToDelName);
        }
    }

    private static void insertQuery(IgniteCache cache, String tblName, List<IgnitePair<String>> fields, int cntr) {
        GridStringBuilder q = new GridStringBuilder().a("insert into ").a(tblName).a(" (id, ");
        q.a(fields.stream().map(IgniteBiTuple::get1).collect(Collectors.joining(", ")));
        q.a(") values (");
        q.a(fields.stream().map(f -> "?").collect(Collectors.joining(", ", "?, ", ")")));
        Object[] paramVals = new Object[fields.size() + 1];
        for (int i = 0; i < fields.size() + 1; ++i) {
            paramVals[i] = i % 2 == 0 ? Integer.valueOf(cntr) : String.valueOf(cntr);
        }
        IgniteIndexReaderTest.query(cache, q.toString(), paramVals);
    }

    private static void updateQuery(IgniteCache cache, String tblName, List<IgnitePair<String>> fields, int cntr) {
        GridStringBuilder q = new GridStringBuilder().a("update ").a(tblName).a(" set ").a(fields.stream().map(IgniteBiTuple::get1).collect(Collectors.joining("=?, ", "", "=?"))).a(" where id=?");
        Object[] paramVals = new Object[fields.size() + 1];
        for (int i = 0; i < fields.size() + 1; ++i) {
            paramVals[i] = i % 2 == 0 ? Integer.valueOf(cntr) : String.valueOf(cntr);
        }
        Object id = paramVals[0];
        paramVals[0] = paramVals[paramVals.length - 1];
        paramVals[paramVals.length - 1] = id;
        IgniteIndexReaderTest.query(cache, q.toString(), paramVals);
    }

    private static List<List<?>> query(IgniteCache cache, String qry) {
        return cache.query(new SqlFieldsQuery(qry)).getAll();
    }

    private static List<List<?>> query(IgniteCache cache, String qry, Object ... args) {
        return cache.query(new SqlFieldsQuery(qry).setArgs(args)).getAll();
    }

    private void checkOutput(String output, int treesCnt, int travErrCnt, int pageListsErrCnt, int seqErrCnt, boolean idxReadingErr, boolean partReadingErr, boolean idxSizeConsistent) {
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("<RECURSIVE> Total trees: " + treesCnt));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("<HORIZONTAL> Total trees: " + treesCnt));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("<RECURSIVE> Total errors during trees traversal: " + travErrCnt));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("<HORIZONTAL> Total errors during trees traversal: " + travErrCnt));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("Total errors during lists scan: " + pageListsErrCnt));
        if (idxSizeConsistent) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"No index size consistency errors found.");
        } else {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Index size inconsistency");
        }
        if (seqErrCnt >= 0) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)("Total errors occurred during sequential scan: " + seqErrCnt));
        } else {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Orphan pages were not reported due to --indexes filter.");
        }
        if (travErrCnt == 0 && pageListsErrCnt == 0 && seqErrCnt == 0) {
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)output, (String)"<ERROR> ");
        }
        if (idxReadingErr) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"<ERROR> Errors detected while reading index.bin");
        }
        if (partReadingErr) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"<ERROR> Errors detected while reading partition files:");
        }
    }

    private void checkIdxs(String output, TableInfo info, boolean corruptedIdx) {
        List<IgnitePair<String>> fields = IgniteIndexReaderTest.fields(info.fieldsCnt);
        List<IgnitePair<String>> idxs = IgniteIndexReaderTest.idxs(info.tblName, fields);
        int entriesCnt = info.rec - info.del;
        idxs.stream().map(IgniteBiTuple::get1).forEach(idx -> {
            this.checkIdx(output, "<RECURSIVE> ", idx.toUpperCase(), entriesCnt, corruptedIdx);
            this.checkIdx(output, "<HORIZONTAL> ", idx.toUpperCase(), entriesCnt, corruptedIdx);
        });
    }

    private void checkIdx(String output, String traversePrefix, String idx, int entriesCnt, boolean canBeCorrupted) {
        Pattern ptrnCorrect = Pattern.compile(this.checkIdxRegex(traversePrefix, false, idx, 1, String.valueOf(entriesCnt)));
        Matcher mCorrect = ptrnCorrect.matcher(output);
        if (canBeCorrupted) {
            Pattern ptrnCorrupted = Pattern.compile(this.checkIdxRegex(traversePrefix, true, idx, 0, "[0-9]{1,4}"));
            Matcher mCorrupted = ptrnCorrupted.matcher(output);
            IgniteIndexReaderTest.assertTrue((String)("could not find index " + idx + ":\n" + output), (mCorrect.find() || mCorrupted.find() ? 1 : 0) != 0);
        } else {
            IgniteIndexReaderTest.assertTrue((String)("could not find index " + idx + ":\n" + output), (boolean)mCorrect.find());
        }
    }

    private String checkIdxRegex(String traversePrefix, boolean withErrors, String idxName, int minimumPageStatSize, String itemsCnt) {
        return String.format(withErrors ? CHECK_IDX_PTRN_WITH_ERRORS : CHECK_IDX_PTRN_CORRECT, idxName, minimumPageStatSize, itemsCnt).replace("<PREFIX>", traversePrefix);
    }

    private String runIndexReader(File workDir, String cacheGrp, @Nullable String[] idxs, boolean checkParts) throws IgniteCheckedException {
        File dir = new File(workDir, this.dataDir(cacheGrp));
        ByteArrayOutputStream destStream = new ByteArrayOutputStream();
        HashSet<String> idxSet = Objects.isNull(idxs) ? null : new HashSet<String>(Arrays.asList(idxs));
        try (IgniteIndexReader reader = new IgniteIndexReader(Objects.isNull(idxSet) ? null : idxSet::contains, checkParts, new PrintStream(destStream), this.createFilePageStoreFactory(dir));){
            reader.readIdx();
        }
        return ((Object)destStream).toString();
    }

    protected IgniteIndexReaderFilePageStoreFactory createFilePageStoreFactory(File dir) throws IgniteCheckedException {
        return new IgniteIndexReaderFilePageStoreFactoryImpl(dir, 4096, 1024, 2);
    }

    @Test
    public void testCorrectIdx() throws IgniteCheckedException {
        this.checkCorrectIdx(workDir);
    }

    @Test
    public void testCorrectIdxWithCheckParts() throws IgniteCheckedException {
        this.checkCorrectIdxWithCheckParts(workDir);
    }

    @Test
    public void testCorrectIdxWithFilter() throws IgniteCheckedException {
        this.checkCorrectIdxWithFilter(workDir);
    }

    @Test
    public void testEmpty() throws IgniteCheckedException {
        this.checkEmpty(workDir);
    }

    @Test
    public void testCorruptedIdx() throws Exception {
        this.checkCorruptedIdx(Arrays.asList(workDir));
    }

    @Test
    public void testCorruptedIdxWithCheckParts() throws Exception {
        this.checkCorruptedIdxWithCheckParts(Arrays.asList(workDir));
    }

    @Test
    public void testCorruptedPart() throws Exception {
        this.checkCorruptedPart(Arrays.asList(workDir));
    }

    @Test
    public void testCorruptedIdxAndPart() throws Exception {
        this.checkCorruptedIdxAndPart(Arrays.asList(workDir));
    }

    @Test
    public void testQryCacheGroup() throws IgniteCheckedException {
        this.checkQryCacheGroup(workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCorruptedIdxAndPart(List<File> workDirs) throws Exception {
        A.ensure((Objects.nonNull(workDirs) && !workDirs.isEmpty() ? 1 : 0) != 0, (String)"empty workDirs");
        try {
            for (File dir : workDirs) {
                this.corruptFile(dir, 65535, 5);
                this.corruptFile(dir, 0, 8);
            }
            String output = this.runIndexReader(workDirs.get(0), CACHE_GROUP_NAME, null, false);
            boolean idxReadingErr = this.isReportIdxAndPartFilesReadingErr();
            boolean partReadingErr = this.isReportIdxAndPartFilesReadingErr();
            this.checkOutput(output, 19, 23, 0, 2, idxReadingErr, partReadingErr, false);
            for (int i = 0; i < 3; ++i) {
                this.checkIdxs(output, TableInfo.generate(i), true);
            }
        }
        finally {
            for (File dir : workDirs) {
                this.restoreFile(dir, 65535);
                this.restoreFile(dir, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCorruptedPart(List<File> workDirs) throws Exception {
        A.ensure((Objects.nonNull(workDirs) && !workDirs.isEmpty() ? 1 : 0) != 0, (String)"empty workDirs");
        try {
            for (File dir : workDirs) {
                this.corruptFile(dir, 0, 8);
            }
            String output = this.runIndexReader(workDirs.get(0), CACHE_GROUP_NAME, null, false);
            boolean partReadingErr = this.isReportIdxAndPartFilesReadingErr();
            this.checkOutput(output, 19, 23, 0, 0, false, partReadingErr, true);
            for (int i = 0; i < 3; ++i) {
                this.checkIdxs(output, TableInfo.generate(i), true);
            }
        }
        finally {
            for (File dir : workDirs) {
                this.restoreFile(dir, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCorruptedIdxWithCheckParts(List<File> workDirs) throws Exception {
        A.ensure((Objects.nonNull(workDirs) && !workDirs.isEmpty() ? 1 : 0) != 0, (String)"empty workDirs");
        try {
            for (int i = 31; i < 35; ++i) {
                for (File dir : workDirs) {
                    this.corruptFile(dir, 65535, i);
                }
            }
            String output = this.runIndexReader(workDirs.get(0), CACHE_GROUP_NAME, null, true);
            Pattern ptrn = Pattern.compile("Partition check finished, total errors: [0-9]{2,5}, total problem partitions: [0-9]{2,5}");
            IgniteIndexReaderTest.assertTrue((String)output, (boolean)ptrn.matcher(output).find());
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Total errors during lists scan: 0");
        }
        finally {
            for (File dir : workDirs) {
                this.restoreFile(dir, 65535);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCorruptedIdx(List<File> workDirs) throws Exception {
        A.ensure((Objects.nonNull(workDirs) && !workDirs.isEmpty() ? 1 : 0) != 0, (String)"empty workDirs");
        try {
            for (File dir : workDirs) {
                this.corruptFile(dir, 65535, 5);
            }
            String output = this.runIndexReader(workDirs.get(0), CACHE_GROUP_NAME, null, false);
            int travErrCnt = 2;
            int seqErrCnt = 2;
            boolean idxReadingErr = this.isReportIdxAndPartFilesReadingErr();
            this.checkOutput(output, 19, travErrCnt, 0, seqErrCnt, idxReadingErr, false, false);
            for (int i = 0; i < 3; ++i) {
                this.checkIdxs(output, TableInfo.generate(i), true);
            }
        }
        finally {
            for (File dir : workDirs) {
                this.restoreFile(dir, 65535);
            }
        }
    }

    protected void checkQryCacheGroup(File workDir) throws IgniteCheckedException {
        String output = this.runIndexReader(workDir, QUERY_CACHE_GROUP_NAME, null, false);
        this.checkOutput(output, 5, 0, 0, 0, false, false, true);
    }

    protected void checkCorrectIdx(File workDir) throws IgniteCheckedException {
        String output = this.runIndexReader(workDir, CACHE_GROUP_NAME, null, false);
        this.checkOutput(output, 19, 0, 0, 0, false, false, true);
        for (int i = 0; i < 3; ++i) {
            this.checkIdxs(output, TableInfo.generate(i), false);
        }
    }

    protected void checkCorrectIdxWithCheckParts(File workDir) throws IgniteCheckedException {
        String output = this.runIndexReader(workDir, CACHE_GROUP_NAME, null, true);
        this.checkOutput(output, 19, 0, 0, 0, false, false, true);
        for (int i = 0; i < 3; ++i) {
            this.checkIdxs(output, TableInfo.generate(i), false);
        }
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Partitions check detected no errors.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Partition check finished, total errors: 0, total problem partitions: 0");
    }

    protected void checkCorrectIdxWithFilter(File workDir) throws IgniteCheckedException {
        String[] idxsToCheck = new String[]{"2654_-1177891018_T2_F1_IDX##H2Tree%0", "2654_-1177891018_T2_F2_IDX##H2Tree%0"};
        String output = this.runIndexReader(workDir, CACHE_GROUP_NAME, idxsToCheck, false);
        this.checkOutput(output, 3, 0, 0, -1, false, false, true);
        HashSet<String> idxSet = new HashSet<String>(Arrays.asList(idxsToCheck));
        for (int i = 0; i < 3; ++i) {
            TableInfo info = TableInfo.generate(i);
            List<IgnitePair<String>> fields = IgniteIndexReaderTest.fields(info.fieldsCnt);
            List<IgnitePair<String>> idxs = IgniteIndexReaderTest.idxs(info.tblName, fields);
            int entriesCnt = info.rec - info.del;
            idxs.stream().map(IgniteBiTuple::get1).filter(idxSet::contains).forEach(idx -> {
                this.checkIdx(output, "<RECURSIVE> ", idx.toUpperCase(), entriesCnt, false);
                this.checkIdx(output, "<HORIZONTAL> ", idx.toUpperCase(), entriesCnt, false);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkEmpty(File workDir) throws IgniteCheckedException {
        String output = this.runIndexReader(workDir, EMPTY_CACHE_GROUP_NAME, null, false);
        this.checkOutput(output, 1, 0, 0, 0, false, false, true);
        String newCleanGrp = "noCache";
        File cleanDir = new File(workDir, this.dataDir(newCleanGrp));
        try {
            cleanDir.mkdir();
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.runIndexReader(workDir, newCleanGrp, null, false), IgniteCheckedException.class, null);
        }
        finally {
            U.delete((File)cleanDir);
        }
    }

    protected boolean isReportIdxAndPartFilesReadingErr() {
        return false;
    }

    private static class TestClass2
    extends TestClass1 {
        public TestClass2(Integer f, String s) {
            super(f, s);
        }
    }

    private static class TestClass1 {
        private final Integer f;
        private final String s;

        public TestClass1(Integer f, String s) {
            this.f = f;
            this.s = s;
        }
    }

    private static class TableInfo {
        final String tblName;
        final int fieldsCnt;
        final int rec;
        final int del;

        public TableInfo(String tblName, int fieldsCnt, int rec, int del) {
            this.tblName = tblName;
            this.fieldsCnt = fieldsCnt;
            this.rec = rec;
            this.del = del;
        }

        public static TableInfo generate(int i) {
            return new TableInfo("T" + i, 3 + i % 3, 1700 - i % 3 * 500, i % 3 * 250);
        }
    }
}

