/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.commandline.walconverter.DataEntryWrapper;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverterArguments;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalIteratorFactoryIgnoreError;
import org.apache.ignite.internal.commandline.walconverter.MetastoreDataRecordWrapper;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.commandline.walconverter.WalStat;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.FilteredWalIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.WalFilters;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccLeafIO;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class IgniteWalConverter {
    public static void main(String[] args) {
        IgniteWalConverterArguments parameters = IgniteWalConverterArguments.parse(System.out, args);
        if (parameters != null) {
            IgniteWalConverter.convert(System.out, parameters);
        }
    }

    public static void convert(PrintStream out, IgniteWalConverterArguments params) {
        PageIO.registerH2((IOVersions)H2InnerIO.VERSIONS, (IOVersions)H2LeafIO.VERSIONS, (IOVersions)H2MvccInnerIO.VERSIONS, (IOVersions)H2MvccLeafIO.VERSIONS);
        H2ExtrasInnerIO.register();
        H2ExtrasLeafIO.register();
        if (params.includeSensitive() == null) {
            System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", "hash");
        } else {
            switch (params.includeSensitive()) {
                case SHOW: {
                    System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", "plain");
                    break;
                }
                case HASH: 
                case MD5: {
                    System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", "hash");
                    break;
                }
                case HIDE: {
                    System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", "none");
                    break;
                }
                default: {
                    assert (false) : "Unexpected includeSensitive: " + (Object)((Object)params.includeSensitive());
                    break;
                }
            }
        }
        System.setProperty("IGNITE_PDS_SKIP_CRC", Boolean.toString(params.isSkipCrc()));
        RecordV1Serializer.skipCrc = params.isSkipCrc();
        System.setProperty("IGNITE_TO_STRING_MAX_LENGTH", String.valueOf(Integer.MAX_VALUE));
        WalStat stat = params.isPrintStat() ? new WalStat() : null;
        IgniteWalIteratorFactory.IteratorParametersBuilder iteratorParametersBuilder = new IgniteWalIteratorFactory.IteratorParametersBuilder().pageSize(params.getPageSize()).binaryMetadataFileStoreDir(params.getBinaryMetadataDir()).marshallerMappingFileStoreDir(params.getMarshallerMappingDir()).keepBinary(!params.isUnwrapBinary());
        if (params.getWalDir() != null) {
            iteratorParametersBuilder.filesOrDirs(new File[]{params.getWalDir()});
        }
        if (params.getWalArchiveDir() != null) {
            iteratorParametersBuilder.filesOrDirs(new File[]{params.getWalArchiveDir()});
        }
        IgniteWalIteratorFactoryIgnoreError factory = new IgniteWalIteratorFactoryIgnoreError();
        boolean printAlways = F.isEmpty(params.getRecordTypes());
        try (WALIterator stIt = IgniteWalConverter.walIterator(factory.iterator(iteratorParametersBuilder), params.getPages());){
            String currentWalPath = null;
            while (stIt.hasNextX()) {
                String currentRecordWalPath = IgniteWalConverter.getCurrentWalFilePath(stIt);
                if (currentWalPath == null || !currentWalPath.equals(currentRecordWalPath)) {
                    out.println("File: " + currentRecordWalPath);
                    currentWalPath = currentRecordWalPath;
                }
                IgniteBiTuple next = (IgniteBiTuple)stIt.nextX();
                WALPointer pointer = (WALPointer)next.get1();
                WALRecord record = (WALRecord)next.get2();
                if (stat != null) {
                    stat.registerRecord(record, pointer, true);
                }
                if (!printAlways && !params.getRecordTypes().contains(record.type())) continue;
                boolean print = true;
                if (record instanceof TimeStampRecord) {
                    print = IgniteWalConverter.withinTimeRange((TimeStampRecord)record, params.getFromTime(), params.getToTime());
                }
                String recordStr = IgniteWalConverter.toString(record, params.includeSensitive());
                if (!print || !F.isEmpty((String)params.hasText()) && !recordStr.contains(params.hasText())) continue;
                out.println(recordStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
        if (stat != null) {
            out.println("Statistic collected:\n" + stat.toString());
        }
    }

    private static boolean withinTimeRange(TimeStampRecord rec, Long fromTime, Long toTime) {
        if (fromTime != null && rec.timestamp() < fromTime) {
            return false;
        }
        return toTime == null || rec.timestamp() <= toTime;
    }

    private static String getCurrentWalFilePath(WALIterator it) {
        String res = null;
        try {
            WALIterator walIter = it instanceof FilteredWalIterator ? (WALIterator)U.field((Object)it, (String)"delegateWalIter") : it;
            Integer curIdx = (Integer)U.field((Object)walIter, (String)"curIdx");
            List walFileDescriptors = (List)U.field((Object)walIter, (String)"walFileDescriptors");
            if (curIdx != null && walFileDescriptors != null && curIdx < walFileDescriptors.size()) {
                res = ((FileDescriptor)walFileDescriptors.get(curIdx)).getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private static String toString(WALRecord walRecord, ProcessSensitiveData sensitiveData) {
        if (walRecord instanceof DataRecord) {
            DataRecord dataRecord = (DataRecord)walRecord;
            ArrayList<DataEntryWrapper> entryWrappers = new ArrayList<DataEntryWrapper>(dataRecord.writeEntries().size());
            for (DataEntry dataEntry : dataRecord.writeEntries()) {
                entryWrappers.add(new DataEntryWrapper(dataEntry, sensitiveData));
            }
            dataRecord.setWriteEntries(entryWrappers);
        } else if (walRecord instanceof MetastoreDataRecord) {
            walRecord = new MetastoreDataRecordWrapper((MetastoreDataRecord)walRecord, sensitiveData);
        }
        return walRecord.toString();
    }

    private static WALIterator walIterator(WALIterator walIter, Collection<T2<Integer, Long>> pageIds) throws IgniteCheckedException {
        Predicate filter = null;
        if (!pageIds.isEmpty()) {
            HashSet<T2<Integer, Long>> grpAndPageIds0 = new HashSet<T2<Integer, Long>>(pageIds);
            Set grpAndParts = grpAndPageIds0.stream().map(tup -> new T2(tup.get1(), (Object)PageIdUtils.partId((long)((Long)tup.get2())))).collect(Collectors.toSet());
            filter = WalFilters.checkpoint().or(WalFilters.pageOwner(grpAndPageIds0)).or(WalFilters.partitionMetaStateUpdate(grpAndParts));
        }
        return filter != null ? new FilteredWalIterator(walIter, filter) : walIter;
    }
}

