/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.ru;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.ru.RollingUpgradeArguments;
import org.apache.ignite.internal.commandline.ru.RollingUpgradeSubCommands;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeResult;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeTask;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeTaskArg;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeOperation;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeStatus;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeStatusResult;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeStatusTask;

public class RollingUpgradeCommand
extends AbstractCommand<RollingUpgradeArguments> {
    private static final String EMPTY_LIST = "  none";
    private RollingUpgradeArguments rollingUpgradeArgs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            if (RollingUpgradeSubCommands.STATUS == this.rollingUpgradeArgs.command()) {
                VisorRollingUpgradeStatusResult status = (VisorRollingUpgradeStatusResult)TaskExecutor.executeTask(client, VisorRollingUpgradeStatusTask.class, null, clientCfg);
                this.printRollingUpgradeStatus(log, status);
                VisorRollingUpgradeStatusResult visorRollingUpgradeStatusResult = status;
                return visorRollingUpgradeStatusResult;
            }
            VisorRollingUpgradeChangeModeResult res = (VisorRollingUpgradeChangeModeResult)TaskExecutor.executeTask(client, VisorRollingUpgradeChangeModeTask.class, this.toVisorArguments(this.rollingUpgradeArgs), clientCfg);
            this.printRollingUpgradeChangeModeResult(log, res, this.rollingUpgradeArgs.command());
            VisorRollingUpgradeChangeModeResult visorRollingUpgradeChangeModeResult = res;
            return visorRollingUpgradeChangeModeResult;
        }
        catch (Throwable e) {
            log.severe("Failed to execute rolling upgrade command='" + this.rollingUpgradeArgs.command().text() + "' " + CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public RollingUpgradeArguments arg() {
        return this.rollingUpgradeArgs;
    }

    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Enable rolling upgrade:", CommandList.ROLLING_UPGRADE, RollingUpgradeSubCommands.START.text(), CommandLogger.optional("--yes"));
        Command.usage(logger, "Disable rolling upgrade:", CommandList.ROLLING_UPGRADE, RollingUpgradeSubCommands.FINISH.text(), CommandLogger.optional("--yes"));
        Command.usage(logger, "Enable force rolling upgrade mode:", CommandList.ROLLING_UPGRADE, RollingUpgradeSubCommands.FORCE.text(), CommandLogger.optional("--yes"));
        Command.usage(logger, "Get rolling upgrade status:", CommandList.ROLLING_UPGRADE, RollingUpgradeSubCommands.STATUS.text());
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        RollingUpgradeSubCommands cmd = RollingUpgradeSubCommands.of(argIter.nextArg("Expected rolling upgrade action"));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct action");
        }
        this.rollingUpgradeArgs = new RollingUpgradeArguments.Builder(cmd).build();
    }

    @Override
    public String name() {
        return CommandList.ROLLING_UPGRADE.toCommandName();
    }

    @Override
    public String confirmationPrompt() {
        switch (this.rollingUpgradeArgs.command()) {
            case FINISH: {
                return "Warning: the command will disable rolling upgrade mode.";
            }
            case FORCE: {
                return "Warning: the command will enable rolling upgrade mode (force mode).";
            }
            case START: {
                return "Warning: the command will enable rolling upgrade mode.";
            }
            case STATUS: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported command: " + (Object)((Object)this.rollingUpgradeArgs.command()));
    }

    private VisorRollingUpgradeChangeModeTaskArg toVisorArguments(RollingUpgradeArguments args) {
        assert (RollingUpgradeSubCommands.START == args.command() || RollingUpgradeSubCommands.FINISH == args.command() || RollingUpgradeSubCommands.FORCE == args.command());
        switch (args.command()) {
            case FINISH: {
                return new VisorRollingUpgradeChangeModeTaskArg(VisorRollingUpgradeOperation.DISABLE, false);
            }
            case FORCE: {
                return new VisorRollingUpgradeChangeModeTaskArg(VisorRollingUpgradeOperation.ENABLE, true);
            }
            case START: {
                return new VisorRollingUpgradeChangeModeTaskArg(VisorRollingUpgradeOperation.ENABLE, false);
            }
        }
        throw new IllegalArgumentException("Unsupported command: " + (Object)((Object)args.command()));
    }

    private void printRollingUpgradeStatus(Logger log, VisorRollingUpgradeStatusResult res) {
        VisorRollingUpgradeStatus status = res.getStatus();
        log.info("Rolling upgrade is " + (status.isEnabled() ? "enabled." : "disabled."));
        if (status.isForcedModeEnabled()) {
            log.info("Forced mode is enabled.");
        }
        log.info("Initial version: " + status.getInitialVersion());
        log.info("Target version: " + (F.isEmpty((String)status.getTargetVersion()) ? "N/A" : status.getTargetVersion()));
        if (status.isEnabled()) {
            log.info("List of alive nodes in the cluster that are not updated yet:");
            if (res.getInitialNodes().isEmpty()) {
                log.info(EMPTY_LIST);
            } else {
                res.getInitialNodes().forEach(id -> log.info("  " + id));
            }
            log.info("List of alive nodes in the cluster that are updated:");
            if (res.getUpdatedNodes().isEmpty()) {
                log.info(EMPTY_LIST);
            } else {
                res.getUpdatedNodes().forEach(id -> log.info("  " + id));
            }
        }
    }

    private void printRollingUpgradeChangeModeResult(Logger log, VisorRollingUpgradeChangeModeResult res, RollingUpgradeSubCommands command) {
        if (RollingUpgradeModeChangeResult.Result.SUCCESS == res.getResult()) {
            log.info("Rolling upgrade mode successfully " + (RollingUpgradeSubCommands.START == command || RollingUpgradeSubCommands.FORCE == command ? "enabled." : "disabled."));
        } else {
            log.info("Rolling upgrade operation failed. " + res.getCause().getMessage());
        }
    }
}

