/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.util.TopologyUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.dr.VisorDrCleanupTreeTask;
import org.apache.ignite.internal.visor.dr.VisorDrCleanupTreeTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrCleanupTreeTaskResult;
import org.apache.ignite.internal.visor.dr.VisorDrRebuildTreeOperation;
import org.jetbrains.annotations.Nullable;

public class DrCleanupPartitionLogCommand
extends AbstractCommand<Arguments> {
    public static final String GROUPS_ARG = "--groups";
    public static final String CACHES_ARG = "--caches";
    public static final String NODES_ARG = "--nodes";
    private Arguments arguments;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Optional<GridClientNode> firstNodeOpt = TopologyUtils.anyConnectableServerNode(client.compute());
            if (firstNodeOpt.isPresent()) {
                VisorDrCleanupTreeTaskResult res;
                if (this.arguments.nodeIds == null) {
                    res = (VisorDrCleanupTreeTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorDrCleanupTreeTask.class.getName(), this.convertArguments(), null, clientCfg);
                } else {
                    VisorTaskArgument visorArg = new VisorTaskArgument((Collection)client.compute().nodes().stream().filter(node -> this.arguments.nodeIds.contains(node.consistentId().toString())).map(GridClientNode::nodeId).collect(Collectors.toList()), (Object)this.convertArguments(), false);
                    res = (VisorDrCleanupTreeTaskResult)client.compute().projection(firstNodeOpt.get()).execute(VisorDrCleanupTreeTask.class.getName(), (Object)visorArg);
                }
                this.printResult(res, logger);
            } else {
                logger.warning("No nodes found in topology, command won't be executed.");
            }
        }
        catch (Throwable t) {
            logger.severe("Failed to execute persistence command='" + (Object)((Object)DrSubCommandsList.CLEANUP_TREES) + "'");
            logger.severe(CommandLogger.errorMessage(t));
            throw t;
        }
        return null;
    }

    private VisorDrCleanupTreeTaskArgs convertArguments() {
        return new VisorDrCleanupTreeTaskArgs(this.convertOperation(this.arguments.op), this.arguments.caches, this.arguments.groups);
    }

    private VisorDrRebuildTreeOperation convertOperation(Operation op) {
        switch (op) {
            case STATUS: {
                return VisorDrRebuildTreeOperation.STATUS;
            }
            case CANCEL: {
                return VisorDrRebuildTreeOperation.CANCEL;
            }
        }
        return VisorDrRebuildTreeOperation.DEFAULT;
    }

    @Override
    public Arguments arg() {
        return this.arguments;
    }

    @Override
    public final void printUsage(Logger log) {
        throw new UnsupportedOperationException("printUsage");
    }

    protected void printResult(VisorDrCleanupTreeTaskResult res, Logger log) {
        if (!res.messages().isEmpty()) {
            log.info(res.messages().stream().collect(Collectors.joining(System.lineSeparator())));
        } else {
            log.warning("No issues found.");
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set<String> cacheGrps = null;
        Set<String> cacheNames = null;
        ArrayList<String> consistentIds = null;
        Operation op = Operation.of(argIter.peekNextArg());
        if (op != null) {
            argIter.nextArg("");
        } else {
            op = Operation.DEFAULT;
        }
        switch (op) {
            case STATUS: 
            case CANCEL: {
                this.arguments = new Arguments(op);
                return;
            }
            case DEFAULT: {
                block14: while (argIter.hasNextSubArg()) {
                    String nextArg;
                    switch (nextArg = argIter.nextArg("")) {
                        case "--caches": {
                            cacheNames = CommandArgUtils.validateCachesArgument(argIter.nextCachesSet(nextArg), DrSubCommandsList.CLEANUP_TREES.toString());
                            continue block14;
                        }
                        case "--groups": {
                            cacheGrps = CommandArgUtils.validateCachesArgument(argIter.nextCacheGroupsSet(nextArg), DrSubCommandsList.CLEANUP_TREES.toString());
                            continue block14;
                        }
                        case "--nodes": {
                            Set<String> ids = argIter.nextStringSet(NODES_ARG);
                            if (ids.isEmpty()) {
                                throw new IllegalArgumentException("Consistent ids list is empty.");
                            }
                            consistentIds = new ArrayList<String>(ids);
                            continue block14;
                        }
                    }
                    throw new IllegalArgumentException("Argument " + nextArg + " is not supported.");
                }
                this.arguments = new Arguments(cacheNames, cacheGrps, consistentIds);
                return;
            }
        }
        throw new IllegalArgumentException("Command is not supported.");
    }

    @Override
    public String name() {
        return DrSubCommandsList.CLEANUP_TREES.text().toUpperCase();
    }

    static enum Operation {
        DEFAULT,
        STATUS,
        CANCEL;


        @Nullable
        static Operation of(String arg) {
            if ("status".equalsIgnoreCase(arg)) {
                return STATUS;
            }
            if ("cancel".equalsIgnoreCase(arg)) {
                return CANCEL;
            }
            return null;
        }
    }

    public static class Arguments {
        private Operation op;
        private Set<String> caches;
        private Set<String> groups;
        private List<String> nodeIds;

        public Arguments(Set<String> caches, Set<String> groups, List<String> nodeIds) {
            this.op = Operation.DEFAULT;
            this.caches = caches;
            this.groups = groups;
            this.nodeIds = nodeIds;
        }

        public Arguments(Operation op) {
            this.op = op;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

