/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.ssl.SslContextFactory;

public class CommonArgParser {
    private final Logger logger;
    static final String CMD_HOST = "--host";
    static final String CMD_PORT = "--port";
    static final String CMD_PASSWORD = "--password";
    static final String CMD_USER = "--user";
    public static final String CMD_AUTO_CONFIRMATION = "--yes";
    static final String CMD_PING_INTERVAL = "--ping-interval";
    static final String CMD_PING_TIMEOUT = "--ping-timeout";
    static final String CMD_CONNECTION_TIMEOUT = "--connection-timeout";
    public static final String CMD_VERBOSE = "--verbose";
    static final String CMD_SSL_PROTOCOL = "--ssl-protocol";
    static final String CMD_SSL_KEY_ALGORITHM = "--ssl-key-algorithm";
    static final String CMD_SSL_CIPHER_SUITES = "--ssl-cipher-suites";
    static final String CMD_KEYSTORE = "--keystore";
    static final String CMD_KEYSTORE_PASSWORD = "--keystore-password";
    static final String CMD_KEYSTORE_TYPE = "--keystore-type";
    static final String CMD_TRUSTSTORE = "--truststore";
    static final String CMD_TRUSTSTORE_PASSWORD = "--truststore-password";
    static final String CMD_TRUSTSTORE_TYPE = "--truststore-type";
    private static final Set<String> AUX_COMMANDS = new HashSet<String>();
    private static final Set<String> SENSITIVE_ARGUMENTS = new HashSet<String>();

    public static boolean isSensitiveArgument(String arg) {
        return SENSITIVE_ARGUMENTS.contains(arg);
    }

    public CommonArgParser(Logger logger) {
        this.logger = logger;
    }

    public static String[] getCommonOptions() {
        ArrayList<String> list = new ArrayList<String>(32);
        list.add(CommandLogger.optional(CMD_HOST, "HOST_OR_IP"));
        list.add(CommandLogger.optional(CMD_PORT, "PORT"));
        list.add(CommandLogger.optional(CMD_USER, "USER"));
        list.add(CommandLogger.optional(CMD_PASSWORD, "PASSWORD"));
        list.add(CommandLogger.optional(CMD_PING_INTERVAL, "PING_INTERVAL"));
        list.add(CommandLogger.optional(CMD_PING_TIMEOUT, "PING_TIMEOUT"));
        list.add(CommandLogger.optional(CMD_CONNECTION_TIMEOUT, "CONNECTION_TIMEOUT"));
        list.add(CommandLogger.optional(CMD_VERBOSE));
        list.add(CommandLogger.optional(CMD_SSL_PROTOCOL, "SSL_PROTOCOL[, SSL_PROTOCOL_2, ..., SSL_PROTOCOL_N]"));
        list.add(CommandLogger.optional(CMD_SSL_CIPHER_SUITES, "SSL_CIPHER_1[, SSL_CIPHER_2, ..., SSL_CIPHER_N]"));
        list.add(CommandLogger.optional(CMD_SSL_KEY_ALGORITHM, "SSL_KEY_ALGORITHM"));
        list.add(CommandLogger.optional(CMD_KEYSTORE_TYPE, "KEYSTORE_TYPE"));
        list.add(CommandLogger.optional(CMD_KEYSTORE, "KEYSTORE_PATH"));
        list.add(CommandLogger.optional(CMD_KEYSTORE_PASSWORD, "KEYSTORE_PASSWORD"));
        list.add(CommandLogger.optional(CMD_TRUSTSTORE_TYPE, "TRUSTSTORE_TYPE"));
        list.add(CommandLogger.optional(CMD_TRUSTSTORE, "TRUSTSTORE_PATH"));
        list.add(CommandLogger.optional(CMD_TRUSTSTORE_PASSWORD, "TRUSTSTORE_PASSWORD"));
        return list.toArray(new String[0]);
    }

    protected Command parseCommand(String s) {
        CommandList cmd = CommandList.of(s);
        return cmd != null ? cmd.command() : null;
    }

    public ConnectionAndSslParameters parseAndValidate(Iterator<String> rawArgIter) {
        String host = "127.0.0.1";
        String port = "11211";
        String user = null;
        String pwd = null;
        Long pingInterval = 5000L;
        Long pingTimeout = 7000L;
        Integer connTimeout = 10000;
        boolean autoConfirmation = false;
        boolean verbose = false;
        String sslProtocol = "TLS";
        String sslCipherSuites = "";
        String sslKeyAlgorithm = SslContextFactory.DFLT_KEY_ALGORITHM;
        String sslKeyStoreType = SslContextFactory.DFLT_STORE_TYPE;
        String sslKeyStorePath = null;
        char[] sslKeyStorePassword = null;
        String sslTrustStoreType = SslContextFactory.DFLT_STORE_TYPE;
        String sslTrustStorePath = null;
        char[] sslTrustStorePassword = null;
        CommandArgIterator argIter = new CommandArgIterator(rawArgIter, AUX_COMMANDS);
        Command command = null;
        block42: while (argIter.hasNextArg()) {
            String str = argIter.nextArg("").toLowerCase();
            Command cmd = this.parseCommand(str);
            if (cmd != null) {
                if (command != null) {
                    throw new IllegalArgumentException("Only one action can be specified, but found at least two: " + cmd.name() + ", " + command.name());
                }
                cmd.parseArguments(argIter);
                command = cmd;
                continue;
            }
            switch (str) {
                case "--host": {
                    host = argIter.nextArg("Expected host name");
                    break;
                }
                case "--port": {
                    port = argIter.nextArg("Expected port number");
                    try {
                        int p = Integer.parseInt(port);
                        if (p > 0 && p <= 65535) continue block42;
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                }
                case "--ping-interval": {
                    pingInterval = argIter.nextNonNegativeLongArg("ping interval");
                    break;
                }
                case "--ping-timeout": {
                    pingTimeout = argIter.nextNonNegativeLongArg("ping timeout");
                    break;
                }
                case "--connection-timeout": {
                    connTimeout = argIter.nextNonNegativeIntArg("connection timeout");
                    break;
                }
                case "--user": {
                    user = argIter.nextArg("Expected user name");
                    break;
                }
                case "--password": {
                    pwd = argIter.nextArg("Expected password");
                    this.logger.info(this.securityWarningMessage(CMD_PASSWORD));
                    break;
                }
                case "--ssl-protocol": {
                    sslProtocol = argIter.nextArg("Expected SSL protocol");
                    break;
                }
                case "--ssl-cipher-suites": {
                    sslCipherSuites = argIter.nextArg("Expected SSL cipher suites");
                    break;
                }
                case "--ssl-key-algorithm": {
                    sslKeyAlgorithm = argIter.nextArg("Expected SSL key algorithm");
                    break;
                }
                case "--keystore": {
                    sslKeyStorePath = argIter.nextArg("Expected SSL key store path");
                    break;
                }
                case "--keystore-password": {
                    sslKeyStorePassword = argIter.nextArg("Expected SSL key store password").toCharArray();
                    this.logger.info(this.securityWarningMessage(CMD_KEYSTORE_PASSWORD));
                    break;
                }
                case "--keystore-type": {
                    sslKeyStoreType = argIter.nextArg("Expected SSL key store type");
                    break;
                }
                case "--truststore": {
                    sslTrustStorePath = argIter.nextArg("Expected SSL trust store path");
                    break;
                }
                case "--truststore-password": {
                    sslTrustStorePassword = argIter.nextArg("Expected SSL trust store password").toCharArray();
                    this.logger.info(this.securityWarningMessage(CMD_TRUSTSTORE_PASSWORD));
                    break;
                }
                case "--truststore-type": {
                    sslTrustStoreType = argIter.nextArg("Expected SSL trust store type");
                    break;
                }
                case "--yes": {
                    autoConfirmation = true;
                    break;
                }
                case "--verbose": {
                    verbose = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected argument: " + str);
                }
            }
        }
        if (command == null) {
            throw new IllegalArgumentException("No action was specified");
        }
        return new ConnectionAndSslParameters(command, host, port, user, pwd, pingTimeout, pingInterval, connTimeout, autoConfirmation, verbose, sslProtocol, sslCipherSuites, sslKeyAlgorithm, sslKeyStorePath, sslKeyStorePassword, sslKeyStoreType, sslTrustStorePath, sslTrustStorePassword, sslTrustStoreType);
    }

    private String securityWarningMessage(String password) {
        String pwdArgWarnFmt = "Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).";
        return String.format("Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).", password, password);
    }

    static {
        AUX_COMMANDS.add(CMD_HOST);
        AUX_COMMANDS.add(CMD_PORT);
        AUX_COMMANDS.add(CMD_PASSWORD);
        AUX_COMMANDS.add(CMD_USER);
        AUX_COMMANDS.add(CMD_AUTO_CONFIRMATION);
        AUX_COMMANDS.add(CMD_VERBOSE);
        AUX_COMMANDS.add(CMD_PING_INTERVAL);
        AUX_COMMANDS.add(CMD_PING_TIMEOUT);
        AUX_COMMANDS.add(CMD_CONNECTION_TIMEOUT);
        AUX_COMMANDS.add(CMD_SSL_PROTOCOL);
        AUX_COMMANDS.add(CMD_SSL_KEY_ALGORITHM);
        AUX_COMMANDS.add(CMD_SSL_CIPHER_SUITES);
        AUX_COMMANDS.add(CMD_KEYSTORE);
        AUX_COMMANDS.add(CMD_KEYSTORE_PASSWORD);
        AUX_COMMANDS.add(CMD_KEYSTORE_TYPE);
        AUX_COMMANDS.add(CMD_TRUSTSTORE);
        AUX_COMMANDS.add(CMD_TRUSTSTORE_PASSWORD);
        AUX_COMMANDS.add(CMD_TRUSTSTORE_TYPE);
        SENSITIVE_ARGUMENTS.add(CMD_PASSWORD);
        SENSITIVE_ARGUMENTS.add(CMD_KEYSTORE_PASSWORD);
        SENSITIVE_ARGUMENTS.add(CMD_TRUSTSTORE_PASSWORD);
    }
}

