/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.processors.ru.RollingUpgradeModeChangeResult;
import org.apache.ignite.internal.visor.ru.VisorRollingUpgradeChangeModeResult;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.junit.Test;

public class GridCommandHandlerRUTest
extends GridCommandHandlerAbstractTest {
    private boolean addExtraArguments;

    @Override
    public String getTestIgniteInstanceName() {
        return "gridCommandHandlerTest";
    }

    @Override
    protected void addExtraArguments(List<String> args) {
        if (this.addExtraArguments) {
            super.addExtraArguments(args);
        }
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.addExtraArguments = true;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(true);
    }

    @Test
    public void testEnablingRollingUpgradeWithoutAutoConfirmation() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        this.addExtraArguments = false;
        CommandHandler hnd = new CommandHandler();
        GridCommandHandlerRUTest.assertEquals((int)0, (int)this.execute(hnd, "--rolling-upgrade", "start", "--yes"));
        this.checkFailedRollingUpgradeChangeModeResult((VisorRollingUpgradeChangeModeResult)hnd.getLastOperationResult(), "Enabling rolling upgrade should fail", UnsupportedOperationException.class);
        GridCommandHandlerRUTest.assertEquals((int)0, (int)this.execute(hnd, "--rolling-upgrade", "force", "--yes"));
        this.checkFailedRollingUpgradeChangeModeResult((VisorRollingUpgradeChangeModeResult)hnd.getLastOperationResult(), "Enabling rolling upgrade should fail", UnsupportedOperationException.class);
        GridCommandHandlerRUTest.assertEquals((int)1, (int)this.execute(hnd, "--rolling-upgrade", "start", "unknown-parameter"));
    }

    @Test
    public void testRollingUpgrade() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        CommandHandler hnd = new CommandHandler();
        GridCommandHandlerRUTest.assertEquals((int)0, (int)this.execute(hnd, "--rolling-upgrade", "start"));
        VisorRollingUpgradeChangeModeResult res = (VisorRollingUpgradeChangeModeResult)hnd.getLastOperationResult();
        GridCommandHandlerRUTest.assertTrue((String)("Enabling rolling upgrade should fail [res=" + res + ']'), (RollingUpgradeModeChangeResult.Result.FAIL == res.getResult() ? 1 : 0) != 0);
        GridCommandHandlerRUTest.assertEquals((String)("The cause of the failure should be UnsupportedOperationException [cause=" + res.getCause() + ']'), (String)res.getCause().getClassName(), (String)UnsupportedOperationException.class.getName());
        GridCommandHandlerRUTest.assertEquals((int)0, (int)this.execute(hnd, "--rolling-upgrade", "finish"));
        res = (VisorRollingUpgradeChangeModeResult)hnd.getLastOperationResult();
        GridCommandHandlerRUTest.assertTrue((String)("Disabling rolling upgrade should fail [res=" + res + ']'), (RollingUpgradeModeChangeResult.Result.FAIL == res.getResult() ? 1 : 0) != 0);
        GridCommandHandlerRUTest.assertEquals((String)("The cause of the failure should be UnsupportedOperationException [cause=" + res.getCause() + ']'), (String)res.getCause().getClassName(), (String)UnsupportedOperationException.class.getName());
    }

    @Test
    public void testRollingUpgradeStatus() throws Exception {
        this.autoConfirmation = false;
        IgniteEx ignite = this.startGrid(0);
        this.injectTestSystemOut();
        GridCommandHandlerRUTest.assertEquals((int)0, (int)this.execute("--rolling-upgrade", "status"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Rolling upgrade is disabled");
    }

    private void checkFailedRollingUpgradeChangeModeResult(VisorRollingUpgradeChangeModeResult res, String msg, Class eCls) {
        GridCommandHandlerRUTest.assertTrue((String)(msg + " [res=" + res + ']'), (RollingUpgradeModeChangeResult.Result.FAIL == res.getResult() ? 1 : 0) != 0);
        GridCommandHandlerRUTest.assertEquals((String)("The cause of the failure should be " + eCls.getName() + " [cause=" + res.getCause() + ']'), (String)res.getCause().getClassName(), (String)eCls.getName());
    }
}

