/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DeploymentEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.junit.Test;

public class GridCommandHandlerInterruptCommandTest
extends GridCommandHandlerAbstractTest {
    private static final int LOAD_LOOP = 500000;
    private static final String IDLE_VERIFY_TASK_V2 = "org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2";
    private static final String VALIDATE_INDEX_TASK = "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask";
    private ListeningTestLogger lnsrLog;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)this.lnsrLog).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0xC800000L).setMaxSize(0xC800000L))).setIncludeEventTypes(new int[]{33}).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setName("default").setQueryEntities(Collections.singleton(this.createQueryEntity()))});
    }

    private QueryEntity createQueryEntity() {
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getTypeName());
        qryEntity.setValueType(UserValue.class.getName());
        qryEntity.setTableName("USER_TEST_TABLE");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("x", "java.lang.Integer");
        fields.put("y", "java.lang.Integer");
        fields.put("z", "java.lang.Integer");
        qryEntity.setFields(fields);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        QueryIndex idx2 = new QueryIndex();
        idx2.setName("IDX_2");
        idx2.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("x", false);
        idx2.setFields(idxFields);
        QueryIndex idx3 = new QueryIndex();
        idx3.setName("IDX_3");
        idx3.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("y", false);
        idx3.setFields(idxFields);
        QueryIndex idx4 = new QueryIndex();
        idx4.setName("IDX_4");
        idx4.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("z", false);
        idx4.setFields(idxFields);
        qryEntity.setIndexes(Arrays.asList(idx2, idx3, idx4));
        return qryEntity;
    }

    @Test
    public void testValidateIndexesCommand() throws Exception {
        this.lnsrLog = new ListeningTestLogger(false, log);
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        this.preloadeData(ignite);
        CountDownLatch startTaskLatch = this.waitForTaskEvent(ignite, VALIDATE_INDEX_TASK);
        LogListener lnsrValidationCancelled = LogListener.matches((String)"Index validation was cancelled.").build();
        this.lnsrLog.registerListener(lnsrValidationCancelled);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> GridCommandHandlerInterruptCommandTest.assertSame((Object)4, (Object)this.execute("--cache", "validate_indexes")));
        startTaskLatch.await();
        fut.cancel();
        fut.get();
        GridCommandHandlerInterruptCommandTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ignite.compute().activeTaskFutures().isEmpty(), (long)10000L));
        GridCommandHandlerInterruptCommandTest.assertTrue((boolean)lnsrValidationCancelled.check());
    }

    @Test
    public void testIdleVerifyCommand() throws Exception {
        this.lnsrLog = new ListeningTestLogger(false, log);
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        this.preloadeData(ignite);
        CountDownLatch startTaskLatch = this.waitForTaskEvent(ignite, IDLE_VERIFY_TASK_V2);
        LogListener lnsrValidationCancelled = LogListener.matches((String)"Idle verify was cancelled.").build();
        this.lnsrLog.registerListener(lnsrValidationCancelled);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> GridCommandHandlerInterruptCommandTest.assertSame((Object)4, (Object)this.execute("--cache", "idle_verify")));
        startTaskLatch.await();
        fut.cancel();
        fut.get();
        GridCommandHandlerInterruptCommandTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ignite.compute().activeTaskFutures().isEmpty(), (long)10000L));
        GridCommandHandlerInterruptCommandTest.assertFalse((boolean)lnsrValidationCancelled.check());
    }

    private CountDownLatch waitForTaskEvent(IgniteEx ignite, String taskName) {
        CountDownLatch startTaskLatch = new CountDownLatch(1);
        ignite.events().localListen((IgnitePredicate & Serializable)evt -> {
            GridCommandHandlerInterruptCommandTest.assertTrue((boolean)(evt instanceof DeploymentEvent));
            if (taskName.equals(((DeploymentEvent)evt).alias())) {
                startTaskLatch.countDown();
                return false;
            }
            return true;
        }, new int[]{33});
        return startTaskLatch;
    }

    private void preloadeData(IgniteEx ignite) {
        try (IgniteDataStreamer streamr = ignite.dataStreamer("default");){
            for (int i = 0; i < 500000; ++i) {
                streamr.addData((Object)i, (Object)new UserValue(i));
            }
        }
    }

    @Test
    public void testCancelValidateIndexesClosure() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        ignite0.cluster().active(true);
        this.preloadeData(ignite0);
        AtomicBoolean cancelled = new AtomicBoolean(false);
        ValidateIndexesClosure clo = new ValidateIndexesClosure(cancelled::get, Collections.singleton("default"), 0, 0, false, true);
        ListeningTestLogger listeningLogger = new ListeningTestLogger(false, log);
        GridTestUtils.setFieldValue((Object)clo, (String)"ignite", (Object)ignite0);
        GridTestUtils.setFieldValue((Object)clo, (String)"log", (Object)listeningLogger);
        LogListener lnsrValidationStarted = LogListener.matches((String)"Current progress of ValidateIndexesClosure").build();
        listeningLogger.registerListener(lnsrValidationStarted);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> (IgniteException)GridTestUtils.assertThrows((IgniteLogger)log, () -> ((ValidateIndexesClosure)clo).call(), IgniteException.class, (String)"Closure of index validation was cancelled."));
        GridCommandHandlerInterruptCommandTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((LogListener)lnsrValidationStarted).check(), (long)10000L));
        GridCommandHandlerInterruptCommandTest.assertFalse((boolean)fut.isDone());
        cancelled.set(true);
        fut.get(10000L);
    }

    private static class UserValue {
        private int x;
        private int y;
        private int z;

        public UserValue(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public UserValue(long seed) {
            this.x = (int)(seed % 6991L);
            this.y = (int)(seed % 18679L);
            this.z = (int)(seed % 31721L);
        }

        public String toString() {
            return S.toString(UserValue.class, (Object)this);
        }
    }
}

