/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.ValidateIndexesCommandArg;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerIndexingCheckSizeTest
extends GridCommandHandlerClusterByClassAbstractTest {
    private static final int ENTRY_CNT = 100;
    private static final String NON_PERSIST_REGION = "non-persist";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)client, "persons-cache-vi", "group1", null, this.queryEntities(), 100);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.getDataStorageConfiguration().setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName(NON_PERSIST_REGION)});
        return cfg;
    }

    @Test
    public void testCheckCacheSizeWhenBrokenCache() {
        this.validateCheckSizesAfterBreakCacheDataTree(crd, "persons-cache-vi", 100);
    }

    @Test
    public void testNoCheckCacheSizeWhenBrokenCache() {
        String cacheName = "persons-cache-vi";
        GridCommandHandlerIndexingUtils.breakCacheDataTree(log, crd.cachex(cacheName), 1, null);
        this.checkNoCheckSizeInCaseBrokenData(cacheName);
    }

    @Test
    public void testCheckCacheSizeWhenBrokenIdx() throws Exception {
        this.validateCheckSizesAfterBreakSqlIndex(crd, "persons-cache-vi", 100);
    }

    @Test
    public void testNoCheckCacheSizeWhenBrokenIdx() throws Exception {
        String cacheName = "persons-cache-vi";
        GridCommandHandlerIndexingUtils.breakSqlIndex(crd.cachex(cacheName), 1, null);
        this.checkNoCheckSizeInCaseBrokenData(cacheName);
    }

    @Test
    public void testNoErrorOnCacheWithoutQueryEntity() {
        String cacheName = "default";
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)crd, cacheName, "group1", null, Collections.emptyMap(), 0);
        try (IgniteDataStreamer streamer = crd.dataStreamer(cacheName);){
            for (int i = 0; i < 100; ++i) {
                streamer.addData((Object)i, (Object)new GridCommandHandlerIndexingUtils.Person(i, "p_" + i));
            }
            streamer.flush();
        }
        this.execVIWithNoErrCheck(cacheName, false);
        this.execVIWithNoErrCheck(cacheName, true);
    }

    @Test
    public void testNoErrorOnEmptyCacheWithQueryEntity() {
        String cacheName = "default";
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)crd, cacheName, "group1", null, this.queryEntities(), 0);
        this.execVIWithNoErrCheck(cacheName, false);
        this.execVIWithNoErrCheck(cacheName, true);
    }

    @Test
    public void testNoErrorOnCacheWithEntryWithoutQueryEntity() {
        String cacheName = "persons-cache-vi";
        int cacheSize = crd.cachex(cacheName).size();
        try (IgniteDataStreamer streamer = crd.dataStreamer(cacheName);){
            for (int i = cacheSize; i < cacheSize + 100; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
            streamer.flush();
        }
        this.execVIWithNoErrCheck(cacheName, false);
        this.execVIWithNoErrCheck(cacheName, true);
    }

    @Test
    public void testNoErrorOnCacheWithEntryWithoutQueryEntityAndWithNullValues() {
        String cacheName = "persons-cache-vi";
        int cacheSize = crd.cachex(cacheName).size();
        try (IgniteDataStreamer streamer = crd.dataStreamer(cacheName);){
            int i;
            for (i = cacheSize; i < cacheSize + 90; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
            while (i < cacheSize + 100) {
                streamer.addData((Object)i, null);
                ++i;
            }
            streamer.flush();
        }
        this.execVIWithNoErrCheck(cacheName, false);
        this.execVIWithNoErrCheck(cacheName, true);
    }

    @Test
    public void testCheckCacheSizeWhenBrokenCacheInNonPersistRegion() {
        IgniteEx node = crd;
        String cacheName = "persons-cache-vi_new";
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)node, cacheName, "group1_new", NON_PERSIST_REGION, this.queryEntities(), 100);
        this.validateCheckSizesAfterBreakCacheDataTree(node, cacheName, 100);
    }

    @Test
    public void testCheckCacheSizeWhenBrokenIdxInNonPersistRegion() throws Exception {
        IgniteEx node = crd;
        String cacheName = "persons-cache-vi_new";
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)node, cacheName, "group1_new", NON_PERSIST_REGION, this.queryEntities(), 100);
        this.validateCheckSizesAfterBreakSqlIndex(node, cacheName, 100);
    }

    @Test
    public void testCheckCacheSizeWhenBrokenCacheWithDynamicAddColumnAndIndex() {
        IgniteEx node = crd;
        String cacheName = "persons-cache-vi";
        int addCnt = 100;
        this.addColumnAndIdx(node, cacheName, addCnt);
        this.validateCheckSizesAfterBreakCacheDataTree(node, cacheName, 100 + addCnt);
    }

    @Test
    public void testCheckCacheSizeWhenBrokenIdxWithDynamicAddColumnAndIndex() throws Exception {
        IgniteEx node = crd;
        String cacheName = "persons-cache-vi";
        int addCnt = 100;
        this.addColumnAndIdx(node, cacheName, addCnt);
        this.validateCheckSizesAfterBreakSqlIndex(node, cacheName, 100 + addCnt);
    }

    @Test
    public void testNoErrorOnCacheWithQueryEntity() {
        String cacheName = "persons-cache-vi";
        this.execVIWithNoErrCheck(cacheName, false);
        this.execVIWithNoErrCheck(cacheName, true);
    }

    @Test
    public void testNoNpeInToString() {
        List<IgniteDataTransferObject> transferObjects = Arrays.asList(new ValidateIndexesCheckSizeIssue(), new ValidateIndexesCheckSizeIssue(null, 0L, null), new ValidateIndexesCheckSizeIssue("idx", 0L, null), new ValidateIndexesCheckSizeIssue(null, 0L, (Throwable)new Exception("error")), new ValidateIndexesCheckSizeIssue("idx", 0L, (Throwable)new Exception("error")), new ValidateIndexesCheckSizeResult(), new ValidateIndexesCheckSizeResult(0L, null), new ValidateIndexesCheckSizeResult(0L, Collections.emptyList()), new ValidateIndexesCheckSizeResult(0L, Arrays.asList(new ValidateIndexesCheckSizeIssue())));
        log.info("transferObjects=" + transferObjects);
    }

    private void addColumnAndIdx(IgniteEx node, String cacheName, int addCnt) {
        IgniteCache cache = node.cache(cacheName);
        cache.query(new SqlFieldsQuery("alter table Person add column orgAddr varchar")).getAll();
        cache.query(new SqlFieldsQuery("alter table Organization add column addr varchar")).getAll();
        cache.query(new SqlFieldsQuery("create index p_o_addr on Person (orgAddr)")).getAll();
        cache.query(new SqlFieldsQuery("create index o_addr on Organization (addr)")).getAll();
        int key = node.cachex(cacheName).size();
        try (IgniteDataStreamer streamer = node.dataStreamer(cacheName);){
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < addCnt; ++i) {
                streamer.addData((Object)key++, (Object)new GridCommandHandlerIndexingUtils.Person(rand.nextInt(), String.valueOf(rand.nextLong())).orgAddr(String.valueOf(rand.nextLong())));
                streamer.addData((Object)key++, (Object)new GridCommandHandlerIndexingUtils.Organization(rand.nextInt(), String.valueOf(rand.nextLong())).addr(String.valueOf(rand.nextLong())));
            }
            streamer.flush();
        }
    }

    private void validateCheckSizesAfterBreakSqlIndex(IgniteEx node, String cacheName, int entryCnt) throws Exception {
        HashMap<String, AtomicInteger> rmvIdxByTbl = new HashMap<String, AtomicInteger>();
        GridCommandHandlerIndexingUtils.breakSqlIndex(node.cachex(cacheName), 0, row -> {
            rmvIdxByTbl.computeIfAbsent(this.tableName(cacheName, (CacheDataRow)row), s -> new AtomicInteger()).incrementAndGet();
            return true;
        });
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)rmvIdxByTbl.size(), (int)this.queryEntities().size());
        this.validateCheckSizes(node, cacheName, rmvIdxByTbl, ai -> entryCnt, ai -> entryCnt - ai.get());
    }

    private void validateCheckSizesAfterBreakCacheDataTree(IgniteEx node, String cacheName, int entryCnt) {
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(node);
        HashMap<String, AtomicInteger> rmvEntryByTbl = new HashMap<String, AtomicInteger>();
        GridCommandHandlerIndexingUtils.breakCacheDataTree(log, node.cachex(cacheName), 1, (i, entry) -> {
            rmvEntryByTbl.computeIfAbsent(this.tableName(cacheName, (Cache.Entry)entry), s -> new AtomicInteger()).incrementAndGet();
            return true;
        });
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)rmvEntryByTbl.size(), (int)this.queryEntities().size());
        this.validateCheckSizes(node, cacheName, rmvEntryByTbl, ai -> entryCnt - ai.get(), ai -> entryCnt);
    }

    private Map<QueryEntity, Function<Random, Object>> queryEntities() {
        HashMap<QueryEntity, Function<Random, Object>> qryEntities = new HashMap<QueryEntity, Function<Random, Object>>();
        qryEntities.put(GridCommandHandlerIndexingUtils.personEntity(), rand -> new GridCommandHandlerIndexingUtils.Person(rand.nextInt(), String.valueOf(rand.nextLong())));
        qryEntities.put(GridCommandHandlerIndexingUtils.organizationEntity(), rand -> new GridCommandHandlerIndexingUtils.Organization(rand.nextInt(), String.valueOf(rand.nextLong())));
        return qryEntities;
    }

    private void execVIWithNoErrCheck(String cacheName, boolean checkSizes) {
        ArrayList<String> cmdWithArgs = new ArrayList<String>(Arrays.asList(CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), cacheName));
        if (checkSizes) {
            cmdWithArgs.add(ValidateIndexesCommandArg.CHECK_SIZES.argName());
        }
        this.injectTestSystemOut();
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)0, (int)this.execute(cmdWithArgs));
        String out = testOut.toString();
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"issues found (listed above)");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"Size check");
    }

    private void checkNoCheckSizeInCaseBrokenData(String cacheName) {
        this.injectTestSystemOut();
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)0, (int)this.execute(CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), cacheName));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"issues found (listed above)");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"Size check");
    }

    private void validateCheckSizes(IgniteEx node, String cacheName, Map<String, AtomicInteger> rmvByTbl, Function<AtomicInteger, Integer> cacheSizeExp, Function<AtomicInteger, Integer> idxSizeExp) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(rmvByTbl);
        Objects.requireNonNull(cacheSizeExp);
        Objects.requireNonNull(idxSizeExp);
        this.injectTestSystemOut();
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)0, (int)this.execute(CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), cacheName, ValidateIndexesCommandArg.CHECK_SIZES.argName()));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"issues found (listed above)");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Size check");
        Map valIdxCheckSizeResults = ((VisorValidateIndexesJobResult)((VisorValidateIndexesTaskResult)this.lastOperationResult).results().get(node.localNode().id())).checkSizeResult();
        GridCommandHandlerIndexingCheckSizeTest.assertEquals((int)rmvByTbl.size(), (int)valIdxCheckSizeResults.size());
        for (Map.Entry<String, AtomicInteger> rmvByTblEntry : rmvByTbl.entrySet()) {
            ValidateIndexesCheckSizeResult checkSizeRes = valIdxCheckSizeResults.entrySet().stream().filter(e -> ((String)e.getKey()).contains((CharSequence)rmvByTblEntry.getKey())).map(Map.Entry::getValue).findAny().orElse(null);
            GridCommandHandlerIndexingCheckSizeTest.assertNotNull((Object)checkSizeRes);
            GridCommandHandlerIndexingCheckSizeTest.assertEquals((long)cacheSizeExp.apply(rmvByTblEntry.getValue()).intValue(), (long)checkSizeRes.cacheSize());
            Collection issues = checkSizeRes.issues();
            GridCommandHandlerIndexingCheckSizeTest.assertFalse((boolean)issues.isEmpty());
            issues.forEach(issue -> {
                GridCommandHandlerIndexingCheckSizeTest.assertEquals((long)((Integer)idxSizeExp.apply((AtomicInteger)rmvByTblEntry.getValue())).intValue(), (long)issue.indexSize());
                Throwable err = issue.error();
                GridCommandHandlerIndexingCheckSizeTest.assertNotNull((Object)err);
                GridCommandHandlerIndexingCheckSizeTest.assertEquals((String)"Cache and index size not same.", (String)err.getMessage());
            });
        }
    }

    private String tableName(String cacheName, CacheDataRow cacheDataRow) {
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(cacheDataRow);
        try {
            return crd.context().query().typeByValue(cacheName, crd.cachex(cacheName).context().cacheObjectContext(), cacheDataRow.key(), cacheDataRow.value(), false).tableName();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private <K, V> String tableName(String cacheName, Cache.Entry<K, V> cacheEntry) {
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(cacheEntry);
        try {
            return crd.context().query().typeByValue(cacheName, crd.cachex(cacheName).context().cacheObjectContext(), null, (CacheObject)cacheEntry.getValue(), false).tableName();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }
}

