/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.visor.cache.index.IndexListInfoContainer;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.junit.Test;

public class GridCommandHandlerIndexListTest
extends GridCommandHandlerAbstractTest {
    public static final int GRIDS_NUM = 2;
    static final String SPECIFIC_CACHE_NAME = "SpecificCacheName";
    static final String DEFAULT_CACHE_NAME_PREFIX = "SQL_PUBLIC_";
    private Ignite ignite;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.ignite = this.startGrids(2);
        this.ignite.cluster().active(true);
        GridCommandHandlerIndexingUtils.createAndFillSeveralCaches(this.ignite);
        this.createTable();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    @Test
    public void testCacheIndexList() {
        String idxName = "PERSON_ORGID_ASC_IDX";
        int expectedLinesNum = 15;
        int expectedIndexDescrLinesNum = 2;
        this.injectTestSystemOut();
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        GridCommandHandlerIndexListTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_list", "--index-name", "PERSON_ORGID_ASC_IDX"));
        String outStr = testOut.toString();
        GridCommandHandlerIndexListTest.assertTrue((boolean)outStr.contains("grpName=group1, cacheName=persons-cache-vi, idxName=PERSON_ORGID_ASC_IDX, colsNames=ArrayList [ORGID, _KEY], tblName=PERSON"));
        GridCommandHandlerIndexListTest.assertTrue((boolean)outStr.contains("grpName=group1_second, cacheName=persons-cache-vi-second, idxName=PERSON_ORGID_ASC_IDX, colsNames=ArrayList [ORGID, _KEY], tblName=PERSON"));
        String[] outputLines = outStr.split("\n");
        int outputLinesNum = outputLines.length;
        GridCommandHandlerIndexListTest.assertEquals((String)("Unexpected number of lines: " + outputLinesNum), (int)outputLinesNum, (int)15);
        long indexDescrLinesNum = Arrays.stream(outputLines).filter(s -> s.contains("grpName=")).count();
        GridCommandHandlerIndexListTest.assertEquals((String)("Unexpected number of index description lines: " + indexDescrLinesNum), (long)indexDescrLinesNum, (long)2L);
        Set cmdResult = (Set)handler.getLastOperationResult();
        GridCommandHandlerIndexListTest.assertNotNull((Object)cmdResult);
        int resSetSize = cmdResult.size();
        GridCommandHandlerIndexListTest.assertEquals((String)("Unexpected result set size: " + resSetSize), (int)resSetSize, (int)2);
        boolean isResSetCorrect = cmdResult.stream().map(IndexListInfoContainer::indexName).allMatch(name -> name.equals("PERSON_ORGID_ASC_IDX"));
        GridCommandHandlerIndexListTest.assertTrue((String)"Unexpected result set", (boolean)isResSetCorrect);
    }

    @Test
    public void tesAllArgs() {
        String idxName = "PERSON_ORGID_ASC_IDX";
        this.injectTestSystemOut();
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        GridCommandHandlerIndexListTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_list", "--node-id", this.grid(0).localNode().id().toString(), "--group-name", "^group1$", "--cache-name", "persons-cache-vi", "--index-name", "PERSON_ORGID_ASC_IDX"));
        GridCommandHandlerIndexListTest.assertTrue((boolean)testOut.toString().contains("grpName=group1, cacheName=persons-cache-vi, idxName=PERSON_ORGID_ASC_IDX, colsNames=ArrayList [ORGID, _KEY], tblName=PERSON"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListCacheWithoutIndexes() {
        IgniteEx ignite = this.grid(0);
        String tmpCacheName = "tmpCache";
        this.injectTestSystemOut();
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        try {
            ignite.createCache("tmpCache");
            try (IgniteDataStreamer streamer = ignite.dataStreamer("tmpCache");){
                for (long i = 0L; i < 1000L; ++i) {
                    streamer.addData((Object)(i * 13L), (Object)(i * 17L));
                }
            }
            GridCommandHandlerIndexListTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_list", "--cache-name", "tmpCache"));
            String str = testOut.toString();
            String[] lines = str.split("\n");
            GridCommandHandlerIndexListTest.assertEquals((String)"Unexpected output size", (int)11, (int)lines.length);
        }
        finally {
            ignite.destroyCache("tmpCache");
        }
    }

    @Test
    public void testGroupNameFilter1() {
        this.checkGroup("^group1$", "group1", 7);
    }

    @Test
    public void testGroupNameFilter2() {
        this.checkGroup("^group1", (String name) -> name.equals("group1") || name.equals("group1_second"), 10);
    }

    @Test
    public void testEmptyGroupFilter() {
        this.checkGroup("no_group", "no_group", 8);
    }

    private void checkGroup(String grpRegEx, String grpName, int expectedResNum) {
        this.checkGroup(grpRegEx, (String name) -> name.equals(grpName), expectedResNum);
    }

    private void checkGroup(String grpRegEx, Predicate<String> predicate, int expectedResNum) {
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        GridCommandHandlerIndexListTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_list", "--group-name", grpRegEx));
        Set cmdResult = (Set)handler.getLastOperationResult();
        GridCommandHandlerIndexListTest.assertNotNull((Object)cmdResult);
        boolean isResCorrect = cmdResult.stream().map(IndexListInfoContainer::groupName).allMatch(predicate);
        GridCommandHandlerIndexListTest.assertTrue((String)"Unexpected command result", (boolean)isResCorrect);
        int indexesNum = cmdResult.size();
        GridCommandHandlerIndexListTest.assertEquals((String)("Unexpected number of indexes: " + indexesNum), (int)indexesNum, (int)expectedResNum);
    }

    @Test
    public void testCacheNameFilter1() {
        this.checkCacheNameFilter("three_entries", cacheName -> cacheName.contains("three_entries"), 8);
    }

    @Test
    public void testCacheNameFilterSQLSpecificCacheName() {
        this.checkCacheNameFilter(SPECIFIC_CACHE_NAME, cacheName -> cacheName.contains(SPECIFIC_CACHE_NAME), 2);
    }

    @Test
    public void testCacheNameFilterSQLDefaultCacheName() {
        this.checkCacheNameFilter(DEFAULT_CACHE_NAME_PREFIX, cacheName -> cacheName.contains(DEFAULT_CACHE_NAME_PREFIX), 2);
    }

    @Test
    public void testCacheNameFilter2() {
        this.checkCacheNameFilter("^three_entries", cacheName -> cacheName.startsWith("three_entries"), 4);
    }

    private void checkCacheNameFilter(String cacheRegEx, Predicate<String> predicate, int expectedResNum) {
        CommandHandler handler = new CommandHandler(this.createTestLogger());
        GridCommandHandlerIndexListTest.assertEquals((int)0, (int)this.execute(handler, "--cache", "indexes_list", "--cache-name", cacheRegEx));
        Set cmdResult = (Set)handler.getLastOperationResult();
        GridCommandHandlerIndexListTest.assertNotNull((Object)cmdResult);
        boolean isResCorrect = cmdResult.stream().map(IndexListInfoContainer::cacheName).allMatch(predicate);
        GridCommandHandlerIndexListTest.assertTrue((String)"Unexpected command result", (boolean)isResCorrect);
        int indexesNum = cmdResult.size();
        GridCommandHandlerIndexListTest.assertEquals((String)("Unexpected number of indexes: " + indexesNum), (int)indexesNum, (int)expectedResNum);
    }

    private void createTable() throws Exception {
        Class.forName("org.apache.ignite.IgniteJdbcThinDriver");
        String url = "jdbc:ignite:thin://127.0.0.1";
        try (Connection conn = DriverManager.getConnection(url);){
            conn.prepareStatement("drop table if exists T1").execute();
            conn.prepareStatement("create table T1 (id integer primary key, enddate timestamp)").execute();
            conn.prepareStatement("create index idx_t1_enddate ON T1 (enddate)").execute();
            conn.prepareStatement("drop table if exists T2").execute();
            conn.prepareStatement("create table T2 (id integer primary key, enddate timestamp) with \"cache_name=SpecificCacheName\"").execute();
            conn.prepareStatement("create index idx_t2_enddate ON T2 (enddate)").execute();
        }
    }
}

