/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.MessageOrderLogListener;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.apache.ignite.util.GridCommandHandlerIndexingUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class GridCommandHandlerIndexForceRebuildTest
extends GridCommandHandlerAbstractTest {
    private static final String CACHE_NAME_1_1 = "cache_1_1";
    private static final String CACHE_NAME_1_2 = "cache_1_2";
    private static final String CACHE_NAME_2_1 = "cache_2_1";
    private static final String CACHE_NAME_NO_GRP = "cache_no_group";
    private static final String CACHE_NAME_NON_EXISTING = "non_existing_cache";
    private static final String GRP_NAME_1 = "group_1";
    private static final String GRP_NAME_2 = "group_2";
    private static final String GRP_NAME_NON_EXISTING = "non_existing_group";
    private static final int GRIDS_NUM = 3;
    private static final int LAST_NODE_NUM = 2;
    private static final Map<String, GridFutureAdapter<Void>> blockRebuildIdx = new ConcurrentHashMap<String, GridFutureAdapter<Void>>();

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        ListeningTestLogger testLog = new ListeningTestLogger(log);
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)testLog);
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startupTestCluster();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        blockRebuildIdx.clear();
    }

    private void startupTestCluster() throws Exception {
        for (int i = 0; i < 3; ++i) {
            GridQueryProcessor.idxCls = BlockingIndexing.class;
            this.startGrid(i);
        }
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, CACHE_NAME_1_1, GRP_NAME_1);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, CACHE_NAME_1_2, GRP_NAME_1);
        GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, CACHE_NAME_2_1, GRP_NAME_2);
        GridCommandHandlerIndexingUtils.createAndFillThreeFieldsEntryCache((Ignite)ignite, CACHE_NAME_NO_GRP, null, Collections.singletonList(GridCommandHandlerIndexingUtils.complexIndexEntity()));
    }

    @Test
    public void testEmptyResult() {
        this.injectTestSystemOut();
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(2).localNode().id().toString(), "--cache-names", CACHE_NAME_NON_EXISTING));
        String cacheNamesOutputStr = testOut.toString();
        GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)cacheNamesOutputStr.contains("WARNING: Indexes rebuild was not started for any cache. Check command input."));
        testOut.reset();
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(2).localNode().id().toString(), "--group-names", GRP_NAME_NON_EXISTING));
        String grpNamesOutputStr = testOut.toString();
        GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)grpNamesOutputStr.contains("WARNING: Indexes rebuild was not started for any cache. Check command input."));
    }

    @Test
    public void testComplexIndexRebuild() throws IgniteInterruptedCheckedException {
        this.injectTestSystemOut();
        LogListener lsnr = this.installRebuildCheckListener(this.grid(2), CACHE_NAME_NO_GRP);
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(2).localNode().id().toString(), "--cache-names", CACHE_NAME_NO_GRP));
        GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)this.waitForIndexesRebuild(this.grid(2)));
        GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)lsnr.check());
        this.removeLogListener(this.grid(2), lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheNamesArg() throws Exception {
        blockRebuildIdx.put(CACHE_NAME_2_1, (GridFutureAdapter<Void>)new GridFutureAdapter());
        this.injectTestSystemOut();
        LogListener[] cache1Listeners = new LogListener[3];
        LogListener[] cache2Listeners = new LogListener[3];
        try {
            this.triggerIndexRebuild(2, Collections.singletonList(CACHE_NAME_2_1));
            for (int i = 0; i < 3; ++i) {
                cache1Listeners[i] = this.installRebuildCheckListener(this.grid(i), CACHE_NAME_1_1);
                cache2Listeners[i] = this.installRebuildCheckListener(this.grid(i), CACHE_NAME_1_2);
            }
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(2).localNode().id().toString(), "--cache-names", "cache_1_1,cache_2_1,non_existing_cache"));
            blockRebuildIdx.remove(CACHE_NAME_2_1);
            this.waitForIndexesRebuild(this.grid(2));
            String outputStr = testOut.toString();
            this.validateOutputCacheNamesNotFound(outputStr, CACHE_NAME_NON_EXISTING);
            this.validateOutputIndicesRebuildingInProgress(outputStr, F.asMap((Object)GRP_NAME_2, (Object)F.asList((Object)CACHE_NAME_2_1)));
            this.validateOutputIndicesRebuildWasStarted(outputStr, F.asMap((Object)GRP_NAME_1, (Object)F.asList((Object)CACHE_NAME_1_1)));
            GridCommandHandlerIndexForceRebuildTest.assertEquals((String)"Unexpected number of lines in output.", (int)19, (int)outputStr.split("\n").length);
            GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache1Listeners[0].check());
            GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache1Listeners[1].check());
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)cache1Listeners[2].check());
            for (LogListener cache2Lsnr : cache2Listeners) {
                GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache2Lsnr.check());
            }
        }
        finally {
            blockRebuildIdx.remove(CACHE_NAME_2_1);
            for (int i = 0; i < 3; ++i) {
                this.removeLogListener(this.grid(i), cache1Listeners[i]);
                this.removeLogListener(this.grid(i), cache2Listeners[i]);
            }
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)this.waitForIndexesRebuild(this.grid(2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupNamesArg() throws Exception {
        blockRebuildIdx.put(CACHE_NAME_1_2, (GridFutureAdapter<Void>)new GridFutureAdapter());
        this.injectTestSystemOut();
        LogListener[] cache1Listeners = new LogListener[3];
        LogListener[] cache2Listeners = new LogListener[3];
        try {
            this.triggerIndexRebuild(2, Collections.singletonList(CACHE_NAME_1_2));
            for (int i = 0; i < 3; ++i) {
                cache1Listeners[i] = this.installRebuildCheckListener(this.grid(i), CACHE_NAME_1_1);
                cache2Listeners[i] = this.installRebuildCheckListener(this.grid(i), CACHE_NAME_NO_GRP);
            }
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(2).localNode().id().toString(), "--group-names", "group_1,group_2,non_existing_group"));
            blockRebuildIdx.remove(CACHE_NAME_1_2);
            this.waitForIndexesRebuild(this.grid(2));
            String outputStr = testOut.toString();
            this.validateOutputCacheGroupsNotFound(outputStr, GRP_NAME_NON_EXISTING);
            this.validateOutputIndicesRebuildingInProgress(outputStr, F.asMap((Object)GRP_NAME_1, (Object)F.asList((Object)CACHE_NAME_1_2)));
            this.validateOutputIndicesRebuildWasStarted(outputStr, F.asMap((Object)GRP_NAME_1, (Object)F.asList((Object)CACHE_NAME_1_1), (Object)GRP_NAME_2, (Object)F.asList((Object)CACHE_NAME_2_1)));
            GridCommandHandlerIndexForceRebuildTest.assertEquals((String)"Unexpected number of lines in outputStr.", (int)20, (int)outputStr.split("\n").length);
            GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache1Listeners[0].check());
            GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache1Listeners[1].check());
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)cache1Listeners[2].check());
            for (LogListener cache2Lsnr : cache2Listeners) {
                GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)cache2Lsnr.check());
            }
        }
        finally {
            blockRebuildIdx.remove(CACHE_NAME_1_2);
            for (int i = 0; i < 3; ++i) {
                this.removeLogListener(this.grid(i), cache1Listeners[i]);
                this.removeLogListener(this.grid(i), cache2Listeners[i]);
            }
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)this.waitForIndexesRebuild(this.grid(2)));
        }
    }

    @Test
    public void testIllegalArgument() {
        int code = this.execute("--cache", "indexes_force_rebuild", "--illegal_parameter");
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)1, (int)code);
    }

    @Test
    public void testClientNodeConnection() throws Exception {
        IgniteEx client = this.startGrid("client");
        try {
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)1, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", client.localNode().id().toString(), "--group-names", GRP_NAME_1));
        }
        finally {
            this.stopGrid("client");
        }
    }

    @Test
    public void testAsyncIndexesRebuild() throws IgniteInterruptedCheckedException {
        blockRebuildIdx.put(CACHE_NAME_1_1, (GridFutureAdapter<Void>)new GridFutureAdapter());
        blockRebuildIdx.put(CACHE_NAME_1_2, (GridFutureAdapter<Void>)new GridFutureAdapter());
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(0).localNode().id().toString(), "--cache-names", CACHE_NAME_1_1));
        GridCommandHandlerIndexForceRebuildTest.assertTrue((String)"Failed to wait for index rebuild start for first cache.", (boolean)GridTestUtils.waitForCondition(() -> this.getActiveRebuildCaches(this.grid(0)).size() == 1, (long)10000L));
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", this.grid(0).localNode().id().toString(), "--cache-names", CACHE_NAME_1_2));
        GridCommandHandlerIndexForceRebuildTest.assertTrue((String)"Failed to wait for index rebuild start for second cache.", (boolean)GridTestUtils.waitForCondition(() -> this.getActiveRebuildCaches(this.grid(0)).size() == 2, (long)10000L));
        blockRebuildIdx.clear();
        GridCommandHandlerIndexForceRebuildTest.assertTrue((String)"Failed to wait for final index rebuild.", (boolean)this.waitForIndexesRebuild(this.grid(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexRebuildUnderLoad() throws Exception {
        IgniteEx n = this.grid(0);
        AtomicBoolean stopLoad = new AtomicBoolean(false);
        String cacheName1 = "tmpCache1";
        String cacheName2 = "tmpCache2";
        List caches = F.asList((Object[])new String[]{cacheName1, cacheName2});
        try {
            for (Object c : caches) {
                GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)n, (String)c, "tmpGrp");
            }
            int cacheSize = n.cache(cacheName1).size(new CachePeekMode[0]);
            for (Object c : caches) {
                blockRebuildIdx.put((String)c, (GridFutureAdapter<Void>)new GridFutureAdapter());
            }
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", n.localNode().id().toString(), "--cache-names", cacheName1 + "," + cacheName2));
            IgniteInternalFuture putCacheFut = GridTestUtils.runAsync(() -> {
                ThreadLocalRandom r = ThreadLocalRandom.current();
                while (!stopLoad.get()) {
                    n.cache(cacheName1).put((Object)r.nextInt(), (Object)new GridCommandHandlerIndexingUtils.Person(r.nextInt(), String.valueOf(r.nextLong())));
                }
            });
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> n.cache(cacheName1).size(new CachePeekMode[0]) > cacheSize, (long)this.getTestTimeout()));
            for (String c : caches) {
                IgniteInternalFuture rebIdxFut = n.context().query().indexRebuildFuture(CU.cacheId((String)c));
                GridCommandHandlerIndexForceRebuildTest.assertNotNull((Object)rebIdxFut);
                GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)rebIdxFut.isDone());
                blockRebuildIdx.get(c).get(this.getTestTimeout());
            }
            IgniteInternalFuture destroyCacheFut = n.context().cache().dynamicDestroyCache(cacheName2, false, true, false, null);
            SchemaIndexCacheFuture intlRebIdxFut = this.schemaIndexCacheFuture(n, CU.cacheId((String)cacheName2));
            GridCommandHandlerIndexForceRebuildTest.assertNotNull((Object)intlRebIdxFut);
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((SchemaIndexOperationCancellationToken)intlRebIdxFut.cancelToken()).isCancelled(), (long)this.getTestTimeout()));
            stopLoad.set(true);
            blockRebuildIdx.clear();
            this.waitForIndexesRebuild(n);
            intlRebIdxFut.get(this.getTestTimeout());
            destroyCacheFut.get(this.getTestTimeout());
            putCacheFut.get(this.getTestTimeout());
            this.injectTestSystemOut();
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", cacheName1));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found.");
        }
        finally {
            stopLoad.set(true);
            blockRebuildIdx.clear();
            n.destroyCache(cacheName1);
            n.destroyCache(cacheName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedIndexRebuild() throws Exception {
        IgniteEx ignite = this.grid(0);
        String cacheName = "tmpCache";
        String grpName = "tmpGrp";
        try {
            GridCommandHandlerIndexingUtils.createAndFillCache((Ignite)ignite, "tmpCache", "tmpGrp");
            GridCommandHandlerIndexingUtils.breakSqlIndex(ignite.cachex("tmpCache"), 1, null);
            this.injectTestSystemOut();
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "--check-sizes"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"issues found (listed above)");
            testOut.reset();
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", ignite.localNode().id().toString(), "--cache-names", "tmpCache"));
            GridCommandHandlerIndexForceRebuildTest.assertTrue((boolean)this.waitForIndexesRebuild(ignite));
            this.forceCheckpoint((Ignite)ignite);
            GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "validate_indexes", "--check-crc", "tmpCache"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no issues found.");
        }
        finally {
            ignite.destroyCache("tmpCache");
        }
    }

    @Test
    public void testSequentialForceRebuildIndexes() throws Exception {
        IgniteEx grid = this.grid(0);
        this.injectTestSystemOut();
        this.forceRebuildIndices(F.asList((Object)CACHE_NAME_1_1), grid);
        String outputStr = testOut.toString();
        this.validateOutputIndicesRebuildWasStarted(outputStr, F.asMap((Object)GRP_NAME_1, (Object)F.asList((Object)CACHE_NAME_1_1)));
        GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)outputStr.contains("WARNING: These caches have indexes rebuilding in progress:"));
        this.forceRebuildIndices(F.asList((Object)CACHE_NAME_1_1), grid);
        this.validateOutputIndicesRebuildWasStarted(outputStr, F.asMap((Object)GRP_NAME_1, (Object)F.asList((Object)CACHE_NAME_1_1)));
        GridCommandHandlerIndexForceRebuildTest.assertFalse((boolean)outputStr.contains("WARNING: These caches have indexes rebuilding in progress:"));
    }

    private void validateOutputCacheNamesNotFound(String outputStr, String ... cacheNames) {
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)("WARNING: These caches were not found:" + U.nl() + this.makeStringListWithIndent(cacheNames)));
    }

    private void validateOutputCacheGroupsNotFound(String outputStr, String ... cacheGrps) {
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)("WARNING: These cache groups were not found:" + U.nl() + this.makeStringListWithIndent(cacheGrps)));
    }

    private String makeStringListWithIndent(String ... strings) {
        return "  " + String.join((CharSequence)(U.nl() + "  "), strings);
    }

    private String makeStringListForCacheGroupsAndNames(Map<String, List<String>> cacheGroputToNames) {
        SB sb = new SB();
        for (Map.Entry<String, List<String>> entry : cacheGroputToNames.entrySet()) {
            String cacheGrp = entry.getKey();
            for (String cacheName : entry.getValue()) {
                sb.a("  ").a("groupName=").a(cacheGrp).a(", cacheName=").a(cacheName).a(U.nl());
            }
        }
        return sb.toString();
    }

    private void validateOutputIndicesRebuildingInProgress(String outputStr, Map<String, List<String>> cacheGroputToNames) {
        String caches = this.makeStringListForCacheGroupsAndNames(cacheGroputToNames);
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)("WARNING: These caches have indexes rebuilding in progress:" + U.nl() + caches));
    }

    private void validateOutputIndicesRebuildWasStarted(String outputStr, Map<String, List<String>> cacheGroputToNames) {
        String caches = this.makeStringListForCacheGroupsAndNames(cacheGroputToNames);
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)("Indexes rebuild was started for these caches:" + U.nl() + caches));
    }

    private void triggerIndexRebuild(int igniteIdx, Collection<String> excludedCacheNames) throws Exception {
        this.stopGrid(igniteIdx);
        GridTestUtils.deleteIndexBin((String)this.getTestIgniteInstanceName(2));
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteEx ignite = this.startGrid(igniteIdx);
        this.resetBaselineTopology();
        this.awaitPartitionMapExchange();
        this.waitForIndexesRebuild(ignite, 30000L, excludedCacheNames);
    }

    private boolean waitForIndexesRebuild(IgniteEx ignite) throws IgniteInterruptedCheckedException {
        return this.waitForIndexesRebuild(ignite, 30000L, Collections.emptySet());
    }

    private boolean waitForIndexesRebuild(IgniteEx ignite, long timeout, Collection<String> excludedCacheNames) throws IgniteInterruptedCheckedException {
        return GridTestUtils.waitForCondition(() -> ignite.context().cache().publicCaches().stream().filter(c -> !excludedCacheNames.contains(c.getName())).allMatch(c -> c.indexReadyFuture().isDone()), (long)timeout);
    }

    private Set<IgniteCacheProxy<?, ?>> getActiveRebuildCaches(IgniteEx ignite) {
        return ignite.context().cache().publicCaches().stream().filter(c -> !c.indexReadyFuture().isDone()).collect(Collectors.toSet());
    }

    private LogListener installRebuildCheckListener(IgniteEx ignite, String cacheName) {
        MessageOrderLogListener lsnr = new MessageOrderLogListener(new MessageOrderLogListener.MessageGroup(true).add("Started indexes rebuilding for cache \\[name=" + cacheName + ".*").add("Finished indexes rebuilding for cache \\[name=" + cacheName + ".*"));
        ListeningTestLogger impl = (ListeningTestLogger)GridTestUtils.getFieldValue((Object)ignite.log(), (String[])new String[]{"impl"});
        GridCommandHandlerIndexForceRebuildTest.assertNotNull((Object)impl);
        impl.registerListener((LogListener)lsnr);
        return lsnr;
    }

    private void removeLogListener(IgniteEx ignite, LogListener lsnr) {
        ListeningTestLogger impl = (ListeningTestLogger)GridTestUtils.getFieldValue((Object)ignite.log(), (String[])new String[]{"impl"});
        GridCommandHandlerIndexForceRebuildTest.assertNotNull((Object)impl);
        impl.unregisterListener((Consumer)lsnr);
    }

    @Nullable
    private SchemaIndexCacheFuture schemaIndexCacheFuture(IgniteEx n, int cacheId) {
        GridQueryIndexing indexing = n.context().query().getIndexing();
        Map idxRebuildFuts = (Map)GridTestUtils.getFieldValueHierarchy((Object)indexing, (String[])new String[]{"idxRebuildFuts"});
        return (SchemaIndexCacheFuture)idxRebuildFuts.get(cacheId);
    }

    private void forceRebuildIndices(Iterable<String> cacheNames, IgniteEx grid) throws Exception {
        String cacheNamesArg = String.join((CharSequence)",", cacheNames);
        GridCommandHandlerIndexForceRebuildTest.assertEquals((int)0, (int)this.execute("--cache", "indexes_force_rebuild", "--node-id", grid.localNode().id().toString(), "--cache-names", cacheNamesArg));
        this.waitForIndexesRebuild(grid, this.getTestTimeout(), Collections.emptyList());
    }

    private static class BlockingRebuildIdxFuture
    extends GridFutureAdapter<Void> {
        private final GridFutureAdapter<Void> original;
        private final GridCacheContext cctx;

        BlockingRebuildIdxFuture(GridFutureAdapter<Void> original, GridCacheContext cctx) {
            this.original = original;
            this.cctx = cctx;
        }

        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            try {
                GridFutureAdapter fut = (GridFutureAdapter)blockRebuildIdx.get(this.cctx.name());
                if (fut != null) {
                    fut.onDone();
                    GridCommandHandlerIndexForceRebuildTest.assertTrue((String)"Failed to wait for indexes rebuild unblocking", (boolean)GridTestUtils.waitForCondition(() -> !blockRebuildIdx.containsKey(this.cctx.name()), (long)60000L));
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                GridCommandHandlerIndexForceRebuildTest.fail((String)"Waiting for indexes rebuild unblocking was interrupted");
            }
            return this.original.onDone((Object)res, err);
        }
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private BlockingIndexing() {
        }

        protected void rebuildIndexesFromHash0(GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut, SchemaIndexOperationCancellationToken cancel) {
            super.rebuildIndexesFromHash0(cctx, clo, (GridFutureAdapter)new BlockingRebuildIdxFuture(rebuildIdxFut, cctx), cancel);
        }
    }
}

