/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.UnaryOperator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.DefragmentationParameters;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.junit.Test;

public class GridCommandHandlerDefragmentationTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    private static CountDownLatch blockCdl;
    private static CountDownLatch waitCdl;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.getDataStorageConfiguration().setWalSegmentSize(524288).setWalSegments(3);
        return cfg;
    }

    @Test
    public void testDefragmentationSchedule() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerDefragmentationTest.assertEquals((int)1, (int)this.execute("--defragmentation", "schedule"));
        String grid0ConsId = this.grid(0).configuration().getConsistentId().toString();
        String grid1ConsId = this.grid(1).configuration().getConsistentId().toString();
        ListeningTestLogger testLog = new ListeningTestLogger();
        CommandHandler cmd = this.createCommandHandler(testLog);
        LogListener logLsnr = LogListener.matches((String)"Scheduling completed successfully.").build();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", grid0ConsId));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        MaintenanceTask mntcTask = DefragmentationParameters.toStore(Collections.emptyList());
        GridCommandHandlerDefragmentationTest.assertNotNull((Object)this.grid(0).context().maintenanceRegistry().registerMaintenanceTask(mntcTask));
        GridCommandHandlerDefragmentationTest.assertNull((Object)this.grid(1).context().maintenanceRegistry().registerMaintenanceTask(mntcTask));
        this.stopGrid(0);
        this.startGrid(0);
        logLsnr = LogListener.matches((String)"Node is already in Maintenance Mode").build();
        testLog.clearListeners();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", grid0ConsId));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        this.stopGrid(0);
        this.startGrid(0);
        this.stopGrid(1);
        this.startGrid(1);
        this.stopAllGrids();
        this.startGrids(2);
        logLsnr = LogListener.matches((String)"Scheduling completed successfully.").times(2).build();
        testLog.clearListeners();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", String.join((CharSequence)",", grid0ConsId, grid1ConsId)));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    public void testDefragmentationCancel() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        String grid0ConsId = this.grid(0).configuration().getConsistentId().toString();
        ListeningTestLogger testLog = new ListeningTestLogger();
        CommandHandler cmd = this.createCommandHandler(testLog);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", grid0ConsId));
        LogListener logLsnr = LogListener.matches((String)"Scheduled defragmentation task cancelled successfully.").atLeast(1).build();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", this.grid(0).localNode().attribute("org.apache.ignite.rest.tcp.port").toString(), "--defragmentation", "cancel"));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        testLog.clearListeners();
        logLsnr = LogListener.matches((String)"Scheduled defragmentation task is not found.").build();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", this.grid(1).localNode().attribute("org.apache.ignite.rest.tcp.port").toString(), "--defragmentation", "cancel"));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    public void testDefragmentationCancelInProgress() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ig.getOrCreateCache("default");
        for (int i = 0; i < 1024; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.forceCheckpoint((Ignite)ig);
        String grid0ConsId = ig.configuration().getConsistentId().toString();
        ListeningTestLogger testLog = new ListeningTestLogger();
        CommandHandler cmd = this.createCommandHandler(testLog);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", grid0ConsId));
        String port = this.grid(0).localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        this.stopGrid(0);
        blockCdl = new CountDownLatch(128);
        UnaryOperator cfgOp = cfg -> {
            DataStorageConfiguration dsCfg = cfg.getDataStorageConfiguration();
            FileIOFactory delegate = dsCfg.getFileIOFactory();
            dsCfg.setFileIOFactory((FileIOFactory & Serializable)(file, modes) -> {
                if (file.getName().contains("dfrg")) {
                    if (blockCdl.getCount() == 0L) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        blockCdl.countDown();
                    }
                }
                return delegate.create(file, modes);
            });
            return cfg;
        };
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            try {
                this.startGridWithCfg(0, cfgOp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        blockCdl.await();
        LogListener logLsnr = LogListener.matches((String)"Defragmentation cancelled successfully.").build();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", port, "--defragmentation", "cancel"));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        fut.get();
        testLog.clearListeners();
        logLsnr = LogListener.matches((String)"Defragmentation is already completed or has been cancelled previously.").build();
        testLog.registerListener(logLsnr);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", port, "--defragmentation", "cancel"));
        GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    public void testDefragmentationStatus() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        ig.getOrCreateCache("default1");
        IgniteCache cache = ig.getOrCreateCache("default2");
        ig.getOrCreateCache("default3");
        for (int i = 0; i < 1024; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.forceCheckpoint((Ignite)ig);
        String grid0ConsId = ig.configuration().getConsistentId().toString();
        ListeningTestLogger testLog = new ListeningTestLogger();
        CommandHandler cmd = this.createCommandHandler(testLog);
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--defragmentation", "schedule", "--nodes", grid0ConsId));
        String port = this.grid(0).localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        this.stopGrid(0);
        blockCdl = new CountDownLatch(128);
        waitCdl = new CountDownLatch(1);
        UnaryOperator cfgOp = cfg -> {
            DataStorageConfiguration dsCfg = cfg.getDataStorageConfiguration();
            FileIOFactory delegate = dsCfg.getFileIOFactory();
            dsCfg.setFileIOFactory((FileIOFactory & Serializable)(file, modes) -> {
                if (file.getName().contains("dfrg")) {
                    if (blockCdl.getCount() == 0L) {
                        try {
                            waitCdl.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        blockCdl.countDown();
                    }
                }
                return delegate.create(file, modes);
            });
            return cfg;
        };
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            try {
                this.startGridWithCfg(0, cfgOp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        blockCdl.await();
        List<LogListener> logLsnrs = Arrays.asList(LogListener.matches((String)"default1 - size before/after: 0MB/0MB").build(), LogListener.matches((String)"default2 - partitions processed/all:").build(), LogListener.matches((String)"Awaiting defragmentation: default3").build());
        for (LogListener logLsnr : logLsnrs) {
            testLog.registerListener(logLsnr);
        }
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", port, "--defragmentation", "status"));
        waitCdl.countDown();
        for (LogListener logLsnr : logLsnrs) {
            GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        }
        fut.get();
        ((GridCacheDatabaseSharedManager)this.grid(0).context().cache().context().database()).defragmentationManager().completionFuture().get();
        testLog.clearListeners();
        logLsnrs = Arrays.asList(LogListener.matches((String)"default1 - size before/after: 0MB/0MB").build(), LogListener.matches((Pattern)Pattern.compile("default2 - size before/after: (\\S+)/\\1")).build(), LogListener.matches((String)"default3 - size before/after: 0MB/0MB").build());
        for (LogListener logLsnr : logLsnrs) {
            testLog.registerListener(logLsnr);
        }
        GridCommandHandlerDefragmentationTest.assertEquals((int)0, (int)this.execute(cmd, "--port", port, "--defragmentation", "status"));
        for (LogListener logLsnr : logLsnrs) {
            GridCommandHandlerDefragmentationTest.assertTrue((boolean)logLsnr.check());
        }
    }

    private CommandHandler createCommandHandler(final ListeningTestLogger testLog) {
        Logger log = CommandHandler.initLogger(null);
        log.addHandler(new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                String msg = record.getMessage();
                testLog.info(msg);
                return msg + "\n";
            }
        }));
        return new CommandHandler(log);
    }
}

