/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CheckIndexesInlineSizeOnNodeJoinMultiJvmTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="1")
public class GridCommandHandlerCheckIndexesInlineSizeTest
extends GridCommandHandlerAbstractTest {
    private static final String INDEX_PROBLEM_FMT = "Full index name: PUBLIC#TEST_TABLE#%s nodes: [%s] inline size: 1, nodes: [%s] inline size: 2";
    private static final int NODES_CNT = 2;
    private static final int INITIAL_PAYLOAD_SIZE = 1;
    private int payloadSize;
    private static final UUID remoteNodeId = UUID.randomUUID();

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.isRemoteJvm(igniteInstanceName)) {
            cfg.setNodeId(remoteNodeId);
        }
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridCommandHandlerCheckIndexesInlineSizeTest.assertEquals((int)1, (int)Integer.parseInt(System.getProperty("IGNITE_MAX_INDEX_PAYLOAD_SIZE")));
        this.startGrids(2).cluster().active(true);
        for (Map.Entry entry : CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.getSqlStatements().entrySet()) {
            GridCommandHandlerCheckIndexesInlineSizeTest.executeSql(this.grid(0), (String)entry.getKey(), (Object[])entry.getValue());
        }
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    protected boolean isMultiJvm() {
        return true;
    }

    protected List<String> additionalRemoteJvmArgs() {
        List args = super.additionalRemoteJvmArgs();
        args.add("-DIGNITE_MAX_INDEX_PAYLOAD_SIZE=" + this.payloadSize);
        return args;
    }

    protected IgniteEx startGrid(int idx) throws Exception {
        this.payloadSize = this.getMaxPayloadSize(idx);
        return super.startGrid(idx);
    }

    @Test
    public void test() {
        this.injectTestSystemOut();
        GridCommandHandlerCheckIndexesInlineSizeTest.assertEquals((int)0, (int)this.execute("--cache", "check_index_inline_sizes"));
        GridCommandHandlerCheckIndexesInlineSizeTest.checkUtilityOutput(log, testOut.toString(), this.grid(0).localNode().id(), remoteNodeId);
    }

    private int getMaxPayloadSize(int nodeId) {
        return 1 + nodeId;
    }

    private static List<List<?>> executeSql(IgniteEx node, String stmt, Object ... args) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(stmt).setArgs(args), true).getAll();
    }

    public static void checkUtilityOutput(IgniteLogger log, String output, UUID localNodeId, UUID remoteNodeId) {
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Found 4 secondary indexes.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"3 index(es) have different effective inline size on nodes. It can lead to performance degradation in SQL queries.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"Index(es):");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)String.format(INDEX_PROBLEM_FMT, "L_IDX", localNodeId, remoteNodeId));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)String.format(INDEX_PROBLEM_FMT, "S1_IDX", localNodeId, remoteNodeId));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)String.format(INDEX_PROBLEM_FMT, "I_IDX", localNodeId, remoteNodeId));
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"  Check that value of property IGNITE_MAX_INDEX_PAYLOAD_SIZE are the same on all nodes.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"  Recreate indexes (execute DROP INDEX, CREATE INDEX commands) with different inline size.");
    }
}

