/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.check_indexes_inline_size.CheckIndexInlineSizesResult;
import org.apache.ignite.internal.commandline.cache.check_indexes_inline_size.CheckIndexInlineSizesTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.VisorTaskArgument;

public class CheckIndexInlineSizes
extends AbstractCommand<Void> {
    public static final String NOT_ALL_NODES_SUPPORT_FEATURE_WARN_MSG_FMT = "Indexes inline size have been checked on limited nodes. Skipped nodes: %s";
    public static final String INDEXES_INLINE_SIZE_ARE_THE_SAME = "All secondary indexes have the same effective inline size on all cluster nodes.";
    private static final Predicate<GridClientNode> SRV_NODES = node -> !node.isClient() && !node.isDaemon();

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Set serverNodes = client.compute().nodes().stream().filter(SRV_NODES).collect(Collectors.toSet());
            Set supportedServerNodes = serverNodes.stream().filter(n -> n.supports(IgniteFeatures.CHECK_INDEX_INLINE_SIZES)).collect(Collectors.toSet());
            Collection serverNodeIds = F.transform(serverNodes, GridClientNode::nodeId);
            Collection supportedServerNodeIds = F.transform(supportedServerNodes, GridClientNode::nodeId);
            CheckIndexInlineSizesResult res = (CheckIndexInlineSizesResult)client.compute().projection(supportedServerNodes).execute(CheckIndexInlineSizesTask.class.getName(), (Object)new VisorTaskArgument(supportedServerNodeIds, false));
            Set<UUID> unsupportedNodes = serverNodeIds.stream().filter(n -> !supportedServerNodeIds.contains(n)).collect(Collectors.toSet());
            this.analyzeResults(log, unsupportedNodes, res);
        }
        return null;
    }

    private void analyzeResults(Logger log, Set<UUID> unsupportedNodes, CheckIndexInlineSizesResult res) {
        if (!F.isEmpty(unsupportedNodes)) {
            log.info(String.format(NOT_ALL_NODES_SUPPORT_FEATURE_WARN_MSG_FMT, unsupportedNodes));
        }
        HashMap<String, Map> indexToSizeNode = new HashMap<String, Map>();
        for (Map.Entry nodeRes : res.inlineSizes().entrySet()) {
            for (Map.Entry index : ((Map)nodeRes.getValue()).entrySet()) {
                Map sizeToNodes = indexToSizeNode.computeIfAbsent((String)index.getKey(), x -> new HashMap());
                sizeToNodes.computeIfAbsent(index.getValue(), x -> new HashSet()).add(nodeRes.getKey());
            }
        }
        log.info("Found " + indexToSizeNode.size() + " secondary indexes.");
        Map<String, Map<Integer, Set<UUID>>> problems = indexToSizeNode.entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (F.isEmpty(problems)) {
            log.info(INDEXES_INLINE_SIZE_ARE_THE_SAME);
        } else {
            this.printProblemsAndShowRecommendations(problems, log);
        }
    }

    private void printProblemsAndShowRecommendations(Map<String, Map<Integer, Set<UUID>>> problems, Logger log) {
        log.info(problems.size() + " index(es) have different effective inline size on nodes. It can lead to performance degradation in SQL queries.");
        log.info("Index(es):");
        for (Map.Entry<String, Map<Integer, Set<UUID>>> entry : problems.entrySet()) {
            SB sb = new SB();
            sb.a("Full index name: ").a(entry.getKey());
            for (Integer size : entry.getValue().keySet()) {
                sb.a(" nodes: ").a(entry.getValue().get(size)).a(" inline size: ").a((Object)size).a(",");
            }
            sb.setLength(sb.length() - 1);
            log.info("  " + sb);
        }
        log.info("");
        log.info("Recommendations:");
        log.info("  Check that value of property IGNITE_MAX_INDEX_PAYLOAD_SIZE are the same on all nodes.");
        log.info("  Recreate indexes (execute DROP INDEX, CREATE INDEX commands) with different inline size.");
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public void printUsage(Logger logger) {
        CacheCommands.usageCache(logger, CacheSubcommands.CHECK_INDEX_INLINE_SIZES, "Checks that secondary indexes inline size are same on the cluster nodes.", null, new String[0]);
    }

    @Override
    public String name() {
        return CacheSubcommands.CHECK_INDEX_INLINE_SIZES.text().toUpperCase();
    }
}

