/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.apache.ignite.util.KillCommandsTests;
import org.junit.Test;

public class KillCommandsControlShTest
extends GridCommandHandlerClusterByClassAbstractTest {
    private static List<IgniteEx> srvs;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        srvs = new ArrayList<IgniteEx>();
        for (int i = 0; i < 2; ++i) {
            srvs.add(this.grid(i));
        }
        IgniteCache cache = client.getOrCreateCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        for (int i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.awaitPartitionMapExchange();
    }

    @Override
    protected void afterTest() throws Exception {
    }

    @Test
    public void testCancelSQLQuery() {
        KillCommandsTests.doTestCancelSQLQuery((IgniteEx)client, qryId -> {
            int res = this.execute("--kill", "sql", (String)qryId);
            KillCommandsControlShTest.assertEquals((int)0, (int)res);
        });
    }

    @Test
    public void testCancelContinuousQuery() throws Exception {
        KillCommandsTests.doTestCancelContinuousQuery((IgniteEx)client, srvs, (nodeId, routineId) -> {
            int res = this.execute("--kill", "continuous", nodeId.toString(), routineId.toString());
            KillCommandsControlShTest.assertEquals((int)0, (int)res);
        });
    }

    @Test
    public void testCancelScanQuery() {
        KillCommandsTests.doTestScanQueryCancel((IgniteEx)client, srvs, args -> {
            int res = this.execute("--kill", "scan", ((UUID)args.get1()).toString(), (String)args.get2(), ((Long)args.get3()).toString());
            KillCommandsControlShTest.assertEquals((int)0, (int)res);
        });
    }

    @Test
    public void testCancelClientConnection() {
        KillCommandsTests.doTestCancelClientConnection(srvs, (nodeId, connId) -> {
            ArrayList<String> params = new ArrayList<String>(Arrays.asList("--kill", "client", connId == null ? "ALL" : Long.toString(connId)));
            if (nodeId != null) {
                params.addAll(Arrays.asList("--node-id", nodeId.toString()));
            }
            KillCommandsControlShTest.assertEquals((int)0, (int)this.execute(params));
        });
    }

    @Test
    public void testCancelUnknownSQLQuery() {
        int res = this.execute("--kill", "sql", srvs.get(0).localNode().id().toString() + "_42");
        KillCommandsControlShTest.assertEquals((int)0, (int)res);
    }

    @Test
    public void testCancelUnknownContinuousQuery() {
        int res = this.execute("--kill", "continuous", srvs.get(0).localNode().id().toString(), UUID.randomUUID().toString());
        KillCommandsControlShTest.assertEquals((int)0, (int)res);
    }

    @Test
    public void testCancelUnknownScanQuery() {
        int res = this.execute("--kill", "scan", srvs.get(0).localNode().id().toString(), "unknown", "1");
        KillCommandsControlShTest.assertEquals((int)0, (int)res);
    }

    @Test
    public void testCancelClientConnectionWrongParams() {
        KillCommandsControlShTest.assertEquals((int)1, (int)this.execute("--kill", "client"));
        KillCommandsControlShTest.assertEquals((int)1, (int)this.execute("--kill", "client", "not_a_number"));
        KillCommandsControlShTest.assertEquals((int)1, (int)this.execute("--kill", "client", "1", "--node-id"));
        KillCommandsControlShTest.assertEquals((int)1, (int)this.execute("--kill", "client", "1", "--node-id", "not_an_uuid"));
        KillCommandsControlShTest.assertEquals((String)"Unknown connection id", (int)4, (int)this.execute("--kill", "client", "123"));
    }
}

