/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTaskResult;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.junit.Test;

public class GridCommandHandlerTracingConfigurationTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    private static final Map<TracingConfigurationCoordinates, TracingConfigurationParameters> DFLT_CONFIG_MAP = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>();
    private static final TracingConfigurationCoordinates TX_SCOPE_SPECIFIC_COORDINATES = new TracingConfigurationCoordinates.Builder(Scope.TX).build();
    private static final TracingConfigurationCoordinates EXCHANGE_SCOPE_SPECIFIC_COORDINATES = new TracingConfigurationCoordinates.Builder(Scope.EXCHANGE).build();
    private static final TracingConfigurationParameters SOME_SCOPE_SPECIFIC_PARAMETERS = new TracingConfigurationParameters.Builder().withSamplingRate(0.75).withIncludedScopes(Collections.singleton(Scope.COMMUNICATION)).build();
    private static final TracingConfigurationCoordinates TX_LABEL_SPECIFIC_COORDINATES = new TracingConfigurationCoordinates.Builder(Scope.TX).withLabel("label").build();
    private static final TracingConfigurationParameters SOME_LABEL_SPECIFIC_PARAMETERS = new TracingConfigurationParameters.Builder().withSamplingRate(0.111).withIncludedScopes(Collections.singleton(Scope.EXCHANGE)).build();
    protected IgniteEx ignite;
    private static CommandHandler hnd;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.ignite = this.startGrids(2);
        hnd = new CommandHandler();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.grid(0).tracingConfiguration().resetAll(null);
        this.grid(0).tracingConfiguration().set(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        this.grid(0).tracingConfiguration().set(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        this.grid(0).tracingConfiguration().set(EXCHANGE_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
    }

    @Override
    protected void afterTest() throws Exception {
    }

    @Test
    public void testTracingConfigurationHelpCommand() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "help"));
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "--help"));
    }

    @Test
    public void testTracingConfigurationWithoutSubCommandsReturnsTracingConfigurationForAllScopes() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration"));
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> expTracingCfg = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(DFLT_CONFIG_MAP);
        expTracingCfg.put(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        expTracingCfg.put(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        expTracingCfg.put(EXCHANGE_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expTracingCfg.forEach((arg_0, arg_1) -> ((VisorTracingConfigurationTaskResult)expRes).add(arg_0, arg_1));
        this.verifyResult(expRes);
    }

    @Test
    public void testGetAllWithScopeReturnsOnlySpecifiedScopeSpecificConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "get_all", "--scope", "TX"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        expRes.add(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testGetAllWithoutScopeReturnsTracingConfigurationsForAllScopes() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "get_all"));
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> expTracingCfg = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(DFLT_CONFIG_MAP);
        expTracingCfg.put(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        expTracingCfg.put(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        expTracingCfg.put(EXCHANGE_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expTracingCfg.forEach((arg_0, arg_1) -> ((VisorTracingConfigurationTaskResult)expRes).add(arg_0, arg_1));
        this.verifyResult(expRes);
    }

    @Test
    public void testGetWithScopeReturnsScopeSpecificConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "get", "--scope", "TX"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testGetWithScopeAndLabelReturnsLabelSpecificConfigurationIfSuchOneExists() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "get", "--scope", "TX", "--label", "label"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testResetAllWithScopeResetsScopeBasedConfigurationAndReturnsIt() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "reset_all", "--scope", "TX"));
        GridCommandHandlerTracingConfigurationTest.assertEquals(Collections.singletonMap(TX_SCOPE_SPECIFIC_COORDINATES, TracingConfigurationManager.DEFAULT_TX_CONFIGURATION), (Object)this.grid(0).tracingConfiguration().getAll(Scope.TX));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, TracingConfigurationManager.DEFAULT_TX_CONFIGURATION);
        this.verifyResult(expRes);
    }

    @Test
    public void testResetAllWithoutScopeResetsTracingConfigurationForAllScopesAndReturnsIt() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "reset_all"));
        GridCommandHandlerTracingConfigurationTest.assertEquals(Collections.singletonMap(TX_SCOPE_SPECIFIC_COORDINATES, TracingConfigurationManager.DEFAULT_TX_CONFIGURATION), (Object)this.grid(0).tracingConfiguration().getAll(Scope.TX));
        GridCommandHandlerTracingConfigurationTest.assertEquals(Collections.singletonMap(EXCHANGE_SCOPE_SPECIFIC_COORDINATES, TracingConfigurationManager.DEFAULT_EXCHANGE_CONFIGURATION), (Object)this.grid(0).tracingConfiguration().getAll(Scope.EXCHANGE));
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> expTracingCfg = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(DFLT_CONFIG_MAP);
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expTracingCfg.forEach((arg_0, arg_1) -> ((VisorTracingConfigurationTaskResult)expRes).add(arg_0, arg_1));
        this.verifyResult(expRes);
    }

    @Test
    public void testResetWithScopeResetsScopeSpecificConfigurationAndReturnsScopeBasedConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "reset", "--scope", "TX"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, TracingConfigurationManager.DEFAULT_EXCHANGE_CONFIGURATION);
        expRes.add(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testResetWithScopeAndLabelResetsLabelSpecificConfigurationAndReturnsScopeBasedConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "reset", "--scope", "TX", "--label", "label"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testSetWithScopeSetsScopeSpecificConfigurationAndReturnsScopeBasedConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "set", "--scope", "TX", "--sampling-rate", "0.123", "--included-scopes", "COMMUNICATION,EXCHANGE"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, new TracingConfigurationParameters.Builder().withSamplingRate(0.123).withIncludedScopes(new HashSet<Scope>(Arrays.asList(Scope.COMMUNICATION, Scope.EXCHANGE))).build());
        expRes.add(TX_LABEL_SPECIFIC_COORDINATES, SOME_LABEL_SPECIFIC_PARAMETERS);
        this.verifyResult(expRes);
    }

    @Test
    public void testSetWithScopeAndLabelSetsLabelSpecificConfigurationAndReturnsScopeBasedConfiguration() {
        GridCommandHandlerTracingConfigurationTest.assertEquals((int)0, (int)this.execute(hnd, "--tracing-configuration", "set", "--scope", "TX", "--label", "label", "--sampling-rate", "0.123", "--included-scopes", "COMMUNICATION,EXCHANGE"));
        VisorTracingConfigurationTaskResult expRes = new VisorTracingConfigurationTaskResult();
        expRes.add(TX_SCOPE_SPECIFIC_COORDINATES, SOME_SCOPE_SPECIFIC_PARAMETERS);
        expRes.add(TX_LABEL_SPECIFIC_COORDINATES, new TracingConfigurationParameters.Builder().withSamplingRate(0.123).withIncludedScopes(new HashSet<Scope>(Arrays.asList(Scope.COMMUNICATION, Scope.EXCHANGE))).build());
        this.verifyResult(expRes);
    }

    private void verifyResult(VisorTracingConfigurationTaskResult expRes) {
        VisorTracingConfigurationTaskResult gotRes = (VisorTracingConfigurationTaskResult)hnd.getLastOperationResult();
        GridCommandHandlerTracingConfigurationTest.assertNotNull((Object)gotRes);
        GridCommandHandlerTracingConfigurationTest.assertNotNull((Object)gotRes.tracingConfigurations());
        GridCommandHandlerTracingConfigurationTest.assertTrue((expRes.tracingConfigurations().containsAll(gotRes.tracingConfigurations()) && gotRes.tracingConfigurations().containsAll(expRes.tracingConfigurations()) ? 1 : 0) != 0);
    }

    static {
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.TX).build(), TracingConfigurationManager.DEFAULT_TX_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.COMMUNICATION).build(), TracingConfigurationManager.DEFAULT_COMMUNICATION_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.EXCHANGE).build(), TracingConfigurationManager.DEFAULT_EXCHANGE_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), TracingConfigurationManager.DEFAULT_DISCOVERY_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.CACHE_API_READ).build(), TracingConfigurationManager.DEFAULT_CACHE_API_READ_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.CACHE_API_WRITE).build(), TracingConfigurationManager.DEFAULT_CACHE_API_WRITE_CONFIGURATION);
        DFLT_CONFIG_MAP.put(new TracingConfigurationCoordinates.Builder(Scope.SQL).build(), TracingConfigurationManager.DEFAULT_SQL_CONFIGURATION);
    }
}

