/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.TestStorageUtils;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.internal.GridJobExecuteResponse;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.util.GridConcurrentHashSet;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.cache.argument.FindAndDeleteGarbageArg;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.ClusterStateTestUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.db.IgniteCacheGroupsWithRestartsTest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.warmup.BlockedWarmUpConfiguration;
import org.apache.ignite.internal.processors.cache.warmup.BlockedWarmUpStrategy;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpTestPluginProvider;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskResult;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionTimeoutException;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class GridCommandHandlerTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    protected static final String PARTITIONED_CACHE_NAME = "part_cache";
    protected static final String REPLICATED_CACHE_NAME = "repl_cache";
    protected static File defaultDiagnosticDir;
    protected static File customDiagnosticDir;
    private String cfgLocalHost;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.initDiagnosticDir();
        this.cleanPersistenceDir();
        this.cfgLocalHost = null;
    }

    @Override
    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        this.cleanDiagnosticDir();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setGridLogger((IgniteLogger)new ListeningTestLogger(log));
        if (this.cfgLocalHost != null) {
            cfg.setLocalHost(this.cfgLocalHost);
        }
        return cfg;
    }

    protected void initDiagnosticDir() throws IgniteCheckedException {
        defaultDiagnosticDir = new File(U.defaultWorkDirectory() + File.separatorChar + "diagnostic" + File.separatorChar);
        customDiagnosticDir = new File(U.defaultWorkDirectory() + File.separatorChar + "diagnostic_test_dir" + File.separatorChar);
    }

    protected void cleanDiagnosticDir() {
        U.delete((File)defaultDiagnosticDir);
        U.delete((File)customDiagnosticDir);
    }

    @Test
    public void testActivate() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--activate"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Command deprecated. Use --set-state instead.");
    }

    @Test
    public void testClientsLeakage() throws Exception {
        this.startGrids(1);
        Map clnts = (Map)U.field(GridClientFactory.class, (String)"openClients");
        HashMap clntsBefore = new HashMap(clnts);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "ACTIVE"));
        HashMap clntsAfter1 = new HashMap(clnts);
        GridCommandHandlerTest.assertTrue((String)("Still opened clients: " + new ArrayList(clnts.values())), (boolean)clntsBefore.equals(clntsAfter1));
        this.stopAllGrids();
        GridCommandHandlerTest.assertEquals((int)2, (int)this.execute("--set-state", "ACTIVE"));
        HashMap clntsAfter2 = new HashMap(clnts);
        GridCommandHandlerTest.assertTrue((String)("Still opened clients: " + new ArrayList(clnts.values())), (boolean)clntsBefore.equals(clntsAfter2));
    }

    private CacheConfiguration cacheConfiguration(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration(cacheName).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1);
        return ccfg;
    }

    private File startGridAndPutNodeToMaintenance(CacheConfiguration[] cachesToStart, @Nullable Function<String, Boolean> cacheToCorrupt) throws Exception {
        File[] cpMarkers;
        assert (cachesToStart != null && cachesToStart.length > 0);
        IgniteEx ig0 = this.startGrid(0);
        IgniteEx ig1 = this.startGrid(1);
        String ig1Folder = ig1.context().pdsFolderResolver().resolveFolders().folderName();
        File dbDir = U.resolveWorkDirectory((String)ig1.configuration().getWorkDirectory(), (String)"db", (boolean)false);
        File ig1LfsDir = new File(dbDir, ig1Folder);
        ig0.cluster().baselineAutoAdjustEnabled(false);
        ig0.cluster().state(ClusterState.ACTIVE);
        IgniteCache dfltCache = ig0.getOrCreateCache(cachesToStart[0]);
        if (cachesToStart.length > 1) {
            for (int i = 1; i < cachesToStart.length; ++i) {
                ig0.getOrCreateCache(cachesToStart[i]);
            }
        }
        for (int k = 0; k < 1000; ++k) {
            dfltCache.put((Object)k, (Object)k);
        }
        GridCacheDatabaseSharedManager dbMrg0 = (GridCacheDatabaseSharedManager)ig0.context().cache().context().database();
        GridCacheDatabaseSharedManager dbMrg1 = (GridCacheDatabaseSharedManager)ig1.context().cache().context().database();
        dbMrg0.forceCheckpoint("cp").futureFor(CheckpointState.FINISHED).get();
        dbMrg1.forceCheckpoint("cp").futureFor(CheckpointState.FINISHED).get();
        Arrays.stream(cachesToStart).map(ccfg -> ccfg.getName()).filter(name -> (Boolean)cacheToCorrupt.apply((String)name)).forEach(name -> ig0.cluster().disableWal(name));
        for (int k = 1000; k < 2000; ++k) {
            dfltCache.put((Object)k, (Object)k);
        }
        this.stopGrid(1);
        for (File cpMark : cpMarkers = new File(ig1LfsDir, "cp").listFiles()) {
            if (!cpMark.getName().contains("-END")) continue;
            cpMark.delete();
        }
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.startGrid(1), Exception.class, null);
        return ig1LfsDir;
    }

    @Test
    public void testPersistenceCleanSpecifiedCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        String cacheName2 = "default2";
        String cacheName3 = "default3";
        String nonExistingCacheName = "default4";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1), this.cacheConfiguration(cacheName2), this.cacheConfiguration(cacheName3)}, s -> !s.equals(cacheName3));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--persistence", "clean", "caches", nonExistingCacheName, "--host", "localhost", "--port", port));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "clean", "caches", cacheName0 + "," + cacheName1, "--host", "localhost", "--port", port));
        boolean cleanedEmpty = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(f -> f.getName().contains(cacheName0) || f.getName().contains(cacheName1)).map(f -> f.listFiles().length == 1).reduce(true, (t, u) -> t != false && u != false);
        GridCommandHandlerTest.assertTrue((boolean)cleanedEmpty);
        boolean nonCleanedNonEmpty = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(f -> f.getName().contains(cacheName2) || f.getName().contains(cacheName3)).map(f -> f.listFiles().length > 1).reduce(true, (t, u) -> t != false && u != false);
        GridCommandHandlerTest.assertTrue((boolean)nonCleanedNonEmpty);
        this.stopGrid(1);
        ig1 = this.startGrid(1);
        GridCommandHandlerTest.assertTrue((boolean)ig1.context().maintenanceRegistry().isMaintenanceMode());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "clean", "caches", cacheName2, "--host", "localhost", "--port", port));
        this.stopGrid(1);
        ig1 = this.startGrid(1);
        GridCommandHandlerTest.assertFalse((boolean)ig1.context().maintenanceRegistry().isMaintenanceMode());
    }

    @Test
    public void testPersistenceCleanCorruptedCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        String cacheName2 = "default2";
        String cacheName3 = "default3";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1), this.cacheConfiguration(cacheName2), this.cacheConfiguration(cacheName3)}, s -> !s.equals(cacheName3));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "clean", "corrupted", "--host", "localhost", "--port", port));
        boolean cleanedEmpty = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(f -> f.getName().contains(cacheName0) || f.getName().contains(cacheName1) || f.getName().contains(cacheName2)).map(f -> f.listFiles().length == 1).reduce(true, (t, u) -> t != false && u != false);
        GridCommandHandlerTest.assertTrue((boolean)cleanedEmpty);
        this.stopGrid(1);
        ig1 = this.startGrid(1);
        GridCommandHandlerTest.assertFalse((boolean)ig1.context().maintenanceRegistry().isMaintenanceMode());
    }

    @Test
    public void testPersistenceCleanAllCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1)}, s -> s.equals(cacheName0));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "clean", "all", "--host", "localhost", "--port", port));
        boolean allEmpty = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("cache-")).map(f -> f.listFiles().length == 1).reduce(true, (t, u) -> t != false && u != false);
        GridCommandHandlerTest.assertTrue((boolean)allEmpty);
        this.stopGrid(1);
        ig1 = this.startGrid(1);
        GridCommandHandlerTest.assertFalse((boolean)ig1.context().maintenanceRegistry().isMaintenanceMode());
    }

    @Test
    public void testPersistenceBackupAllCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1)}, s -> s.equals(cacheName0));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "backup", "all", "--host", "localhost", "--port", port));
        Set backedUpCacheDirs = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("backup_")).map(f -> f.getName().substring("backup_".length())).collect(Collectors.toCollection(TreeSet::new));
        Set allCacheDirs = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("cache-")).map(File::getName).collect(Collectors.toCollection(TreeSet::new));
        GridCommandHandlerTest.assertEqualsCollections((Collection)backedUpCacheDirs, (Collection)allCacheDirs);
        this.checkCacheAndBackupDirsContent(mntcNodeWorkDir);
    }

    @Test
    public void testPersistenceBackupCorruptedCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1)}, s -> s.equals(cacheName0));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "backup", "corrupted", "--host", "localhost", "--port", port));
        long backedUpCachesCnt = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("backup_")).filter(f -> f.getName().contains(cacheName0)).count();
        GridCommandHandlerTest.assertEquals((long)1L, (long)backedUpCachesCnt);
        this.checkCacheAndBackupDirsContent(mntcNodeWorkDir);
    }

    @Test
    public void testPersistenceBackupSpecifiedCachesCommand() throws Exception {
        String cacheName0 = "default0";
        String cacheName1 = "default1";
        String cacheName2 = "default2";
        String nonExistingCacheName = "nonExistingCache";
        File mntcNodeWorkDir = this.startGridAndPutNodeToMaintenance(new CacheConfiguration[]{this.cacheConfiguration(cacheName0), this.cacheConfiguration(cacheName1), this.cacheConfiguration(cacheName2)}, s -> s.equals(cacheName0) || s.equals(cacheName2));
        IgniteEx ig1 = this.startGrid(1);
        String port = ig1.localNode().attribute("org.apache.ignite.rest.tcp.port").toString();
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--persistence", "backup", "caches", nonExistingCacheName, "--host", "localhost", "--port", port));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--persistence", "backup", "caches", cacheName0 + "," + cacheName2, "--host", "localhost", "--port", port));
        long backedUpCachesCnt = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("backup_")).count();
        GridCommandHandlerTest.assertEquals((long)2L, (long)backedUpCachesCnt);
        this.checkCacheAndBackupDirsContent(mntcNodeWorkDir);
    }

    private void checkCacheAndBackupDirsContent(File mntcNodeWorkDir) {
        List backupDirs = Arrays.stream(mntcNodeWorkDir.listFiles()).filter(File::isDirectory).filter(f -> f.getName().startsWith("backup_")).collect(Collectors.toList());
        Path mntcNodeWorkDirPath = mntcNodeWorkDir.toPath();
        for (File bDir : backupDirs) {
            File origCacheDir = mntcNodeWorkDirPath.resolve(bDir.getName().substring("backup_".length())).toFile();
            GridCommandHandlerTest.assertTrue((boolean)origCacheDir.isDirectory());
            GridCommandHandlerTest.assertEquals((int)origCacheDir.listFiles().length, (int)bDir.listFiles().length);
        }
    }

    @Test
    public void testReadOnlyEnableDisable() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "ACTIVE_READ_ONLY"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE_READ_ONLY, (Object)ignite.cluster().state());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Cluster state changed to ACTIVE_READ_ONLY");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "ACTIVE"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Cluster state changed to ACTIVE");
    }

    @Test
    public void testClusterChangeTag() throws Exception {
        String newTag = "new_tag";
        IgniteEx cl = this.startGrid(0);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--change-tag", ""));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--change-tag", "new_tag"));
        boolean tagUpdated = GridTestUtils.waitForCondition(() -> "new_tag".equals(cl.cluster().tag()), (long)10000L);
        GridCommandHandlerTest.assertTrue((String)"Tag has not been updated in 10 seconds", (boolean)tagUpdated);
    }

    @Test
    public void testClusterChangeId() throws Exception {
        String newId = "11111111-1111-1111-1111-111111111111";
        IgniteEx cl = this.startGrid(0);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--change-id", ""));
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--change-id", "123123"));
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--change-id", "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--verbose", "--change-id", "11111111-1111-1111-1111-111111111111"));
        boolean idUpdated = GridTestUtils.waitForCondition(() -> UUID.fromString("11111111-1111-1111-1111-111111111111").equals(cl.cluster().id()), (long)10000L);
        GridCommandHandlerTest.assertTrue((String)"ID has not been updated in 10 seconds", (boolean)idUpdated);
    }

    @Test
    public void testDeactivate() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--deactivate"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Command deprecated. Use --set-state instead.");
    }

    @Test
    @WithSystemProperty(key="IGNITE_CLUSTER_NAME", value="TEST_CLUSTER_NAME")
    public void testDeactivateWithCheckClusterNameInConfirmationBySystemProperty() throws Exception {
        IgniteEx igniteEx = this.startGrid(0);
        GridCommandHandlerTest.assertFalse((boolean)igniteEx.cluster().active());
        this.deactivateActiveOrNotClusterWithCheckClusterNameInConfirmation(igniteEx, "TEST_CLUSTER_NAME");
    }

    @Test
    public void testDeactivateWithCheckClusterNameInConfirmationByDefault() throws Exception {
        IgniteEx igniteEx = this.startGrid(0);
        GridCommandHandlerTest.assertFalse((boolean)igniteEx.cluster().active());
        this.deactivateActiveOrNotClusterWithCheckClusterNameInConfirmation(igniteEx, igniteEx.context().cache().utilityCache().context().dynamicDeploymentId().toString());
    }

    private void deactivateActiveOrNotClusterWithCheckClusterNameInConfirmation(IgniteEx igniteEx, String clusterName) {
        this.deactivateWithCheckClusterNameInConfirmation(igniteEx, clusterName);
        igniteEx.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertTrue((boolean)igniteEx.cluster().active());
        this.deactivateWithCheckClusterNameInConfirmation(igniteEx, clusterName);
    }

    private void deactivateWithCheckClusterNameInConfirmation(IgniteEx igniteEx, String clusterName) {
        this.autoConfirmation = false;
        this.injectTestSystemOut();
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(CommandList.DEACTIVATE.text()));
        GridCommandHandlerTest.assertFalse((boolean)igniteEx.cluster().active());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("Warning: the command will deactivate a cluster \"" + clusterName + "\"."));
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_CLUSTER_ID_AND_TAG_FEATURE", value="true"), @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")})
    public void testState() throws Exception {
        String newTag = "new_tag";
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--state"));
        String out = testOut.toString();
        UUID clId = ignite.cluster().id();
        String clTag = ignite.cluster().tag();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Cluster is inactive");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cluster  ID: " + clId));
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cluster tag: " + clTag));
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--state"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Cluster is active");
        boolean tagUpdated = GridTestUtils.waitForCondition(() -> {
            ignite.cluster().tag("new_tag");
            return true;
        }, (long)10000L);
        GridCommandHandlerTest.assertTrue((String)"Tag has not been updated in 10 seconds.", (boolean)tagUpdated);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--state"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Cluster tag: new_tag");
        ignite.cluster().state(ClusterState.ACTIVE_READ_ONLY);
        this.awaitPartitionMapExchange();
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE_READ_ONLY, (Object)ignite.cluster().state());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--state"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Cluster is active (read-only)");
    }

    @Test
    @WithSystemProperty(key="IGNITE_CLUSTER_ID_AND_TAG_FEATURE", value="false")
    public void testState1() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--state"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Cluster is inactive");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"Cluster  ID: ");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"Cluster tag: ");
    }

    @Test
    public void testSetState() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        ignite.createCache(ClusterStateTestUtils.partitionedCache((String)PARTITIONED_CACHE_NAME));
        ignite.createCache(ClusterStateTestUtils.replicatedCache((String)REPLICATED_CACHE_NAME));
        ignite.cluster().state(ClusterState.INACTIVE);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.setState((Ignite)ignite, ClusterState.INACTIVE, "INACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE_READ_ONLY, "ACTIVE_READ_ONLY", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE_READ_ONLY, "ACTIVE_READ_ONLY", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE, "ACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE, "ACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.INACTIVE, "INACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE, "ACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.ACTIVE_READ_ONLY, "ACTIVE_READ_ONLY", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
        this.setState((Ignite)ignite, ClusterState.INACTIVE, "INACTIVE", PARTITIONED_CACHE_NAME, REPLICATED_CACHE_NAME);
    }

    private void setState(Ignite ignite, ClusterState state, String strState, String ... cacheNames) throws Exception {
        log.info(ignite.cluster().state() + " -> " + state);
        CountDownLatch latch = this.getNewStateLatch(ignite.cluster().state(), state);
        if (state == ClusterState.INACTIVE) {
            GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", strState, "--force"));
        } else {
            GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", strState));
        }
        latch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        GridCommandHandlerTest.assertEquals((Object)state, (Object)ignite.cluster().state());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("Cluster state changed to " + strState));
        List nodes = IntStream.range(0, 2).mapToObj(arg_0 -> ((GridCommandHandlerTest)this).grid(arg_0)).collect(Collectors.toList());
        ClusterStateTestUtils.putSomeDataAndCheck((IgniteLogger)log, nodes, (String[])cacheNames);
        if (state == ClusterState.ACTIVE) {
            for (String cacheName : cacheNames) {
                this.grid(0).cache(cacheName).clear();
            }
        }
    }

    private CountDownLatch getNewStateLatch(ClusterState oldState, ClusterState newState) {
        if (oldState != newState) {
            CountDownLatch latch = new CountDownLatch(G.allGrids().size());
            for (Ignite grid : G.allGrids()) {
                ((IgniteEx)grid).context().discovery().setCustomEventListener(ChangeGlobalStateFinishMessage.class, (topVer, snd, msg) -> latch.countDown());
            }
            return latch;
        }
        return new CountDownLatch(0);
    }

    @Test
    public void testBaselineCollect() throws Exception {
        IgniteEx ignite = this.startGrid(this.optimize(this.getConfiguration(this.getTestIgniteInstanceName(0))).setLocalHost("0.0.0.0"));
        Field addresses = ignite.cluster().node().getClass().getDeclaredField("addrs");
        addresses.setAccessible(true);
        addresses.set(ignite.cluster().node(), Arrays.asList("127.0.0.1", "0:0:0:0:0:0:0:1", "10.19.112.175", "188.166.164.247"));
        Field hostNames = ignite.cluster().node().getClass().getDeclaredField("hostNames");
        hostNames.setAccessible(true);
        hostNames.set(ignite.cluster().node(), Arrays.asList("10.19.112.175.hostname"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline"));
        List<String> nodesInfo = this.findBaselineNodesInfo();
        GridCommandHandlerTest.assertEquals((int)1, (int)nodesInfo.size());
        GridTestUtils.assertContains((IgniteLogger)log, (String)nodesInfo.get(0), (String)"Address=188.166.164.247.hostname/188.166.164.247, ");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--verbose", "--baseline"));
        nodesInfo = this.findBaselineNodesInfo();
        GridCommandHandlerTest.assertEquals((int)1, (int)nodesInfo.size());
        GridTestUtils.assertContains((IgniteLogger)log, (String)nodesInfo.get(0), (String)"Addresses=188.166.164.247.hostname/188.166.164.247,10.19.112.175.hostname/10.19.112.175");
        addresses.set(ignite.cluster().node(), Collections.emptyList());
        hostNames.set(ignite.cluster().node(), Collections.emptyList());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--verbose", "--baseline"));
        nodesInfo = this.findBaselineNodesInfo();
        GridCommandHandlerTest.assertEquals((int)1, (int)nodesInfo.size());
        GridTestUtils.assertContains((IgniteLogger)log, (String)nodesInfo.get(0), (String)("ConsistentId=" + this.grid(0).cluster().localNode().consistentId() + ", State="));
        GridCommandHandlerTest.assertEquals((int)1, (int)ignite.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testShutdownPolicy() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        ShutdownPolicy policy = ignite.cluster().shutdownPolicy();
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--shutdown-policy"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cluster shutdown policy is " + policy));
    }

    @Test
    public void testShutdownPolicyChange() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        ShutdownPolicy policyToChange = null;
        for (ShutdownPolicy policy : ShutdownPolicy.values()) {
            if (policy == ignite.cluster().shutdownPolicy()) continue;
            policyToChange = policy;
        }
        GridCommandHandlerTest.assertNotNull(policyToChange);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--shutdown-policy", policyToChange.name()));
        GridCommandHandlerTest.assertSame((Object)policyToChange, (Object)ignite.cluster().shutdownPolicy());
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cluster shutdown policy is " + policyToChange));
    }

    @Test
    public void testBaselineCollectWhenClientNodeHasSmallestOrder() throws Exception {
        this.startGrid(0);
        IgniteEx ignite = this.startClientGrid(1);
        this.startGrid(2);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        this.stopGrid(0);
        this.startGrid(0);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline"));
        GridCommandHandlerTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testBaselineCollectCrd() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "--port", "11212"));
        String crdStr = this.findCrdInfo();
        GridCommandHandlerTest.assertEquals((String)("(Coordinator: ConsistentId=" + this.grid(0).cluster().localNode().consistentId() + ", Address=127.0.0.1.hostname/127.0.0.1, Order=1)"), (String)crdStr);
        this.stopGrid(0);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "--port", "11212"));
        crdStr = this.findCrdInfo();
        GridCommandHandlerTest.assertEquals((String)("(Coordinator: ConsistentId=" + this.grid(1).cluster().localNode().consistentId() + ", Address=127.0.0.1.hostname/127.0.0.1, Order=2)"), (String)crdStr);
        this.startGrid(0);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "--port", "11212"));
        crdStr = this.findCrdInfo();
        GridCommandHandlerTest.assertEquals((String)("(Coordinator: ConsistentId=" + this.grid(1).cluster().localNode().consistentId() + ", Address=127.0.0.1.hostname/127.0.0.1, Order=2)"), (String)crdStr);
        this.stopGrid(1);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "--port", "11211"));
        crdStr = this.findCrdInfo();
        GridCommandHandlerTest.assertEquals((String)("(Coordinator: ConsistentId=" + this.grid(0).cluster().localNode().consistentId() + ", Address=127.0.0.1.hostname/127.0.0.1, Order=4)"), (String)crdStr);
    }

    private String findCrdInfo() {
        String outStr = testOut.toString();
        int i = outStr.indexOf("(Coordinator: ConsistentId=");
        GridCommandHandlerTest.assertTrue((i != -1 ? 1 : 0) != 0);
        String crdStr = outStr.substring(i).trim();
        return crdStr.substring(0, crdStr.indexOf(10)).trim();
    }

    private List<String> findBaselineNodesInfo() {
        String outStr = testOut.toString();
        int i = outStr.indexOf("Baseline nodes:");
        GridCommandHandlerTest.assertTrue((String)"Baseline nodes information is not found", (i != -1 ? 1 : 0) != 0);
        int j = outStr.indexOf("\n", i) + 1;
        int beginOfNodeDesc = -1;
        ArrayList<String> nodesInfo = new ArrayList<String>();
        while ((beginOfNodeDesc = outStr.indexOf("ConsistentId=", j)) != -1) {
            j = outStr.indexOf("\n", beginOfNodeDesc);
            nodesInfo.add(outStr.substring(beginOfNodeDesc, j).trim());
        }
        return nodesInfo;
    }

    private String consistentIds(Ignite ... ignites) {
        StringBuilder res = new StringBuilder();
        for (Ignite ignite : ignites) {
            String consistentId = ignite.cluster().localNode().consistentId().toString();
            if (res.length() != 0) {
                res.append(", ");
            }
            res.append(consistentId);
        }
        return res.toString();
    }

    @Test
    public void testBaselineAdd() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "add"));
        GridCommandHandlerTest.assertEquals((int)5, (int)this.execute("--baseline", "add", "non-existent-id"));
        IgniteEx other = this.startGrid(2);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "add", this.consistentIds(new Ignite[]{other})));
        GridCommandHandlerTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testConnectivityCommandWithoutFailedNodes() throws Exception {
        IgniteEx ignite = this.startGrids(5);
        GridCommandHandlerTest.assertFalse((boolean)ClusterState.active((ClusterState)ignite.cluster().state()));
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "connectivity"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"There are no connectivity problems.");
    }

    @Test
    public void testConnectivityCommandWithMultipleTcpLocalAddresses() throws Exception {
        this.cfgLocalHost = "";
        IgniteEx ignite = this.startGrids(6);
        this.assertThatNodeHasMultipleLocalAddresses(ignite);
        IgniteEx client = this.startClientGrid(6);
        this.assertThatNodeHasMultipleLocalAddresses(client);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "connectivity"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"There are no connectivity problems.");
    }

    @Test
    public void testConnectivityCommandWithNodeExit() throws Exception {
        class KillNode3CommunicationSpi
        extends TcpCommunicationSpi {
            boolean fail;

            public KillNode3CommunicationSpi(boolean fail) {
                this.fail = fail;
            }

            public IgniteFuture<BitSet> checkConnection(List<ClusterNode> nodes) {
                if (this.fail) {
                    GridTestUtils.runAsync(() -> ((IgniteEx)node3[0]).close());
                    return null;
                }
                return super.checkConnection(nodes);
            }
        }
        final IgniteEx[] node3 = new IgniteEx[1];
        IgniteEx node1 = this.startGridWithCfg(1, configuration -> {
            configuration.setCommunicationSpi((CommunicationSpi)new KillNode3CommunicationSpi(false));
            return configuration;
        });
        IgniteEx node2 = this.startGridWithCfg(2, configuration -> {
            configuration.setCommunicationSpi((CommunicationSpi)new KillNode3CommunicationSpi(false));
            return configuration;
        });
        node3[0] = this.startGridWithCfg(3, configuration -> {
            configuration.setCommunicationSpi((CommunicationSpi)new KillNode3CommunicationSpi(true));
            return configuration;
        });
        GridCommandHandlerTest.assertFalse((boolean)ClusterState.active((ClusterState)node1.cluster().state()));
        node1.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)3, (int)node1.cluster().nodes().size());
        this.injectTestSystemOut();
        IgniteInternalFuture connectivity = GridTestUtils.runAsync(() -> {
            int result = this.execute("--diagnostic", "connectivity");
            GridCommandHandlerTest.assertEquals((int)0, (int)result);
        });
        connectivity.get();
    }

    @Test
    public void testConnectivityCommandWithFailedNodes() throws Exception {
        UUID okId = UUID.randomUUID();
        final UUID failingId = UUID.randomUUID();
        UnaryOperator operator = configuration -> {
            configuration.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

                public IgniteFuture<BitSet> checkConnection(List<ClusterNode> nodes) {
                    BitSet bitSet = new BitSet();
                    int idx = 0;
                    for (ClusterNode remoteNode : nodes) {
                        if (!remoteNode.id().equals(failingId)) {
                            bitSet.set(idx);
                        }
                        ++idx;
                    }
                    return new IgniteFinishedFutureImpl((Object)bitSet);
                }
            });
            return configuration;
        };
        IgniteEx ignite = this.startGrid("normal", configuration -> {
            operator.apply(configuration);
            configuration.setConsistentId((Serializable)okId);
            configuration.setNodeId(okId);
            return configuration;
        });
        IgniteEx failure = this.startGrid("failure", configuration -> {
            operator.apply(configuration);
            configuration.setConsistentId((Serializable)failingId);
            configuration.setNodeId(failingId);
            return configuration;
        });
        ignite.cluster().state(ClusterState.ACTIVE);
        failure.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        int connectivity = this.execute("--diagnostic", "connectivity");
        GridCommandHandlerTest.assertEquals((int)0, (int)connectivity);
        String out = testOut.toString();
        String what = "There is no connectivity between the following nodes";
        GridTestUtils.assertContains((IgniteLogger)log, (String)out.replaceAll("[\\W_]+", "").trim(), (String)what.replaceAll("[\\W_]+", "").trim());
    }

    @Test
    public void testBaselineRemove() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        IgniteEx other = this.startGrid("nodeToStop");
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        String offlineNodeConsId = this.consistentIds(new Ignite[]{other});
        this.stopGrid("nodeToStop");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "remove", offlineNodeConsId));
        GridCommandHandlerTest.assertEquals((int)1, (int)ignite.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testBaselineRemoveOnNotActiveCluster() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        IgniteEx other = this.startGrid("nodeToStop");
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        String offlineNodeConsId = this.consistentIds(new Ignite[]{other});
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--baseline", "remove", offlineNodeConsId));
        ignite.cluster().state(ClusterState.ACTIVE);
        this.stopGrid("nodeToStop");
        GridCommandHandlerTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
        ignite.cluster().state(ClusterState.INACTIVE);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--baseline", "remove", offlineNodeConsId));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Changing BaselineTopology on inactive cluster is not allowed.");
    }

    @Test
    public void testBaselineSet() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteEx other = this.startGrid(2);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "set", this.consistentIds(new Ignite[]{ignite, other})));
        GridCommandHandlerTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
        GridCommandHandlerTest.assertEquals((int)5, (int)this.execute("--baseline", "set", "invalidConsistentId"));
    }

    @Test
    public void testBaselineSetWithOfflineNode() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        ignite0.cluster().baselineAutoAdjustEnabled(false);
        IgniteEx ignite1 = this.startGrid(this.optimize(this.getConfiguration(this.getTestIgniteInstanceName(1)).setConsistentId(null)));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite0.cluster().state());
        ignite0.cluster().state(ClusterState.ACTIVE);
        IgniteEx other = this.startGrid(2);
        String consistentIds = this.consistentIds(new Ignite[]{ignite0, ignite1, other});
        ignite1.close();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "set", consistentIds));
        GridCommandHandlerTest.assertEquals((int)3, (int)ignite0.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testBaselineVersion() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        ignite.cluster().state(ClusterState.ACTIVE);
        this.startGrid(2);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "version", String.valueOf(ignite.cluster().topologyVersion())));
        GridCommandHandlerTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
    }

    @Test
    public void testBaselineAutoAdjustmentAutoRemoveNode() throws Exception {
        IgniteEx ignite = this.startGrids(3);
        LogListener[] lsnrs = new LogListener[3];
        for (int g = 0; g < 3; ++g) {
            IgniteEx grid = this.grid(g);
            ListeningTestLogger log = (ListeningTestLogger)U.field((Object)grid.configuration().getGridLogger(), (String)"impl");
            LogListener.Builder bldr = LogListener.matches((String)"Baseline parameter 'baselineAutoAdjustTimeout' was changed from '300000' to '2000'");
            if (g == 0) {
                bldr = bldr.andMatches("Baseline auto-adjust will be executed in '2000' ms").andMatches("Baseline auto-adjust will be executed right now.");
            }
            lsnrs[g] = bldr.build();
            log.registerListener(lsnrs[g]);
        }
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "2000"));
        GridCommandHandlerTest.assertEquals((int)3, (int)ignite.cluster().currentBaselineTopology().size());
        this.stopGrid(2);
        for (int i = 0; i < lsnrs.length; ++i) {
            LogListener lsnr = lsnrs[i];
            GridCommandHandlerTest.assertTrue((String)("Failed to wait for the expected log output on " + i), (boolean)lsnr.check(10000L));
        }
        GridCommandHandlerTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> GridCommandHandlerTest.lambda$testBaselineAutoAdjustmentAutoRemoveNode$40((Ignite)ignite), (long)10000L));
        Collection baselineNodesAfter = ignite.cluster().currentBaselineTopology();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "disable"));
        this.stopGrid(1);
        Thread.sleep(3000L);
        Collection baselineNodesFinal = ignite.cluster().currentBaselineTopology();
        GridCommandHandlerTest.assertEquals(baselineNodesAfter.stream().map(BaselineNode::consistentId).collect(Collectors.toList()), baselineNodesFinal.stream().map(BaselineNode::consistentId).collect(Collectors.toList()));
    }

    @Test
    public void testBaselineAutoAdjustmentAutoAddNode() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "2000"));
        GridCommandHandlerTest.assertEquals((int)1, (int)ignite.cluster().currentBaselineTopology().size());
        this.startGrid(1);
        GridCommandHandlerTest.assertEquals((int)1, (int)ignite.cluster().currentBaselineTopology().size());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline"));
        GridCommandHandlerTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> GridCommandHandlerTest.lambda$testBaselineAutoAdjustmentAutoAddNode$41((Ignite)ignite), (long)10000L));
        Collection baselineNodesAfter = ignite.cluster().currentBaselineTopology();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "disable"));
        this.startGrid(2);
        Thread.sleep(3000L);
        Collection baselineNodesFinal = ignite.cluster().currentBaselineTopology();
        GridCommandHandlerTest.assertEquals(baselineNodesAfter.stream().map(BaselineNode::consistentId).collect(Collectors.toList()), baselineNodesFinal.stream().map(BaselineNode::consistentId).collect(Collectors.toList()));
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="false"), @WithSystemProperty(key="IGNITE_BASELINE_AUTO_ADJUST_FEATURE", value="false"), @WithSystemProperty(key="IGNITE_BASELINE_FOR_IN_MEMORY_CACHES_FEATURE", value="false")})
    public void testBaselineAutoAdjustmentAutoFeatureDisabled() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "2000"));
    }

    @Test
    public void testBaselineAutoAdjustmentCouldBeEnabled() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertFalse((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable"));
        GridCommandHandlerTest.assertTrue((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((long)300000L, (long)ignite.cluster().baselineAutoAdjustTimeout());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "disable"));
        GridCommandHandlerTest.assertFalse((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((long)300000L, (long)ignite.cluster().baselineAutoAdjustTimeout());
    }

    @Test
    public void testBaselineAutoAdjustmentTimeoutCouldBeChanged() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertFalse((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "12345"));
        GridCommandHandlerTest.assertTrue((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((long)12345L, (long)ignite.cluster().baselineAutoAdjustTimeout());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "54321"));
        GridCommandHandlerTest.assertTrue((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((long)54321L, (long)ignite.cluster().baselineAutoAdjustTimeout());
    }

    @Test
    public void testBaselineAutoAdjustmentTimeoutWrongArguments() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertFalse((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "qwer"));
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", "-1"));
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "enabled", "timeout"));
    }

    @Test
    public void testBaselineAutoAdjustmentWrongArguments() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertFalse((boolean)ignite.cluster().isBaselineAutoAdjustEnabled());
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "timeout", "qwer"));
        GridCommandHandlerTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "qwer"));
    }

    @Test
    public void testActiveTransactions() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteEx client = this.startGrid("client");
        client.getOrCreateCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC));
        for (Ignite ig : G.allGrids()) {
            GridCommandHandlerTest.assertNotNull((Object)ig.cache("default"));
        }
        CountDownLatch lockLatch = new CountDownLatch(1);
        CountDownLatch unlockLatch = new CountDownLatch(1);
        IgniteInternalFuture<?> fut = this.startTransactions("testActiveTransactions", lockLatch, unlockLatch, true);
        U.awaitQuiet((CountDownLatch)lockLatch);
        GridCommandHandlerTest.doSleep((long)5000L);
        CommandHandler h = new CommandHandler();
        VisorTxInfo[] toKill = new VisorTxInfo[]{null};
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).cluster().localNode());
            for (VisorTxInfo info : res.getInfos()) {
                if (info.getSize() != 100) continue;
                toKill[0] = info;
                break;
            }
            GridCommandHandlerTest.assertEquals((int)3, (int)map.size());
        }, "--tx");
        GridCommandHandlerTest.assertNotNull((Object)toKill[0]);
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            ClusterNode node = this.grid(0).cluster().localNode();
            for (Map.Entry entry : map.entrySet()) {
                GridCommandHandlerTest.assertEquals((int)(((ClusterNode)entry.getKey()).equals(node) ? 1 : 0), (int)((VisorTxTaskResult)entry.getValue()).getInfos().size());
            }
        }, "--tx", "--label", "label1");
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            ClusterNode node1 = this.grid(0).cluster().localNode();
            ClusterNode node2 = this.grid("client").cluster().localNode();
            for (Map.Entry entry : map.entrySet()) {
                if (((ClusterNode)entry.getKey()).equals(node1)) {
                    GridCommandHandlerTest.assertEquals((int)1, (int)((VisorTxTaskResult)entry.getValue()).getInfos().size());
                    GridCommandHandlerTest.assertEquals((String)"label1", (String)((VisorTxInfo)((VisorTxTaskResult)entry.getValue()).getInfos().get(0)).getLabel());
                    continue;
                }
                if (((ClusterNode)entry.getKey()).equals(node2)) {
                    GridCommandHandlerTest.assertEquals((int)1, (int)((VisorTxTaskResult)entry.getValue()).getInfos().size());
                    GridCommandHandlerTest.assertEquals((String)"label2", (String)((VisorTxInfo)((VisorTxTaskResult)entry.getValue()).getInfos().get(0)).getLabel());
                    continue;
                }
                GridCommandHandlerTest.assertTrue((boolean)((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty());
            }
        }, "--tx", "--label", "^label[0-9]");
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).localNode());
            for (VisorTxInfo info : res.getInfos()) {
                GridCommandHandlerTest.assertNull((Object)info.getLabel());
            }
        }, "--tx", "--label", "null");
        int minSize = 10;
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).localNode());
            GridCommandHandlerTest.assertNotNull((Object)res);
            for (VisorTxInfo txInfo : res.getInfos()) {
                GridCommandHandlerTest.assertTrue((txInfo.getSize() >= minSize ? 1 : 0) != 0);
            }
        }, "--tx", "--min-size", Integer.toString(minSize));
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).localNode());
            GridCommandHandlerTest.assertTrue((((VisorTxInfo)res.getInfos().get(0)).getSize() >= ((VisorTxInfo)res.getInfos().get(1)).getSize() ? 1 : 0) != 0);
        }, "--tx", "--order", "SIZE");
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).localNode());
            GridCommandHandlerTest.assertTrue((((VisorTxInfo)res.getInfos().get(0)).getDuration() >= ((VisorTxInfo)res.getInfos().get(1)).getDuration() ? 1 : 0) != 0);
        }, "--tx", "--order", "DURATION");
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(this.grid(0).localNode());
            for (int i = res.getInfos().size() - 1; i > 1; --i) {
                GridCommandHandlerTest.assertTrue((((VisorTxInfo)res.getInfos().get(i - 1)).getStartTime() >= ((VisorTxInfo)res.getInfos().get(i)).getStartTime() ? 1 : 0) != 0);
            }
        }, "--tx", "--order", "START_TIME");
        IgniteInternalFuture startFut = this.multithreadedAsync(() -> {
            try {
                this.startGrid(2);
            }
            catch (Exception e) {
                GridCommandHandlerTest.fail();
            }
        }, 1, "start-node-thread");
        GridCommandHandlerTest.doSleep((long)5000L);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, "--tx"));
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            GridCommandHandlerTest.assertEquals((int)1, (int)map.size());
            Map.Entry killedEntry = map.entrySet().iterator().next();
            VisorTxInfo info = (VisorTxInfo)((VisorTxTaskResult)killedEntry.getValue()).getInfos().get(0);
            GridCommandHandlerTest.assertEquals((Object)toKill[0].getXid(), (Object)info.getXid());
        }, "--tx", "--kill", "--xid", toKill[0].getXid().toString(), "--nodes", this.grid(0).localNode().consistentId().toString());
        unlockLatch.countDown();
        startFut.get();
        fut.get();
        this.awaitPartitionMapExchange();
        this.checkUserFutures();
    }

    @Test
    public void testKillHangingRemoteTransactions() throws Exception {
        int cnt = 3;
        this.startGridsMultiThreaded(3);
        final Ignite[] clients = new Ignite[]{this.startGrid("client1"), this.startGrid("client2"), this.startGrid("client3"), this.startGrid("client4")};
        clients[0].getOrCreateCache(new CacheConfiguration("default").setBackups(2).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64)));
        this.awaitPartitionMapExchange();
        for (Ignite client : clients) {
            GridCommandHandlerTest.assertTrue((boolean)client.configuration().isClientMode());
            GridCommandHandlerTest.assertNotNull((Object)client.cache("default"));
        }
        LongAdder progress = new LongAdder();
        final AtomicInteger idx = new AtomicInteger();
        int tc = clients.length;
        CountDownLatch lockLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Ignite prim = this.primaryNode(0L, "default");
        TestRecordingCommunicationSpi primSpi = TestRecordingCommunicationSpi.spi((Ignite)prim);
        primSpi.blockMessages((IgniteBiPredicate)new IgniteBiPredicate<ClusterNode, Message>(){

            public boolean apply(ClusterNode node, Message message) {
                return message instanceof GridDhtTxFinishRequest;
            }
        });
        GridConcurrentHashSet xidSet = new GridConcurrentHashSet();
        IgniteInternalFuture fut = this.multithreadedAsync(new Runnable((Set)xidSet, lockLatch, commitLatch, progress){
            final /* synthetic */ Set val$xidSet;
            final /* synthetic */ CountDownLatch val$lockLatch;
            final /* synthetic */ CountDownLatch val$commitLatch;
            final /* synthetic */ LongAdder val$progress;
            {
                this.val$xidSet = set;
                this.val$lockLatch = countDownLatch;
                this.val$commitLatch = countDownLatch2;
                this.val$progress = longAdder;
            }

            @Override
            public void run() {
                int id = idx.getAndIncrement();
                Ignite client = clients[id];
                try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED, 0L, 1);){
                    this.val$xidSet.add(tx.xid());
                    IgniteCache cache = client.cache("default");
                    if (id != 0) {
                        U.awaitQuiet((CountDownLatch)this.val$lockLatch);
                    }
                    cache.invoke((Object)0L, (EntryProcessor)new IncrementClosure(), null);
                    if (id == 0) {
                        this.val$lockLatch.countDown();
                        U.awaitQuiet((CountDownLatch)this.val$commitLatch);
                        GridAbstractTest.doSleep((long)500L);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    GridCommandHandlerTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{TransactionTimeoutException.class}));
                }
                this.val$progress.increment();
            }
        }, tc, "invoke-thread");
        U.awaitQuiet((CountDownLatch)lockLatch);
        commitLatch.countDown();
        primSpi.waitForBlocked(clients.length);
        primSpi.stopBlock(true, (IgnitePredicate & Serializable)blockedMsg -> {
            GridIoMessage iom = blockedMsg.ioMessage();
            Message m = iom.message();
            if (m instanceof GridDhtTxFinishRequest) {
                GridDhtTxFinishRequest r = (GridDhtTxFinishRequest)m;
                return !r.nearNodeId().equals(clients[0].cluster().localNode().id());
            }
            return true;
        });
        for (Object ignite : G.allGrids()) {
            if (ignite.configuration().isClientMode().booleanValue()) continue;
            final Collection txs = ((IgniteEx)ignite).context().cache().context().tm().activeTransactions();
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    for (IgniteInternalTx tx : txs) {
                        IgniteTxEntry entry;
                        GridCacheEntryEx cached;
                        Collection candidates;
                        if (tx.local() || (candidates = (cached = (entry = (IgniteTxEntry)tx.writeEntries().iterator().next()).cached()).remoteMvccSnapshot(new GridCacheVersion[0])).size() == clients.length) continue;
                        return false;
                    }
                    return true;
                }
            }, (long)10000L);
        }
        CommandHandler h = new CommandHandler();
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)((IgniteInClosure & Serializable)arg_0 -> this.lambda$testKillHangingRemoteTransactions$b089d2f4$1(prim, (Set)xidSet, clients, arg_0)), "--tx");
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {}, "--tx", "--kill");
        for (Ignite ignite : G.allGrids()) {
            if (ignite.configuration().isClientMode().booleanValue()) continue;
            Collection txs = ((IgniteEx)ignite).context().cache().context().tm().activeTransactions();
            for (IgniteInternalTx tx : txs) {
                if (tx.local()) continue;
                tx.finishFuture().get();
            }
        }
        primSpi.stopBlock(true);
        fut.get();
        Long cur = (Long)clients[0].cache("default").get((Object)0L);
        GridCommandHandlerTest.assertEquals((long)(tc - 1), (long)cur);
        this.checkUserFutures();
    }

    @Test
    public void testBaselineAddOnNotActiveCluster() throws Exception {
        IgniteEx ignite = this.startGrid(1);
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        String consistentIDs = this.getTestIgniteInstanceName(1);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--baseline", "add", consistentIDs));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Changing BaselineTopology on inactive cluster is not allowed.");
        consistentIDs = this.getTestIgniteInstanceName(1) + ", " + this.getTestIgniteInstanceName(2) + "," + this.getTestIgniteInstanceName(3);
        GridCommandHandlerTest.assertEquals((int)5, (int)this.execute("--baseline", "add", consistentIDs));
        String testOutStr = testOut.toString();
        boolean isInstanse1Found = Arrays.stream(testOutStr.split("\n")).filter(s -> s.contains("Arguments:")).noneMatch(s -> s.contains(this.getTestIgniteInstanceName() + "1"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOutStr, (String)"Node not found for consistent ID:");
        GridCommandHandlerTest.assertFalse((String)testOutStr, (boolean)isInstanse1Found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdleVerifyCheckCrcFailsOnNotIdleCluster() throws Exception {
        this.checkpointFreq = 1000L;
        IgniteEx node = this.startGrids(2);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_ASYNC).setName("default"));
        AtomicBoolean stopFlag = new AtomicBoolean();
        Thread loadThread = new Thread(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!stopFlag.get()) {
                cache.put((Object)rnd.nextInt(1000), (Object)rnd.nextInt(1000));
                if (!Thread.interrupted()) continue;
                break;
            }
        });
        try {
            loadThread.start();
            GridCommandHandlerTest.doSleep((long)this.checkpointFreq);
            this.injectTestSystemOut();
            GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--check-crc"));
        }
        finally {
            GridCommandHandlerTest.doSleep((long)this.checkpointFreq);
            stopFlag.set(true);
            loadThread.join();
        }
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"idle_verify failed");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"See log for additional information.");
        String logFileName = out.split("See log for additional information. ")[1].split(".txt")[0];
        String logFile = new String(Files.readAllBytes(new File(logFileName + ".txt").toPath()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)logFile, (String)"Cluster not idle. Modifications found in caches or groups: ");
    }

    @Test
    public void testCacheIdleVerifyDumpWhenNodeFailing() throws Exception {
        IgniteEx ignite = this.startGrids(3);
        IgniteEx unstable = this.startGrid("unstable");
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createCacheAndPreload((Ignite)ignite, 100);
        for (int i = 0; i < 3; ++i) {
            TestRecordingCommunicationSpi.spi((Ignite)unstable).blockMessages(GridJobExecuteResponse.class, this.getTestIgniteInstanceName(i));
        }
        this.injectTestSystemOut();
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump")));
        TestRecordingCommunicationSpi.spi((Ignite)unstable).waitForBlocked();
        UUID unstableNodeId = unstable.cluster().localNode().id();
        unstable.close();
        fut.get();
        this.checkExceptionMessageOnReport(unstableNodeId);
    }

    @Test
    public void testCacheIdleVerifyDumpWhenSeveralNodesFailing() throws Exception {
        int nodes = 6;
        IgniteEx ignite = this.startGrids(nodes);
        ArrayList<IgniteEx> unstableNodes = new ArrayList<IgniteEx>(nodes / 2);
        for (int i = 0; i < nodes; ++i) {
            if (i % 2 != 1) continue;
            unstableNodes.add(this.ignite(i));
        }
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createCacheAndPreload((Ignite)ignite, 100);
        for (Ignite ignite2 : unstableNodes) {
            for (int i = 0; i < nodes; ++i) {
                TestRecordingCommunicationSpi.spi((Ignite)ignite2).blockMessages(GridJobExecuteResponse.class, this.getTestIgniteInstanceName(i));
            }
        }
        this.injectTestSystemOut();
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump")));
        ArrayList<UUID> arrayList = new ArrayList<UUID>(nodes / 2);
        for (Ignite ignite3 : unstableNodes) {
            TestRecordingCommunicationSpi.spi((Ignite)ignite3).waitForBlocked();
            arrayList.add(ignite3.cluster().localNode().id());
            ignite3.close();
        }
        fut.get();
        for (UUID uUID : arrayList) {
            this.checkExceptionMessageOnReport(uUID);
        }
    }

    @Test
    public void testCacheIdleVerifyCrcWithCorruptedPartition() throws Exception {
        this.testCacheIdleVerifyWithCorruptedPartition("--cache", "idle_verify", "--check-crc");
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"idle_verify failed on 1 node.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"See log for additional information.");
    }

    @Test
    public void testCacheIdleVerifyDumpCrcWithCorruptedPartition() throws Exception {
        this.testCacheIdleVerifyWithCorruptedPartition("--cache", "idle_verify", "--dump", "--check-crc");
        String[] parts = testOut.toString().split("VisorIdleVerifyDumpTask successfully written output to '");
        GridCommandHandlerTest.assertEquals((int)2, (int)parts.length);
        String dumpFile = parts[1].split("\\.")[0] + ".txt";
        for (String line : Files.readAllLines(new File(dumpFile).toPath())) {
            testOut.write(line.getBytes());
        }
        String outputStr = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)"idle_verify failed on 1 node.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)outputStr, (String)"idle_verify check has finished, no conflicts have been found.");
    }

    private void corruptPartition(File partitionsDir) throws IOException {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (File partFile : partitionsDir.listFiles((d, n) -> n.startsWith("part"))) {
            try (RandomAccessFile raf = new RandomAccessFile(partFile, "rw");){
                byte[] buf = new byte[1024];
                rand.nextBytes(buf);
                raf.seek(8193L);
                raf.write(buf);
            }
        }
    }

    private void testCacheIdleVerifyWithCorruptedPartition(String ... args) throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createCacheAndPreload((Ignite)ignite, 1000);
        Serializable consistId = ignite.configuration().getConsistentId();
        File partitionsDir = U.resolveWorkDirectory((String)ignite.configuration().getWorkDirectory(), (String)("db/" + consistId + "/cache-" + "default"), (boolean)false);
        this.stopGrid(0);
        this.corruptPartition(partitionsDir);
        this.startGrid(0);
        this.awaitPartitionMapExchange();
        this.forceCheckpoint();
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(args));
    }

    private void checkExceptionMessageOnReport(UUID unstableNodeId) throws IOException {
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithConflicts = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"Idle verify failed on nodes:");
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)("Node ID: " + unstableNodeId));
        } else {
            GridCommandHandlerTest.fail((String)"Should be found dump with conflicts");
        }
    }

    @Test
    public void testCacheIdleVerifyDumpForCorruptedDataOnNonePersistenceClientCache() throws Exception {
        int parts = 32;
        this.dataRegionConfiguration = new DataRegionConfiguration().setName("none-persistence-region");
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setBackups(2).setName("default").setDataRegionName("none-persistence-region"));
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.injectTestSystemOut();
        GridCacheContext cacheCtx = ignite.cachex("default").context();
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)0, (boolean)true, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)(parts / 2), (boolean)false, (boolean)true, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--cache-filter", "NOT_PERSISTENT"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithConflicts = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"found 2 conflict partitions: [updateCounterConflicts=1, reserveCounterConflicts=0, hashConflicts=1]");
        } else {
            GridCommandHandlerTest.fail((String)"Should be found dump with conflicts");
        }
    }

    @NotNull
    private Matcher dumpFileNameMatcher() {
        Pattern fileNamePattern = Pattern.compile(".*VisorIdleVerifyDumpTask successfully written output to '(.*)'");
        return fileNamePattern.matcher(testOut.toString());
    }

    @Test
    public void testCacheIdleVerifyMovingParts() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().state(ClusterState.ACTIVE);
        int parts = 32;
        IgniteCache cache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setBackups(1).setName("default").setRebalanceDelay(10000L));
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no conflicts have been found");
        this.startGrid(2);
        this.resetBaselineTopology();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"MOVING partitions");
    }

    @Test
    public void testCacheSequence() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteEx client = this.startGrid("client");
        IgniteAtomicSequence seq1 = client.atomicSequence("testSeq", 1L, true);
        seq1.get();
        IgniteAtomicSequence seq2 = client.atomicSequence("testSeq2", 10L, true);
        seq2.get();
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "list", "testSeq.*", "--seq"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"testSeq");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"testSeq2");
    }

    private void validate(CommandHandler h, IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>> validateClo, String ... args) {
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, args));
        validateClo.apply(h.getLastOperationResult());
    }

    private Map<Object, Object> generate(int from, int cnt) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        for (int i = 0; i < cnt; ++i) {
            map.put(i + from, i + from);
        }
        return map;
    }

    @Test
    public void testDiagnosticPageLocksTracker() throws Exception {
        IgniteEx ignite = this.startGridWithCfg(0, cfg -> cfg.setConsistentId((Serializable)((Object)"node0/dump")));
        this.startGridWithCfg(1, cfg -> cfg.setConsistentId((Serializable)((Object)"node1/dump")));
        this.startGridWithCfg(2, cfg -> cfg.setConsistentId((Serializable)((Object)"node2/dump")));
        this.startGridWithCfg(3, cfg -> cfg.setConsistentId((Serializable)((Object)"node3/dump")));
        Collection nodes = ignite.cluster().nodes();
        ArrayList nodes0 = new ArrayList(nodes);
        ClusterNode node0 = (ClusterNode)nodes0.get(0);
        ClusterNode node1 = (ClusterNode)nodes0.get(1);
        ClusterNode node2 = (ClusterNode)nodes0.get(2);
        ClusterNode node3 = (ClusterNode)nodes0.get(3);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "help"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump"));
        this.checkNumberFiles(defaultDiagnosticDir, 1);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump_log"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--path", customDiagnosticDir.getAbsolutePath()));
        this.checkNumberFiles(customDiagnosticDir, 1);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--all"));
        this.checkNumberFiles(defaultDiagnosticDir, 5);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump_log", "--all"));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--path", customDiagnosticDir.getAbsolutePath(), "--all"));
        this.checkNumberFiles(customDiagnosticDir, 5);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--nodes", node0.id().toString() + "," + node2.id().toString()));
        this.checkNumberFiles(defaultDiagnosticDir, 7);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--nodes", node0.consistentId().toString() + "," + node2.consistentId().toString()));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump_log", "--nodes", node1.id().toString() + "," + node3.id().toString()));
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--diagnostic", "pageLocks", "dump", "--path", customDiagnosticDir.getAbsolutePath(), "--nodes", node1.consistentId().toString() + "," + node3.consistentId().toString()));
        this.checkNumberFiles(customDiagnosticDir, 7);
    }

    private void checkNumberFiles(File dir, int numberFiles) {
        File[] files = dir.listFiles((d, name) -> name.startsWith("page_lock_dump_"));
        GridCommandHandlerTest.assertEquals((int)numberFiles, (int)files.length);
        for (int i = 0; i < files.length; ++i) {
            GridCommandHandlerTest.assertTrue((files[i].length() > 0L ? 1 : 0) != 0);
        }
    }

    private IgniteInternalFuture<?> startTransactions(String testName, final CountDownLatch lockLatch, final CountDownLatch unlockLatch, final boolean topChangeBeforeUnlock) throws Exception {
        final IgniteEx client = this.grid("client");
        final AtomicInteger idx = new AtomicInteger();
        return this.multithreadedAsync(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                id = idx.getAndIncrement();
                switch (id) {
                    case 0: {
                        try {
                            tx = GridCommandHandlerTest.access$200(GridCommandHandlerTest.this, 0).transactions().txStart();
                            var3_7 = null;
                            GridCommandHandlerTest.access$400(GridCommandHandlerTest.this, 0).cache("default").putAll(GridCommandHandlerTest.access$300(GridCommandHandlerTest.this, 0, 100));
                            lockLatch.countDown();
                            U.awaitQuiet((CountDownLatch)unlockLatch);
                            tx.commit();
                            if (topChangeBeforeUnlock) {
                                GridCommandHandlerTest.access$500("Commit must fail");
                            }
                            if (tx == null) break;
                            if (var3_7 == null) ** GOTO lbl22
                            try {
                                tx.close();
                            }
                            catch (Throwable var4_11) {
                                var3_7.addSuppressed(var4_11);
                            }
                            break;
lbl22:
                            // 1 sources

                            tx.close();
                            ** break;
                            catch (Throwable var4_12) {
                                try {
                                    var3_7 = var4_12;
                                    throw var4_12;
                                }
                                catch (Throwable var5_19) {
                                    if (tx != null) {
                                        if (var3_7 != null) {
                                            try {
                                                tx.close();
                                            }
                                            catch (Throwable var6_20) {
                                                var3_7.addSuppressed(var6_20);
                                            }
                                        } else {
                                            tx.close();
                                        }
                                    }
                                    throw var5_19;
lbl39:
                                    // 1 sources

                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (topChangeBeforeUnlock) {
                                GridCommandHandlerTest.access$600(X.hasCause((Throwable)e, (Class[])new Class[]{TransactionRollbackException.class}));
                                break;
                            }
                            throw e;
                        }
                    }
                    case 1: {
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        GridAbstractTest.doSleep((long)3000L);
                        tx = GridCommandHandlerTest.access$700(GridCommandHandlerTest.this, 0).transactions().withLabel("label1").txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED, 0x7FFFFFFFL, 0);
                        var3_8 = null;
                        GridCommandHandlerTest.access$800(GridCommandHandlerTest.this, 0).cache("default").putAll(GridCommandHandlerTest.access$300(GridCommandHandlerTest.this, 200, 110));
                        GridCommandHandlerTest.access$900(GridCommandHandlerTest.this, 0).cache("default").put((Object)0, (Object)0);
                        if (tx == null) break;
                        if (var3_8 == null) ** GOTO lbl61
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_13) {
                            var3_8.addSuppressed(var4_13);
                        }
                        break;
lbl61:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_14) {
                            try {
                                var3_8 = var4_14;
                                throw var4_14;
                            }
                            catch (Throwable var7_21) {
                                if (tx != null) {
                                    if (var3_8 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var8_22) {
                                            var3_8.addSuppressed(var8_22);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var7_21;
                            }
                        }
                    }
                    case 2: {
                        tx = GridCommandHandlerTest.access$1000(GridCommandHandlerTest.this, 1).transactions().txStart();
                        var3_9 = null;
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        GridCommandHandlerTest.access$1100(GridCommandHandlerTest.this, 1).cache("default").put((Object)0, (Object)0);
                        if (tx == null) break;
                        if (var3_9 == null) ** GOTO lbl92
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_15) {
                            var3_9.addSuppressed(var4_15);
                        }
                        break;
lbl92:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_16) {
                            try {
                                var3_9 = var4_16;
                                throw var4_16;
                            }
                            catch (Throwable var9_23) {
                                if (tx != null) {
                                    if (var3_9 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var10_24) {
                                            var3_9.addSuppressed(var10_24);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var9_23;
                            }
                        }
                    }
                    case 3: {
                        tx = client.transactions().withLabel("label2").txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED, 0L, 0);
                        var3_10 = null;
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        client.cache("default").putAll(GridCommandHandlerTest.access$300(GridCommandHandlerTest.this, 100, 10));
                        client.cache("default").put((Object)0, (Object)0);
                        tx.commit();
                        if (tx == null) break;
                        if (var3_10 == null) ** GOTO lbl125
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_17) {
                            var3_10.addSuppressed(var4_17);
                        }
                        break;
lbl125:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_18) {
                            try {
                                var3_10 = var4_18;
                                throw var4_18;
                            }
                            catch (Throwable var11_25) {
                                if (tx != null) {
                                    if (var3_10 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var12_26) {
                                            var3_10.addSuppressed(var12_26);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var11_25;
                            }
                        }
                    }
                }
            }
        }, 4, "tx-thread-" + testName);
    }

    @Test
    public void testKillHangingLocalTransactions() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteEx client = this.startGrid("client");
        client.getOrCreateCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64)));
        Ignite prim = this.primaryNode(0L, "default");
        TestRecordingCommunicationSpi.spi((Ignite)prim).blockMessages(GridNearLockResponse.class, client.name());
        TestRecordingCommunicationSpi.spi((Ignite)client).blockMessages(GridNearTxFinishRequest.class, prim.name());
        GridNearTxLocal clientTx = null;
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED, 2000L, 1);){
            clientTx = ((TransactionProxyImpl)tx).tx();
            client.cache("default").put((Object)0L, (Object)0L);
            GridCommandHandlerTest.fail();
        }
        catch (Exception e) {
            GridCommandHandlerTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{TransactionTimeoutException.class}));
        }
        GridCommandHandlerTest.assertNotNull(clientTx);
        IgniteEx primEx = (IgniteEx)prim;
        IgniteInternalTx tx0 = (IgniteInternalTx)primEx.context().cache().context().tm().activeTransactions().iterator().next();
        GridCommandHandlerTest.assertNotNull((Object)tx0);
        CommandHandler h = new CommandHandler();
        this.validate(h, (IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>>)(IgniteInClosure & Serializable)map -> {
            ClusterNode node = this.grid(0).cluster().localNode();
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(node);
            for (VisorTxInfo info : res.getInfos()) {
                GridCommandHandlerTest.assertEquals((Object)tx0.xid(), (Object)info.getXid());
            }
            GridCommandHandlerTest.assertEquals((int)1, (int)map.size());
        }, "--tx", "--xid", tx0.xid().toString(), "--kill");
        tx0.finishFuture().get();
        TestRecordingCommunicationSpi.spi((Ignite)prim).stopBlock();
        TestRecordingCommunicationSpi.spi((Ignite)client).stopBlock();
        IgniteInternalFuture nearFinFut = (IgniteInternalFuture)U.field((Object)clientTx, (String)"finishFut");
        nearFinFut.get();
        this.checkUserFutures();
    }

    @Test
    public void setConsistenceIdsWithOfflineBaselineNode() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.ignite(0).createCache(GridCommandHandlerTest.defaultCacheConfiguration().setNodeFilter((IgnitePredicate & Serializable)node -> node.attribute("some-attr") != null));
        GridCommandHandlerTest.assertEquals((int)5, (int)this.execute("--baseline", "set", "non-existing-node-id ," + this.consistentIds(new Ignite[]{ignite})));
    }

    @Test
    public void testCacheIdleVerifyPrintLostPartitions() throws Exception {
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().state(ClusterState.ACTIVE);
        ignite.createCache(new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setCacheMode(CacheMode.PARTITIONED).setPartitionLossPolicy(PartitionLossPolicy.READ_ONLY_SAFE).setBackups(1));
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new byte[i]);
            }
        }
        String g1Name = this.grid(1).name();
        this.stopGrid(1);
        this.cleanPersistenceDir(g1Name);
        this.startGrid(1);
        this.stopGrid(2);
        this.injectTestSystemOut();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--yes"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"LOST partitions:");
    }

    @Test
    public void testMasterKeyChange() throws Exception {
        this.encryptionEnabled = true;
        this.injectTestSystemOut();
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createCacheAndPreload((Ignite)ignite, 10);
        CommandHandler h = new CommandHandler();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, "--encryption", "get_master_key_name"));
        Object res = h.getLastOperationResult();
        GridCommandHandlerTest.assertEquals((Object)ignite.encryption().getMasterKeyName(), (Object)res);
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, "--encryption", "change_master_key", "ignite.master.key2"));
        GridCommandHandlerTest.assertEquals((String)"ignite.master.key2", (String)ignite.encryption().getMasterKeyName());
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, "--encryption", "get_master_key_name"));
        res = h.getLastOperationResult();
        GridCommandHandlerTest.assertEquals((Object)"ignite.master.key2", (Object)res);
        testOut.reset();
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--encryption", "change_master_key", "non-existing-master-key-name"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Master key change was rejected. Unable to get the master key digest.");
    }

    @Test
    public void testCacheGroupKeyChange() throws Exception {
        this.encryptionEnabled = true;
        this.injectTestSystemOut();
        int srvNodes = 2;
        IgniteEx ignite = this.startGrids(srvNodes);
        this.startGrid("client");
        ignite.cluster().state(ClusterState.ACTIVE);
        List srvGrids = GridFunc.asList((Object[])new Ignite[]{this.grid(0), this.grid(1)});
        this.enableCheckpoints(srvGrids, false);
        this.createCacheAndPreload((Ignite)ignite, 1000);
        int ret = this.execute("--encryption", EncryptionSubcommands.CACHE_GROUP_KEY_IDS.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Encryption key identifiers for cache: default");
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "0 (active)"));
        ret = this.execute("--encryption", EncryptionSubcommands.CHANGE_CACHE_GROUP_KEY.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"The encryption key has been changed for the cache group \"default\"");
        ret = this.execute("--encryption", EncryptionSubcommands.CACHE_GROUP_KEY_IDS.toString(), "default");
        GridCommandHandlerTest.assertEquals((String)testOut.toString(), (int)0, (int)ret);
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Encryption key identifiers for cache: default");
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "1 (active)"));
        GridTestUtils.waitForCondition(() -> {
            this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_STATUS.toString(), "default");
            return srvNodes == this.countSubstrs(testOut.toString(), "re-encryption will be completed after the next checkpoint");
        }, (long)this.getTestTimeout());
        this.enableCheckpoints(srvGrids, true);
        this.forceCheckpoint(srvGrids);
        GridTestUtils.waitForCondition(() -> {
            this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_STATUS.toString(), "default");
            return srvNodes == this.countSubstrs(testOut.toString(), "re-encryption completed or not required");
        }, (long)this.getTestTimeout());
    }

    @Test
    public void testChangeReencryptionRate() throws Exception {
        int srvNodes = 2;
        IgniteEx ignite = this.startGrids(srvNodes);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        int ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RATE.toString());
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption rate is not limited."));
        double newRate = 0.01;
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RATE.toString(), Double.toString(newRate));
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), String.format("re-encryption rate has been limited to %.2f MB/s.", newRate)));
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RATE.toString());
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), String.format("re-encryption rate is limited to %.2f MB/s.", newRate)));
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RATE.toString(), "0");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption rate is not limited."));
    }

    @Test
    public void testReencryptionSuspendAndResume() throws Exception {
        this.encryptionEnabled = true;
        this.reencryptSpeed = 0.01;
        this.reencryptBatchSize = 1;
        int srvNodes = 2;
        IgniteEx ignite = this.startGrids(srvNodes);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemOut();
        this.createCacheAndPreload((Ignite)ignite, 10000);
        ignite.encryption().changeCacheGroupKey(Collections.singleton("default")).get();
        GridCommandHandlerTest.assertTrue((boolean)this.isReencryptionStarted("default"));
        int ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_STATUS.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        Pattern ptrn = Pattern.compile("(?m)Node [-0-9a-f]{36}:\n\\s+(?<left>\\d+) KB of data.+");
        Matcher matcher = ptrn.matcher(testOut.toString());
        int matchesCnt = 0;
        while (matcher.find()) {
            GridCommandHandlerTest.assertEquals((int)1, (int)matcher.groupCount());
            int pagesLeft = Integer.parseInt(matcher.group("left"));
            GridCommandHandlerTest.assertTrue((pagesLeft > 0 ? 1 : 0) != 0);
            ++matchesCnt;
        }
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)matchesCnt);
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_SUSPEND.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption of the cache group \"default\" has been suspended."));
        GridCommandHandlerTest.assertFalse((boolean)this.isReencryptionStarted("default"));
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_SUSPEND.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption of the cache group \"default\" has already been suspended."));
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RESUME.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption of the cache group \"default\" has been resumed."));
        GridCommandHandlerTest.assertTrue((boolean)this.isReencryptionStarted("default"));
        ret = this.execute("--encryption", EncryptionSubcommands.REENCRYPTION_RESUME.toString(), "default");
        GridCommandHandlerTest.assertEquals((int)0, (int)ret);
        GridCommandHandlerTest.assertEquals((int)srvNodes, (int)this.countSubstrs(testOut.toString(), "re-encryption of the cache group \"default\" has already been resumed."));
    }

    private boolean isReencryptionStarted(String cacheName) {
        for (Ignite grid : G.allGrids()) {
            ClusterNode locNode = grid.cluster().localNode();
            if (locNode.isClient() || locNode.isDaemon() || !((IgniteEx)grid).context().encryption().reencryptionFuture(CU.cacheId((String)cacheName)).isDone()) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testMasterKeyChangeOnInactiveCluster() throws Exception {
        this.encryptionEnabled = true;
        this.injectTestSystemOut();
        IgniteEx ignite = this.startGrids(1);
        CommandHandler h = new CommandHandler();
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute(h, "--encryption", "get_master_key_name"));
        Object res = h.getLastOperationResult();
        GridCommandHandlerTest.assertEquals((Object)ignite.encryption().getMasterKeyName(), (Object)res);
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute(h, "--encryption", "change_master_key", "ignite.master.key2"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Master key change was rejected. The cluster is inactive.");
    }

    @Test
    public void testStateChangeNoAutoConfirmation() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        this.autoConfirmation = false;
        this.injectTestSystemOut();
        ignite.cluster().state(ClusterState.ACTIVE);
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "INACTIVE"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "INACTIVE"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "ACTIVE_READ_ONLY"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE_READ_ONLY, (Object)ignite.cluster().state());
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "INACTIVE"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.INACTIVE, (Object)ignite.cluster().state());
        this.injectTestSystemIn("y");
        GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--set-state", "ACTIVE"));
        GridCommandHandlerTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
    }

    @Test
    public void testPartialActivateMessage() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        String partialActivationMsg = "Partial activation detected.";
        ignite.cluster().state(ClusterState.ACTIVE);
        this.stopAllGrids();
        this.startGrid(1);
        this.injectTestSystemOut();
        this.autoConfirmation = false;
        this.injectTestSystemIn("y");
        this.execute("--set-state", "ACTIVE");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)partialActivationMsg);
        this.stopAllGrids();
        this.startGrid(1);
        this.autoConfirmation = true;
        this.execute("--set-state", "ACTIVE");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)partialActivationMsg);
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", value="true"), @WithSystemProperty(key="IGNITE_EXECUTE_DURABLE_BACKGROUND_TASKS_ON_NODE_START_OR_ACTIVATE", value="false")})
    public void testCleaningGarbageAfterCacheDestroyedAndNodeStop_ControlConsoleUtil() throws Exception {
        new IgniteCacheGroupsWithRestartsTest().testFindAndDeleteGarbage(this::executeTaskViaControlConsoleUtil);
    }

    @Test
    public void testSuccessStopWarmUp() throws Exception {
        WarmUpTestPluginProvider provider = new WarmUpTestPluginProvider();
        IgniteConfiguration cfg = this.getConfiguration(this.getTestIgniteInstanceName(0)).setPluginProviders(new PluginProvider[]{provider});
        cfg.getDataStorageConfiguration().setDefaultWarmUpConfiguration((WarmUpConfiguration)new BlockedWarmUpConfiguration());
        cfg.getConnectorConfiguration().setHost("localhost");
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> this.startGrid(cfg));
        BlockedWarmUpStrategy blockedWarmUpStgy = (BlockedWarmUpStrategy)provider.strats.get(1);
        try {
            U.await((CountDownLatch)blockedWarmUpStgy.startLatch, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            GridCommandHandlerTest.assertEquals((int)0, (int)this.execute("--warm-up", "--stop", "--yes"));
            fut.get(60000L);
        }
        catch (Throwable t) {
            blockedWarmUpStgy.stopLatch.countDown();
            throw t;
        }
    }

    @Test
    public void testFailStopWarmUp() throws Exception {
        this.startGrid(0);
        GridCommandHandlerTest.assertEquals((int)4, (int)this.execute("--warm-up", "--stop", "--yes"));
    }

    private VisorFindAndDeleteGarbageInPersistenceTaskResult executeTaskViaControlConsoleUtil(IgniteEx ignite, boolean delFoundGarbage) {
        CommandHandler hnd = new CommandHandler();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--yes", "--port", "11212", "--cache", "find_garbage", ignite.localNode().id().toString()));
        if (delFoundGarbage) {
            args.add(FindAndDeleteGarbageArg.DELETE.argName());
        }
        hnd.execute(args);
        return (VisorFindAndDeleteGarbageInPersistenceTaskResult)hnd.getLastOperationResult();
    }

    private int countSubstrs(String str, String substr) {
        int cnt = 0;
        int off = 0;
        while ((off = str.indexOf(substr, off)) != -1) {
            ++cnt;
            ++off;
        }
        return cnt;
    }

    private void assertThatNodeHasMultipleLocalAddresses(IgniteEx n) {
        CommunicationSpi commSpi = n.context().config().getCommunicationSpi();
        Collection rmtAddrs = (Collection)n.localNode().attribute(U.spiAttribute((IgniteSpi)commSpi, (String)"comm.tcp.addrs"));
        MatcherAssert.assertThat((Object)rmtAddrs, (org.hamcrest.Matcher)Matchers.hasSize((org.hamcrest.Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
    }

    private /* synthetic */ void lambda$testKillHangingRemoteTransactions$b089d2f4$1(Ignite prim, Set xidSet, Ignite[] clients, Map map) {
        for (int i = 0; i < 3; ++i) {
            IgniteEx grid = this.grid(i);
            if (grid.localNode().id().equals(prim.cluster().localNode().id())) continue;
            VisorTxTaskResult res = (VisorTxTaskResult)map.get(grid.localNode());
            List infos = res.getInfos().stream().filter(info -> xidSet.contains(info.getNearXid())).collect(Collectors.toList());
            GridCommandHandlerTest.assertEquals((int)clients.length, (int)infos.size());
        }
    }

    private static /* synthetic */ boolean lambda$testBaselineAutoAdjustmentAutoAddNode$41(Ignite ignite) {
        return ignite.cluster().currentBaselineTopology().size() == 2;
    }

    private static /* synthetic */ boolean lambda$testBaselineAutoAdjustmentAutoRemoveNode$40(Ignite ignite) {
        return ignite.cluster().currentBaselineTopology().size() == 2;
    }

    static /* synthetic */ IgniteEx access$200(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ Map access$300(GridCommandHandlerTest x0, int x1, int x2) {
        return x0.generate(x1, x2);
    }

    static /* synthetic */ IgniteEx access$400(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ void access$500(String x0) {
        GridCommandHandlerTest.fail((String)x0);
    }

    static /* synthetic */ void access$600(boolean x0) {
        GridCommandHandlerTest.assertTrue((boolean)x0);
    }

    static /* synthetic */ IgniteEx access$700(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$800(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$900(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$1000(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$1100(GridCommandHandlerTest x0, int x1) {
        return x0.grid(x1);
    }

    private static class IncrementClosure
    implements EntryProcessor<Long, Long, Void> {
        private IncrementClosure() {
        }

        public Void process(MutableEntry<Long, Long> entry, Object ... arguments) throws EntryProcessorException {
            entry.setValue((Object)(entry.exists() ? (Long)entry.getValue() + 1L : 0L));
            return null;
        }
    }
}

