/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverterArguments;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.diagnostic.DiagnosticProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IgniteWalConverterArgumentsTest
extends GridCommonAbstractTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    public IgniteWalConverterArgumentsTest() {
        super(false);
    }

    @Test
    public void testViewHelp() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IgniteWalConverterArguments parseArgs = IgniteWalConverterArguments.parse((PrintStream)new PrintStream(out), null);
        Assert.assertNull((Object)parseArgs);
        String help = out.toString();
        Assert.assertTrue((boolean)help.startsWith("Print WAL log data in human-readable form."));
        for (Field field : IgniteWalConverterArguments.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != String.class) continue;
            field.setAccessible(true);
            String arg = (String)field.get(null);
            Assert.assertTrue((boolean)help.contains("    " + arg + " "));
        }
    }

    @Test
    public void testRequiredWalDir() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("One of the arguments --wal-dir or --wal-archive-dir must be specified.");
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])new String[]{"--page-size", "4096"});
    }

    @Test
    public void testIncorrectWalDir() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("File/directory 'non_existing_path' does not exist.");
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])new String[]{"--wal-dir", "non_existing_path"});
    }

    @Test
    public void testIncorrectWalArchiveDir() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("File/directory 'non_existing_path' does not exist.");
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])new String[]{"--wal-archive-dir", "non_existing_path"});
    }

    @Test
    public void testIncorrectPageSize() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Can't parse number 'not_integer', expected type: java.lang.Integer");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--page-size", "not_integer"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectBinaryMetadataFileStoreDir() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("File/directory 'non_existing_path' does not exist.");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--binary-metadata-dir", "non_existing_path"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectMarshallerMappingDir() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("File/directory 'non_existing_path' does not exist.");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--marshaller-mapping-dir", "non_existing_path"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectRecordTypes() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Unknown record types: [not_exist].");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--record-types", "not_exist"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectSeveralRecordTypes() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Unknown record types: [not_exist1, not_exist2].");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--record-types", "not_exist1,not_exist2"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectWalTimeFromMillis() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Can't parse number 'not_long', expected type: java.lang.Long");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--wal-time-from-millis", "not_long"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectWalTimeToMillis() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Can't parse number 'not_long', expected type: java.lang.Long");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--wal-time-to-millis", "not_long"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testIncorrectProcessSensitiveData() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Unknown --include-sensitive: unknown. Supported:");
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--include-sensitive", "unknown"};
        IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
    }

    @Test
    public void testDefault() throws IOException {
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath()};
        IgniteWalConverterArguments parseArgs = IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
        Assert.assertEquals((long)4096L, (long)parseArgs.getPageSize());
        Assert.assertNull((Object)parseArgs.getBinaryMetadataDir());
        Assert.assertNull((Object)parseArgs.getMarshallerMappingDir());
        Assert.assertFalse((boolean)parseArgs.isUnwrapBinary());
        Assert.assertTrue((boolean)parseArgs.getRecordTypes().isEmpty());
        Assert.assertNull((Object)parseArgs.getFromTime());
        Assert.assertNull((Object)parseArgs.getToTime());
        Assert.assertNull((Object)parseArgs.hasText());
        Assert.assertEquals((Object)ProcessSensitiveData.MD5, (Object)parseArgs.includeSensitive());
        Assert.assertFalse((boolean)parseArgs.isPrintStat());
        Assert.assertFalse((boolean)parseArgs.isSkipCrc());
    }

    @Test
    public void testParse() throws IOException {
        File binaryMetadataDir;
        File wal = File.createTempFile("wal", "");
        wal.deleteOnExit();
        File walArchive = File.createTempFile("wal_archive", "");
        walArchive.deleteOnExit();
        File marshallerDir = binaryMetadataDir = new File(System.getProperty("java.io.tmpdir"));
        String[] args = new String[]{"--wal-dir", wal.getAbsolutePath(), "--wal-archive-dir", walArchive.getAbsolutePath(), "--page-size", "2048", "--binary-metadata-dir", binaryMetadataDir.getAbsolutePath(), "--marshaller-mapping-dir", marshallerDir.getAbsolutePath(), "--unwrap-binary", "--record-types", "DATA_RECORD_V2,TX_RECORD", "--wal-time-from-millis", "1575158400000", "--wal-time-to-millis", "1577836740999", "--has-text", "search string", "--include-sensitive", "HASH", "--print-stat", "--skip-crc"};
        IgniteWalConverterArguments parseArgs = IgniteWalConverterArguments.parse((PrintStream)System.out, (String[])args);
        Assert.assertEquals((Object)wal, (Object)parseArgs.getWalDir());
        Assert.assertEquals((Object)walArchive, (Object)parseArgs.getWalArchiveDir());
        Assert.assertEquals((long)2048L, (long)parseArgs.getPageSize());
        Assert.assertEquals((Object)binaryMetadataDir, (Object)parseArgs.getBinaryMetadataDir());
        Assert.assertEquals((Object)marshallerDir, (Object)parseArgs.getMarshallerMappingDir());
        Assert.assertTrue((boolean)parseArgs.isUnwrapBinary());
        Assert.assertTrue((boolean)parseArgs.getRecordTypes().contains(WALRecord.RecordType.DATA_RECORD_V2));
        Assert.assertTrue((boolean)parseArgs.getRecordTypes().contains(WALRecord.RecordType.TX_RECORD));
        Assert.assertEquals((long)1575158400000L, (long)parseArgs.getFromTime());
        Assert.assertEquals((long)1577836740999L, (long)parseArgs.getToTime());
        Assert.assertEquals((Object)"search string", (Object)parseArgs.hasText());
        Assert.assertEquals((Object)ProcessSensitiveData.HASH, (Object)parseArgs.includeSensitive());
        Assert.assertTrue((boolean)parseArgs.isPrintStat());
        Assert.assertTrue((boolean)parseArgs.isSkipCrc());
    }

    @Test
    public void testParsePageId() {
        String[] invalidValues;
        for (String v : invalidValues = new String[]{null, "", " ", "a", "a:", "a:b", "a:b", "a:1", "1:b", "1;1", "1a:1", "1:1b", "1:1:1"}) {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageId((String)v), IllegalArgumentException.class, null);
        }
        IgniteWalConverterArgumentsTest.assertEquals((Object)new T2((Object)1, (Object)1L), (Object)IgniteWalConverterArguments.parsePageId((String)"1:1"));
        IgniteWalConverterArgumentsTest.assertEquals((Object)new T2((Object)-1, (Object)1L), (Object)IgniteWalConverterArguments.parsePageId((String)"-1:1"));
        IgniteWalConverterArgumentsTest.assertEquals((Object)new T2((Object)1, (Object)-1L), (Object)IgniteWalConverterArguments.parsePageId((String)"1:-1"));
        IgniteWalConverterArgumentsTest.assertEquals((Object)new T2((Object)-1, (Object)-1L), (Object)IgniteWalConverterArguments.parsePageId((String)"-1:-1"));
    }

    @Test
    public void testParsePageIdsFile() throws Exception {
        File f = new File(System.getProperty("java.io.tmpdir"), "test");
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageIds((File)f), IllegalArgumentException.class, null);
            IgniteWalConverterArgumentsTest.assertTrue((boolean)f.createNewFile());
            IgniteWalConverterArgumentsTest.assertTrue((boolean)IgniteWalConverterArguments.parsePageIds((File)f).isEmpty());
            U.writeStringToFile((File)f, (String)"a:b", (String)Charset.defaultCharset().toString(), (boolean)false);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageIds((File)f), IllegalArgumentException.class, null);
            U.writeStringToFile((File)f, (String)"1:1,1:1", (String)Charset.defaultCharset().toString(), (boolean)false);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageIds((File)f), IllegalArgumentException.class, null);
            U.writeStringToFile((File)f, (String)"1:1", (String)Charset.defaultCharset().toString(), (boolean)false);
            IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object)new T2((Object)1, (Object)1L)), (Collection)IgniteWalConverterArguments.parsePageIds((File)f));
            U.writeStringToFile((File)f, (String)(U.nl() + "2:2"), (String)Charset.defaultCharset().toString(), (boolean)true);
            IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object[])new T2[]{new T2((Object)1, (Object)1L), new T2((Object)2, (Object)2L)}), (Collection)IgniteWalConverterArguments.parsePageIds((File)f));
            U.writeStringToFile((File)f, (String)(U.nl() + "-1:1"), (String)Charset.defaultCharset().toString(), (boolean)true);
            U.writeStringToFile((File)f, (String)(U.nl() + "1:-1"), (String)Charset.defaultCharset().toString(), (boolean)true);
            U.writeStringToFile((File)f, (String)(U.nl() + "-1:-1"), (String)Charset.defaultCharset().toString(), (boolean)true);
            IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object[])new T2[]{new T2((Object)1, (Object)1L), new T2((Object)2, (Object)2L), new T2((Object)-1, (Object)1L), new T2((Object)1, (Object)-1L), new T2((Object)-1, (Object)-1L)}), (Collection)IgniteWalConverterArguments.parsePageIds((File)f));
        }
        finally {
            IgniteWalConverterArgumentsTest.assertTrue((boolean)U.delete((File)f));
        }
    }

    @Test
    public void testParsePageIdsStrings() {
        IgniteWalConverterArgumentsTest.assertTrue((boolean)IgniteWalConverterArguments.parsePageIds((String[])new String[0]).isEmpty());
        GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageIds((String[])new String[]{"a:b"}), IllegalArgumentException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parsePageIds((String[])new String[]{"1:1", "a:b"}), IllegalArgumentException.class, null);
        IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object)new T2((Object)1, (Object)1L)), (Collection)IgniteWalConverterArguments.parsePageIds((String[])new String[]{"1:1"}));
        IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object[])new T2[]{new T2((Object)1, (Object)1L), new T2((Object)2, (Object)2L), new T2((Object)-1, (Object)1L), new T2((Object)1, (Object)-1L), new T2((Object)-1, (Object)-1L)}), (Collection)IgniteWalConverterArguments.parsePageIds((String[])new String[]{"1:1", "2:2", "-1:1", "1:-1", "-1:-1"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParsePagesArgument() throws IOException {
        File walDir = new File(System.getProperty("java.io.tmpdir"), "walDir");
        try {
            IgniteWalConverterArgumentsTest.assertTrue((boolean)walDir.mkdir());
            String[] args = new String[]{"--wal-dir", walDir.getAbsolutePath(), "--pages", null};
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            args[3] = "1";
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parse((PrintStream)ps, (String[])args), IllegalArgumentException.class, null);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parse((PrintStream)ps, (String[])new String[]{args[0], args[1], args[2]}), IgniteException.class, null);
            args[3] = "1:1";
            IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object)new T2((Object)1, (Object)1L)), (Collection)IgniteWalConverterArguments.parse((PrintStream)ps, (String[])args).getPages());
            File f = new File(System.getProperty("java.io.tmpdir"), "test");
            try {
                args[3] = f.getAbsolutePath();
                GridTestUtils.assertThrows((IgniteLogger)log, () -> IgniteWalConverterArguments.parse((PrintStream)ps, (String[])args), IllegalArgumentException.class, null);
                IgniteWalConverterArgumentsTest.assertTrue((boolean)f.createNewFile());
                IgniteWalConverterArgumentsTest.assertTrue((boolean)IgniteWalConverterArguments.parse((PrintStream)ps, (String[])args).getPages().isEmpty());
                U.writeStringToFile((File)f, (String)"1:1", (String)Charset.defaultCharset().toString(), (boolean)false);
                IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)F.asList((Object)new T2((Object)1, (Object)1L)), (Collection)IgniteWalConverterArguments.parse((PrintStream)ps, (String[])args).getPages());
            }
            finally {
                IgniteWalConverterArgumentsTest.assertTrue((boolean)U.delete((File)f));
            }
        }
        finally {
            IgniteWalConverterArgumentsTest.assertTrue((boolean)U.delete((File)walDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedPagesFile() throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), this.getName());
        try {
            int grpId = 10;
            long[] pageIds = new long[]{20L, 40L};
            File f = DiagnosticProcessor.corruptedPagesFile((Path)tmpDir.toPath(), (FileIOFactory)new RandomAccessFileIOFactory(), (int)grpId, (long[])pageIds);
            IgniteWalConverterArgumentsTest.assertTrue((boolean)f.exists());
            IgniteWalConverterArgumentsTest.assertTrue((boolean)f.isFile());
            IgniteWalConverterArgumentsTest.assertTrue((f.length() > 0L ? 1 : 0) != 0);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            IgniteWalConverterArguments args = IgniteWalConverterArguments.parse((PrintStream)ps, (String[])new String[]{"--wal-dir", tmpDir.getAbsolutePath(), "--pages", f.getAbsolutePath()});
            IgniteWalConverterArgumentsTest.assertNotNull((Object)args.getPages());
            IgniteWalConverterArgumentsTest.assertEqualsCollections((Collection)LongStream.of(pageIds).mapToObj(pageId -> new T2((Object)grpId, (Object)pageId)).collect(Collectors.toList()), (Collection)args.getPages());
        }
        finally {
            if (tmpDir.exists()) {
                IgniteWalConverterArgumentsTest.assertTrue((boolean)U.delete((File)tmpDir));
            }
        }
    }
}

