/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.tracing.configuration;

import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationOperation;
import org.jetbrains.annotations.Nullable;

public enum TracingConfigurationSubcommand {
    HELP("help", null),
    GET("get", VisorTracingConfigurationOperation.GET),
    GET_ALL("get_all", VisorTracingConfigurationOperation.GET_ALL),
    RESET("reset", VisorTracingConfigurationOperation.RESET),
    RESET_ALL("reset_all", VisorTracingConfigurationOperation.RESET_ALL),
    SET("set", VisorTracingConfigurationOperation.SET);

    private static final TracingConfigurationSubcommand[] VALS;
    private final String name;
    private final VisorTracingConfigurationOperation visorOperation;

    private TracingConfigurationSubcommand(String name, VisorTracingConfigurationOperation visorOperation) {
        this.name = name;
        this.visorOperation = visorOperation;
    }

    public static TracingConfigurationSubcommand of(String text) {
        for (TracingConfigurationSubcommand cmd : TracingConfigurationSubcommand.values()) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    public VisorTracingConfigurationOperation visorBaselineOperation() {
        return this.visorOperation;
    }

    @Nullable
    public static TracingConfigurationSubcommand fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALS = TracingConfigurationSubcommand.values();
    }
}

