/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrTopologyTaskResult;

public class DrTopologyCommand
extends DrAbstractRemoteSubCommand<VisorDrTopologyTaskArgs, VisorDrTopologyTaskResult, DrTopologyArguments> {
    public static final String SENDER_HUBS_PARAM = "--sender-hubs";
    public static final String RECEIVER_HUBS_PARAM = "--receiver-hubs";
    public static final String DATA_NODES_PARAM = "--data-nodes";
    public static final String OTHER_NODES_PARAM = "--other-nodes";

    @Override
    protected String visorTaskName() {
        return "org.gridgain.grid.internal.visor.dr.console.VisorDrTopologyTask";
    }

    @Override
    protected DrTopologyArguments parseArguments0(CommandArgIterator argIter) {
        String nextArg;
        boolean senderHubs = false;
        boolean receiverHubs = false;
        boolean dataNodes = false;
        boolean otherNodes = false;
        block12: while ((nextArg = argIter.peekNextArg()) != null) {
            switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                case "--sender-hubs": {
                    senderHubs = true;
                    break;
                }
                case "--receiver-hubs": {
                    receiverHubs = true;
                    break;
                }
                case "--data-nodes": {
                    dataNodes = true;
                    break;
                }
                case "--other-nodes": {
                    otherNodes = true;
                    break;
                }
                default: {
                    break block12;
                }
            }
            argIter.nextArg(null);
        }
        if (!(senderHubs || receiverHubs || dataNodes || otherNodes)) {
            otherNodes = true;
            dataNodes = true;
            receiverHubs = true;
            senderHubs = true;
        }
        return new DrTopologyArguments(senderHubs, receiverHubs, dataNodes, otherNodes);
    }

    @Override
    protected void printResult(VisorDrTopologyTaskResult res, Logger log) {
        log.info("Data Center ID: " + res.getDataCenterId());
        log.info(String.format("Topology: %d server(s), %d client(s)", res.getServerNodesCount(), res.getClientNodesCount()));
        if (res.getDataCenterId() == 0) {
            log.info("Data Replication state: is not configured.");
            return;
        }
        if (((DrTopologyArguments)this.arg()).dataNodes) {
            List dataNodes = res.getDataNodes();
            if (dataNodes.isEmpty()) {
                log.info("Data nodes: not found");
            } else {
                log.info("Data nodes: " + dataNodes.size());
            }
            for (T2 dataNode : dataNodes) {
                log.info(String.format("  nodeId=%s, Address=%s", dataNode.toArray()));
            }
            log.info("--------------------------------------------------------------------------------");
        }
        if (((DrTopologyArguments)this.arg()).senderHubs) {
            List senderHubs = res.getSenderHubs();
            if (senderHubs.isEmpty()) {
                log.info("Sender hubs: not found");
            } else {
                log.info("Sender hubs: " + senderHubs.size());
            }
            for (T3 senderHub : senderHubs) {
                log.info(String.format("  nodeId=%s, Address=%s, Mode=%s", senderHub.toArray()));
            }
            log.info("--------------------------------------------------------------------------------");
        }
        if (((DrTopologyArguments)this.arg()).receiverHubs) {
            List receiverHubs = res.getReceiverHubs();
            if (receiverHubs.isEmpty()) {
                log.info("Receiver hubs: not found");
            } else {
                log.info("Receiver hubs: " + receiverHubs.size());
            }
            for (T3 receiverHub : receiverHubs) {
                log.info(String.format("  nodeId=%s, Address=%s, Mode=%s", receiverHub.toArray()));
            }
            log.info("--------------------------------------------------------------------------------");
        }
        if (((DrTopologyArguments)this.arg()).otherNodes) {
            List otherNodes = res.getOtherNodes();
            if (otherNodes.isEmpty()) {
                log.info("Other nodes: not found");
            } else {
                log.info("Other nodes: " + otherNodes.size());
            }
            for (T3 otherNode : otherNodes) {
                log.info(String.format("  nodeId=%s, Address=%s, Mode=%s", otherNode.toArray()));
            }
            log.info("--------------------------------------------------------------------------------");
        }
        this.printUnrecognizedNodesMessage(log, true);
    }

    @Override
    public String name() {
        return DrSubCommandsList.TOPOLOGY.text();
    }

    public static class DrTopologyArguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrTopologyTaskArgs> {
        private final boolean senderHubs;
        private final boolean receiverHubs;
        private final boolean dataNodes;
        private final boolean otherNodes;

        public DrTopologyArguments(boolean senderHubs, boolean receiverHubs, boolean dataNodes, boolean otherNodes) {
            this.senderHubs = senderHubs;
            this.receiverHubs = receiverHubs;
            this.dataNodes = dataNodes;
            this.otherNodes = otherNodes;
        }

        @Override
        public VisorDrTopologyTaskArgs toVisorArgs() {
            int flags = 0;
            if (this.senderHubs) {
                flags |= 1;
            }
            if (this.receiverHubs) {
                flags |= 2;
            }
            if (this.dataNodes) {
                flags |= 4;
            }
            if (this.otherNodes) {
                flags |= 8;
            }
            return new VisorDrTopologyTaskArgs(flags);
        }
    }
}

