/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.shutdown.ShutdownPolicyArgument;
import org.apache.ignite.internal.commandline.util.TopologyUtils;
import org.apache.ignite.internal.visor.shutdown.VisorShutdownPolicyTask;
import org.apache.ignite.internal.visor.shutdown.VisorShutdownPolicyTaskArg;
import org.apache.ignite.internal.visor.shutdown.VisorShutdownPolicyTaskResult;

public class ShutdownPolicyCommand
extends AbstractCommand<ShutdownPolicyArgument> {
    private ShutdownPolicyArgument shutdownPolicyArgument;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            UUID coordinatorId = TopologyUtils.coordinatorId(client.compute());
            VisorShutdownPolicyTaskResult res = (VisorShutdownPolicyTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorShutdownPolicyTask.class.getName(), ShutdownPolicyCommand.toTaskArg(this.shutdownPolicyArgument), coordinatorId, clientCfg);
            logger.info("Cluster shutdown policy is " + res.getShutdown());
        }
        return null;
    }

    private static VisorShutdownPolicyTaskArg toTaskArg(ShutdownPolicyArgument arg) {
        return new VisorShutdownPolicyTaskArg(arg.getShutdown());
    }

    @Override
    public ShutdownPolicyArgument arg() {
        return this.shutdownPolicyArgument;
    }

    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Set or display shutdown policy:", CommandList.SHUTDOWN_POLICY, CommandLogger.optional(CommandLogger.join("|", ShutdownPolicy.values())));
    }

    @Override
    public String name() {
        return CommandList.SHUTDOWN_POLICY.toCommandName();
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.shutdownPolicyArgument = new ShutdownPolicyArgument.Builder().build();
            return;
        }
        ShutdownPolicyArgument.Builder builderArg = new ShutdownPolicyArgument.Builder();
        builderArg.setShutdownPolicy(ShutdownPolicy.valueOf((String)argIter.nextArg("Shutdown policy is expected")));
        this.shutdownPolicyArgument = builderArg.build();
    }
}

