/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.apache.ignite.util.KillCommandsTests;
import org.junit.Test;

public class KillCommandsControlShTest
extends GridCommandHandlerClusterByClassAbstractTest {
    private static List<IgniteEx> srvs;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        srvs = new ArrayList<IgniteEx>();
        for (int i = 0; i < 2; ++i) {
            srvs.add(this.grid(i));
        }
        IgniteCache cache = client.getOrCreateCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        for (int i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.awaitPartitionMapExchange();
    }

    @Override
    protected void afterTest() throws Exception {
    }

    @Test
    public void testCancelSQLQuery() {
        KillCommandsTests.doTestCancelSQLQuery((IgniteEx)client, qryId -> {
            int res = this.execute("--kill", "sql", (String)qryId);
            KillCommandsControlShTest.assertEquals((int)0, (int)res);
        });
    }

    @Test
    public void testCancelContinuousQuery() throws Exception {
        KillCommandsTests.doTestCancelContinuousQuery((IgniteEx)client, srvs, (nodeId, routineId) -> {
            int res = this.execute("--kill", "continuous", nodeId.toString(), routineId.toString());
            KillCommandsControlShTest.assertEquals((int)0, (int)res);
        });
    }

    @Test
    public void testCancelUnknownSQLQuery() {
        int res = this.execute("--kill", "sql", srvs.get(0).localNode().id().toString() + "_42");
        KillCommandsControlShTest.assertEquals((int)0, (int)res);
    }

    @Test
    public void testCancelUnknownContinuousQuery() {
        int res = this.execute("--kill", "continuous", srvs.get(0).localNode().id().toString(), UUID.randomUUID().toString());
        KillCommandsControlShTest.assertEquals((int)0, (int)res);
    }
}

