/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.util.GridCommandHandlerAbstractTest;

public abstract class GridCommandHandlerClusterByClassAbstractTest
extends GridCommandHandlerAbstractTest {
    protected static final int SERVER_NODE_CNT = 2;
    protected static IgniteEx crd;
    protected static IgniteEx client;

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        crd = this.startGrids(2);
        crd.cluster().baselineAutoAdjustEnabled(false);
        client = this.startGrid("client");
        crd.cluster().active(true);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        Set cfgCacheNames = Stream.of(crd.configuration().getCacheConfiguration()).map(CacheConfiguration::getName).filter(cacheName -> CacheType.cacheType((String)cacheName).userCache()).collect(Collectors.toSet());
        HashSet rmvCacheNames = new HashSet(crd.cacheNames());
        rmvCacheNames.removeAll(cfgCacheNames);
        crd.destroyCaches(rmvCacheNames);
        cfgCacheNames.stream().map(arg_0 -> ((IgniteEx)crd).cache(arg_0)).forEach(IgniteCache::removeAll);
    }
}

