/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.walconverter.IgniteWalConverter;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveDataUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testframework.wal.record.RecordUtils;
import org.apache.ignite.transactions.Transaction;
import org.junit.Test;

public class IgniteWalConverterSensitiveDataTest
extends GridCommonAbstractTest {
    private static final String SENSITIVE_DATA_VALUE_PREFIX = "must_hide_it_";
    private static String walDirPath;
    private static int pageSize;
    private static PrintStream sysOut;
    private static List<String> sensitiveValues;
    private static ByteArrayOutputStream testOut;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        sysOut = System.out;
        testOut = new ByteArrayOutputStream(16384);
        int nodeId = 0;
        IgniteEx crd = this.startGrid(nodeId);
        crd.cluster().active(true);
        try (Transaction tx = crd.transactions().txStart();){
            IgniteCache cache = crd.cache("default");
            sensitiveValues.add("must_hide_it_0");
            sensitiveValues.add("must_hide_it_1");
            sensitiveValues.add("must_hide_it_2");
            String val0 = sensitiveValues.get(0);
            String val1 = sensitiveValues.get(1);
            String val2 = sensitiveValues.get(2);
            cache.put((Object)val0, (Object)val0);
            cache.withKeepBinary().put((Object)val1, (Object)val1);
            cache.put((Object)val2, (Object)new Person(1, val2));
            tx.commit();
        }
        GridKernalContext kernalCtx = crd.context();
        IgniteWriteAheadLogManager wal = kernalCtx.cache().context().wal();
        for (WALRecord walRecord : this.withSensitiveData()) {
            if (!RecordUtils.isIncludeIntoLog((WALRecord)walRecord)) continue;
            wal.log(walRecord);
        }
        sensitiveValues.add(SENSITIVE_DATA_VALUE_PREFIX);
        wal.flush(null, true);
        IgniteConfiguration cfg = crd.configuration();
        String wd = cfg.getWorkDirectory();
        String wp = cfg.getDataStorageConfiguration().getWalPath();
        String fn = kernalCtx.pdsFolderResolver().resolveFolders().folderName();
        walDirPath = wd + File.separator + wp + File.separator + fn;
        pageSize = cfg.getDataStorageConfiguration().getPageSize();
        this.stopGrid(nodeId);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.clearGridToStringClassCache();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        log.info("Test output for " + this.currentTestMethod());
        log.info("----------------------------------------");
        System.setOut(sysOut);
        log.info(testOut.toString());
        this.resetTestOut();
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setQueryEntities(Arrays.asList(this.personQueryEntity()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    @Test
    public void testSensitiveDataByDefaultMd5() {
        this.exeWithCheck(null, true, false, ProcessSensitiveDataUtils::md5);
    }

    @Test
    public void testShowSensitiveData() {
        this.exeWithCheck(ProcessSensitiveData.SHOW, true, true, Function.identity());
    }

    @Test
    public void testHideSensitiveData() {
        this.exeWithCheck(ProcessSensitiveData.HIDE, false, false, Function.identity());
    }

    @Test
    public void testHashSensitiveData() {
        this.exeWithCheck(ProcessSensitiveData.HASH, true, false, s -> String.valueOf(s.hashCode()));
    }

    @Test
    public void testMd5HashSensitiveData() {
        this.exeWithCheck(ProcessSensitiveData.MD5, true, false, ProcessSensitiveDataUtils::md5);
    }

    private void exeWithCheck(ProcessSensitiveData processSensitiveData, boolean containsData, boolean containsPrefix, Function<String, String> converter) {
        Objects.requireNonNull(converter);
        this.injectTestSystemOut();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--page-size");
        args.add(String.valueOf(pageSize));
        args.add("--wal-dir");
        args.add(walDirPath);
        if (processSensitiveData != null) {
            args.add("--include-sensitive");
            args.add(processSensitiveData.name());
        }
        IgniteWalConverter.main((String[])args.toArray(new String[args.size()]));
        String testOutStr = testOut.toString();
        if (containsPrefix) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOutStr, (String)SENSITIVE_DATA_VALUE_PREFIX);
        } else {
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOutStr, (String)SENSITIVE_DATA_VALUE_PREFIX);
        }
        for (String sensitiveDataValue : sensitiveValues) {
            if (containsData) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)testOutStr, (String)converter.apply(sensitiveDataValue));
                continue;
            }
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOutStr, (String)converter.apply(sensitiveDataValue));
        }
    }

    private void injectTestSystemOut() {
        System.setOut(new PrintStream(testOut));
    }

    private void resetTestOut() {
        testOut.reset();
    }

    private Collection<WALRecord> withSensitiveData() {
        ArrayList<WALRecord> walRecords = new ArrayList<WALRecord>();
        int cacheId = CU.cacheId((String)"default");
        DataEntry dataEntry = new DataEntry(cacheId, (KeyCacheObject)new KeyCacheObjectImpl((Object)SENSITIVE_DATA_VALUE_PREFIX, null, 0), (CacheObject)new CacheObjectImpl((Object)SENSITIVE_DATA_VALUE_PREFIX, null), GridCacheOperation.CREATE, new GridCacheVersion(), new GridCacheVersion(), 0L, 0, 0L, 0);
        byte[] sensitiveDataBytes = SENSITIVE_DATA_VALUE_PREFIX.getBytes(StandardCharsets.UTF_8);
        walRecords.add((WALRecord)new DataRecord(dataEntry));
        walRecords.add((WALRecord)new MetastoreDataRecord(SENSITIVE_DATA_VALUE_PREFIX, sensitiveDataBytes));
        return walRecords;
    }

    private QueryEntity personQueryEntity() {
        String orgIdField = "orgId";
        String nameField = "name";
        return new QueryEntity().setKeyType(String.class.getName()).setValueType(Person.class.getName()).addQueryField(orgIdField, Integer.class.getName(), null).addQueryField(nameField, String.class.getName(), null).setIndexes(Arrays.asList(new QueryIndex(nameField), new QueryIndex(orgIdField)));
    }

    static {
        sensitiveValues = new ArrayList<String>();
    }

    private static class Person
    implements Serializable {
        int orgId;
        String name;

        Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

