/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.commandline.BaselineCommand;
import org.apache.ignite.internal.commandline.ClusterChangeIdCommand;
import org.apache.ignite.internal.commandline.ClusterChangeTagCommand;
import org.apache.ignite.internal.commandline.ClusterStateChangeCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommonArgParser;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.internal.commandline.ShutdownPolicyCommand;
import org.apache.ignite.internal.commandline.TxCommands;
import org.apache.ignite.internal.commandline.WalCommands;
import org.apache.ignite.internal.commandline.baseline.BaselineArguments;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.CacheValidateIndexes;
import org.apache.ignite.internal.commandline.cache.FindAndDeleteGarbage;
import org.apache.ignite.internal.commandline.cache.argument.FindAndDeleteGarbageArg;
import org.apache.ignite.internal.commandline.cache.argument.ValidateIndexesCommandArg;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesRule;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="true")
public class CommandHandlerParsingTest {
    @ClassRule
    public static final TestRule classRule = new SystemPropertiesRule();
    private static final String INVALID_REGEX = "[]";
    @Rule
    public final TestRule methodRule = new SystemPropertiesRule();

    @Test
    public void testValidateIndexArguments() {
        try {
            int expectedCheckFirst = 10;
            int expectedCheckThrough = 11;
            UUID nodeId = UUID.randomUUID();
            ConnectionAndSslParameters args = this.parseArgs(Arrays.asList(CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), "cache1, cache2", nodeId.toString(), ValidateIndexesCommandArg.CHECK_FIRST.toString(), Integer.toString(expectedCheckFirst), ValidateIndexesCommandArg.CHECK_THROUGH.toString(), Integer.toString(expectedCheckThrough)));
            Assert.assertTrue((boolean)(args.command() instanceof CacheCommands));
            CacheSubcommands subcommand = ((CacheCommands)args.command()).arg();
            CacheValidateIndexes.Arguments arg = (CacheValidateIndexes.Arguments)subcommand.subcommand().arg();
            Assert.assertEquals((String)"nodeId parameter unexpected value", (Object)nodeId, (Object)arg.nodeId());
            Assert.assertEquals((String)"checkFirst parameter unexpected value", (long)expectedCheckFirst, (long)arg.checkFirst());
            Assert.assertEquals((String)"checkThrough parameter unexpected value", (long)expectedCheckThrough, (long)arg.checkThrough());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unexpected exception: " + e));
        }
        try {
            int expectedParam = 11;
            UUID nodeId = UUID.randomUUID();
            ConnectionAndSslParameters args = this.parseArgs(Arrays.asList(CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), nodeId.toString(), ValidateIndexesCommandArg.CHECK_THROUGH.toString(), Integer.toString(expectedParam)));
            Assert.assertTrue((boolean)(args.command() instanceof CacheCommands));
            CacheSubcommands subcommand = ((CacheCommands)args.command()).arg();
            CacheValidateIndexes.Arguments arg = (CacheValidateIndexes.Arguments)subcommand.subcommand().arg();
            Assert.assertNull((String)"caches weren't specified, null value expected", (Object)arg.caches());
            Assert.assertEquals((String)"nodeId parameter unexpected value", (Object)nodeId, (Object)arg.nodeId());
            Assert.assertEquals((String)"checkFirst parameter unexpected value", (long)-1L, (long)arg.checkFirst());
            Assert.assertEquals((String)"checkThrough parameter unexpected value", (long)expectedParam, (long)arg.checkThrough());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.assertParseArgsThrows("Value for '--check-first' property should be positive.", CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), ValidateIndexesCommandArg.CHECK_FIRST.toString(), "0");
        this.assertParseArgsThrows("Numeric value for '--check-through' parameter expected.", CommandList.CACHE.text(), CacheSubcommands.VALIDATE_INDEXES.text(), ValidateIndexesCommandArg.CHECK_THROUGH.toString());
    }

    @Test
    public void testFindAndDeleteGarbage() {
        String nodeId = UUID.randomUUID().toString();
        String delete = FindAndDeleteGarbageArg.DELETE.toString();
        String groups = "group1,grpoup2,group3";
        List<List<String>> lists = this.generateArgumentList(CacheSubcommands.FIND_AND_DELETE_GARBAGE.text(), new T2((Object)nodeId, (Object)false), new T2((Object)delete, (Object)false), new T2((Object)groups, (Object)false));
        for (List<String> list : lists) {
            ConnectionAndSslParameters args = this.parseArgs(list);
            Assert.assertTrue((boolean)(args.command() instanceof CacheCommands));
            CacheSubcommands subcommand = ((CacheCommands)args.command()).arg();
            FindAndDeleteGarbage.Arguments arg = (FindAndDeleteGarbage.Arguments)subcommand.subcommand().arg();
            if (list.contains(nodeId)) {
                Assert.assertEquals((String)"nodeId parameter unexpected value", (Object)nodeId, (Object)arg.nodeId().toString());
            } else {
                Assert.assertNull((Object)arg.nodeId());
            }
            Assert.assertEquals((Object)list.contains(delete), (Object)arg.delete());
            if (list.contains(groups)) {
                Assert.assertEquals((long)3L, (long)arg.groups().size());
                continue;
            }
            Assert.assertNull((Object)arg.groups());
        }
    }

    private List<List<String>> generateArgumentList(String subcommand, T2<String, Boolean> ... optional) {
        List<List<T2>> lists = this.generateAllCombinations(Arrays.asList(optional), x -> (Boolean)x.get2());
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<String> empty = new ArrayList<String>();
        empty.add(CommandList.CACHE.text());
        empty.add(subcommand);
        res.add(empty);
        for (List<T2> list : lists) {
            ArrayList arg = new ArrayList(empty);
            list.forEach(x -> arg.add(x.get1()));
            res.add(arg);
        }
        return res;
    }

    private <T> List<List<T>> generateAllCombinations(List<T> source, Predicate<T> stopFunc) {
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        for (int i = 0; i < source.size(); ++i) {
            ArrayList<T> sourceCopy = new ArrayList<T>(source);
            Object removed = sourceCopy.remove(i);
            this.generateAllCombinations(Collections.singletonList(removed), sourceCopy, stopFunc, res);
        }
        return res;
    }

    private <T> void generateAllCombinations(List<T> res, List<T> source, Predicate<T> stopFunc, List<List<T>> acc) {
        acc.add(res);
        if (stopFunc != null && stopFunc.test(res.get(res.size() - 1))) {
            return;
        }
        if (source.size() == 1) {
            ArrayList<T> list = new ArrayList<T>(res);
            list.add(source.get(0));
            acc.add(list);
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            ArrayList<T> res0 = new ArrayList<T>(res);
            ArrayList<T> sourceCopy = new ArrayList<T>(source);
            Object removed = sourceCopy.remove(i);
            res0.add(removed);
            this.generateAllCombinations(res0, sourceCopy, stopFunc, acc);
        }
    }

    @Test
    public void testParseAndValidateSSLArguments() {
        for (CommandList cmd : CommandList.values()) {
            if (this.requireArgs(cmd)) continue;
            this.assertParseArgsThrows("Expected SSL trust store path", "--truststore");
            ConnectionAndSslParameters args = this.parseArgs(Arrays.asList("--keystore", "testKeystore", "--keystore-password", "testKeystorePassword", "--keystore-type", "testKeystoreType", "--truststore", "testTruststore", "--truststore-password", "testTruststorePassword", "--truststore-type", "testTruststoreType", "--ssl-key-algorithm", "testSSLKeyAlgorithm", "--ssl-protocol", "testSSLProtocol", cmd.text()));
            Assert.assertEquals((Object)"testSSLProtocol", (Object)args.sslProtocol());
            Assert.assertEquals((Object)"testSSLKeyAlgorithm", (Object)args.sslKeyAlgorithm());
            Assert.assertEquals((Object)"testKeystore", (Object)args.sslKeyStorePath());
            Assert.assertArrayEquals((char[])"testKeystorePassword".toCharArray(), (char[])args.sslKeyStorePassword());
            Assert.assertEquals((Object)"testKeystoreType", (Object)args.sslKeyStoreType());
            Assert.assertEquals((Object)"testTruststore", (Object)args.sslTrustStorePath());
            Assert.assertArrayEquals((char[])"testTruststorePassword".toCharArray(), (char[])args.sslTrustStorePassword());
            Assert.assertEquals((Object)"testTruststoreType", (Object)args.sslTrustStoreType());
            Assert.assertEquals((Object)cmd.command(), (Object)args.command());
        }
    }

    @Test
    public void testParseAndValidateUserAndPassword() {
        for (CommandList cmd : CommandList.values()) {
            if (this.requireArgs(cmd)) continue;
            this.assertParseArgsThrows("Expected user name", "--user");
            this.assertParseArgsThrows("Expected password", "--password");
            ConnectionAndSslParameters args = this.parseArgs(Arrays.asList("--user", "testUser", "--password", "testPass", cmd.text()));
            Assert.assertEquals((Object)"testUser", (Object)args.userName());
            Assert.assertEquals((Object)"testPass", (Object)args.password());
            Assert.assertEquals((Object)cmd.command(), (Object)args.command());
        }
    }

    @Test
    public void testParseAndValidateWalActions() {
        ConnectionAndSslParameters args = this.parseArgs(Arrays.asList(CommandList.WAL.text(), "print"));
        Assert.assertEquals((Object)CommandList.WAL.command(), (Object)args.command());
        T2 arg = ((WalCommands)args.command()).arg();
        Assert.assertEquals((Object)"print", (Object)arg.get1());
        String nodes = UUID.randomUUID().toString() + "," + UUID.randomUUID().toString();
        args = this.parseArgs(Arrays.asList(CommandList.WAL.text(), "delete", nodes));
        arg = ((WalCommands)args.command()).arg();
        Assert.assertEquals((Object)"delete", (Object)arg.get1());
        Assert.assertEquals((Object)nodes, (Object)arg.get2());
        this.assertParseArgsThrows("Expected arguments for " + CommandList.WAL.text(), CommandList.WAL.text());
        String rnd = UUID.randomUUID().toString();
        this.assertParseArgsThrows("Unexpected action " + rnd + " for " + CommandList.WAL.text(), CommandList.WAL.text(), rnd);
    }

    @Test
    public void testParseShutdownPolicyParameters() {
        ConnectionAndSslParameters args = this.parseArgs(Arrays.asList(CommandList.SHUTDOWN_POLICY.text()));
        Assert.assertEquals((Object)CommandList.SHUTDOWN_POLICY.command(), (Object)args.command());
        Assert.assertNull((Object)((ShutdownPolicyCommand)args.command()).arg().getShutdown());
        for (ShutdownPolicy policy : ShutdownPolicy.values()) {
            args = this.parseArgs(Arrays.asList(CommandList.SHUTDOWN_POLICY.text(), String.valueOf(policy)));
            Assert.assertEquals((Object)CommandList.SHUTDOWN_POLICY.command(), (Object)args.command());
            Assert.assertSame((Object)policy, (Object)((ShutdownPolicyCommand)args.command()).arg().getShutdown());
        }
    }

    @Test
    public void testParseAutoConfirmationFlag() {
        block10: for (CommandList cmdL : CommandList.values()) {
            Command cmd = cmdL == CommandList.SET_STATE ? this.parseArgs(Arrays.asList(cmdL.text(), "ACTIVE")).command() : (cmdL == CommandList.ROLLING_UPGRADE ? this.parseArgs(Arrays.asList(cmdL.text(), "start")).command() : cmdL.command());
            if (cmd.confirmationPrompt() == null) continue;
            UUID uuid = UUID.fromString("11111111-1111-1111-1111-111111111111");
            ConnectionAndSslParameters args = cmdL == CommandList.CLUSTER_CHANGE_TAG ? this.parseArgs(Arrays.asList(cmdL.text(), "test_tag")) : (cmdL == CommandList.CLUSTER_CHANGE_ID ? this.parseArgs(Arrays.asList(cmdL.text(), uuid.toString())) : (cmdL == CommandList.SET_STATE ? this.parseArgs(Arrays.asList(cmdL.text(), "ACTIVE")) : (cmdL == CommandList.ROLLING_UPGRADE ? this.parseArgs(Arrays.asList(cmdL.text(), "start")) : (cmdL == CommandList.WARM_UP ? this.parseArgs(Arrays.asList(cmdL.text(), "--stop")) : this.parseArgs(Arrays.asList(cmdL.text()))))));
            this.checkCommonParametersCorrectlyParsed(cmdL, args, false);
            switch (cmdL) {
                case ROLLING_UPGRADE: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), "start", "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    continue block10;
                }
                case DEACTIVATE: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    continue block10;
                }
                case SET_STATE: {
                    for (String newState : Arrays.asList("ACTIVE_READ_ONLY", "ACTIVE", "INACTIVE")) {
                        args = this.parseArgs(Arrays.asList(cmdL.text(), newState, "--yes"));
                        this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                        ClusterState argState = ((ClusterStateChangeCommand)args.command()).arg();
                        Assert.assertEquals((Object)newState, (Object)argState.toString());
                    }
                    continue block10;
                }
                case BASELINE: {
                    for (String baselineAct : Arrays.asList("add", "remove", "set")) {
                        args = this.parseArgs(Arrays.asList(cmdL.text(), baselineAct, "c_id1,c_id2", "--yes"));
                        this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                        BaselineArguments arg = ((BaselineCommand)args.command()).arg();
                        Assert.assertEquals((Object)baselineAct, (Object)arg.getCmd().text());
                        Assert.assertEquals(new HashSet<String>(Arrays.asList("c_id1", "c_id2")), new HashSet(arg.getConsistentIds()));
                    }
                    continue block10;
                }
                case TX: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), "--xid", "xid1", "--min-duration", "10", "--kill", "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    VisorTxTaskArg txTaskArg = ((TxCommands)args.command()).arg();
                    Assert.assertEquals((Object)"xid1", (Object)txTaskArg.getXid());
                    Assert.assertEquals((long)10000L, (long)txTaskArg.getMinDuration());
                    Assert.assertEquals((Object)VisorTxOperation.KILL, (Object)txTaskArg.getOperation());
                    continue block10;
                }
                case CLUSTER_CHANGE_ID: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), uuid.toString(), "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    Assert.assertEquals((Object)uuid, (Object)((ClusterChangeIdCommand)args.command()).arg());
                    continue block10;
                }
                case CLUSTER_CHANGE_TAG: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), "test_tag", "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    Assert.assertEquals((Object)"test_tag", (Object)((ClusterChangeTagCommand)args.command()).arg());
                    continue block10;
                }
                case WARM_UP: {
                    args = this.parseArgs(Arrays.asList(cmdL.text(), "--stop", "--yes"));
                    this.checkCommonParametersCorrectlyParsed(cmdL, args, true);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Unknown command: " + cmdL));
                }
            }
        }
    }

    private void checkCommonParametersCorrectlyParsed(CommandList cmd, ConnectionAndSslParameters args, boolean autoConfirm) {
        Assert.assertEquals((Object)cmd.command(), (Object)args.command());
        Assert.assertEquals((Object)"127.0.0.1", (Object)args.host());
        Assert.assertEquals((Object)"11211", (Object)args.port());
        Assert.assertEquals((Object)autoConfirm, (Object)args.autoConfirmation());
    }

    @Test
    public void testConnectionSettings() {
        for (CommandList cmd : CommandList.values()) {
            if (this.requireArgs(cmd)) continue;
            ConnectionAndSslParameters args = this.parseArgs(Arrays.asList(cmd.text()));
            Assert.assertEquals((Object)cmd.command(), (Object)args.command());
            Assert.assertEquals((Object)"127.0.0.1", (Object)args.host());
            Assert.assertEquals((Object)"11211", (Object)args.port());
            args = this.parseArgs(Arrays.asList("--port", "12345", "--host", "test-host", "--ping-interval", "5000", "--ping-timeout", "40000", "--connection-timeout", "1000", cmd.text()));
            Assert.assertEquals((Object)cmd.command(), (Object)args.command());
            Assert.assertEquals((Object)"test-host", (Object)args.host());
            Assert.assertEquals((Object)"12345", (Object)args.port());
            Assert.assertEquals((long)5000L, (long)args.pingInterval());
            Assert.assertEquals((long)40000L, (long)args.pingTimeout());
            Assert.assertEquals((long)1000L, (long)args.connectionTimeout());
            this.assertParseArgsThrows("Invalid value for port: wrong-port", "--port", "wrong-port", cmd.text());
            this.assertParseArgsThrows("Invalid value for ping interval: -10", "--ping-interval", "-10", cmd.text());
            this.assertParseArgsThrows("Invalid value for ping timeout: -20", "--ping-timeout", "-20", cmd.text());
            this.assertParseArgsThrows("Invalid value for connection timeout: -30", "--connection-timeout", "-30", cmd.text());
        }
    }

    @Test
    public void testTransactionArguments() {
        this.parseArgs(Arrays.asList("--tx"));
        this.assertParseArgsThrows("Expecting --min-duration", "--tx", "--min-duration");
        this.assertParseArgsThrows("Invalid value for --min-duration: -1", "--tx", "--min-duration", "-1");
        this.assertParseArgsThrows("Expecting --min-size", "--tx", "--min-size");
        this.assertParseArgsThrows("Invalid value for --min-size: -1", "--tx", "--min-size", "-1");
        this.assertParseArgsThrows("--label", "--tx", "--label");
        this.assertParseArgsThrows("Illegal regex syntax", "--tx", "--label", "tx123[");
        this.assertParseArgsThrows("Projection can't be used together with list of consistent ids.", "--tx", "--servers", "--nodes", "1,2,3");
        ConnectionAndSslParameters args = this.parseArgs(Arrays.asList("--tx", "--min-duration", "120", "--min-size", "10", "--limit", "100", "--order", "SIZE", "--servers"));
        VisorTxTaskArg arg = ((TxCommands)args.command()).arg();
        Assert.assertEquals((Object)120000L, (Object)arg.getMinDuration());
        Assert.assertEquals((Object)10, (Object)arg.getMinSize());
        Assert.assertEquals((Object)100, (Object)arg.getLimit());
        Assert.assertEquals((Object)VisorTxSortOrder.SIZE, (Object)arg.getSortOrder());
        Assert.assertEquals((Object)VisorTxProjection.SERVER, (Object)arg.getProjection());
        args = this.parseArgs(Arrays.asList("--tx", "--min-duration", "130", "--min-size", "1", "--limit", "60", "--order", "DURATION", "--clients"));
        arg = ((TxCommands)args.command()).arg();
        Assert.assertEquals((Object)130000L, (Object)arg.getMinDuration());
        Assert.assertEquals((Object)1, (Object)arg.getMinSize());
        Assert.assertEquals((Object)60, (Object)arg.getLimit());
        Assert.assertEquals((Object)VisorTxSortOrder.DURATION, (Object)arg.getSortOrder());
        Assert.assertEquals((Object)VisorTxProjection.CLIENT, (Object)arg.getProjection());
        args = this.parseArgs(Arrays.asList("--tx", "--nodes", "1,2,3"));
        arg = ((TxCommands)args.command()).arg();
        Assert.assertNull((Object)arg.getProjection());
        Assert.assertEquals(Arrays.asList("1", "2", "3"), (Object)arg.getConsistentIds());
    }

    @Test
    public void testKillArguments() {
        this.assertParseArgsThrows("Expected type of resource to kill.", "--kill");
        String uuid = UUID.randomUUID().toString();
        this.assertParseArgsThrows("Expected SQL query id.", "--kill", "sql");
        this.assertParseArgsThrows("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'", "--kill", "sql", "not_sql_id");
        this.assertParseArgsThrows("Expected query originating node id.", "--kill", "continuous");
        this.assertParseArgsThrows("Expected continuous query id.", "--kill", "continuous", UUID.randomUUID().toString());
        this.assertParseArgsThrows("Invalid UUID string: not_a_uuid", IllegalArgumentException.class, "--kill", "continuous", "not_a_uuid");
        this.assertParseArgsThrows("Invalid UUID string: not_a_uuid", IllegalArgumentException.class, "--kill", "continuous", UUID.randomUUID().toString(), "not_a_uuid");
    }

    @Test
    public void testValidateIndexesNotAllowedForSystemCache() {
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "validate_indexes", "cache1,ignite-sys-cache")), IllegalArgumentException.class, (String)"validate_indexes not allowed for 'ignite-sys-cache' cache.");
    }

    @Test
    public void testIdleVerifyWithCheckCrcNotAllowedForSystemCache() {
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "idle_verify", "--check-crc", "--cache-filter", "ALL")), IllegalArgumentException.class, (String)"idle_verify with --check-crc and --cache-filter ALL or SYSTEM not allowed. You should remove --check-crc or change --cache-filter value.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "idle_verify", "--check-crc", "--cache-filter", "SYSTEM")), IllegalArgumentException.class, (String)"idle_verify with --check-crc and --cache-filter ALL or SYSTEM not allowed. You should remove --check-crc or change --cache-filter value.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "idle_verify", "--check-crc", "ignite-sys-cache")), IllegalArgumentException.class, (String)"idle_verify with --check-crc not allowed for `ignite-sys-cache` cache.");
    }

    @Test
    public void testIndexForceRebuildWrongArgs() {
        String nodeId = UUID.randomUUID().toString();
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id")), IllegalArgumentException.class, (String)"Failed to read node id.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--cache-names")), IllegalArgumentException.class, (String)"Expected comma-separated list of cache names.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--group-names")), IllegalArgumentException.class, (String)"Expected comma-separated list of cache group names.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--group-names", "someNames", "--cache-names", "someNames")), IllegalArgumentException.class, (String)"Either --group-names or --cache-names must be specified.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--cache-names", "someNames", "--cache-names", "someMoreNames")), IllegalArgumentException.class, (String)"--cache-names arg specified twice.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--group-names", "someNames", "--group-names", "someMoreNames")), IllegalArgumentException.class, (String)"--group-names arg specified twice.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--group-names", "--some-other-arg")), IllegalArgumentException.class, (String)"--group-names not specified.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_force_rebuild", "--node-id", nodeId, "--cache-names", "--some-other-arg")), IllegalArgumentException.class, (String)"--cache-names not specified.");
    }

    @Test
    public void testIndexListWrongArgs() {
        String nodeId = UUID.randomUUID().toString();
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id")), IllegalArgumentException.class, (String)"Failed to read node id.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--group-name")), IllegalArgumentException.class, (String)"Failed to read group name regex.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--group-name", INVALID_REGEX)), IllegalArgumentException.class, (String)"Invalid group name regex: []");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--cache-name")), IllegalArgumentException.class, (String)"Failed to read cache name regex.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--cache-name", INVALID_REGEX)), IllegalArgumentException.class, (String)"Invalid cache name regex: []");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--index-name")), IllegalArgumentException.class, (String)"Failed to read index name regex.");
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id", nodeId, "--index-name", INVALID_REGEX)), IllegalArgumentException.class, (String)"Invalid index name regex: []");
    }

    @Test
    public void testIndexRebuildStatusWrongArgs() {
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList("--cache", "indexes_list", "--node-id")), IllegalArgumentException.class, (String)"Failed to read node id.");
    }

    @Test
    public void testPartitionReconciliationArgumentsValidation() {
        this.assertParseArgsThrows("The repair algorithm should be specified. The following values can be used: " + Arrays.toString(RepairAlgorithm.values()) + '.', "--cache", "partition_reconciliation", "--repair");
        this.assertParseArgsThrows("Invalid repair algorithm: invalid-repair-alg. The following values can be used: " + Arrays.toString(RepairAlgorithm.values()) + '.', "--cache", "partition_reconciliation", "--repair", "invalid-repair-alg");
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--fix-alg", "PRIMARY"));
        this.assertParseArgsThrows("The parallelism level should be specified.", "--cache", "partition_reconciliation", "--parallelism");
        this.assertParseArgsThrows(String.format("The positive integer should be specified, or 0 (number of cores on a server node will be used as parallelism in such case). If the given value is greater than the number of cores on a server node, the behavior will be equal to the case when 0 is specified.", "abc"), "--cache", "partition_reconciliation", "--parallelism", "abc");
        this.assertParseArgsThrows(String.format("The positive integer should be specified, or 0 (number of cores on a server node will be used as parallelism in such case). If the given value is greater than the number of cores on a server node, the behavior will be equal to the case when 0 is specified.", "0.5"), "--cache", "partition_reconciliation", "--parallelism", "0.5");
        this.assertParseArgsThrows(String.format("The positive integer should be specified, or 0 (number of cores on a server node will be used as parallelism in such case). If the given value is greater than the number of cores on a server node, the behavior will be equal to the case when 0 is specified.", "-1"), "--cache", "partition_reconciliation", "--parallelism", "-1");
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--parallelism", "8"));
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--parallelism", "1"));
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--parallelism", "0"));
        this.assertParseArgsThrows("The batch size should be specified.", "--cache", "partition_reconciliation", "--batch-size");
        this.assertParseArgsThrows("Invalid batch size: abc. Integer value greater than zero should be used.", "--cache", "partition_reconciliation", "--batch-size", "abc");
        this.assertParseArgsThrows("Invalid batch size: 0. Integer value greater than zero should be used.", "--cache", "partition_reconciliation", "--batch-size", "0");
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--batch-size", "10"));
        this.assertParseArgsThrows("The recheck attempts should be specified.", "--cache", "partition_reconciliation", "--recheck-attempts");
        this.assertParseArgsThrows("Invalid recheck attempts: abc. Integer value between 1 (inclusive) and 5 (exclusive) should be used.", "--cache", "partition_reconciliation", "--recheck-attempts", "abc");
        this.assertParseArgsThrows("Invalid recheck attempts: 6. Integer value between 1 (inclusive) and 5 (exclusive) should be used.", "--cache", "partition_reconciliation", "--recheck-attempts", "6");
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--recheck-attempts", "1"));
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--recheck-attempts", "5"));
        this.assertParseArgsThrows("The recheck delay should be specified.", "--cache", "partition_reconciliation", "--recheck-delay");
        this.assertParseArgsThrows("Invalid recheck delay: abc. Integer value between 0 (inclusive) and 100 (exclusive) should be used.", "--cache", "partition_reconciliation", "--recheck-delay", "abc");
        this.assertParseArgsThrows("Invalid recheck delay: 101. Integer value between 0 (inclusive) and 100 (exclusive) should be used.", "--cache", "partition_reconciliation", "--recheck-delay", "101");
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--recheck-delay", "0"));
        this.parseArgs(Arrays.asList("--cache", "partition_reconciliation", "--recheck-delay", "50"));
    }

    @Test
    public void testTracingConfigurationArgumentsValidation() {
        this.assertParseArgsThrows("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "reset", "--scope");
        this.assertParseArgsThrows("Invalid scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "reset", "--scope", "aaa");
        this.assertParseArgsThrows("The label should be specified.", "--tracing-configuration", "reset", "--label");
        this.assertParseArgsThrows("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "reset_all", "--scope");
        this.assertParseArgsThrows("Invalid scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "reset_all", "--scope", "aaa");
        this.assertParseArgsThrows("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "get", "--scope");
        this.assertParseArgsThrows("Invalid scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "get", "--scope", "aaa");
        this.assertParseArgsThrows("The label should be specified.", "--tracing-configuration", "get", "--label");
        this.assertParseArgsThrows("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "get_all", "--scope");
        this.assertParseArgsThrows("Invalid scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "get_all", "--scope", "aaa");
        this.assertParseArgsThrows("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "set", "--scope");
        this.assertParseArgsThrows("Invalid scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "set", "--scope", "aaa");
        this.assertParseArgsThrows("The label should be specified.", "--tracing-configuration", "set", "--label");
        this.assertParseArgsThrows("The sampling rate should be specified. Decimal value between 0 and 1 should be used.", "--tracing-configuration", "set", "--sampling-rate");
        this.assertParseArgsThrows("Invalid sampling-rate 'aaa'. Decimal value between 0 and 1 should be used.", "--tracing-configuration", "set", "--sampling-rate", "aaa");
        this.assertParseArgsThrows("Invalid sampling-rate '-1'. Decimal value between 0 and 1 should be used.", "--tracing-configuration", "set", "--sampling-rate", "-1");
        this.assertParseArgsThrows("Invalid sampling-rate '2'. Decimal value between 0 and 1 should be used.", "--tracing-configuration", "set", "--sampling-rate", "2");
        this.assertParseArgsThrows("At least one supported scope should be specified.", "--tracing-configuration", "set", "--included-scopes");
        this.assertParseArgsThrows("Invalid supported scope 'aaa'. The following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "set", "--included-scopes", "TX,aaa");
    }

    @Test
    public void testTracingConfigurationArgumentsValidationMandatoryArgumentSet() {
        this.parseArgs(Arrays.asList("--tracing-configuration"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "get_all"));
        this.assertParseArgsThrows("Scope attribute is missing. Following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "reset");
        this.assertParseArgsThrows("Scope attribute is missing. Following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "get");
        this.assertParseArgsThrows("Scope attribute is missing. Following values can be used: " + Arrays.toString(Scope.values()) + '.', "--tracing-configuration", "set");
        this.parseArgs(Arrays.asList("--tracing-configuration", "set", "--scope", "DISCOVERY"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "set", "--scope", "discovery"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "set", "--scope", "Discovery"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "get", "--scope", "TX"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "get", "--scope", "tx"));
        this.parseArgs(Arrays.asList("--tracing-configuration", "get", "--scope", "Tx"));
    }

    @Test
    public void testParseVerboseOption() {
        for (CommandList cmd : CommandList.values()) {
            if (this.requireArgs(cmd)) continue;
            Assert.assertFalse((String)cmd.toString(), (boolean)this.parseArgs(Collections.singletonList(cmd.text())).verbose());
            Assert.assertTrue((String)cmd.toString(), (boolean)this.parseArgs(Arrays.asList(cmd.text(), "--verbose")).verbose());
        }
    }

    @Test
    public void testWarmUpArgs() {
        String[][] args;
        for (String[] arg : args = new String[][]{{"--warm-up"}, {"--warm-up", "1"}, {"--warm-up", "stop"}}) {
            GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList(arg)), IllegalArgumentException.class, (String)"--stop argument is missing.");
        }
        Assert.assertNotNull((Object)this.parseArgs(Arrays.asList("--warm-up", "--stop")));
    }

    private ConnectionAndSslParameters parseArgs(List<String> args) {
        return new CommonArgParser(this.setupTestLogger()).parseAndValidate(args.iterator());
    }

    private Logger setupTestLogger() {
        Logger result = Logger.getLogger(this.getClass().getName());
        result.setLevel(Level.INFO);
        result.setUseParentHandlers(false);
        result.addHandler(CommandHandler.setupStreamHandler());
        return result;
    }

    private void assertParseArgsThrows(@Nullable String failMsg, String ... args) {
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList(args)), IllegalArgumentException.class, (String)failMsg);
    }

    private void assertParseArgsThrows(@Nullable String failMsg, Class<? extends Exception> cls, String ... args) {
        GridTestUtils.assertThrows(null, () -> this.parseArgs(Arrays.asList(args)), cls, (String)failMsg);
    }

    private boolean requireArgs(@Nullable CommandList cmd) {
        return cmd == CommandList.CACHE || cmd == CommandList.WAL || cmd == CommandList.ROLLING_UPGRADE || cmd == CommandList.CLUSTER_CHANGE_TAG || cmd == CommandList.CLUSTER_CHANGE_ID || cmd == CommandList.DATA_CENTER_REPLICATION || cmd == CommandList.SET_STATE || cmd == CommandList.ENCRYPTION || cmd == CommandList.METADATA || cmd == CommandList.WARM_UP || cmd == CommandList.PROPERTY || cmd == CommandList.METRIC || cmd == CommandList.DEFRAGMENTATION || cmd == CommandList.KILL;
    }
}

