/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.commandline.walconverter.RecordSizeCountStat;
import org.apache.ignite.internal.commandline.walconverter.TxWalStat;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.transactions.TransactionState;

public class WalStat {
    static final int DISPLAY_MAX = 80;
    private TxWalStat txStat = new TxWalStat();
    private final Map<String, RecordSizeCountStat> segmentsFolder = new TreeMap<String, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> segmentsIndexes = new TreeMap<String, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> recTypeSizes = new TreeMap<String, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> dataRecordEntriesCnt = new TreeMap<Integer, RecordSizeCountStat>();
    private final Map<Boolean, RecordSizeCountStat> dataRecordUnderTx = new TreeMap<Boolean, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> dataEntryOperation = new TreeMap<String, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> dataEntryCacheId = new TreeMap<Integer, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> txRecordAct = new TreeMap<String, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> txRecordPrimNodesCnt = new TreeMap<Integer, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> txRecordNodesCnt = new TreeMap<Integer, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> pageSnapshotTypes = new TreeMap<String, RecordSizeCountStat>();
    private final Map<String, RecordSizeCountStat> pageSnapshotIndexes = new TreeMap<String, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> pageSnapshotCacheGrp = new TreeMap<Integer, RecordSizeCountStat>();
    private final Map<Integer, RecordSizeCountStat> pageSnapshotPartId = new TreeMap<Integer, RecordSizeCountStat>();

    private static <K> void incrementStat(K key, WALRecord record, Map<K, RecordSizeCountStat> map) {
        WalStat.incrementStat(key, map, record.size());
    }

    private static <K> void incrementStat(K key, Map<K, RecordSizeCountStat> map, int size) {
        RecordSizeCountStat val = map.get(key);
        RecordSizeCountStat recordStat = val == null ? new RecordSizeCountStat() : val;
        recordStat.occurrence(size);
        map.put(key, recordStat);
    }

    void registerRecord(WALRecord record, WALPointer walPointer, boolean workDir) {
        WALRecord.RecordType type = record.type();
        if (type == WALRecord.RecordType.PAGE_RECORD) {
            this.registerPageSnapshot((PageSnapshot)record);
        } else if (type == WALRecord.RecordType.DATA_RECORD || type == WALRecord.RecordType.DATA_RECORD_V2 || type == WALRecord.RecordType.MVCC_DATA_RECORD) {
            this.registerDataRecord((DataRecord)record);
        } else if (type == WALRecord.RecordType.TX_RECORD || type == WALRecord.RecordType.MVCC_TX_RECORD) {
            this.registerTxRecord((TxRecord)record);
        }
        WalStat.incrementStat(type.toString(), record, this.recTypeSizes);
        if (walPointer instanceof FileWALPointer) {
            FileWALPointer fPtr = (FileWALPointer)walPointer;
            WalStat.incrementStat(Long.toString(fPtr.index()), record, this.segmentsIndexes);
            WalStat.incrementStat(workDir ? "work" : "archive", record, this.segmentsFolder);
        }
    }

    private void registerTxRecord(TxRecord txRecord) {
        GridCacheVersion ver;
        TransactionState state = txRecord.state();
        WalStat.incrementStat(state.toString(), (WALRecord)txRecord, this.txRecordAct);
        int totalNodes = 0;
        Map map = txRecord.participatingNodes();
        if (map != null) {
            WalStat.incrementStat(Integer.valueOf(map.size()), (WALRecord)txRecord, this.txRecordPrimNodesCnt);
            HashSet set = new HashSet(150);
            for (Map.Entry next : map.entrySet()) {
                set.add(next.getKey());
                set.addAll((Collection)next.getValue());
            }
            totalNodes = set.size();
            WalStat.incrementStat(Integer.valueOf(totalNodes), (WALRecord)txRecord, this.txRecordNodesCnt);
        }
        if ((ver = txRecord.nearXidVersion()) != null) {
            switch (state) {
                case PREPARING: 
                case PREPARED: {
                    this.txStat.onTxPrepareStart(ver, map != null ? map.size() : 0, totalNodes);
                    break;
                }
                case COMMITTED: {
                    this.txStat.onTxEnd(ver, true);
                    break;
                }
                default: {
                    this.txStat.onTxEnd(ver, false);
                }
            }
        }
    }

    private void registerPageSnapshot(PageSnapshot record) {
        FullPageId fullPageId = record.fullPageId();
        long pageId = fullPageId.pageId();
        WalStat.incrementStat(WalStat.getPageType(record), (WALRecord)record, this.pageSnapshotTypes);
        int idx = PageIdUtils.pageIndex((long)pageId);
        String idxAsStr = idx <= 100 ? Integer.toString(idx) : ">100";
        WalStat.incrementStat(idxAsStr, (WALRecord)record, this.pageSnapshotIndexes);
        WalStat.incrementStat(Integer.valueOf(fullPageId.groupId()), (WALRecord)record, this.pageSnapshotCacheGrp);
        WalStat.incrementStat(Integer.valueOf(PageIdUtils.partId((long)pageId)), (WALRecord)record, this.pageSnapshotPartId);
    }

    private void registerDataRecord(DataRecord record) {
        List dataEntries = record.writeEntries();
        if (!dataEntries.isEmpty()) {
            boolean underTx = false;
            for (DataEntry next : dataEntries) {
                int size = dataEntries.size() > 1 ? -1 : record.size();
                WalStat.incrementStat(next.op().toString(), this.dataEntryOperation, size);
                WalStat.incrementStat(Integer.valueOf(next.cacheId()), this.dataEntryCacheId, size);
                this.txStat.onDataEntry(next);
                underTx |= next.nearXidVersion() != null;
            }
            WalStat.incrementStat(Boolean.valueOf(underTx), (WALRecord)record, this.dataRecordUnderTx);
        }
        WalStat.incrementStat(Integer.valueOf(dataEntries.size()), (WALRecord)record, this.dataRecordEntriesCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPageType(PageSnapshot record) {
        byte[] pageData = record.pageData();
        ByteBuffer buf = ByteBuffer.allocateDirect(pageData.length);
        try {
            buf.order(ByteOrder.nativeOrder());
            buf.put(pageData);
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            int type = PageIO.getType((long)addr);
            int ver = PageIO.getVersion((long)addr);
            String string = PageIO.getPageIO((int)type, (int)ver).getClass().getSimpleName();
            return string;
        }
        catch (IgniteCheckedException igniteCheckedException) {
        }
        finally {
            GridUnsafe.cleanDirectBuffer((ByteBuffer)buf);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printSizeCountMap(sb, "WAL Segments: Source folder", this.segmentsFolder);
        this.printSizeCountMap(sb, "WAL Segments: File index", this.segmentsIndexes);
        this.printSizeCountMap(sb, "Record type", this.recTypeSizes);
        this.printSizeCountMap(sb, "Tx Record: Action", this.txRecordAct);
        this.printSizeCountMap(sb, "Tx Record: Primary nodes count", this.txRecordPrimNodesCnt);
        this.printSizeCountMap(sb, "Tx Record: Nodes count", this.txRecordNodesCnt);
        this.printSizeCountMap(sb, "Data Record: Entries count", this.dataRecordEntriesCnt);
        this.printSizeCountMap(sb, "Data Record: Under TX", this.dataRecordUnderTx);
        this.printSizeCountMap(sb, "Data Entry: Operations", this.dataEntryOperation);
        this.printSizeCountMap(sb, "Data Entry: Cache ID", this.dataEntryCacheId);
        this.printSizeCountMap(sb, "Page Snapshot: Page Types", this.pageSnapshotTypes);
        this.printSizeCountMap(sb, "Page Snapshot: Indexes", this.pageSnapshotIndexes);
        this.printSizeCountMap(sb, "Page Snapshot: Cache Groups", this.pageSnapshotCacheGrp);
        this.printSizeCountMap(sb, "Page Snapshot: Partition ID", this.pageSnapshotPartId);
        sb.append(this.txStat.toString());
        return sb.toString();
    }

    private void printSizeCountMap(StringBuilder sb, String mapName, Map<?, RecordSizeCountStat> map) {
        sb.append(mapName).append(": \n");
        sb.append("key\tsize\tcount\tavg.size");
        sb.append("\n");
        ArrayList entries = new ArrayList(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, RecordSizeCountStat>>(){

            @Override
            public int compare(Map.Entry<?, RecordSizeCountStat> o1, Map.Entry<?, RecordSizeCountStat> o2) {
                return -Integer.compare(o1.getValue().getCount(), o2.getValue().getCount());
            }
        });
        RecordSizeCountStat others = new RecordSizeCountStat();
        int otherRecords = 0;
        int cnt = 0;
        for (Map.Entry entry : entries) {
            if (cnt < 80) {
                sb.append(entry.getKey()).append("\t").append(entry.getValue()).append("\t");
                sb.append("\n");
            } else {
                ++otherRecords;
                others.add((RecordSizeCountStat)entry.getValue());
            }
            ++cnt;
        }
        if (otherRecords > 0) {
            sb.append("... other ").append(otherRecords).append(" values").append("\t").append(others).append("\t");
            sb.append("\n");
        }
        sb.append("\n");
    }
}

