/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.ignite.internal.commandline.walconverter.RecordSizeCountStat;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class TxWalStat {
    private static final int POPULAR_COMBINATION_MAP_MAX_SIZE = 50000;
    private static final int USAGES_CNT_EVICT_PROHIBITED = 10;
    private final Map<GridCacheVersion, TxOccurrence> opened = new HashMap<GridCacheVersion, TxOccurrence>();
    private final RecordSizeCountStat avgPrimaryNodes = new RecordSizeCountStat();
    private final RecordSizeCountStat avgTotalNodes = new RecordSizeCountStat();
    private final Map<Integer, Integer> txEntriesUpdated = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> txCachesInvolved = new TreeMap<Integer, Integer>();
    private final LruMap<String> cacheIdsInTx = new LruMap(50000, 10);
    private final LruMap<String> cacheIdsWeightedNodesInTx = new LruMap(50000, 900);
    private final LruMap<String> cacheIdsWeightedTotalNodesInTx = new LruMap(50000, 1500);

    private static <K> void incrementStat(K key, Map<K, Integer> map) {
        TxWalStat.incrementStat(key, map, 1);
    }

    private static <K> void incrementStat(K key, Map<K, Integer> map, int increment) {
        Integer val = map.get(key);
        int recordStat = val == null ? 0 : val;
        map.put(key, recordStat += increment);
    }

    void onTxPrepareStart(GridCacheVersion nearXidVer, int nodes, int totalNodes) {
        this.txComputeIfAbsent(nearXidVer, nodes, totalNodes);
    }

    private TxOccurrence txComputeIfAbsent(GridCacheVersion nearXidVer, int nodes, int totalNodes) {
        TxOccurrence occurrence = this.opened.get(nearXidVer);
        if (occurrence == null) {
            occurrence = new TxOccurrence(nodes, totalNodes);
        }
        this.opened.put(nearXidVer, occurrence);
        return occurrence;
    }

    void onTxEnd(GridCacheVersion nearXidVer, boolean commit) {
        TxOccurrence occurrence = this.opened.remove(nearXidVer);
        if (occurrence == null) {
            return;
        }
        if (!commit) {
            return;
        }
        if (occurrence.nodes > 0 && occurrence.totalNodes > 0) {
            this.avgPrimaryNodes.occurrence(occurrence.nodes);
            this.avgTotalNodes.occurrence(occurrence.totalNodes);
        }
        TxWalStat.incrementStat(occurrence.entriesUpdated, this.txEntriesUpdated);
        TxWalStat.incrementStat(occurrence.caches.size(), this.txCachesInvolved);
        if (!occurrence.caches.isEmpty()) {
            String sortedCachesKey = occurrence.caches.toString();
            TxWalStat.incrementStat(sortedCachesKey, ((LruMap)this.cacheIdsInTx).map, 1);
            if (occurrence.nodes > 0) {
                TxWalStat.incrementStat(sortedCachesKey, ((LruMap)this.cacheIdsWeightedNodesInTx).map, occurrence.nodes);
            }
            if (occurrence.totalNodes > 0) {
                TxWalStat.incrementStat(sortedCachesKey, ((LruMap)this.cacheIdsWeightedTotalNodesInTx).map, occurrence.totalNodes);
            }
        }
    }

    void onDataEntry(DataEntry entry) {
        GridCacheVersion ver = entry.nearXidVersion();
        if (ver == null) {
            return;
        }
        this.txComputeIfAbsent(ver, -1, -1).onDataEntry(entry);
    }

    private void printSizeCountMap(StringBuilder sb, String mapName, Map<?, Integer> map) {
        sb.append(mapName).append(": \n");
        sb.append("key\tcount");
        sb.append("\n");
        ArrayList entries = new ArrayList(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, Integer>>(){

            @Override
            public int compare(Map.Entry<?, Integer> o1, Map.Entry<?, Integer> o2) {
                return -Integer.compare(o1.getValue(), o2.getValue());
            }
        });
        int othersCnt = 0;
        int othersSum = 0;
        int cnt = 0;
        for (Map.Entry entry : entries) {
            if (cnt < 80) {
                sb.append(entry.getKey()).append("\t").append(entry.getValue()).append("\t");
                sb.append("\n");
            } else {
                ++othersCnt;
                othersSum += ((Integer)entry.getValue()).intValue();
            }
            ++cnt;
        }
        if (othersCnt > 0) {
            sb.append("... other ").append(othersCnt).append(" values").append("\t").append(othersSum).append("\t");
            sb.append("\n");
        }
        sb.append("\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tx stat: remained Opened: \t").append(this.opened.size()).append("\n").append("\n");
        sb.append("Tx stat: Average Primary Node Count: \t").append(this.avgPrimaryNodes.averageStr()).append("\n").append("\n");
        sb.append("Tx stat: Average Total Node Count: \t").append(this.avgTotalNodes.averageStr()).append("\n").append("\n");
        this.printSizeCountMap(sb, "Tx stat: Entries updated", this.txEntriesUpdated);
        this.printSizeCountMap(sb, "Tx stat: Caches involved", this.txCachesInvolved);
        this.printSizeCountMap(sb, "Tx stat: Caches list in TX, evicted = " + ((LruMap)this.cacheIdsInTx).evicted, ((LruMap)this.cacheIdsInTx).map);
        this.printSizeCountMap(sb, "Tx stat: Caches list in TX; weighted by primary Nodes, evicted = " + ((LruMap)this.cacheIdsWeightedNodesInTx).evicted, ((LruMap)this.cacheIdsWeightedNodesInTx).map);
        this.printSizeCountMap(sb, "Tx stat: Caches list in TX; weighted by total Nodes, evicted = " + ((LruMap)this.cacheIdsWeightedNodesInTx).evicted, ((LruMap)this.cacheIdsWeightedNodesInTx).map);
        return sb.toString();
    }

    private static class LruMap<K> {
        private int maxSize;
        private int evictProhibited;
        private int evicted;
        private Map<K, Integer> map = new LinkedHashMap<K, Integer>(16, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Integer> eldest) {
                boolean evictNow;
                if (this.size() < maxSize) {
                    return false;
                }
                boolean bl = evictNow = eldest.getValue() < evictProhibited;
                if (evictNow) {
                    evicted++;
                }
                return evictNow;
            }
        };

        LruMap(int maxSize, int evictProhibited) {
            this.maxSize = maxSize;
            this.evictProhibited = evictProhibited;
        }
    }

    private static class TxOccurrence {
        private int nodes;
        private int totalNodes;
        private int entriesUpdated;
        private TreeSet<Integer> caches = new TreeSet();

        TxOccurrence(int nodes, int totalNodes) {
            this.nodes = nodes;
            this.totalNodes = totalNodes;
        }

        void onDataEntry(DataEntry entry) {
            ++this.entriesUpdated;
            this.caches.add(entry.cacheId());
        }
    }
}

