/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.walconverter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;
import org.apache.ignite.internal.commandline.walconverter.ProcessSensitiveData;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.jetbrains.annotations.Nullable;

public class IgniteWalConverterArguments {
    private static final Pattern PAGE_ID_PATTERN = Pattern.compile("(-?\\d+):(-?\\d+)");
    private final File walDir;
    private final File walArchiveDir;
    private final int pageSize;
    private final File binaryMetadataDir;
    private final File marshallerMappingDir;
    private final boolean unwrapBinary;
    private final Set<WALRecord.RecordType> recordTypes;
    private final Long fromTime;
    private final Long toTime;
    private final String hasText;
    private final ProcessSensitiveData includeSensitive;
    private final boolean printStat;
    private final boolean skipCrc;
    private final Collection<T2<Integer, Long>> pages;

    public IgniteWalConverterArguments(File walDir, File walArchiveDir, int pageSize, File binaryMetadataDir, File marshallerMappingDir, boolean unwrapBinary, Set<WALRecord.RecordType> recordTypes, Long fromTime, Long toTime, String hasText, ProcessSensitiveData includeSensitive, boolean printStat, boolean skipCrc, Collection<T2<Integer, Long>> pages) {
        this.walDir = walDir;
        this.walArchiveDir = walArchiveDir;
        this.pageSize = pageSize;
        this.binaryMetadataDir = binaryMetadataDir;
        this.marshallerMappingDir = marshallerMappingDir;
        this.unwrapBinary = unwrapBinary;
        this.recordTypes = recordTypes;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.hasText = hasText;
        this.includeSensitive = includeSensitive;
        this.printStat = printStat;
        this.skipCrc = skipCrc;
        this.pages = pages;
    }

    public File getWalDir() {
        return this.walDir;
    }

    public File getWalArchiveDir() {
        return this.walArchiveDir;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public File getBinaryMetadataDir() {
        return this.binaryMetadataDir;
    }

    public File getMarshallerMappingDir() {
        return this.marshallerMappingDir;
    }

    public boolean isUnwrapBinary() {
        return this.unwrapBinary;
    }

    public Set<WALRecord.RecordType> getRecordTypes() {
        return this.recordTypes;
    }

    public Long getFromTime() {
        return this.fromTime;
    }

    public Long getToTime() {
        return this.toTime;
    }

    public String hasText() {
        return this.hasText;
    }

    public ProcessSensitiveData includeSensitive() {
        return this.includeSensitive;
    }

    public boolean isPrintStat() {
        return this.printStat;
    }

    public boolean isSkipCrc() {
        return this.skipCrc;
    }

    public Collection<T2<Integer, Long>> getPages() {
        return this.pages;
    }

    @Nullable
    public static File file(@Nullable String filePath, boolean checkExists, boolean checkIsDirectory) {
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (checkExists && !file.exists()) {
            throw new IllegalArgumentException("File/directory '" + filePath + "' does not exist.");
        }
        if (checkIsDirectory && !file.isDirectory()) {
            throw new IllegalArgumentException("File '" + filePath + "' must be directory.");
        }
        return file;
    }

    private static Set<WALRecord.RecordType> checkRecordTypes(String[] recordTypesStrArray) {
        TreeSet<String> unknownRecordTypes = new TreeSet<String>();
        HashSet<WALRecord.RecordType> recordTypes = new HashSet<WALRecord.RecordType>();
        if (recordTypesStrArray != null) {
            for (String recordTypeStr : recordTypesStrArray) {
                try {
                    recordTypes.add(WALRecord.RecordType.valueOf((String)recordTypeStr));
                }
                catch (Exception e) {
                    unknownRecordTypes.add(recordTypeStr);
                }
            }
            if (!unknownRecordTypes.isEmpty()) {
                throw new IllegalArgumentException("Unknown record types: " + unknownRecordTypes + ". Supported record types: " + Arrays.toString(WALRecord.RecordType.values()));
            }
        }
        return recordTypes;
    }

    public static IgniteWalConverterArguments parse(PrintStream out, String ... args) {
        ProcessSensitiveData includeSensitive;
        AtomicReference<CLIArgumentParser> parserRef = new AtomicReference<CLIArgumentParser>();
        CLIArgument[] cLIArgumentArray = new CLIArgument[14];
        cLIArgumentArray[0] = CLIArgument.optionalArg(Args.WAL_DIR.arg(), "Path to dir with wal files.", String.class, () -> {
            if (((CLIArgumentParser)parserRef.get()).get(Args.WAL_ARCHIVE_DIR.arg()) == null) {
                throw new IllegalArgumentException("One of the arguments --wal-dir or --wal-archive-dir must be specified.");
            }
            return null;
        });
        cLIArgumentArray[1] = CLIArgument.optionalArg(Args.WAL_ARCHIVE_DIR.arg(), "Path to dir with wal files.", String.class);
        cLIArgumentArray[2] = CLIArgument.optionalArg(Args.PAGE_SIZE.arg(), "Size of pages, which was selected for file store (1024, 2048, 4096, etc).", Integer.class, () -> 4096);
        cLIArgumentArray[3] = CLIArgument.optionalArg(Args.BINARY_METADATA_DIR.arg(), "Path to binary meta.", String.class);
        cLIArgumentArray[4] = CLIArgument.optionalArg(Args.MARSHALLER_MAPPING_DIR.arg(), "Path to marshaller dir.", String.class);
        cLIArgumentArray[5] = CLIArgument.optionalArg(Args.UNWRAP_BINARY.arg(), "Unwrap binary non-primitive objects.", Boolean.class);
        cLIArgumentArray[6] = CLIArgument.optionalArg(Args.RECORD_TYPES.arg(), "Comma-separated WAL record types (TX_RECORD, DATA_RECORD, etc). By default, all types will be printed.", String[].class);
        cLIArgumentArray[7] = CLIArgument.optionalArg(Args.WAL_TIME_FROM_MILLIS.arg(), "The start time interval for the record time in milliseconds.", Long.class);
        cLIArgumentArray[8] = CLIArgument.optionalArg(Args.WAL_TIME_TO_MILLIS.arg(), "The end time interval for the record time in milliseconds.", Long.class);
        cLIArgumentArray[9] = CLIArgument.optionalArg(Args.HAS_TEXT.arg(), "Filter by substring in the WAL record.", String.class);
        cLIArgumentArray[10] = CLIArgument.optionalArg(Args.INCLUDE_SENSITIVE.arg(), "Strategy for the processing of sensitive data (SHOW, HIDE, HASH, MD5). Default MD5.", String.class, ProcessSensitiveData.MD5::toString);
        cLIArgumentArray[11] = CLIArgument.optionalArg(Args.PRINT_STAT.arg(), "Write summary statistics for WAL.", Boolean.class);
        cLIArgumentArray[12] = CLIArgument.optionalArg(Args.SKIP_CRC.arg(), "Skip CRC calculation/check flag", Boolean.class);
        cLIArgumentArray[13] = CLIArgument.optionalArg(Args.PAGES.arg(), "Comma-separated pages or path to file with pages on each line in grpId:pageId format", String.class);
        CLIArgumentParser parser = new CLIArgumentParser(Arrays.asList(cLIArgumentArray));
        if (args == null || args.length < 1) {
            out.println("Print WAL log data in human-readable form.");
            out.println(parser.usage());
            out.println("For example:");
            out.println("    " + Args.WAL_DIR.arg() + " /work/db/wal");
            out.println("    " + Args.WAL_ARCHIVE_DIR.arg() + " /work/db/wal_archive");
            out.println("    " + Args.PAGE_SIZE.arg() + " 4096");
            out.println("    " + Args.BINARY_METADATA_DIR.arg() + " /work/db/nodeId-consistentId");
            out.println("    " + Args.MARSHALLER_MAPPING_DIR.arg() + " /work/db/marshaller");
            out.println("    " + Args.UNWRAP_BINARY.arg());
            out.println("    " + Args.RECORD_TYPES.arg() + " DataRecord,TxRecord");
            out.println("    " + Args.WAL_TIME_FROM_MILLIS.arg() + " 1575158400000");
            out.println("    " + Args.WAL_TIME_TO_MILLIS.arg() + " 1577836740999");
            out.println("    " + Args.HAS_TEXT.arg() + " search_string");
            out.println("    " + Args.INCLUDE_SENSITIVE.arg() + " SHOW");
            out.println("    " + Args.SKIP_CRC.arg());
            out.println("    " + Args.PAGES.arg() + " 123456:789456123,123456:789456124");
            return null;
        }
        parserRef.set(parser);
        parser.parse(Arrays.asList(args).iterator());
        File walDir = IgniteWalConverterArguments.file((String)parser.get(Args.WAL_DIR.arg()), true, false);
        File walArchiveDir = IgniteWalConverterArguments.file((String)parser.get(Args.WAL_ARCHIVE_DIR.arg()), true, false);
        int pageSize = (Integer)parser.get(Args.PAGE_SIZE.arg());
        File binaryMetadataDir = IgniteWalConverterArguments.file((String)parser.get(Args.BINARY_METADATA_DIR.arg()), true, true);
        File marshallerMappingDir = IgniteWalConverterArguments.file((String)parser.get(Args.MARSHALLER_MAPPING_DIR.arg()), true, true);
        boolean unwrapBinary = (Boolean)parser.get(Args.UNWRAP_BINARY.arg());
        Set<WALRecord.RecordType> recordTypes = IgniteWalConverterArguments.checkRecordTypes((String[])parser.get(Args.RECORD_TYPES.arg()));
        Long fromTime = (Long)parser.get(Args.WAL_TIME_FROM_MILLIS.arg());
        Long toTime = (Long)parser.get(Args.WAL_TIME_TO_MILLIS.arg());
        String hasText = (String)parser.get(Args.HAS_TEXT.arg());
        boolean printStat = (Boolean)parser.get(Args.PRINT_STAT.arg());
        boolean skipCrc = (Boolean)parser.get(Args.SKIP_CRC.arg());
        Collection<T2<Integer, Long>> pages = IgniteWalConverterArguments.pages((String)parser.get(Args.PAGES.arg()));
        String processSensitiveDataStr = (String)parser.get(Args.INCLUDE_SENSITIVE.arg());
        try {
            includeSensitive = ProcessSensitiveData.valueOf(processSensitiveDataStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown --include-sensitive: " + processSensitiveDataStr + ". Supported: " + Arrays.toString((Object[])ProcessSensitiveData.values()));
        }
        out.println("Program arguments:");
        if (walDir != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.WAL_DIR, walDir.getAbsolutePath()});
        }
        if (walArchiveDir != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.WAL_ARCHIVE_DIR, walArchiveDir.getAbsolutePath()});
        }
        out.printf("\t%s = %d\n", new Object[]{Args.PAGE_SIZE, pageSize});
        if (binaryMetadataDir != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.BINARY_METADATA_DIR, binaryMetadataDir});
        }
        if (marshallerMappingDir != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.MARSHALLER_MAPPING_DIR, marshallerMappingDir});
        }
        out.printf("\t%s = %s\n", new Object[]{Args.UNWRAP_BINARY, unwrapBinary});
        if (!F.isEmpty(recordTypes)) {
            out.printf("\t%s = %s\n", new Object[]{Args.RECORD_TYPES, recordTypes});
        }
        if (fromTime != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.WAL_TIME_FROM_MILLIS, new Date(fromTime)});
        }
        if (toTime != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.WAL_TIME_TO_MILLIS, new Date(toTime)});
        }
        if (hasText != null) {
            out.printf("\t%s = %s\n", new Object[]{Args.HAS_TEXT, hasText});
        }
        out.printf("\t%s = %s\n", new Object[]{Args.INCLUDE_SENSITIVE, includeSensitive});
        out.printf("\t%s = %b\n", new Object[]{Args.PRINT_STAT, printStat});
        out.printf("\t%s = %b\n", new Object[]{Args.SKIP_CRC, skipCrc});
        if (!pages.isEmpty()) {
            out.printf("\t%s = %s\n", new Object[]{Args.PAGES, pages});
        }
        return new IgniteWalConverterArguments(walDir, walArchiveDir, pageSize, binaryMetadataDir, marshallerMappingDir, unwrapBinary, recordTypes, fromTime, toTime, hasText, includeSensitive, printStat, skipCrc, pages);
    }

    static Collection<T2<Integer, Long>> pages(@Nullable String pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        File pagesFile = new File(pages);
        return pagesFile.exists() ? IgniteWalConverterArguments.parsePageIds(pagesFile) : IgniteWalConverterArguments.parsePageIds(pages.split(","));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Collection<T2<Integer, Long>> parsePageIds(File f) throws IllegalArgumentException {
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String s;
            int i = 0;
            ArrayList res = new ArrayList();
            while ((s = reader.readLine()) != null) {
                try {
                    res.add(IgniteWalConverterArguments.parsePageId(s));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Error parsing value \"" + s + "\" on " + i + " line of the file: " + f.getAbsolutePath(), e);
                }
                ++i;
            }
            List<T2<Integer, Long>> list = res.isEmpty() ? Collections.emptyList() : res;
            return list;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error when working with the file: " + f.getAbsolutePath(), e);
        }
    }

    static T2<Integer, Long> parsePageId(@Nullable String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("Null value.");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Empty value.");
        }
        Matcher m = PAGE_ID_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Incorrect value " + s + ", valid format: grpId:pageId. Example: 123:456");
        }
        return new T2((Object)Integer.parseInt(m.group(1)), (Object)Long.parseLong(m.group(2)));
    }

    static Collection<T2<Integer, Long>> parsePageIds(String ... strs) throws IllegalArgumentException {
        ArrayList res = new ArrayList();
        for (int i = 0; i < strs.length; ++i) {
            try {
                res.add(IgniteWalConverterArguments.parsePageId(strs[i]));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error parsing value \"" + strs[i] + "\" of " + i + " element", e);
            }
        }
        return res.isEmpty() ? Collections.emptyList() : res;
    }

    public static enum Args {
        WAL_DIR("--wal-dir"),
        WAL_ARCHIVE_DIR("--wal-archive-dir"),
        PAGE_SIZE("--page-size"),
        BINARY_METADATA_DIR("--binary-metadata-dir"),
        MARSHALLER_MAPPING_DIR("--marshaller-mapping-dir"),
        UNWRAP_BINARY("--unwrap-binary"),
        RECORD_TYPES("--record-types"),
        WAL_TIME_FROM_MILLIS("--wal-time-from-millis"),
        WAL_TIME_TO_MILLIS("--wal-time-to-millis"),
        HAS_TEXT("--has-text"),
        INCLUDE_SENSITIVE("--include-sensitive"),
        PRINT_STAT("--print-stat"),
        SKIP_CRC("--skip-crc"),
        PAGES("--pages");

        private String arg;

        private Args(String arg) {
            this.arg = arg;
        }

        public String arg() {
            return this.arg;
        }
    }
}

